/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.utilities.webdav.protocol;

import com.sap.sapdb.testframe.utilities.webdav.protocol.URLStreamHandlerFactory;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVException;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVHTTPHeaders;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVHttpConnection;
import com.sap.sapdb.testframe.utilities.webdav.protocol.WebDAVStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.util.Enumeration;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WebDAVCore {
    protected URL url = null;
    protected WebDAVHTTPHeaders requestContext = new WebDAVHTTPHeaders();
    protected WebDAVHTTPHeaders responseContext = new WebDAVHTTPHeaders();
    protected WebDAVStatus status = new WebDAVStatus();
    protected WebDAVHttpConnection connection = null;
    protected boolean timeoutDetected = false;

    public WebDAVCore() {
    }

    public WebDAVCore(URL url) {
        this.url = url;
    }

    protected InputStream getContentsInputStream() throws WebDAVException {
        this.setupRequest("GET");
        this.getResults();
        InputStream stream = null;
        try {
            stream = this.connection.getInputStream();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        return stream;
    }

    public OutputStream getContentsOutputStream() throws WebDAVException {
        if (this.requestContext.contentType() == null) {
            this.requestContext.contentType("text/plain");
        }
        this.setupRequest("PUT");
        this.connection.setDoOutput(true);
        OutputStream stream = null;
        try {
            stream = this.connection.getOutputStream();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        return stream;
    }

    public byte[] GET() throws WebDAVException {
        byte[] cachedContents = null;
        InputStream is = this.getContentsInputStream();
        cachedContents = this.readBody(is);
        return cachedContents;
    }

    public boolean GET(File destination) throws WebDAVException {
        boolean result = false;
        InputStream is = this.getContentsInputStream();
        result = this.readBody(is, destination);
        return result;
    }

    public boolean PUT(String contents, String contentType, String locktoken) throws WebDAVException {
        boolean result = false;
        if (contentType != null) {
            this.requestContext.contentType(contentType);
        }
        if (locktoken != null) {
            this.requestContext.precondition(locktoken);
        }
        OutputStream os = this.getContentsOutputStream();
        result = this.writeBody(os, contents);
        this.getResults();
        if (this.status.getStatusCode() == -1) {
            throw new WebDAVException(-1, "Serverstatus unknown");
        }
        return result;
    }

    public boolean PUT(File contents, String contentType, String locktoken) throws WebDAVException {
        boolean result = false;
        if (contentType != null) {
            this.requestContext.contentType(contentType);
        }
        if (locktoken != null) {
            this.requestContext.precondition(locktoken);
        }
        OutputStream os = this.getContentsOutputStream();
        result = this.writeBody(os, contents);
        this.getResults();
        if (this.status.getStatusCode() == -1) {
            throw new WebDAVException(-1, "Serverstatus unknown");
        }
        return result;
    }

    public void PUT() throws WebDAVException {
        OutputStream os = this.getContentsOutputStream();
        if (os != null) {
            // empty if block
        }
        this.getResults();
        if (this.status.getStatusCode() == -1) {
            throw new WebDAVException(-1, "Serverstatus unknown");
        }
    }

    public void MKCOL(String contents) throws WebDAVException {
        try {
            if (contents != null) {
                this.connection.setDoOutput(true);
                this.requestContext.contentType("text/xml");
            }
            this.setupRequest("MKCOL");
            if (contents != null) {
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, contents);
            }
            this.getResults();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
    }

    public void DELETE(String locktoken) throws WebDAVException {
        if (locktoken != null) {
            this.requestContext.precondition(locktoken);
        }
        this.setupRequest("DELETE");
        this.getResults();
    }

    public byte[] COPY(String destUrl, String overwrite, String body, String locktoken) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition(locktoken);
            }
            this.setupRequest("COPY");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    public byte[] COPY(String destUrl, String overwrite, String body, String locktoken, String depth) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition(locktoken);
            }
            if (depth != null) {
                this.requestContext.depth(depth);
            }
            this.setupRequest("COPY");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    public byte[] MOVE(String destUrl, String overwrite, String body, String locktoken) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition(locktoken);
            }
            this.setupRequest("MOVE");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    public byte[] MOVE(String destUrl, String overwrite, String body, String locktoken, String depth) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (destUrl != null) {
                this.requestContext.destination(destUrl);
            }
            if (overwrite != null) {
                this.requestContext.overwrite(overwrite);
            }
            if (locktoken != null) {
                this.requestContext.precondition(locktoken);
            }
            if (depth != null) {
                this.requestContext.depth(depth);
            }
            this.setupRequest("MOVE");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean HEAD(String body) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            this.setupRequest("HEAD");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            if (this.status.getStatusCode() == -1) {
                throw new WebDAVException(-1, "Serverstatus unknown");
            }
            InputStream is = null;
            cachedContents = this.readBody(is);
            if (cachedContents.length <= 0) return true;
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            System.out.println(exc.getMessage());
            throw new WebDAVException(500, "IO Exception");
        }
        return true;
    }

    public byte[] LOCK(String body, String locktoken) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (locktoken != null) {
                this.requestContext.lockToken(locktoken);
            }
            this.setupRequest("LOCK");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    public byte[] UNLOCK(String body, String locktoken) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (locktoken != null) {
                this.requestContext.precondition(locktoken);
            }
            this.setupRequest("UNLOCK");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    public byte[] OPTIONS(String body) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            this.setupRequest("OPTIONS");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            cachedContents = this.readBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    protected void getResults() throws WebDAVException {
        String statusMessage = null;
        int responseCode = 0;
        try {
            responseCode = this.connection.getResponseCode();
            this.status.setStatusCode(responseCode);
            statusMessage = this.connection.getResponseMessage();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        if (statusMessage == null || statusMessage.equals("Unknown")) {
            statusMessage = WebDAVStatus.getStatusMessage(this.status.getStatusCode());
        }
        int i = 1;
        String name = null;
        while ((name = this.connection.getHeaderFieldKey(i)) != null) {
            name = name.toLowerCase();
            String value = this.connection.getHeaderField(i);
            this.responseContext.put(name, value);
            ++i;
        }
        if (responseCode >= 300 && responseCode <= 399) {
            throw new WebDAVException(responseCode, statusMessage);
        }
        if (responseCode >= 400 && responseCode <= 499) {
            throw new WebDAVException(responseCode, statusMessage);
        }
        if (responseCode >= 500 && responseCode <= 599) {
            throw new WebDAVException(responseCode, statusMessage);
        }
    }

    protected void setupRequest(String method) throws WebDAVException {
        try {
            this.connection = (WebDAVHttpConnection)this.url.openConnection();
            this.connection.setRequestMethod(method);
        }
        catch (ProtocolException exc) {
            exc.printStackTrace();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        Enumeration<Object> propertyNames = this.requestContext.keys();
        while (propertyNames.hasMoreElements()) {
            String name = (String)propertyNames.nextElement();
            String value = (String)this.requestContext.get(name);
            this.connection.setRequestProperty(name, value);
        }
    }

    protected boolean writeBody(OutputStream os, String body) throws WebDAVException {
        try {
            if (os == null) {
                os = this.connection.getOutputStream();
            }
            StringReader is = new StringReader(body);
            int ch = -1;
            while ((ch = is.read()) != -1) {
                os.write(ch);
            }
            is.close();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        return true;
    }

    protected boolean writeBody(OutputStream os, File body) throws WebDAVException {
        try {
            if (os == null) {
                os = this.connection.getOutputStream();
            }
            FileInputStream fis = new FileInputStream(body);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf, 0, 1024)) != -1) {
                os.write(buf, 0, i);
            }
            fis.close();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        return true;
    }

    protected byte[] readBody(InputStream is) throws WebDAVException {
        byte[] cachedContents = null;
        try {
            if (is == null) {
                is = this.connection.getInputStream();
            }
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        try {
            int length = (int)this.responseContext.contentLength();
            if (length != -1) {
                int rcvd = 0;
                int size = 0;
                cachedContents = new byte[length];
                try {
                    do {
                        rcvd = is.read(cachedContents, size += rcvd, length - size);
                    } while (size < length && rcvd != -1);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (rcvd == -1) {
                    cachedContents = WebDAVCore.resizeArray(cachedContents, size);
                }
            } else {
                cachedContents = new byte[]{};
                int inc = 8192;
                int off = cachedContents.length;
                int rcvd = 0;
                try {
                    while ((rcvd = is.read(cachedContents = WebDAVCore.resizeArray(cachedContents, (off += rcvd) + inc), off, inc)) != -1) {
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                cachedContents = WebDAVCore.resizeArray(cachedContents, off);
            }
            if (is != null) {
                is.close();
            }
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return cachedContents;
    }

    protected boolean readBody(InputStream is, File destination) throws WebDAVException {
        byte[] buf = null;
        try {
            if (is == null) {
                is = this.connection.getInputStream();
            }
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        try {
            int length = (int)this.responseContext.contentLength();
            int rcvd = 0;
            int size = 0;
            destination.createNewFile();
            FileOutputStream fos = new FileOutputStream(destination);
            buf = new byte[1024];
            try {
                do {
                    rcvd = is.read(buf, 0, 1024);
                    fos.write(buf, 0, rcvd);
                } while ((size += rcvd) < length && rcvd != -1);
            }
            catch (Exception e) {
                // empty catch block
            }
            fos.close();
            if (is != null) {
                is.close();
            }
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return true;
    }

    public File PROPFIND(String body) throws WebDAVException, SAXException {
        File xmlBody = null;
        try {
            this.requestContext.depth("1");
            this.setupRequest("PROPFIND");
            if (body != null) {
                this.connection.setDoOutput(true);
                OutputStream os = this.connection.getOutputStream();
                this.writeBody(os, body);
            }
            this.getResults();
            InputStream is = null;
            xmlBody = this.readXmlBody(is);
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (SAXParseException exc) {
            throw exc;
        }
        catch (SAXException exc) {
            System.out.println("********************Fehler in Parser!!!**********************");
            exc.printStackTrace();
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        return xmlBody;
    }

    protected File readXmlBody(InputStream is) throws WebDAVException, SAXException {
        File tempBody;
        this.responseContext = new WebDAVHTTPHeaders();
        byte[] cachedContents = null;
        this.timeoutDetected = false;
        try {
            if (is == null) {
                is = this.connection.getInputStream();
            }
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Error");
        }
        try {
            tempBody = File.createTempFile("xmlbody", ".xml");
            FileOutputStream fos = new FileOutputStream(tempBody);
            int length = (int)this.responseContext.contentLength();
            if (length != -1) {
                int rcvd = 0;
                int size = 0;
                cachedContents = new byte[length];
                do {
                    rcvd = is.read(cachedContents, size += rcvd, length - size);
                } while (size < length && rcvd != -1);
                if (rcvd == -1) {
                    cachedContents = WebDAVCore.resizeArray(cachedContents, size);
                }
            } else {
                cachedContents = new byte[]{};
                int inc = 8192;
                int off = cachedContents.length;
                int rcvd = 0;
                while ((rcvd = is.read(cachedContents = WebDAVCore.resizeArray(cachedContents, (off += rcvd) + inc), off, inc)) != -1) {
                }
                cachedContents = WebDAVCore.resizeArray(cachedContents, off);
                for (int i = 0; i < 39; ++i) {
                    cachedContents[i] = 32;
                }
            }
            is.close();
            fos.write(cachedContents);
            fos.close();
        }
        catch (WebDAVException exc) {
            throw exc;
        }
        catch (IOException exc) {
            throw new WebDAVException(500, "IO Exception");
        }
        if (this.timeoutDetected) {
            return null;
        }
        return tempBody;
    }

    public WebDAVHTTPHeaders getRequestHeaders() {
        return this.requestContext;
    }

    public WebDAVHTTPHeaders getResponseHeaders() {
        return this.responseContext;
    }

    public WebDAVStatus getStatus() {
        return this.status;
    }

    private static final byte[] resizeArray(byte[] src, int new_size) {
        byte[] tmp = new byte[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    public WebDAVCore createResource(String host, int port, String baseUrl, String url_str) {
        URLStreamHandlerFactory fac = new URLStreamHandlerFactory();
        URLStreamHandler handler = fac.createURLStreamHandler("http");
        WebDAVCore resource = null;
        try {
            this.url = new URL("http", host, port, baseUrl + url_str, handler);
            resource = new WebDAVCore(this.url);
        }
        catch (Exception exc) {
            System.out.println("  creating java resource");
            System.out.println("  Java exception: " + exc);
            exc.printStackTrace();
            System.out.println("Preparations..........failed");
            System.out.println("Skipping test destructiveTest002");
        }
        return resource;
    }

    public void setURL(URL url) {
        this.url = url;
    }
}

