/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.testcase;

import com.sap.sapdb.testframe.testcase.ColumnDescriptor;
import com.sap.sapdb.testframe.testcase.VerificationDataIterator;
import com.sap.sapdb.testframe.testcase.VerificationDataIteratorPretty;
import com.stevesoft.pat.Regex;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.StringTokenizer;

public abstract class VerificationData {
    protected ArrayList mValues;
    protected ArrayList mColumnDescriptions;
    protected ArrayList mTempRow;
    protected boolean mColumnnamesDefined = false;
    protected String mErrorMessage = "n/a";
    protected int mResultCounter = -1;
    protected int mColumnNumber = 0;
    protected int mRowNumber;
    protected boolean mCheckColumnNames = true;
    protected Hashtable rowHash = new Hashtable();
    protected LinkedList notHashableRows = new LinkedList();
    protected boolean mResultSetIsScrollable = false;
    private int mCharInACell = 15;
    public static final char OP_SORTED = 's';
    public static final char OP_SUBSET = 'u';
    public static final char OP_COMPLETE = 'c';
    public static String numberPattern = "[\\+-]?[\\d]+(\\.[\\d]*)?";
    private boolean generatedFromResultSet = false;

    protected VerificationData() {
        this.mColumnDescriptions = new ArrayList(20);
        this.mValues = new ArrayList(100);
        this.mTempRow = new ArrayList(20);
    }

    protected VerificationData(String Datasets) throws RuntimeException {
        this();
        this.add(Datasets);
    }

    protected VerificationData(ResultSet Set2) throws RuntimeException {
        this();
        try {
            if (Set2.getType() != 1003) {
                this.mResultSetIsScrollable = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.add(Set2);
    }

    public void add(String Set2) throws RuntimeException {
        if (Set2 == null) {
            throw new RuntimeException("Input string is null!");
        }
        String helpSet = Set2.trim();
        String tempInput = null;
        String[] SetAsArray = new String[100];
        int ic = 0;
        int indexOfArray = 0;
        boolean isOpenedParenthesis = false;
        boolean isOpenedApostrophe = false;
        char currentChar = 'a';
        int startOfSubString = 0;
        if (helpSet.startsWith("(") && helpSet.indexOf("(", 1) == -1 && helpSet.endsWith(")")) {
            if (helpSet.substring(1, helpSet.length() - 1).trim().length() == 0) {
                throw new RuntimeException("Illegal DataSet! (opened and closed parenthesis without content); \ninput: " + Set2);
            }
            SetAsArray[0] = helpSet.substring(1, helpSet.length() - 1).trim();
        }
        if (!helpSet.startsWith("(") && !helpSet.endsWith(")")) {
            SetAsArray[0] = helpSet;
        }
        if (!helpSet.startsWith("(") && helpSet.endsWith(")")) {
            throw new RuntimeException("Input string does not start with a parenthesis but ends with one. \ninput: " + Set2);
        }
        if (helpSet.startsWith("(") && !helpSet.endsWith(")")) {
            throw new RuntimeException("Input string does not end with a parenthesis. \ninput: " + Set2);
        }
        if (helpSet.startsWith("(") && helpSet.indexOf("(", 1) != -1 && helpSet.endsWith(")")) {
            for (int i = 0; i < helpSet.length(); ++i) {
                currentChar = helpSet.charAt(i);
                if (!isOpenedParenthesis && currentChar == '(') {
                    isOpenedParenthesis = true;
                    startOfSubString = i + 1;
                    continue;
                }
                if (!isOpenedApostrophe && currentChar == '\'') {
                    isOpenedApostrophe = true;
                    continue;
                }
                if (isOpenedApostrophe && currentChar == '\'') {
                    if (helpSet.charAt(i + 1) == '\'') {
                        ++i;
                        continue;
                    }
                    isOpenedApostrophe = false;
                    continue;
                }
                if (!isOpenedApostrophe && isOpenedParenthesis && currentChar == ')') {
                    isOpenedParenthesis = false;
                    if (helpSet.substring(startOfSubString, i).trim().length() != 0) {
                        SetAsArray[indexOfArray] = helpSet.substring(startOfSubString, i).trim();
                        ++indexOfArray;
                    } else {
                        throw new RuntimeException("Illegal DataSet! (opened and closed parenthesis without content); \ninput: " + Set2);
                    }
                }
                if (!isOpenedParenthesis || isOpenedApostrophe || currentChar != 40) continue;
                throw new RuntimeException("Illegal DataSet (duplicate opened parenthesis); \ninput: " + Set2);
            }
            if (isOpenedApostrophe) {
                throw new RuntimeException("Illegal DataSet input ( unclosed apostrophe )!\ninput: " + Set2);
            }
        }
        indexOfArray = 0;
        while (SetAsArray[indexOfArray] != null) {
            tempInput = SetAsArray[indexOfArray].trim();
            if (tempInput.startsWith("[") && !tempInput.endsWith("]")) {
                throw new RuntimeException("Input token does not end with a bracket. \ntoken: " + tempInput);
            }
            if (tempInput.startsWith("[") && tempInput.endsWith("]") && this.mColumnnamesDefined) {
                throw new RuntimeException("Second token with column definition.\ntoken: " + tempInput);
            }
            if (tempInput.startsWith("[") && tempInput.endsWith("]") && !this.mColumnnamesDefined) {
                StringTokenizer stTempInput = new StringTokenizer(tempInput.substring(1, tempInput.length() - 1), ",");
                while (stTempInput.hasMoreTokens()) {
                    String dummy = stTempInput.nextToken().trim();
                    if (dummy.indexOf(":") == -1) {
                        this.mColumnDescriptions.add(new ColumnDescriptor(dummy));
                        continue;
                    }
                    this.mColumnDescriptions.add(new ColumnDescriptor(dummy.substring(0, dummy.indexOf(":")).trim(), ColumnDescriptor.getType(dummy.substring(dummy.indexOf(":") + 1, dummy.length()).trim())));
                }
                if (this.mColumnNumber == 0) {
                    this.mColumnNumber = this.mColumnDescriptions.size();
                } else if (this.mColumnNumber != this.mColumnDescriptions.size()) {
                    throw new RuntimeException("Definition of column does not match with existing number ( " + this.mColumnNumber + " ) of columns. \ntoken: " + tempInput);
                }
                this.mColumnnamesDefined = true;
            }
            if (!tempInput.startsWith("[")) {
                String tempValue = "";
                this.mTempRow.clear();
                int i = 0;
                boolean dontExpectComma = true;
                isOpenedApostrophe = false;
                while (i < tempInput.length()) {
                    currentChar = tempInput.charAt(i);
                    if (Character.isWhitespace(currentChar)) {
                        ++i;
                        continue;
                    }
                    if (currentChar == ',') {
                        if (dontExpectComma) {
                            ic = i + 1;
                            throw new RuntimeException("Wrong data definition! Found no content before comma.\ntoken: " + tempInput + "\nposition: " + ic);
                        }
                        dontExpectComma = true;
                        ++i;
                        continue;
                    }
                    if (dontExpectComma && (Character.toUpperCase(currentChar) == 'N' || Character.toUpperCase(currentChar) == 'I')) {
                        if (i + 3 <= tempInput.length() && tempInput.substring(i, i + 3).compareToIgnoreCase("NaN") == 0) {
                            this.mTempRow.add(new String("NaN"));
                            i += 3;
                            dontExpectComma = false;
                            continue;
                        }
                        if (i + 4 <= tempInput.length() && tempInput.substring(i, i + 4).compareToIgnoreCase("NULL") == 0) {
                            this.mTempRow.add(null);
                            i += 4;
                            dontExpectComma = false;
                            continue;
                        }
                        if (i + 6 <= tempInput.length() && tempInput.substring(i, i + 6).compareToIgnoreCase("IGNORE") == 0) {
                            this.mTempRow.add("IGNORE");
                            i += 6;
                            dontExpectComma = false;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! Expected one of the words \"NULL\", \"NaN\" or \"IGNORE\" but found something else.\ntoken: " + tempInput + "\nposition: " + ic);
                    }
                    if (dontExpectComma && Character.toUpperCase(currentChar) == 'X') {
                        int j = 0;
                        while (i < tempInput.length() - 1) {
                            ++j;
                            if ((currentChar = Character.toUpperCase(tempInput.charAt(++i))) == ',') {
                                --i;
                                --j;
                                break;
                            }
                            if (Character.isDigit(currentChar) || currentChar == 'A' || currentChar == 'B' || currentChar == 'C' || currentChar == 'D' || currentChar == 'E' || currentChar == 'F') {
                                tempValue = tempValue + currentChar;
                                continue;
                            }
                            ic = i + 1;
                            throw new RuntimeException("Wrong data definition! Unexpected sign for hex value found: " + currentChar + "\nin token: " + tempInput + "\nat position: " + ic);
                        }
                        if (j % 2 == 0) {
                            this.mTempRow.add(new String(tempValue.trim()));
                            tempValue = "";
                            dontExpectComma = false;
                            ++i;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! Found the beginnig of a binary value " + tempValue + " but not a correct end\nfrom token: " + tempInput + "\nposition: " + ic);
                    }
                    if (dontExpectComma && (Character.isDigit(currentChar) || currentChar == '-' || currentChar == '+' || currentChar == '.' || currentChar == '<' || currentChar == '>' || currentChar == '/' || currentChar == '=' || currentChar == '%')) {
                        tempValue = tempValue + currentChar;
                        while (i < tempInput.length() - 1) {
                            if ((currentChar = tempInput.charAt(++i)) == ',') {
                                --i;
                                break;
                            }
                            tempValue = tempValue + currentChar;
                        }
                        try {
                            if (tempValue.matches("(RANGE:)?(([<>]=?" + numberPattern + ")|(" + numberPattern + "/" + numberPattern + "\\%?))")) {
                                if (!tempValue.startsWith("RANGE:")) {
                                    tempValue = "RANGE:" + tempValue;
                                }
                                this.mTempRow.add(tempValue);
                            } else {
                                BigDecimal myBigValue = new BigDecimal(tempValue.trim());
                                this.mTempRow.add(myBigValue);
                            }
                        }
                        catch (NumberFormatException nfe) {
                            ic = i + 1;
                            throw new RuntimeException("Wrong data definition! Tried to build a number with: " + tempValue + " \nfrom token: " + tempInput + "\nposition: " + ic);
                        }
                        dontExpectComma = false;
                        ++i;
                        tempValue = "";
                        continue;
                    }
                    if (dontExpectComma && currentChar == 'R') {
                        if (i + 6 <= tempInput.length() && tempInput.substring(i, i + 6).compareToIgnoreCase("REGEX:") == 0) {
                            tempValue = "REGEX:";
                            i += 6;
                            dontExpectComma = true;
                            continue;
                        }
                        if (i + 6 <= tempInput.length() && tempInput.substring(i, i + 6).compareToIgnoreCase("RANGE:") == 0) {
                            tempValue = "RANGE:";
                            i += 6;
                            dontExpectComma = true;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! Expected the words \"REGEX:\" but found something else.\ntoken: " + tempInput + "\nposition: " + ic);
                    }
                    if (dontExpectComma && currentChar == '\'') {
                        isOpenedApostrophe = true;
                        while (i < tempInput.length() - 1) {
                            if ((currentChar = tempInput.charAt(++i)) == '\'') {
                                if (i + 1 < tempInput.length()) {
                                    if (tempInput.charAt(i + 1) == '\'') {
                                        tempValue = tempValue + currentChar;
                                        ++i;
                                        continue;
                                    }
                                    isOpenedApostrophe = false;
                                    break;
                                }
                                isOpenedApostrophe = false;
                                break;
                            }
                            tempValue = tempValue + currentChar;
                        }
                        if (!isOpenedApostrophe) {
                            this.mTempRow.add(new String(tempValue));
                            tempValue = "";
                            dontExpectComma = false;
                            ++i;
                            continue;
                        }
                        ic = i + 1;
                        throw new RuntimeException("Wrong data definition! ( unclosed apostrophe ).\ntoken: " + tempInput + "\nposition: " + ic);
                    }
                    ic = i + 1;
                    throw new RuntimeException("Wrong data definition! Expecting a number, a string or NULL.\ntoken: " + tempInput + "\nposition: " + ic);
                }
                if (dontExpectComma || tempValue.length() > 0) {
                    throw new RuntimeException("Wrong data definition! \ntoken: " + tempInput + "\nposition: " + i);
                }
                if (this.mColumnnamesDefined && this.mColumnNumber != this.mTempRow.size()) {
                    throw new RuntimeException("Wrong data definition! Found " + (this.mTempRow.size() == 1 ? "one entry" : this.mTempRow.size() + " entries") + ", but " + this.mColumnNumber + " column's exists.\ntoken: " + tempInput);
                }
                this.mValues.add(this.mTempRow.clone());
                if (this.mColumnNumber == 0) {
                    this.mColumnNumber = this.mTempRow.size();
                }
                ++this.mRowNumber;
                this.mTempRow.clear();
            }
            ++indexOfArray;
        }
        this.setRowCounter(this.mRowNumber);
        this.mErrorMessage = "No errors.";
    }

    public void add(ResultSet Set2) throws RuntimeException {
        this.setGeneratedFromResultSet(true);
        if (Set2 == null) {
            throw new RuntimeException("ResultSet is NULL.");
        }
        try {
            int i;
            if (Set2.getType() != 1003) {
                Set2.beforeFirst();
            }
            ResultSetMetaData MetaData = Set2.getMetaData();
            if (this.mColumnNumber == 0) {
                this.mColumnNumber = MetaData.getColumnCount();
            } else if (this.mColumnNumber != MetaData.getColumnCount()) {
                throw new RuntimeException("Count of columns in result set ( " + MetaData.getColumnCount() + " ) does not match with count of existing column ( " + this.mColumnNumber + " )!");
            }
            for (i = 0; i < this.mColumnNumber; ++i) {
                if (this.mColumnnamesDefined) {
                    if (((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType() != MetaData.getColumnType(i)) {
                        throw new RuntimeException("Wrong column type occured. Expected: " + ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType() + ", but found: " + MetaData.getColumnType(i));
                    }
                    if (((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName().compareTo(MetaData.getColumnName(i)) == 0) continue;
                    throw new RuntimeException("Wrong column name occured. Expected: " + ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName() + ", but found: " + MetaData.getColumnName(i));
                }
                this.mColumnDescriptions.add(new ColumnDescriptor(MetaData.getColumnName(i + 1), ColumnDescriptor.getType(MetaData.getColumnTypeName(i + 1))));
            }
            if (!this.mColumnnamesDefined) {
                this.mColumnnamesDefined = true;
            }
            while (Set2.next()) {
                for (i = 0; i < this.mColumnNumber; ++i) {
                    String myLittleString;
                    block21: {
                        if (ColumnDescriptor.isNumeric(MetaData.getColumnType(i + 1))) {
                            try {
                                BigDecimal myBigDecimal = Set2.getBigDecimal(i + 1);
                                if (Set2.wasNull()) {
                                    this.mTempRow.add(null);
                                    continue;
                                }
                                this.mTempRow.add(new BigDecimal(myBigDecimal.unscaledValue(), myBigDecimal.scale()));
                            }
                            catch (SQLException se) {
                                if (se.getErrorCode() != -10811) break block21;
                                this.mTempRow.add(new String("NaN"));
                            }
                            continue;
                        }
                    }
                    if (ColumnDescriptor.isString(MetaData.getColumnType(i + 1))) {
                        myLittleString = Set2.getString(i + 1);
                        if (Set2.wasNull()) {
                            this.mTempRow.add(null);
                            continue;
                        }
                        this.mTempRow.add(new String(myLittleString));
                        continue;
                    }
                    if (ColumnDescriptor.isBinary(MetaData.getColumnType(i + 1))) {
                        myLittleString = ColumnDescriptor.hex2String(Set2.getBytes(i + 1)).toUpperCase();
                        if (Set2.wasNull()) {
                            this.mTempRow.add(null);
                            continue;
                        }
                        this.mTempRow.add(new String(myLittleString));
                        continue;
                    }
                    throw new RuntimeException("Neither a string, a number nor a binary found. Get for column: " + MetaData.getColumnName(i + 1) + ": SQLType: " + MetaData.getColumnType(i + 1) + " and SQLTypeName: " + MetaData.getColumnTypeName(i + 1));
                }
                this.mValues.add(this.mTempRow.clone());
                this.mTempRow.clear();
            }
            this.mRowNumber = this.mValues.size();
            this.setRowCounter(this.mRowNumber);
        }
        catch (SQLException sqle) {
            this.mErrorMessage = "Error.";
            throw new RuntimeException("Catched SQLException: " + sqle.getLocalizedMessage() + " Errorcode:" + sqle.getErrorCode());
        }
        this.mErrorMessage = "No errors.";
    }

    public void ignoreCellForVerification(int Row, int Column) throws RuntimeException {
        if (this.mRowNumber == 0) {
            throw new RuntimeException("Error. Verification data object is empty!");
        }
        if (this.mRowNumber < Row) {
            throw new RuntimeException("Error. Row number " + Row + " does not exist in verification data object! Max rows in this object: " + this.mRowNumber);
        }
        if (this.mColumnNumber < Column) {
            throw new RuntimeException("Error. Column number " + Column + " does not exist in verification data object! Max columns in this object: " + this.mColumnNumber);
        }
        this.mTempRow = (ArrayList)this.mValues.get(Row - 1);
        this.mTempRow.set(Column - 1, "IGNORE");
        this.mValues.set(Row - 1, this.mTempRow.clone());
    }

    protected boolean checkMetaData(ResultSet Set2) throws Exception {
        ResultSetMetaData MetaData = Set2.getMetaData();
        int ColumnNumber = MetaData.getColumnCount();
        if (ColumnNumber != this.mColumnNumber) {
            throw new RuntimeException("Wrong number of columns: Expecting <" + this.mColumnNumber + ">, but found <" + ColumnNumber + "> columns.");
        }
        for (int i = 0; i < this.mColumnNumber; ++i) {
            if (!this.mColumnnamesDefined) continue;
            ColumnDescriptor Col = (ColumnDescriptor)this.mColumnDescriptions.get(i);
            if (!(!this.mCheckColumnNames || Col.getName().compareTo(MetaData.getColumnName(i + 1)) == 0 || Col.getName().equalsIgnoreCase("OWNER") && MetaData.getColumnName(i + 1).equalsIgnoreCase("SCHEMANAME") || Col.getName().equalsIgnoreCase("SCHEMANAME") && MetaData.getColumnName(i + 1).equalsIgnoreCase("OWNER"))) {
                throw new RuntimeException("Wrong column name in column " + (i + 1) + ": Expecting <" + Col.getName() + ">, but found <" + MetaData.getColumnName(i + 1) + ">.");
            }
            if (Col.compareType(MetaData.getColumnType(i + 1))) continue;
            throw new RuntimeException("Wrong data type of column " + (i + 1) + ", name: " + MetaData.getColumnName(i + 1) + ": Expecting <" + Col.getTypeName() + ">, but found <" + ColumnDescriptor.getTypeName(MetaData.getColumnType(i + 1)) + ">.");
        }
        return true;
    }

    protected boolean checkMetaData(VerificationData Set2) throws RuntimeException {
        int ColumnNumber = 0;
        ColumnDescriptor Col = null;
        ColumnDescriptor ColFromSet = null;
        ColumnNumber = Set2.getColumnCounter();
        if (ColumnNumber != this.mColumnNumber) {
            throw new RuntimeException("Wrong number of columns: Expecting <" + this.mColumnNumber + ">, but found <" + ColumnNumber + "> columns.");
        }
        for (int i = 0; i < this.mColumnNumber; ++i) {
            if (!this.mColumnnamesDefined) continue;
            Col = (ColumnDescriptor)this.mColumnDescriptions.get(i);
            ColFromSet = (ColumnDescriptor)Set2.getColumnDescriptions().get(i);
            if (!(!this.mCheckColumnNames || Col.getName().compareTo(ColFromSet.getName()) == 0 || Col.getName().equalsIgnoreCase("OWNER") && ColFromSet.getName().equalsIgnoreCase("SCHEMANAME") || Col.getName().equalsIgnoreCase("SCHEMANAME") && ColFromSet.getName().equalsIgnoreCase("OWNER"))) {
                throw new RuntimeException("Wrong column name in column " + (i + 1) + ": Expecting <" + Col.getName() + ">, but found <" + ColFromSet.getName() + ">.");
            }
            if (Col.compareType(ColFromSet.getType())) continue;
            throw new RuntimeException("Wrong data type of column " + (i + 1) + ", name: " + ColFromSet.getName() + ": Expecting <" + Col.getTypeName() + ">, but found <" + ColumnDescriptor.getTypeName(ColFromSet.getType()) + ">.");
        }
        return true;
    }

    protected void checkResultCounter(ResultSet Set2) throws RuntimeException {
        if (this.mResultCounter != -1) {
            int resultCounterInSet = 0;
            try {
                Set2.beforeFirst();
                while (Set2.next()) {
                    ++resultCounterInSet;
                }
            }
            catch (SQLException sqle) {
                throw new RuntimeException("Can't check number of results.");
            }
            if (this.mResultCounter != resultCounterInSet) {
                throw new RuntimeException("Wrong number of results: Expecting <" + this.mResultCounter + "> rows, but found <" + resultCounterInSet + ">.");
            }
        }
    }

    protected void checkResultCounter(VerificationData Set2) throws RuntimeException {
        if (this.mResultCounter != -1 && this.mResultCounter != Set2.getRowCounter()) {
            throw new RuntimeException("Wrong number of results: Expecting <" + this.mResultCounter + "> rows, but found <" + Set2.getRowCounter() + ">.");
        }
    }

    public void clear() {
        this.mValues.clear();
        this.mColumnDescriptions.clear();
        this.mTempRow.clear();
        this.mColumnnamesDefined = false;
        this.mResultCounter = -1;
        this.mErrorMessage = "No error.";
        this.mColumnNumber = 0;
        this.mRowNumber = 0;
        this.setGeneratedFromResultSet(false);
    }

    private String paddTo(String str, int len) {
        int l = str.length();
        if (l < len) {
            char[] ca = new char[len - l];
            Arrays.fill(ca, ' ');
            return str + new String(ca);
        }
        if (l == len) {
            return str;
        }
        return str.substring(0, len - 2) + "..";
    }

    public void setTheCellLengthOfTheResultset(int newLength) {
        if (newLength > 2) {
            this.mCharInACell = newLength;
        }
    }

    public String toString() {
        String dummy = null;
        if (this.mRowNumber != 0 || this.mColumnNumber != 0) {
            if (this.mColumnnamesDefined) {
                int i;
                dummy = "";
                for (i = 0; i < this.mColumnNumber; ++i) {
                    dummy = dummy + this.paddTo(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getName(), this.mCharInACell);
                    dummy = dummy + " ";
                }
                dummy = dummy + "\n";
                for (i = 0; i < this.mColumnNumber; ++i) {
                    dummy = dummy + this.paddTo("" + ((ColumnDescriptor)this.mColumnDescriptions.get(i)).getType(), this.mCharInACell);
                    dummy = dummy + " ";
                }
                dummy = dummy + "\n";
                for (i = 0; i < this.mColumnNumber; ++i) {
                    dummy = dummy + this.paddTo(((ColumnDescriptor)this.mColumnDescriptions.get(i)).getTypeName(), this.mCharInACell);
                    dummy = dummy + " ";
                }
            }
            if (dummy == null) {
                dummy = "No column information (type and name) available.";
            }
            dummy = dummy + "\n\n";
            ArrayList tempRow = new ArrayList();
            String valueInRow = null;
            for (int i = 0; i < this.mRowNumber; ++i) {
                tempRow = (ArrayList)this.mValues.get(i);
                for (int j = 0; j < tempRow.size(); ++j) {
                    if (tempRow.get(j) == null) {
                        dummy = dummy + this.paddTo("NULL", this.mCharInACell);
                        dummy = dummy + " ";
                        continue;
                    }
                    valueInRow = tempRow.get(j).toString();
                    dummy = dummy + this.paddTo(valueInRow, this.mCharInACell);
                    dummy = dummy + " ";
                }
                dummy = dummy + "\n";
            }
        }
        return dummy;
    }

    public String resultSetRowToString(ResultSet Set2, int row) {
        String dummy = "";
        Object dummyobj = null;
        try {
            if (Set2.getType() != 1003) {
                Set2.absolute(row);
            }
            for (int i = 0; i < Set2.getMetaData().getColumnCount(); ++i) {
                dummyobj = Set2.getMetaData().getColumnType(i + 1) == -2 ? ColumnDescriptor.hex2String(Set2.getBytes(i + 1)) : Set2.getObject(i + 1);
                if (Set2.wasNull()) {
                    dummy = dummy + " NULL,";
                    continue;
                }
                dummy = dummy + this.paddTo(" " + dummyobj, this.mCharInACell);
                dummy = dummy + ",";
            }
            if ((dummy = dummy.trim()).length() > 3) {
                dummy = dummy.substring(0, dummy.length() - 1);
            }
        }
        catch (SQLException sqle) {
            dummy = dummy + " n/a -> " + sqle.getLocalizedMessage();
        }
        return dummy;
    }

    public String verificationDataRowToString(VerificationData Set2, int row) {
        String dummy = "";
        Object dummyobj = null;
        try {
            ArrayList thisRow = (ArrayList)Set2.getRows().get(row);
            for (int i = 0; i < thisRow.size(); ++i) {
                dummyobj = thisRow.get(i);
                if (dummyobj == null) {
                    dummy = dummy + this.paddTo(" NULL,", this.mCharInACell);
                    continue;
                }
                dummy = dummy + this.paddTo(" " + dummyobj, this.mCharInACell);
                dummy = dummy + ",";
            }
            if ((dummy = dummy.trim()).length() > 3) {
                dummy = dummy.substring(0, dummy.length() - 1);
            }
        }
        catch (Exception e) {
            dummy = dummy + " n/a -> " + e.getLocalizedMessage();
        }
        return dummy;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void compareNumber(ResultSet Set2, int Column, int Row, Object Value) throws RuntimeException {
        try {
            BigDecimal RefVal = Set2.getBigDecimal(Column);
            this.compareNumber(RefVal, Column, Row, Value);
        }
        catch (SQLException e) {
            if (e.getErrorCode() == -10811) {
                if (!((String)Value).equalsIgnoreCase("NaN")) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found 'NaN' value.");
                }
            }
            throw new RuntimeException("Illegal ResultSet. " + e.getLocalizedMessage());
        }
    }

    protected void compareNumber(VerificationData Set2, int Column, int Row, Object Value) throws RuntimeException {
        Object RefObj = null;
        RefObj = ((ArrayList)Set2.getRows().get(Row)).get(Column);
        this.compareNumber((Object)RefObj, Column + 1, Row + 1, Value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void compareNumber(Object RefObj, int Column, int Row, Object Value) throws RuntimeException {
        try {
            if (Value != null && Value instanceof String && ((String)Value).equalsIgnoreCase("IGNORE")) {
                return;
            }
            if (Value == null || RefObj == null) {
                if (Value == null && RefObj != null) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefObj + ">.");
                }
                if (Value == null || RefObj != null) return;
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">:  Expecting <" + Value + ">, but found NULL value.");
            } else if (Value != null && Value instanceof String && ((String)Value).equalsIgnoreCase("NaN")) {
                if (RefObj == null || !(RefObj instanceof String) || ((String)RefObj).equalsIgnoreCase("NaN")) return;
                throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NaN value, but found <" + RefObj + ">.");
            } else {
                BigDecimal RefVal = (BigDecimal)RefObj;
                if (Value != null && Value instanceof String && ((String)Value).startsWith("RANGE:")) {
                    String m_Value = ((String)Value).replaceAll(" ", "").substring(6);
                    if (m_Value.charAt(0) == '<') {
                        if (m_Value.charAt(1) == '=') {
                            if (RefVal.compareTo(new BigDecimal(m_Value.substring(2))) <= 0) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  <=" + m_Value.substring(2) + ">, but found <" + RefVal + ">.");
                        } else {
                            if (RefVal.compareTo(new BigDecimal(m_Value.substring(1))) < 0) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  <" + m_Value.substring(1) + ">, but found <" + RefVal + ">.");
                        }
                    } else if (m_Value.charAt(0) == '>') {
                        if (m_Value.charAt(1) == '=') {
                            if (RefVal.compareTo(new BigDecimal(m_Value.substring(2))) >= 0) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  >=" + m_Value.substring(2) + ">, but found <" + RefVal + ">.");
                        } else {
                            if (RefVal.compareTo(new BigDecimal(m_Value.substring(1))) > 0) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <  >" + m_Value.substring(1) + ">, but found <" + RefVal + ">.");
                        }
                    } else {
                        if (m_Value.indexOf("/") == -1) throw new RuntimeException("Wrong syntax. Found a range but it didn't start with '<' or '>' or have a '/' inside.");
                        String[] valueArray = m_Value.split("/");
                        if (valueArray[1].indexOf("%") != -1) {
                            valueArray[1] = valueArray[1].substring(0, valueArray[1].indexOf("%"));
                            BigDecimal bd1 = new BigDecimal(valueArray[0]);
                            BigDecimal bd2 = new BigDecimal(valueArray[1]);
                            BigDecimal bd3 = null;
                            bd3 = bd1.multiply(bd2).divide(BigDecimal.valueOf(100L), 4, 6);
                            if (RefVal.compareTo(bd1.subtract(bd3)) >= 0 && RefVal.compareTo(bd1.add(bd3)) <= 0) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting < " + bd1.subtract(bd3).toString() + " <= x <= " + bd1.add(bd3).toString() + " >, but found <" + RefVal + ">.");
                        } else {
                            if (RefVal.compareTo(new BigDecimal(valueArray[0])) >= 0 && RefVal.compareTo(new BigDecimal(valueArray[1])) <= 0) return;
                            throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting < " + valueArray[0] + " <= x <= " + valueArray[1] + " >, but found <" + RefVal + ">.");
                        }
                    }
                } else {
                    if (RefVal.compareTo((BigDecimal)Value) == 0) return;
                    throw new RuntimeException("Wrong value in row <" + (Row + 1) + ">, column <" + (Column + 1) + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
                }
            }
        }
        catch (Exception e) {
            if (!((String)RefObj).equalsIgnoreCase("NaN")) throw new RuntimeException("Can not create a number and it is not: 'NaN'. -> " + e.getLocalizedMessage());
            throw new RuntimeException("Wrong value in row <" + (Row + 1) + ">, column <" + (Column + 1) + ">:  Expecting <" + Value + ">, but found a 'NaN' value.");
        }
    }

    protected void compareString(ResultSet Set2, int Column, int Row, String Value) throws RuntimeException {
        this.compareString(Set2, Column, Row, Value, null);
    }

    protected void compareString(ResultSet Set2, int Column, int Row, String Value, String expr) throws RuntimeException {
        try {
            String RefVal = Set2.getString(Column);
            this.compareString(RefVal, Column, Row, Value, expr);
        }
        catch (SQLException e) {
            throw new RuntimeException("Illegal ResultSet found. " + e.getLocalizedMessage());
        }
    }

    protected void compareString(VerificationData Set2, int Column, int Row, String Value) throws RuntimeException {
        this.compareString(Set2, Column, Row, Value, null);
    }

    protected void compareString(Object RefObj, int Column, int Row, String Value) throws RuntimeException {
        this.compareString(RefObj, Column, Row, Value, null);
    }

    protected void compareString(VerificationData Set2, int Column, int Row, String Value, String expr) throws RuntimeException {
        Object RefObj = ((ArrayList)Set2.getRows().get(Row)).get(Column);
        this.compareString(RefObj, Column, Row, Value, expr);
    }

    protected void compareString(Object RefObj, int Column, int Row, String Value, String expr) throws RuntimeException {
        try {
            if (Value != null && Value.equalsIgnoreCase("IGNORE")) {
                return;
            }
            if (Value == null || RefObj == null) {
                if (Value == null && RefObj != null) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefObj + ">.");
                }
                if (Value != null && RefObj == null) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">:  Expecting <" + Value + ">, but found NULL value.");
                }
            } else {
                String RefVal = (String)RefObj;
                if (expr != null) {
                    Regex regexpr = Regex.perlCode((String)expr);
                    Value = regexpr.replaceAll(Value);
                    RefVal = regexpr.replaceAll(RefVal);
                }
                if (Value.startsWith("REGEX:")) {
                    if (!RefVal.matches(Value.substring(6))) {
                        throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value.substring(6) + ">, but found <" + RefVal + ">.");
                    }
                } else if (RefVal.compareTo(Value) != 0) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting <" + Value + ">, but found <" + RefVal + ">.");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal verification data object found. " + e.getLocalizedMessage());
        }
    }

    protected void compareBinary(ResultSet Set2, int Column, int Row, String Value) throws RuntimeException {
        try {
            String RefObj = null;
            byte[] bytes = Set2.getBytes(Column);
            if (!Set2.wasNull()) {
                RefObj = ColumnDescriptor.hex2String(bytes);
            }
            this.compareBinary(RefObj, Column, Row, Value);
        }
        catch (SQLException e) {
            throw new RuntimeException("Illegal Resultset found. " + e.getLocalizedMessage());
        }
    }

    protected void compareBinary(VerificationData Set2, int Column, int Row, String Value) throws RuntimeException {
        Object RefObj = ((ArrayList)Set2.getRows().get(Row)).get(Column);
        this.compareBinary(RefObj, Column + 1, Row + 1, Value);
    }

    protected void compareBinary(Object RefObj, int Column, int Row, String Value) throws RuntimeException {
        try {
            if (Value != null && Value.equalsIgnoreCase("IGNORE")) {
                return;
            }
            if (Value == null || RefObj == null) {
                if (Value == null && RefObj != null) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: Expecting NULL value, but found <" + RefObj + ">.");
                }
                if (Value != null && RefObj == null) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">:  Expecting <" + Value + ">, but found NULL value.");
                }
            } else {
                String RefVal = ((String)RefObj).replaceAll("0+$", "");
                if (!RefVal.equalsIgnoreCase(Value.replaceAll("0+$", ""))) {
                    throw new RuntimeException("Wrong value in row <" + Row + ">, column <" + Column + ">: \nExpecting <" + Value.toUpperCase() + ">, \nbut found <" + RefVal.toUpperCase() + ">.");
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Illegal verification data object found. -> " + e.getLocalizedMessage());
        }
    }

    public abstract boolean equals(ResultSet var1);

    public abstract boolean equals(VerificationData var1);

    public String getErrorMessage() {
        return this.mErrorMessage;
    }

    public abstract char getOperatorType();

    public Iterator iterator() {
        return new VerificationDataIterator(this.mValues, this.mColumnDescriptions, this.mColumnnamesDefined);
    }

    public Iterator iteratorPretty() {
        return new VerificationDataIteratorPretty(this.mValues, this.mColumnDescriptions, this.mColumnnamesDefined);
    }

    public void setColumnNameCheck(boolean CheckOrNot) {
        this.mCheckColumnNames = CheckOrNot;
    }

    void setRowCounter(int RowCounter) {
        this.mResultCounter = RowCounter;
    }

    public int getRowCounter() {
        return this.mResultCounter;
    }

    void setColumnCounter(int ColumnCounter) {
        this.mColumnNumber = ColumnCounter;
    }

    public int getColumnCounter() {
        return this.mColumnNumber;
    }

    protected ArrayList getRows() {
        return this.mValues;
    }

    protected ArrayList getColumnDescriptions() {
        return this.mColumnDescriptions;
    }

    protected void generateHashTable(Regex regexpr) {
        this.rowHash.clear();
        this.notHashableRows.clear();
        for (int n = 0; n < this.mRowNumber; ++n) {
            ArrayList dataRow = (ArrayList)this.mValues.get(n);
            Integer hash = VerificationData.createRowHash(dataRow, this.mColumnNumber, regexpr);
            if (hash == null) {
                this.notHashableRows.add(new Integer(n));
                continue;
            }
            LinkedList<Integer> ll = (LinkedList<Integer>)this.rowHash.get(hash);
            if (ll == null) {
                ll = new LinkedList<Integer>();
            }
            ll.add(new Integer(n));
            this.rowHash.put(hash, ll);
        }
    }

    protected static Integer createRowHash(ArrayList dataRow, int length, Regex regexpr) {
        ArrayList<Object> newDataRow = new ArrayList<Object>(dataRow);
        for (int i = 0; i < length; ++i) {
            if (dataRow.get(i) instanceof String) {
                String value = dataRow.get(i).toString();
                if (value.startsWith("REGEX:") || value.startsWith("RANGE:") || value.equalsIgnoreCase("IGNORE")) {
                    return null;
                }
                if (value.matches("\\p{XDigit}+")) {
                    newDataRow.set(i, value.replaceAll("0+$", ""));
                }
                if (regexpr != null) {
                    newDataRow.set(i, regexpr.replaceAll(value));
                }
            }
            if (!(dataRow.get(i) instanceof BigDecimal)) continue;
            newDataRow.set(i, Double.valueOf(dataRow.get(i).toString()));
        }
        return new Integer(newDataRow.hashCode());
    }

    public boolean isGeneratedFromResultSet() {
        return this.generatedFromResultSet;
    }

    private void setGeneratedFromResultSet(boolean generatedFromResultSet) {
        this.generatedFromResultSet = generatedFromResultSet;
    }
}

