/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.TestProtocol;
import com.sap.sapdb.testframe.testcase.ExplainDataIterator;
import com.sap.sapdb.testframe.testcase.ExplainDataIteratorPretty;
import com.sap.sapdb.testframe.testcase.TestStatement;
import com.sap.sapdb.testframe.testcase.VerificationDataComplete;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;

public class TestTrace {
    private PrintWriter mTraceWriter;
    private boolean mPrinted = false;
    private File mTraceFile = null;
    private boolean mPrintResults = true;
    private boolean mPrintExplain = true;

    public TestTrace() {
        this.mTraceWriter = new PrintWriter(new BufferedOutputStream(System.out), true);
    }

    public TestTrace(String pTraceFilePath, String pTraceFileName, String pTraceFileExtension, int pTraceFileVersion) {
        try {
            this.mTraceFile = TestProtocol.createFile(pTraceFilePath, pTraceFileName, pTraceFileExtension, pTraceFileVersion).getFile();
            this.mTraceWriter = new PrintWriter((Writer)new BufferedWriter(new FileWriter(this.mTraceFile)), true);
        }
        catch (IOException e) {
            System.err.println("Cannot open trace file: " + e.getMessage());
            e.printStackTrace(System.err);
        }
    }

    public void finalize() {
        if (this.mTraceFile != null && !this.mPrinted) {
            this.mTraceFile.delete();
        }
        try {
            this.mTraceWriter.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void flush() {
        this.mTraceWriter.flush();
    }

    public boolean isPrintExplain() {
        return this.mPrintExplain;
    }

    public boolean isPrintResults() {
        return this.mPrintResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(TestStatement pStatement, String pStep, String pSqlString) {
        ExplainDataIteratorPretty it;
        StringBuffer sb = new StringBuffer();
        String deli = System.getProperty("line.separator");
        if (!this.mPrinted) {
            this.mPrinted = true;
        }
        int ll = pSqlString.length();
        int k = 0;
        k = ll / 70;
        sb.append(deli + "Command: <<< Step " + pStep + " >>>");
        for (int i = 0; i <= k; ++i) {
            int j = (i + 1) * 70;
            if (j > ll) {
                j = ll;
            }
            sb.append(deli + "   " + pSqlString.substring(i * 70, j));
        }
        if (this.mPrintResults) {
            if (pStatement.getException() != null) {
                sb.append(deli + deli + "Result:");
                sb.append(deli + "   " + ((SQLException)pStatement.getException()).getErrorCode() + " " + ((SQLException)pStatement.getException()).getMessage());
            } else {
                ResultSet lRs = null;
                try {
                    lRs = pStatement.getResultSet();
                }
                catch (SQLException e) {
                    // empty catch block
                }
                if (lRs == null) {
                    sb.append(deli + deli + "Result:");
                    sb.append(deli + "   " + pStatement.getResultCounter());
                } else {
                    VerificationDataComplete lVd = new VerificationDataComplete(lRs);
                    Iterator lIt = lVd.iteratorPretty();
                    if (lIt != null) {
                        sb.append(deli + deli + "Result:");
                        int ii = 0;
                        while (lIt.hasNext()) {
                            if (ii++ > 100) {
                                sb.append(deli + deli + "too many result entries. Result output cut at this point");
                                break;
                            }
                            sb.append(deli + lIt.next().toString());
                        }
                    }
                }
            }
        }
        if (this.mPrintExplain && pStatement.getExplainObject() != null && (it = pStatement.getExplainObject().iteratorPretty()) != null) {
            sb.append(deli + deli + "Explain:");
            while (it.hasNext()) {
                sb.append(deli + ((ExplainDataIterator)it).next().toString());
            }
        }
        if (sb.length() > 0) {
            PrintWriter printWriter = this.mTraceWriter;
            synchronized (printWriter) {
                this.mTraceWriter.println(sb.toString());
            }
        }
    }

    public void setPrintExplain(boolean newPrintExplain) {
        this.mPrintExplain = newPrintExplain;
    }

    public void setPrintResults(boolean newPrintResults) {
        this.mPrintResults = newPrintResults;
    }
}

