/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.dbtech.jdbc.PeekAndPoke;
import com.sap.dbtech.powertoys.DBM;
import com.sap.sapdb.testframe.driver.TestDatabaseException;
import com.sap.sapdb.testframe.driver.TestStatementMonitorException;
import com.sap.sapdb.testframe.testcase.TestPreparedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class TestStatementMonitor {
    static final String MONITOR_TIME = "Diagnose monitor time";
    static final String MONITOR_READ = "Diagnose monitor read";
    static final String MONITOR_SEL = "Diagnose monitor selectivity";
    static final String SQL_STAT = "SQL_STATEMENT";
    static final String ROWS_READ = "ROWS_READ";
    static final String ROWS_QUAL = "ROWS_QUAL";
    static final String VIRTUAL_READS = "VIRTUAL_READS";
    static final String PHYSICAL_IO = "PHYSICAL_IO";
    static final String STRATEGY = "STRATEGY";
    static final String RUNTIME = "RUNTIME";
    static final String EXECTIME = "TOTCMDEXECUTETIME";
    static final String SIOREADCNT = "SIOREADCNT";
    static final String SIOWRITECNT = "SIOWRITECNT";
    static final String IOREADCNT = "IOREADCNT";
    static final String IOWRITECNT = "IOWRITECNT";
    static final String DIOREADCNT = "DIOREADCNT";
    static final String DIOWRITECNT = "DIOWRITECNT";
    private Connection mConnection = null;
    private HashMap mMonitorResults = null;
    private HashMap mMonitorXCONSResults = null;
    private boolean mIsActivated = false;
    private boolean mIsActive = false;
    private int mActiveTimeThreshold;
    private Statement mHelpStatement = null;
    private String mDBMHost;
    private String mDBMName;
    private int mPort = -1;
    private DBM mDBMan = null;

    public TestStatementMonitor(Connection pConnection) throws TestStatementMonitorException {
        this.mConnection = pConnection;
        this.mMonitorResults = new HashMap();
        try {
            this.mHelpStatement = this.mConnection.createStatement();
        }
        catch (SQLException se) {
            throw new TestStatementMonitorException(se.getMessage());
        }
    }

    public TestStatementMonitor(Connection pConnection, String pDBMHost, String pDBMName) throws TestStatementMonitorException {
        this.mConnection = pConnection;
        this.mMonitorResults = new HashMap();
        this.mMonitorXCONSResults = new HashMap();
        this.mDBMHost = pDBMHost;
        this.mDBMName = pDBMName;
        try {
            this.mHelpStatement = this.mConnection.createStatement();
        }
        catch (SQLException se) {
            throw new TestStatementMonitorException(se.getMessage());
        }
    }

    public TestStatementMonitor(Connection pConnection, String pDBMHost, String pDBMName, int pPort) throws TestStatementMonitorException {
        this.mConnection = pConnection;
        this.mMonitorResults = new HashMap();
        this.mMonitorXCONSResults = new HashMap();
        this.mDBMHost = pDBMHost;
        this.mDBMName = pDBMName;
        this.mPort = pPort;
        try {
            this.mHelpStatement = this.mConnection.createStatement();
        }
        catch (SQLException se) {
            throw new TestStatementMonitorException(se.getMessage());
        }
    }

    public TestStatementMonitor(Connection pConnection, String pSql) throws TestStatementMonitorException {
        this(pConnection);
        this.execute(pSql);
    }

    public void activate() throws TestStatementMonitorException {
        if (this.mIsActivated) {
            return;
        }
        if (this.isThresholdTimeActive()) {
            this.mIsActive = true;
            this.mActiveTimeThreshold = this.getThresholdTime();
        } else {
            this.mIsActive = false;
        }
        this.clear();
        if (this.mIsActive) {
            if (this.mActiveTimeThreshold != 0) {
                this.setThresholdTime(0);
            }
        } else {
            this.setThresholdTime(0);
            this.mIsActivated = true;
        }
    }

    protected static void appendNChar(StringBuffer pStb, char pChar, int pNumber) {
        for (int i = 0; i < pNumber; ++i) {
            pStb.append(pChar);
        }
    }

    protected static void appendNSpaces(StringBuffer pStb, int pNumber) {
        for (int i = 0; i < pNumber; ++i) {
            pStb.append(' ');
        }
    }

    public void clear() throws TestStatementMonitorException {
        try {
            this.mHelpStatement.executeUpdate("Diagnose monitor clear");
            this.mMonitorResults.clear();
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public void initializeXCONS() throws TestStatementMonitorException {
        try {
            this.mMonitorResults.clear();
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public String executeDBMCmd(String pCmd) throws TestDatabaseException {
        String logon = "";
        try {
            if (this.mDBMan == null) {
                this.mDBMan = this.mPort != -1 ? DBM.dbDBM((String)(this.mDBMHost + ":" + this.mPort), (String)this.mDBMName) : DBM.dbDBM((String)this.mDBMHost, (String)this.mDBMName);
                logon = "USER_LOGON DBM,DBM";
                this.mDBMan.cmd(logon);
            }
            return this.mDBMan.cmd(pCmd);
        }
        catch (Exception e) {
            System.out.println("Could not execute: " + pCmd);
            System.out.println("Exception: " + e.getMessage() + "\n" + e.getClass());
            throw new TestDatabaseException(e, " DBM command: " + pCmd + ", logon String: " + logon);
        }
    }

    public void clearXCONSResults() {
        this.mMonitorXCONSResults.clear();
    }

    public void enable() throws TestStatementMonitorException {
        try {
            this.executeDBMCmd("db_cons time enable");
            this.executeDBMCmd("db_cons reset t_cnt");
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public void deactivate() throws TestStatementMonitorException {
        if (!this.mIsActivated) {
            return;
        }
        if (this.mIsActive) {
            if (this.getThresholdTime() != this.mActiveTimeThreshold) {
                this.setThresholdTime(this.mActiveTimeThreshold);
            } else {
                this.setThresholdTimeOff();
                this.mIsActive = false;
            }
        }
        this.mIsActivated = false;
    }

    public void execute(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            this.activate();
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.close();
            this.fill(pid);
            this.deactivate();
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public void execute(TestPreparedStatement pSql) throws TestStatementMonitorException {
        try {
            this.activate();
            String pid = TestStatementMonitor.getParseId(pSql);
            ResultSet rs = pSql.executeQuery();
            rs.close();
            this.fill(pid);
            this.deactivate();
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pSql.close();
            }
            catch (Exception e) {}
        }
    }

    public void executeSel(String pSql, Connection pConnection, int pStatementTaskId) throws TestStatementMonitorException {
        PreparedStatement pstmt = null;
        long start = 0L;
        long end = 0L;
        long result = 0L;
        try {
            pstmt = pConnection.prepareStatement(pSql);
            this.enable();
            start = this.getDBTime();
            ResultSet rs = pstmt.executeQuery();
            rs.close();
            pConnection.commit();
            end = this.getDBTime();
            result = end - start;
            System.out.println("Runtime in ms (result) : " + result);
            this.fill(pStatementTaskId, result);
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public void execute(String pSql, Connection pConnection, int pStatementTaskId) throws TestStatementMonitorException {
        PreparedStatement pstmt = null;
        long start = 0L;
        long end = 0L;
        long result = 0L;
        try {
            pstmt = pConnection.prepareStatement(pSql);
            this.enable();
            start = this.getDBTime();
            pstmt.execute();
            pConnection.commit();
            end = this.getDBTime();
            result = end - start;
            System.out.println("Runtime in ms (result) : " + result);
            this.fill(pStatementTaskId, result);
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public void executeUpd(TestPreparedStatement pSql, int pStatementTaskId) throws TestStatementMonitorException {
        long start = 0L;
        long end = 0L;
        long result = 0L;
        try {
            start = this.getDBTime();
            pSql.execute();
            end = this.getDBTime();
            result = end - start;
            System.out.println("Runtime in ms (result) : " + result);
            this.fill(pStatementTaskId, result);
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public long getDBTime() {
        long outTime = 0L;
        ResultSet lRs = null;
        Timestamp lEndTime = null;
        try {
            lRs = this.mHelpStatement.executeQuery("Select now() from dual");
            if (lRs.next()) {
                lEndTime = lRs.getTimestamp(1);
                outTime = lEndTime.getTime() + (long)(lEndTime.getNanos() / 1000000);
            } else {
                System.out.println("No result for NOW()");
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        System.out.println("lEndTimeStamp : " + lEndTime);
        System.out.println("outTime: " + outTime);
        return outTime;
    }

    public String getTime() {
        String outTime = "";
        ResultSet lRs = null;
        Timestamp lEndTime = null;
        try {
            lRs = this.mHelpStatement.executeQuery("Select distinct now() from configuration");
            if (lRs.next()) {
                lEndTime = lRs.getTimestamp(1);
                outTime = lEndTime.toString().substring(11, 22);
            } else {
                System.out.println("No result for NOW()");
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return outTime;
    }

    public String getDate() {
        String outDate = "";
        ResultSet lRs = null;
        Timestamp lEndDate = null;
        try {
            lRs = this.mHelpStatement.executeQuery("Select now() from dual");
            if (lRs.next()) {
                lEndDate = lRs.getTimestamp(1);
                outDate = lEndDate.toString().substring(0, 10);
            } else {
                System.out.println("No result for NOW()");
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        return outDate;
    }

    public void fill(String pPid) throws TestStatementMonitorException {
        this.mMonitorResults.put(SQL_STAT, this.getStringFromSysparseid(SQL_STAT, pPid));
        this.mMonitorResults.put(STRATEGY, this.getStringFromSysmonitor(STRATEGY, pPid));
        this.mMonitorResults.put(RUNTIME, new Integer(this.getIntegerFromSysmonitor(RUNTIME, pPid)));
        this.mMonitorResults.put(RUNTIME, new Float(this.getFloatFromSysmonitor(RUNTIME, pPid)));
        this.mMonitorResults.put(PHYSICAL_IO, new Integer(this.getIntegerFromSysmonitor(PHYSICAL_IO, pPid)));
        this.mMonitorResults.put(VIRTUAL_READS, new Integer(this.getIntegerFromSysmonitor(VIRTUAL_READS, pPid)));
        this.mMonitorResults.put(ROWS_READ, new Integer(this.getIntegerFromSysmonitor(ROWS_READ, pPid)));
        this.mMonitorResults.put(ROWS_QUAL, new Integer(this.getIntegerFromSysmonitor(ROWS_QUAL, pPid)));
    }

    public void fill(int pStatementTaskId, long pRuntime) throws TestStatementMonitorException {
        block2: {
            this.mMonitorXCONSResults.put(EXECTIME, new Integer(this.getIntegerFromTaskDetails(EXECTIME, pStatementTaskId)));
            this.mMonitorXCONSResults.put(SIOREADCNT, new Integer(this.getIntegerFromTaskDetails(SIOREADCNT, pStatementTaskId)));
            this.mMonitorXCONSResults.put(SIOWRITECNT, new Integer(this.getIntegerFromTaskDetails(SIOWRITECNT, pStatementTaskId)));
            try {
                this.mMonitorXCONSResults.put(IOREADCNT, new Integer(this.getIntegerFromTaskDetails(IOREADCNT, pStatementTaskId)));
                this.mMonitorXCONSResults.put(IOWRITECNT, new Integer(this.getIntegerFromTaskDetails(IOWRITECNT, pStatementTaskId)));
            }
            catch (Exception e) {
                if (e.getMessage().indexOf("Unknown column name") == -1) break block2;
                this.mMonitorXCONSResults.put(DIOREADCNT, new Integer(this.getIntegerFromTaskDetails(DIOREADCNT, pStatementTaskId)));
                this.mMonitorXCONSResults.put(DIOWRITECNT, new Integer(this.getIntegerFromTaskDetails(DIOWRITECNT, pStatementTaskId)));
            }
        }
        this.mMonitorXCONSResults.put(RUNTIME, new Long(pRuntime));
    }

    private int getIntegerFromSysmonitor(String pColumn, String pPid) throws TestStatementMonitorException {
        Statement stmt = null;
        try {
            stmt = this.mConnection.createStatement();
            String sql = "Select " + pColumn + " from SYSMONITOR where PARSEID = x'" + pPid + "'";
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    private float getFloatFromSysmonitor(String pColumn, String pPid) throws TestStatementMonitorException {
        Statement stmt = null;
        try {
            stmt = this.mConnection.createStatement();
            String sql = "Select " + pColumn + " from SYSMONITOR where PARSEID = x'" + pPid + "'";
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                float f = rs.getFloat(1);
                return f;
            }
            float f = 0.0f;
            return f;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    private int getIntegerFromTaskDetails(String pColumn, int pStatementTaskId) throws TestStatementMonitorException {
        Statement stmt = null;
        try {
            stmt = this.mConnection.createStatement();
            String sql = "Select " + pColumn + " from DOMAIN.SYSMON_TASK_DETAIL where DBPID = " + pStatementTaskId;
            ResultSet rs = stmt.executeQuery(sql);
            if (rs.next()) {
                int n = rs.getInt(1);
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                stmt.close();
            }
            catch (Exception e) {}
        }
    }

    public int getNumberOfPhysicalReads() {
        return (Integer)this.mMonitorResults.get(PHYSICAL_IO);
    }

    public int getNumberOfPhysicalReads(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            this.activate();
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            this.deactivate();
            int n = this.getIntegerFromSysmonitor(PHYSICAL_IO, pid);
            return n;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public int getNumberOfPhysicalReads(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getIntegerFromSysmonitor(PHYSICAL_IO, pid);
    }

    public int getNumberOfRowsQualified() {
        return (Integer)this.mMonitorResults.get(ROWS_QUAL);
    }

    public int getNumberOfRowsQualified(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            this.activate();
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            this.deactivate();
            int n = this.getIntegerFromSysmonitor(ROWS_QUAL, pid);
            return n;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public int getNumberOfRowsQualified(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getIntegerFromSysmonitor(ROWS_QUAL, pid);
    }

    public int getNumberOfRowsRead() {
        return (Integer)this.mMonitorResults.get(ROWS_READ);
    }

    public int getNumberOfRowsRead(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            this.activate();
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            this.deactivate();
            int n = this.getIntegerFromSysmonitor(ROWS_READ, pid);
            return n;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public int getNumberOfRowsRead(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getIntegerFromSysmonitor(ROWS_READ, pid);
    }

    public int getNumberOfVirtualReads() {
        return (Integer)this.mMonitorResults.get(VIRTUAL_READS);
    }

    public int getNumberOfVirtualReads(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            this.activate();
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            this.deactivate();
            int n = this.getIntegerFromSysmonitor(VIRTUAL_READS, pid);
            return n;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public int getNumberOfVirtualReads(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getIntegerFromSysmonitor(VIRTUAL_READS, pid);
    }

    public static String getParseId(PreparedStatement pStmt) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        byte[] pid = PeekAndPoke.getParseIdForMonitor((PreparedStatement)pStmt);
        if (pid == null) {
            return null;
        }
        StringBuffer stb = new StringBuffer();
        for (int i = 0; i < pid.length; ++i) {
            int current = pid[i];
            if (current < 0) {
                current += 256;
            }
            stb.append(hexDigits[current / 16]);
            stb.append(hexDigits[current % 16]);
        }
        return stb.toString();
    }

    public float getRuntime() {
        return ((Float)this.mMonitorResults.get(RUNTIME)).floatValue();
    }

    public long getNOWRuntime() {
        return (Long)this.mMonitorXCONSResults.get(RUNTIME);
    }

    public int getCPUTime() {
        return (Integer)this.mMonitorXCONSResults.get(EXECTIME);
    }

    public int getReadIO() {
        int result = 0;
        try {
            result = (Integer)this.mMonitorXCONSResults.get(IOREADCNT) + (Integer)this.mMonitorXCONSResults.get(SIOREADCNT);
        }
        catch (Exception e) {
            result = (Integer)this.mMonitorXCONSResults.get(DIOREADCNT) + (Integer)this.mMonitorXCONSResults.get(SIOREADCNT);
        }
        return result;
    }

    public int getWriteIO() {
        int result = 0;
        try {
            result = (Integer)this.mMonitorXCONSResults.get(IOWRITECNT) + (Integer)this.mMonitorXCONSResults.get(SIOWRITECNT);
        }
        catch (Exception e) {
            result = (Integer)this.mMonitorXCONSResults.get(DIOWRITECNT) + (Integer)this.mMonitorXCONSResults.get(SIOWRITECNT);
        }
        return result;
    }

    public float getRuntime(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            int threshold = 0;
            boolean isActive = false;
            if (this.isThresholdTimeActive()) {
                isActive = true;
                threshold = this.getThresholdTime();
            } else {
                this.clear();
                this.setThresholdTime(0);
            }
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            if (isActive) {
                this.setThresholdTime(threshold);
            } else {
                this.setThresholdTimeOff();
            }
            float f = this.getFloatFromSysmonitor(RUNTIME, pid);
            return f;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public float getRuntime(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getFloatFromSysmonitor(RUNTIME, pid);
    }

    public String getSQLStatement() {
        return (String)this.mMonitorResults.get(SQL_STAT);
    }

    public String getSQLStatement(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getStringFromSysparseid(SQL_STAT, pid);
    }

    public String getStrategy() {
        return (String)this.mMonitorResults.get(STRATEGY);
    }

    public String getStrategy(String pSql) throws TestStatementMonitorException {
        Statement pstmt = null;
        try {
            int threshold = 0;
            boolean isActive = false;
            if (this.isThresholdTimeActive()) {
                isActive = true;
                threshold = this.getThresholdTime();
            } else {
                this.clear();
                this.setThresholdTime(0);
            }
            pstmt = this.mConnection.prepareStatement(pSql);
            String pid = TestStatementMonitor.getParseId((PreparedStatement)pstmt);
            ResultSet rs = pstmt.executeQuery();
            rs.next();
            if (isActive) {
                this.setThresholdTime(threshold);
            } else {
                this.setThresholdTimeOff();
            }
            String string = this.getStringFromSysmonitor(STRATEGY, pid);
            return string;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
        finally {
            try {
                pstmt.close();
            }
            catch (Exception e) {}
        }
    }

    public String getStrategy(PreparedStatement pStmt) throws TestStatementMonitorException {
        String pid = TestStatementMonitor.getParseId(pStmt);
        return this.getStringFromSysmonitor(STRATEGY, pid);
    }

    private String getStringFromSysmonitor(String pColumn, String pPid) throws TestStatementMonitorException {
        try {
            String sql = "Select " + pColumn + " from SYSMONITOR where PARSEID = x'" + pPid + "'";
            ResultSet rs = this.mHelpStatement.executeQuery(sql);
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    private String getStringFromSysparseid(String pColumn, String pPid) throws TestStatementMonitorException {
        try {
            String sql = "Select " + pColumn + " from SYSPARSEID where PARSEID = x'" + pPid + "'";
            ResultSet rs = this.mHelpStatement.executeQuery(sql);
            if (rs.next()) {
                return rs.getString(1);
            }
            return null;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    private int getThresholdTime() throws TestStatementMonitorException {
        try {
            String sql = "Select NUMERIC_VALUE from DB_STATE where DESCRIPTION = 'Diagnose monitor time'";
            ResultSet rs = this.mHelpStatement.executeQuery(sql);
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    private boolean isThresholdTimeActive() throws TestStatementMonitorException {
        try {
            String sql = "Select NUMERIC_VALUE from DB_STATE where DESCRIPTION = 'Diagnose monitor time'";
            ResultSet rs = this.mHelpStatement.executeQuery(sql);
            return rs.next();
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    private void setThresholdTime(int pData) throws TestStatementMonitorException {
        try {
            this.mHelpStatement.executeUpdate("Diagnose monitor time " + Integer.toString(pData));
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    private void setThresholdTimeOff() throws TestStatementMonitorException {
        try {
            this.mHelpStatement.executeUpdate("Diagnose monitor time off");
        }
        catch (Exception e) {
            throw new TestStatementMonitorException(e.getMessage());
        }
    }

    public String toString() {
        if (this.mMonitorResults.isEmpty()) {
            return null;
        }
        StringBuffer stb = new StringBuffer();
        stb.append(this.mMonitorResults.get(SQL_STAT).toString());
        stb.append(" : ");
        Set KeySet2 = this.mMonitorResults.keySet();
        Iterator it = KeySet2.iterator();
        while (it.hasNext()) {
            Object Key2 = it.next();
            if (Key2.equals(SQL_STAT)) continue;
            Object Value = this.mMonitorResults.get(Key2);
            stb.append(Key2.toString());
            stb.append('=');
            stb.append(Value.toString());
            stb.append(' ');
        }
        return stb.toString();
    }

    public String toStringPretty() {
        if (this.mMonitorResults.isEmpty()) {
            return null;
        }
        String COL1 = "NAME";
        String COL2 = "VALUE";
        int[] mColumnWidth = new int[]{COL1.length(), COL2.length()};
        Iterator itKey = this.mMonitorResults.keySet().iterator();
        while (itKey.hasNext()) {
            Object Key2 = itKey.next();
            mColumnWidth[0] = Math.max(mColumnWidth[0], Key2.toString().length());
            mColumnWidth[1] = Math.max(mColumnWidth[1], this.mMonitorResults.get(Key2).toString().length());
        }
        StringBuffer sep = new StringBuffer();
        for (int i = 0; i < mColumnWidth.length; ++i) {
            sep.append('+');
            TestStatementMonitor.appendNChar(sep, '-', mColumnWidth[i]);
        }
        sep.append("+\n");
        String sepLine = sep.toString();
        StringBuffer hd = new StringBuffer();
        block6: for (int i = 0; i < mColumnWidth.length; ++i) {
            hd.append('|');
            switch (i) {
                case 0: {
                    hd.append(COL1);
                    TestStatementMonitor.appendNSpaces(hd, mColumnWidth[i] - COL1.length());
                    continue block6;
                }
                case 1: {
                    hd.append(COL2);
                    TestStatementMonitor.appendNSpaces(hd, mColumnWidth[i] - COL2.length());
                }
            }
        }
        hd.append("|\n");
        String header = hd.toString();
        StringBuffer out = new StringBuffer();
        out.append("Monitoring data: \n");
        out.append(sepLine);
        out.append(header);
        out.append(sepLine);
        out.append('|');
        out.append(SQL_STAT);
        TestStatementMonitor.appendNSpaces(out, mColumnWidth[0] - SQL_STAT.length());
        out.append('|');
        out.append(this.mMonitorResults.get(SQL_STAT).toString());
        TestStatementMonitor.appendNSpaces(out, mColumnWidth[1] - this.mMonitorResults.get(SQL_STAT).toString().length());
        out.append("|\n");
        Set KeySet2 = this.mMonitorResults.keySet();
        Iterator it = KeySet2.iterator();
        while (it.hasNext()) {
            Object Key3 = it.next();
            if (Key3.equals(SQL_STAT)) continue;
            Object Value = this.mMonitorResults.get(Key3);
            out.append('|');
            out.append(Key3.toString());
            TestStatementMonitor.appendNSpaces(out, mColumnWidth[0] - Key3.toString().length());
            out.append('|');
            out.append(Value.toString());
            TestStatementMonitor.appendNSpaces(out, mColumnWidth[1] - Value.toString().length());
            out.append("|\n");
        }
        out.append(sepLine);
        return out.toString();
    }
}

