/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sapdb.testframe.driver;

import com.sap.sapdb.testframe.driver.TestMessageAttachement;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.FileTypeMap;
import javax.activation.MimetypesFileTypeMap;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class TestMessage {
    private static final String DEFAULT_SMTP_HOST = "mail.sap-ag.de";
    private static final String DEFAULT_EMAIL_DOMAIN = "sap.com";
    private static final String DEFAULT_SENDER = "TestingSAPDB";
    private static final String DEFAULT_SUBJECT = "Error in SAP DB test";
    private static final String RECIPIENTS_DELIMITERS = ":;,";
    private static MimetypesFileTypeMap mftp = new MimetypesFileTypeMap();
    private ArrayList mRecipientList;
    private StringBuffer mMailText = null;
    private String mEmailDomain;
    private String mSmtpHost;
    private String mSender;
    private String mSubject;

    public TestMessage() {
        mftp.addMimeTypes("application/x-zip-compressed zip ZIP");
        this.mMailText = new StringBuffer(8192);
    }

    public void addLine(String pText) {
        this.mMailText.append(pText);
        this.mMailText.append('\n');
    }

    public int getSize() {
        return this.mMailText.length();
    }

    void addRecipient(String pRecipient) {
        if (this.mRecipientList == null) {
            this.mRecipientList = new ArrayList();
        }
        char[] delims = RECIPIENTS_DELIMITERS.toCharArray();
        for (int i = 0; i < delims.length; ++i) {
            if (pRecipient.indexOf(delims[i]) == -1) continue;
            StringTokenizer st = new StringTokenizer(pRecipient, RECIPIENTS_DELIMITERS, false);
            while (st.hasMoreTokens()) {
                this.addRecipient(st.nextToken().trim());
            }
            return;
        }
        if (pRecipient.indexOf("@") == -1) {
            StringTokenizer st = new StringTokenizer(pRecipient, " ", false);
            StringBuffer sb = new StringBuffer();
            int tokenCounter = 0;
            while (st.hasMoreTokens()) {
                if (tokenCounter > 0) {
                    sb.append(".");
                    sb.append(st.nextToken().toLowerCase());
                } else {
                    sb.append(st.nextToken().toLowerCase());
                }
                ++tokenCounter;
            }
            sb.append("@");
            sb.append(this.getEmailDomain());
            String email = sb.toString();
            try {
                this.mRecipientList.add(new InternetAddress(email, ""));
            }
            catch (UnsupportedEncodingException e) {}
        } else {
            try {
                this.mRecipientList.add(new InternetAddress(pRecipient, ""));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private String getEmailDomain() {
        if (this.mEmailDomain == null) {
            return DEFAULT_EMAIL_DOMAIN;
        }
        return this.mEmailDomain;
    }

    private String getSender() {
        if (this.mSender == null) {
            if (this.mRecipientList != null && this.mRecipientList.size() > 0) {
                return ((InternetAddress)this.mRecipientList.get(0)).getAddress();
            }
            return DEFAULT_SENDER;
        }
        return this.mSender;
    }

    private String getSmtpHost() {
        if (this.mSmtpHost == null) {
            return DEFAULT_SMTP_HOST;
        }
        return this.mSmtpHost;
    }

    private String getSubject() {
        if (this.mSubject == null) {
            return DEFAULT_SUBJECT;
        }
        return this.mSubject;
    }

    void send() {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.getSmtpHost());
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            InternetAddress from = new InternetAddress(this.getSender());
            msg.setFrom((Address)from);
            int numberOfRecipients = this.mRecipientList.size();
            InternetAddress[] to = new InternetAddress[numberOfRecipients];
            for (int i = 0; i < numberOfRecipients; ++i) {
                to[i] = (InternetAddress)this.mRecipientList.get(i);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            msg.setSubject(this.getSubject());
            msg.setContent((Object)this.mMailText.toString(), "text/plain");
            Transport.send((Message)msg);
        }
        catch (Exception me) {
            me.printStackTrace();
        }
    }

    void send(TestMessageAttachement pAttachment) {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.getSmtpHost());
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            InternetAddress from = new InternetAddress(this.getSender());
            msg.setFrom((Address)from);
            int numberOfRecipients = this.mRecipientList.size();
            InternetAddress[] to = new InternetAddress[numberOfRecipients];
            for (int i = 0; i < numberOfRecipients; ++i) {
                to[i] = (InternetAddress)this.mRecipientList.get(i);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            msg.setSubject(this.getSubject());
            MimeBodyPart mbp1 = new MimeBodyPart();
            mbp1.setText(this.mMailText.toString());
            MimeBodyPart mbp2 = new MimeBodyPart();
            mbp2.setDescription(pAttachment.getTitle());
            if (pAttachment.isFile()) {
                FileDataSource fds = new FileDataSource(pAttachment.getFile());
                fds.setFileTypeMap((FileTypeMap)mftp);
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
            } else {
                mbp2.setText(pAttachment.getContent());
            }
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp1);
            mp.addBodyPart((BodyPart)mbp2);
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (Exception me) {
            me.printStackTrace();
        }
    }

    void send(ArrayList pAttachmentList) {
        Properties props = new Properties();
        props.put("mail.smtp.host", this.getSmtpHost());
        Session session = Session.getDefaultInstance((Properties)props, null);
        try {
            MimeMessage msg = new MimeMessage(session);
            InternetAddress from = new InternetAddress(this.getSender());
            msg.setFrom((Address)from);
            int numberOfRecipients = this.mRecipientList.size();
            InternetAddress[] to = new InternetAddress[numberOfRecipients];
            for (int i = 0; i < numberOfRecipients; ++i) {
                to[i] = (InternetAddress)this.mRecipientList.get(i);
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])to);
            msg.setSubject(this.getSubject());
            ArrayList<MimeBodyPart> MimeBodyPartList = new ArrayList<MimeBodyPart>();
            MimeBodyPart mbp = null;
            mbp = new MimeBodyPart();
            mbp.setText(this.mMailText.toString());
            MimeBodyPartList.add(mbp);
            ListIterator it = null;
            it = pAttachmentList.listIterator();
            while (it.hasNext()) {
                TestMessageAttachement attachement = (TestMessageAttachement)it.next();
                mbp = new MimeBodyPart();
                mbp.setDescription(attachement.getTitle());
                if (attachement.isFile()) {
                    FileDataSource fds = new FileDataSource(attachement.getFile());
                    fds.setFileTypeMap((FileTypeMap)mftp);
                    mbp.setDataHandler(new DataHandler((DataSource)fds));
                } else {
                    mbp.setText(attachement.getContent());
                }
                MimeBodyPartList.add(mbp);
            }
            MimeMultipart mp = new MimeMultipart();
            it = MimeBodyPartList.listIterator();
            while (it.hasNext()) {
                mp.addBodyPart((BodyPart)((MimeBodyPart)it.next()));
            }
            msg.setContent((Multipart)mp);
            Transport.send((Message)msg);
        }
        catch (Exception me) {
            me.printStackTrace();
        }
    }

    public void setEmailDomain(String newEmailDomain) {
        this.mEmailDomain = newEmailDomain;
    }

    public void setSender(String newSender) {
        this.mSender = newSender;
    }

    public void setSmtpHost(String newSmtpHost) {
        this.mSmtpHost = newSmtpHost;
    }

    public void setSubject(String newSubject) {
        this.mSubject = newSubject;
    }
}

