/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.iiop;

import java.util.Vector;
import sun.rmi.rmic.iiop.BatchEnvironment;
import sun.rmi.rmic.iiop.ClassType;
import sun.rmi.rmic.iiop.CompoundType;
import sun.rmi.rmic.iiop.ContextStack;
import sun.rmi.rmic.iiop.InterfaceType;
import sun.rmi.rmic.iiop.Type;
import sun.rmi.rmic.iiop.ValueType;
import sun.tools.java.ClassDefinition;
import sun.tools.java.ClassNotFound;
import sun.tools.java.CompilerError;
import sun.tools.java.Environment;
import sun.tools.java.MemberDefinition;

public class ImplementationType
extends ClassType {
    public static ImplementationType forImplementation(ClassDefinition classDefinition, ContextStack contextStack, boolean bl2) {
        ImplementationType implementationType;
        block8: {
            if (contextStack.anyErrors()) {
                return null;
            }
            boolean bl3 = false;
            implementationType = null;
            try {
                sun.tools.java.Type type = classDefinition.getType();
                Type type2 = Type.getType(type, contextStack);
                if (type2 != null) {
                    if (!(type2 instanceof ImplementationType)) {
                        return null;
                    }
                    return (ImplementationType)type2;
                }
                if (ImplementationType.couldBeImplementation(bl2, contextStack, classDefinition)) {
                    ImplementationType implementationType2 = new ImplementationType(contextStack, classDefinition);
                    Type.putType(type, (Type)implementationType2, contextStack);
                    contextStack.push(implementationType2);
                    bl3 = true;
                    if (implementationType2.initialize(contextStack, bl2)) {
                        contextStack.pop(true);
                        implementationType = implementationType2;
                    } else {
                        Type.removeType(type, contextStack);
                        contextStack.pop(false);
                    }
                }
            }
            catch (CompilerError compilerError) {
                if (!bl3) break block8;
                contextStack.pop(false);
            }
        }
        return implementationType;
    }

    public String getTypeDescription() {
        return "Implementation";
    }

    private ImplementationType(ContextStack contextStack, ClassDefinition classDefinition) {
        super(0x6010000, classDefinition, contextStack);
    }

    private static boolean couldBeImplementation(boolean bl2, ContextStack contextStack, ClassDefinition classDefinition) {
        boolean bl3 = false;
        BatchEnvironment batchEnvironment = contextStack.getEnv();
        try {
            if (!classDefinition.isClass()) {
                Type.failedConstraint(17, bl2, contextStack, classDefinition.getName());
            } else {
                bl3 = batchEnvironment.defRemote.implementedBy((Environment)batchEnvironment, classDefinition.getClassDeclaration());
                if (!bl3) {
                    Type.failedConstraint(8, bl2, contextStack, classDefinition.getName());
                }
            }
        }
        catch (ClassNotFound classNotFound) {
            Type.classNotFound(contextStack, classNotFound);
        }
        return bl3;
    }

    private boolean initialize(ContextStack contextStack, boolean bl2) {
        boolean bl3 = false;
        ClassDefinition classDefinition = this.getClassDefinition();
        if (this.initParents(contextStack)) {
            Vector vector = new Vector();
            Vector vector2 = new Vector();
            try {
                if (this.addRemoteInterfaces(vector, true, contextStack) != null) {
                    boolean bl4 = false;
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        InterfaceType interfaceType = (InterfaceType)vector.elementAt(n2);
                        if (interfaceType.isType(4096) || interfaceType.isType(524288)) {
                            bl4 = true;
                        }
                        ImplementationType.copyRemoteMethods(interfaceType, vector2);
                        ++n2;
                    }
                    if (!bl4) {
                        Type.failedConstraint(8, bl2, contextStack, this.getQualifiedName());
                        return false;
                    }
                    if (this.checkMethods(classDefinition, vector2, contextStack, bl2)) {
                        bl3 = this.initialize(vector, vector2, null, contextStack, bl2);
                    }
                }
            }
            catch (ClassNotFound classNotFound) {
                Type.classNotFound(contextStack, classNotFound);
            }
        }
        return bl3;
    }

    private static void copyRemoteMethods(InterfaceType interfaceType, Vector vector) {
        if (interfaceType.isType(4096)) {
            Object object;
            CompoundType.Method[] methodArray = interfaceType.getMethods();
            int n2 = 0;
            while (n2 < methodArray.length) {
                object = methodArray[n2];
                if (!vector.contains(object)) {
                    vector.addElement(object);
                }
                ++n2;
            }
            object = interfaceType.getInterfaces();
            int n3 = 0;
            while (n3 < ((InterfaceType[])object).length) {
                ImplementationType.copyRemoteMethods(object[n3], vector);
                ++n3;
            }
        }
    }

    private boolean checkMethods(ClassDefinition classDefinition, Vector vector, ContextStack contextStack, boolean bl2) {
        Object[] objectArray = new CompoundType.Method[vector.size()];
        vector.copyInto(objectArray);
        MemberDefinition memberDefinition = classDefinition.getFirstMember();
        while (memberDefinition != null) {
            if (memberDefinition.isMethod() && !memberDefinition.isConstructor() && !memberDefinition.isInitializer() && !this.updateExceptions(memberDefinition, (CompoundType.Method[])objectArray, contextStack, bl2)) {
                return false;
            }
            memberDefinition = memberDefinition.getNextMember();
        }
        return true;
    }

    private boolean updateExceptions(MemberDefinition memberDefinition, CompoundType.Method[] methodArray, ContextStack contextStack, boolean bl2) {
        int n2 = methodArray.length;
        String string = memberDefinition.toString();
        int n3 = 0;
        while (n3 < n2) {
            CompoundType.Method method = methodArray[n3];
            MemberDefinition memberDefinition2 = method.getMemberDefinition();
            if (string.equals(memberDefinition2.toString())) {
                try {
                    ValueType[] valueTypeArray = this.getMethodExceptions(memberDefinition, bl2, contextStack);
                    method.setImplExceptions(valueTypeArray);
                }
                catch (Exception exception) {
                    return false;
                }
            }
            ++n3;
        }
        return true;
    }
}

