/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class XRTreeFrag
extends XObject {
    public XRTreeFrag(DocumentFragment frag) {
        super(frag);
    }

    public NodeIterator asNodeIterator() {
        if (this.m_obj instanceof NodeIterator) {
            return (NodeIterator)this.m_obj;
        }
        return new NodeIteratorWrapper(this.rtree());
    }

    public boolean bool() {
        return true;
    }

    public NodeList convertToNodeset() {
        if (this.m_obj instanceof NodeList) {
            return (NodeList)this.m_obj;
        }
        return null;
    }

    public boolean equals(XObject obj2) throws TransformerException {
        if (obj2.getType() == 4) {
            return obj2.equals(this);
        }
        if (obj2.getType() == 1) {
            return this.bool() == obj2.bool();
        }
        if (obj2.getType() == 2) {
            return this.num() == obj2.num();
        }
        if (obj2.getType() == 4) {
            return this.str().equals(obj2.str());
        }
        if (obj2.getType() == 3) {
            return this.str().equals(obj2.str());
        }
        if (obj2.getType() == 5) {
            return this.str().equals(obj2.str());
        }
        return super.equals(obj2);
    }

    public int getType() {
        return 5;
    }

    public String getTypeString() {
        return "#RTREEFRAG";
    }

    public double num() {
        String s2 = DOMHelper.getNodeData((DocumentFragment)this.m_obj);
        double result = s2 != null ? XString.castToNum(s2.trim()) : Double.NaN;
        return result;
    }

    public DocumentFragment rtree() {
        return (DocumentFragment)this.m_obj;
    }

    public String str() {
        String str = DOMHelper.getNodeData((DocumentFragment)this.m_obj);
        return str == null ? "" : str;
    }

    class NodeIteratorWrapper
    implements NodeIterator {
        private int m_pos = -1;
        private DocumentFragment m_docFrag;

        NodeIteratorWrapper(DocumentFragment df2) {
            this.m_docFrag = df2;
        }

        public void detach() {
        }

        public boolean getExpandEntityReferences() {
            return true;
        }

        public NodeFilter getFilter() {
            return null;
        }

        public Node getRoot() {
            return null;
        }

        public int getWhatToShow() {
            return -1;
        }

        public Node nextNode() throws DOMException {
            if (this.m_pos == -1) {
                this.m_pos = 0;
                return this.m_docFrag;
            }
            return null;
        }

        public Node previousNode() throws DOMException {
            if (this.m_pos == 0) {
                this.m_pos = -1;
                return this.m_docFrag;
            }
            return null;
        }
    }
}

