/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.Keywords;
import org.apache.xpath.compiler.XPathParser;

class Lexer {
    private Compiler m_compiler;
    PrefixResolver m_namespaceContext;
    XPathParser m_processor;
    static final int TARGETEXTRA = 10000;
    private int[] m_patternMap = new int[100];
    private int m_patternMapSize;

    Lexer(Compiler compiler, PrefixResolver resolver, XPathParser xpathProcessor) {
        this.m_compiler = compiler;
        this.m_namespaceContext = resolver;
        this.m_processor = xpathProcessor;
    }

    private final void addToTokenQueue(String s2) {
        this.m_compiler.m_tokenQueue[this.m_compiler.m_tokenQueueSize++] = s2;
    }

    final int getKeywordToken(String key) {
        int tok;
        try {
            Integer itok = (Integer)Keywords.m_keywords.get(key);
            tok = itok != null ? itok : 0;
        }
        catch (NullPointerException nullPointerException) {
            tok = 0;
        }
        catch (ClassCastException classCastException) {
            tok = 0;
        }
        return tok;
    }

    private int getTokenQueuePosFromMap(int i2) {
        int pos = this.m_patternMap[i2];
        return pos >= 10000 ? pos - 10000 : pos;
    }

    private int mapNSTokens(String pat, int startSubstring, int posOfNSSep, int posOfScan) throws TransformerException {
        String uName;
        String prefix;
        block8: {
            prefix = pat.substring(startSubstring, posOfNSSep);
            if (this.m_namespaceContext != null && !prefix.equals("*") && !prefix.equals("xmlns")) {
                try {
                    if (prefix.length() > 0) {
                        uName = this.m_namespaceContext.getNamespaceForPrefix(prefix);
                        break block8;
                    }
                    uName = this.m_namespaceContext.getNamespaceForPrefix(prefix);
                }
                catch (ClassCastException classCastException) {
                    uName = this.m_namespaceContext.getNamespaceForPrefix(prefix);
                }
            } else {
                uName = prefix;
            }
        }
        if (uName != null && uName.length() > 0) {
            this.addToTokenQueue(uName);
            this.addToTokenQueue(":");
            String s2 = pat.substring(posOfNSSep + 1, posOfScan);
            if (s2.length() > 0) {
                this.addToTokenQueue(s2);
            }
        } else {
            this.m_processor.error(52, new String[]{prefix});
        }
        return -1;
    }

    private boolean mapPatternElemPos(int nesting, boolean isStart, boolean isAttrName) {
        if (nesting == 0) {
            if (!isStart) {
                int n2 = this.m_patternMapSize - 1;
                this.m_patternMap[n2] = this.m_patternMap[n2] - 10000;
            }
            this.m_patternMap[this.m_patternMapSize] = this.m_compiler.m_tokenQueueSize - (isAttrName ? 1 : 0) + 10000;
            ++this.m_patternMapSize;
            isStart = false;
        }
        return isStart;
    }

    private void recordTokenString(Vector targetStrings) {
        int tokPos = this.getTokenQueuePosFromMap(this.m_patternMapSize - 1);
        this.resetTokenMark(tokPos + 1);
        if (this.m_processor.lookahead('(', 1)) {
            int tok = this.getKeywordToken(this.m_processor.m_token);
            switch (tok) {
                case 1030: {
                    targetStrings.addElement("#comment");
                    break;
                }
                case 1031: {
                    targetStrings.addElement("#text");
                    break;
                }
                case 1033: {
                    targetStrings.addElement("*");
                    break;
                }
                case 35: {
                    targetStrings.addElement("/");
                    break;
                }
                case 36: {
                    targetStrings.addElement("*");
                    break;
                }
                case 1032: {
                    targetStrings.addElement("*");
                    break;
                }
                default: {
                    targetStrings.addElement("*");
                    break;
                }
            }
        } else {
            if (this.m_processor.tokenIs('@')) {
                this.resetTokenMark(++tokPos + 1);
            }
            if (this.m_processor.lookahead(':', 1)) {
                tokPos += 2;
            }
            targetStrings.addElement(this.m_compiler.m_tokenQueue[tokPos]);
        }
    }

    private final void resetTokenMark(int mark) {
        int qsz = this.m_compiler.m_tokenQueueSize;
        int n2 = mark > 0 ? (mark <= qsz ? mark - 1 : mark) : (this.m_processor.m_queueMark = 0);
        if (this.m_processor.m_queueMark < qsz) {
            this.m_processor.m_token = (String)this.m_compiler.m_tokenQueue[this.m_processor.m_queueMark++];
            this.m_processor.m_tokenChar = this.m_processor.m_token.charAt(0);
        } else {
            this.m_processor.m_token = null;
            this.m_processor.m_tokenChar = '\u0000';
        }
    }

    void tokenize(String pat) throws TransformerException {
        this.tokenize(pat, null);
    }

    void tokenize(String pat, Vector targetStrings) throws TransformerException {
        this.m_compiler.m_tokenQueueSize = 0;
        this.m_compiler.m_currentPattern = pat;
        this.m_patternMapSize = 0;
        this.m_compiler.m_opMap = new int[2500];
        int nChars = pat.length();
        int startSubstring = -1;
        int posOfNSSep = -1;
        boolean isStartOfPat = true;
        boolean isAttrName = false;
        boolean isNum = false;
        int nesting = 0;
        int i2 = 0;
        while (i2 < nChars) {
            char c10 = pat.charAt(i2);
            switch (c10) {
                case '\"': {
                    if (startSubstring != -1) {
                        isNum = false;
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                        if (posOfNSSep != -1) {
                            posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i2);
                        } else {
                            this.addToTokenQueue(pat.substring(startSubstring, i2));
                        }
                    }
                    startSubstring = i2++;
                    while (i2 < nChars && (c10 = pat.charAt(i2)) != '\"') {
                        ++i2;
                    }
                    if (c10 == '\"') {
                        this.addToTokenQueue(pat.substring(startSubstring, i2 + 1));
                        startSubstring = -1;
                        break;
                    }
                    this.m_processor.error(26, null);
                    break;
                }
                case '\'': {
                    if (startSubstring != -1) {
                        isNum = false;
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                        if (posOfNSSep != -1) {
                            posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i2);
                        } else {
                            this.addToTokenQueue(pat.substring(startSubstring, i2));
                        }
                    }
                    startSubstring = i2++;
                    while (i2 < nChars && (c10 = pat.charAt(i2)) != '\'') {
                        ++i2;
                    }
                    if (c10 == '\'') {
                        this.addToTokenQueue(pat.substring(startSubstring, i2 + 1));
                        startSubstring = -1;
                        break;
                    }
                    this.m_processor.error(27, null);
                    break;
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (startSubstring == -1) break;
                    isNum = false;
                    isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                    isAttrName = false;
                    if (posOfNSSep != -1) {
                        posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i2);
                    } else {
                        this.addToTokenQueue(pat.substring(startSubstring, i2));
                    }
                    startSubstring = -1;
                    break;
                }
                case '@': {
                    isAttrName = true;
                }
                case '-': {
                    if (c10 == '-') {
                        if (!isNum && startSubstring != -1) break;
                        isNum = false;
                    }
                }
                case '!': 
                case '$': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '|': {
                    if (startSubstring != -1) {
                        isNum = false;
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                        if (posOfNSSep != -1) {
                            posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, i2);
                        } else {
                            this.addToTokenQueue(pat.substring(startSubstring, i2));
                        }
                        startSubstring = -1;
                    } else if (c10 == '/' && isStartOfPat) {
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                    } else if (c10 == '*') {
                        isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
                        isAttrName = false;
                    }
                    if (nesting == 0 && c10 == '|') {
                        if (targetStrings != null) {
                            this.recordTokenString(targetStrings);
                        }
                        isStartOfPat = true;
                    }
                    if (c10 == ')' || c10 == ']') {
                        --nesting;
                    } else if (c10 == '(' || c10 == '[') {
                        ++nesting;
                    }
                    this.addToTokenQueue(pat.substring(i2, i2 + 1));
                    break;
                }
                case ':': {
                    if (posOfNSSep == i2 - 1) {
                        if (startSubstring != -1 && startSubstring < i2 - 1) {
                            this.addToTokenQueue(pat.substring(startSubstring, i2 - 1));
                        }
                        isNum = false;
                        isAttrName = false;
                        startSubstring = -1;
                        posOfNSSep = -1;
                        this.addToTokenQueue(pat.substring(i2 - 1, i2 + 1));
                        break;
                    }
                    posOfNSSep = i2;
                }
                default: {
                    if (startSubstring == -1) {
                        startSubstring = i2;
                        isNum = Character.isDigit(c10);
                        break;
                    }
                    if (!isNum) break;
                    isNum = Character.isDigit(c10);
                }
            }
            ++i2;
        }
        if (startSubstring != -1) {
            isNum = false;
            isStartOfPat = this.mapPatternElemPos(nesting, isStartOfPat, isAttrName);
            if (posOfNSSep != -1) {
                posOfNSSep = this.mapNSTokens(pat, startSubstring, posOfNSSep, nChars);
            } else {
                this.addToTokenQueue(pat.substring(startSubstring, nChars));
            }
        }
        if (this.m_compiler.m_tokenQueueSize == 0) {
            this.m_processor.error(28, null);
        } else if (targetStrings != null) {
            this.recordTokenString(targetStrings);
        }
        this.m_processor.m_queueMark = 0;
    }
}

