/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.compiler;

import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.UnionPathIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.compiler.FunctionTable;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.functions.FuncExtFunction;
import org.apache.xpath.functions.Function;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XNumber;
import org.apache.xpath.objects.XString;
import org.apache.xpath.operations.And;
import org.apache.xpath.operations.Bool;
import org.apache.xpath.operations.Div;
import org.apache.xpath.operations.Equals;
import org.apache.xpath.operations.Gt;
import org.apache.xpath.operations.Gte;
import org.apache.xpath.operations.Lt;
import org.apache.xpath.operations.Lte;
import org.apache.xpath.operations.Minus;
import org.apache.xpath.operations.Mod;
import org.apache.xpath.operations.Mult;
import org.apache.xpath.operations.Neg;
import org.apache.xpath.operations.NotEquals;
import org.apache.xpath.operations.Number;
import org.apache.xpath.operations.Operation;
import org.apache.xpath.operations.Or;
import org.apache.xpath.operations.Plus;
import org.apache.xpath.operations.UnaryOperation;
import org.apache.xpath.operations.Variable;
import org.apache.xpath.patterns.AncestorStepPattern;
import org.apache.xpath.patterns.FunctionPattern;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.patterns.UnionPattern;

public class Compiler
extends OpMap {
    private int locPathDepth = -1;
    private PrefixResolver m_currentPrefixResolver = null;
    ErrorListener m_errorHandler;
    SourceLocator m_locator;

    public Compiler() {
        this.m_errorHandler = null;
        this.m_locator = null;
    }

    public Compiler(ErrorListener errorHandler, SourceLocator locator) {
        this.m_errorHandler = errorHandler;
        if (locator != null) {
            SAXSourceLocator ssl = new SAXSourceLocator();
            ssl.setColumnNumber(locator.getColumnNumber());
            ssl.setLineNumber(locator.getLineNumber());
            ssl.setPublicId(locator.getPublicId());
            ssl.setSystemId(locator.getSystemId());
            this.m_locator = ssl;
        }
    }

    protected Expression and(int opPos) throws TransformerException {
        return this.compileOperation(new And(), opPos);
    }

    protected Expression arg(int opPos) throws TransformerException {
        return this.compile(opPos + 2);
    }

    public void assertion(boolean b10, String msg) {
        if (!b10) {
            String fMsg = XSLMessages.createXPATHMessage(30, new Object[]{msg});
            throw new RuntimeException(fMsg);
        }
    }

    protected Expression bool(int opPos) throws TransformerException {
        return this.compileUnary(new Bool(), opPos);
    }

    public Expression compile(int opPos) throws TransformerException {
        int op = this.m_opMap[opPos];
        Expression expr = null;
        switch (op) {
            case 1: {
                expr = this.compile(opPos + 2);
                break;
            }
            case 2: {
                expr = this.or(opPos);
                break;
            }
            case 3: {
                expr = this.and(opPos);
                break;
            }
            case 4: {
                expr = this.notequals(opPos);
                break;
            }
            case 5: {
                expr = this.equals(opPos);
                break;
            }
            case 6: {
                expr = this.lte(opPos);
                break;
            }
            case 7: {
                expr = this.lt(opPos);
                break;
            }
            case 8: {
                expr = this.gte(opPos);
                break;
            }
            case 9: {
                expr = this.gt(opPos);
                break;
            }
            case 10: {
                expr = this.plus(opPos);
                break;
            }
            case 11: {
                expr = this.minus(opPos);
                break;
            }
            case 12: {
                expr = this.mult(opPos);
                break;
            }
            case 13: {
                expr = this.div(opPos);
                break;
            }
            case 14: {
                expr = this.mod(opPos);
                break;
            }
            case 16: {
                expr = this.neg(opPos);
                break;
            }
            case 17: {
                expr = this.string(opPos);
                break;
            }
            case 18: {
                expr = this.bool(opPos);
                break;
            }
            case 19: {
                expr = this.number(opPos);
                break;
            }
            case 20: {
                expr = this.union(opPos);
                break;
            }
            case 21: {
                expr = this.literal(opPos);
                break;
            }
            case 22: {
                expr = this.variable(opPos);
                break;
            }
            case 23: {
                expr = this.group(opPos);
                break;
            }
            case 27: {
                expr = this.numberlit(opPos);
                break;
            }
            case 26: {
                expr = this.arg(opPos);
                break;
            }
            case 24: {
                expr = this.compileExtension(opPos);
                break;
            }
            case 25: {
                expr = this.compileFunction(opPos);
                break;
            }
            case 28: {
                expr = this.locationPath(opPos);
                break;
            }
            case 29: {
                expr = null;
                break;
            }
            case 30: {
                expr = this.matchPattern(opPos + 2);
                break;
            }
            case 31: {
                expr = this.locationPathPattern(opPos);
                break;
            }
            case 15: {
                this.error(24, new Object[]{"quo"});
                break;
            }
            default: {
                this.error(24, new Object[]{Integer.toString(this.m_opMap[opPos])});
            }
        }
        if (expr != null) {
            expr.setSourceLocator(this.m_locator);
        }
        return expr;
    }

    private Expression compileExtension(int opPos) throws TransformerException {
        int endExtFunc = opPos + this.m_opMap[opPos + 1] - 1;
        opPos = OpMap.getFirstChildPos(opPos);
        String ns = (String)this.m_tokenQueue[this.m_opMap[opPos]];
        String funcName = (String)this.m_tokenQueue[this.m_opMap[++opPos]];
        FuncExtFunction extension = new FuncExtFunction(ns, funcName, String.valueOf(String.valueOf(++opPos)) + String.valueOf(this.hashCode()));
        try {
            int i2 = 0;
            while (opPos < endExtFunc) {
                int nextOpPos = this.getNextOpPos(opPos);
                ((Function)extension).setArg(this.compile(opPos), i2);
                opPos = nextOpPos;
                ++i2;
            }
        }
        catch (WrongNumberArgsException wrongNumberArgsException) {}
        return extension;
    }

    Expression compileFunction(int opPos) throws TransformerException {
        int endFunc = opPos + this.m_opMap[opPos + 1] - 1;
        opPos = OpMap.getFirstChildPos(opPos);
        int funcID = this.m_opMap[opPos];
        ++opPos;
        if (funcID != -1) {
            Function func = FunctionTable.getFunction(funcID);
            try {
                int i2 = 0;
                int p2 = opPos;
                while (p2 < endFunc) {
                    func.setArg(this.compile(p2), i2);
                    p2 = this.getNextOpPos(p2);
                    ++i2;
                }
                func.checkNumberArgs(i2);
            }
            catch (WrongNumberArgsException wnae) {
                String name = FunctionTable.m_functions[funcID].getName();
                this.m_errorHandler.fatalError(new TransformerException(String.valueOf(name) + " only allows " + wnae.getMessage() + " arguments", this.m_locator));
            }
            return func;
        }
        this.error(69, null);
        return null;
    }

    private Expression compileOperation(Operation operation, int opPos) throws TransformerException {
        int leftPos = OpMap.getFirstChildPos(opPos);
        int rightPos = this.getNextOpPos(leftPos);
        operation.setLeftRight(this.compile(leftPos), this.compile(rightPos));
        return operation;
    }

    private void compilePredicates(int opPos, Expression[] predicates) throws TransformerException {
        int i2 = 0;
        while (this.getOp(opPos) == 29) {
            predicates[i2] = this.predicate(opPos);
            opPos = this.getNextOpPos(opPos);
            ++i2;
        }
    }

    private Expression compileUnary(UnaryOperation unary, int opPos) throws TransformerException {
        int rightPos = OpMap.getFirstChildPos(opPos);
        unary.setRight(this.compile(rightPos));
        return unary;
    }

    public int countPredicates(int opPos) throws TransformerException {
        int count = 0;
        while (this.getOp(opPos) == 29) {
            ++count;
            opPos = this.getNextOpPos(opPos);
        }
        return count;
    }

    protected Expression div(int opPos) throws TransformerException {
        return this.compileOperation(new Div(), opPos);
    }

    protected Expression equals(int opPos) throws TransformerException {
        return this.compileOperation(new Equals(), opPos);
    }

    public void error(int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHMessage(msg, args);
        if (this.m_errorHandler == null) {
            throw new TransformerException(fmsg, (SAXSourceLocator)this.m_locator);
        }
        this.m_errorHandler.fatalError(new TransformerException(fmsg, this.m_locator));
    }

    public Expression[] getCompiledPredicates(int opPos) throws TransformerException {
        int count = this.countPredicates(opPos);
        if (count > 0) {
            Expression[] predicates = new Expression[count];
            this.compilePredicates(opPos, predicates);
            return predicates;
        }
        return null;
    }

    public int getLocationPathDepth() {
        return this.locPathDepth;
    }

    public PrefixResolver getNamespaceContext() {
        return this.m_currentPrefixResolver;
    }

    public int getWhatToShow(int opPos) {
        int axesType = this.getOp(opPos);
        int testType = this.getOp(opPos + 3);
        switch (testType) {
            case 1030: {
                return 128;
            }
            case 1031: {
                return 12;
            }
            case 1032: {
                return 64;
            }
            case 1033: {
                switch (axesType) {
                    case 49: {
                        return 4098;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 38: 
                    case 42: 
                    case 48: {
                        return -1;
                    }
                }
                if (this.getOp(0) == 30) {
                    return -1283;
                }
                return -3;
            }
            case 35: {
                return 1280;
            }
            case 1034: {
                return 65536;
            }
            case 34: {
                switch (axesType) {
                    case 49: {
                        return 4098;
                    }
                    case 39: 
                    case 51: {
                        return 2;
                    }
                    case 52: 
                    case 53: {
                        return 1;
                    }
                }
                return 1;
            }
        }
        return -1;
    }

    protected Expression group(int opPos) throws TransformerException {
        return this.compile(opPos + 2);
    }

    protected Expression gt(int opPos) throws TransformerException {
        return this.compileOperation(new Gt(), opPos);
    }

    protected Expression gte(int opPos) throws TransformerException {
        return this.compileOperation(new Gte(), opPos);
    }

    protected Expression literal(int opPos) {
        opPos = OpMap.getFirstChildPos(opPos);
        return (XString)this.m_tokenQueue[this.m_opMap[opPos]];
    }

    public Expression locationPath(int opPos) throws TransformerException {
        ++this.locPathDepth;
        try {
            LocPathIterator iter = WalkerFactory.newLocPathIterator(this, opPos);
            if (this.locPathDepth == 0) {
                iter.setIsTopLevel(true);
            }
            LocPathIterator locPathIterator = iter;
            Object var4_4 = null;
            --this.locPathDepth;
            return locPathIterator;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            --this.locPathDepth;
            throw throwable;
        }
    }

    public Expression locationPathPattern(int opPos) throws TransformerException {
        opPos = OpMap.getFirstChildPos(opPos);
        return this.stepPattern(opPos, 0, null);
    }

    protected Expression lt(int opPos) throws TransformerException {
        return this.compileOperation(new Lt(), opPos);
    }

    protected Expression lte(int opPos) throws TransformerException {
        return this.compileOperation(new Lte(), opPos);
    }

    protected Expression matchPattern(int opPos) throws TransformerException {
        int nextOpPos = opPos;
        int i2 = 0;
        while (this.m_opMap[nextOpPos] == 31) {
            nextOpPos = this.getNextOpPos(nextOpPos);
            ++i2;
        }
        if (i2 == 1) {
            return this.compile(opPos);
        }
        UnionPattern up = new UnionPattern();
        StepPattern[] patterns = new StepPattern[i2];
        i2 = 0;
        while (this.m_opMap[opPos] == 31) {
            nextOpPos = this.getNextOpPos(opPos);
            patterns[i2] = (StepPattern)this.compile(opPos);
            opPos = nextOpPos;
            ++i2;
        }
        up.setPatterns(patterns);
        return up;
    }

    protected Expression minus(int opPos) throws TransformerException {
        return this.compileOperation(new Minus(), opPos);
    }

    protected Expression mod(int opPos) throws TransformerException {
        return this.compileOperation(new Mod(), opPos);
    }

    protected Expression mult(int opPos) throws TransformerException {
        return this.compileOperation(new Mult(), opPos);
    }

    protected Expression neg(int opPos) throws TransformerException {
        return this.compileUnary(new Neg(), opPos);
    }

    protected Expression notequals(int opPos) throws TransformerException {
        return this.compileOperation(new NotEquals(), opPos);
    }

    protected Expression number(int opPos) throws TransformerException {
        return this.compileUnary(new Number(), opPos);
    }

    protected Expression numberlit(int opPos) {
        opPos = OpMap.getFirstChildPos(opPos);
        return (XNumber)this.m_tokenQueue[this.m_opMap[opPos]];
    }

    protected Expression or(int opPos) throws TransformerException {
        return this.compileOperation(new Or(), opPos);
    }

    protected Expression plus(int opPos) throws TransformerException {
        return this.compileOperation(new Plus(), opPos);
    }

    public Expression predicate(int opPos) throws TransformerException {
        return this.compile(opPos + 2);
    }

    public void setNamespaceContext(PrefixResolver pr) {
        this.m_currentPrefixResolver = pr;
    }

    protected StepPattern stepPattern(int opPos, int stepCount, StepPattern ancestorPattern) throws TransformerException {
        StepPattern pattern;
        int argLen;
        int startOpPos = opPos;
        int stepType = this.getOpMap()[opPos];
        if (stepType == -1) {
            return null;
        }
        int endStep = this.getNextOpPos(opPos);
        switch (stepType) {
            case 25: {
                argLen = this.m_opMap[opPos + 1];
                pattern = new FunctionPattern(this.compileFunction(opPos));
                break;
            }
            case 50: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = OpMap.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(1280);
                break;
            }
            case 51: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = OpMap.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(2, this.getStepNS(startOpPos), this.getStepLocalName(startOpPos));
                break;
            }
            case 52: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = OpMap.getFirstChildPosOfStep(opPos);
                pattern = new AncestorStepPattern(this.getWhatToShow(startOpPos), this.getStepNS(startOpPos), this.getStepLocalName(startOpPos));
                break;
            }
            case 53: {
                argLen = this.getArgLengthOfStep(opPos);
                opPos = OpMap.getFirstChildPosOfStep(opPos);
                pattern = new StepPattern(this.getWhatToShow(startOpPos), this.getStepNS(startOpPos), this.getStepLocalName(startOpPos));
                break;
            }
            default: {
                this.error(16, null);
                return null;
            }
        }
        pattern.setPredicates(this.getCompiledPredicates(opPos + argLen));
        pattern.setRelativePathPattern(ancestorPattern);
        StepPattern relativePathPattern = this.stepPattern(endStep, stepCount + 1, pattern);
        return relativePathPattern != null ? relativePathPattern : pattern;
    }

    protected Expression string(int opPos) throws TransformerException {
        return this.compileUnary(new org.apache.xpath.operations.String(), opPos);
    }

    protected Expression union(int opPos) throws TransformerException {
        ++this.locPathDepth;
        try {
            UnionPathIterator unionPathIterator = new UnionPathIterator(this, opPos);
            Object var4_3 = null;
            --this.locPathDepth;
            return unionPathIterator;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            --this.locPathDepth;
            throw throwable;
        }
    }

    protected Expression variable(int opPos) throws TransformerException {
        Variable var = new Variable();
        int nsPos = this.m_opMap[opPos = OpMap.getFirstChildPos(opPos)];
        String namespace = nsPos == -2 ? null : (String)this.m_tokenQueue[nsPos];
        String localname = (String)this.m_tokenQueue[this.m_opMap[opPos + 1]];
        QName qname = new QName(namespace, localname);
        var.setQName(qname);
        return var;
    }

    public void warn(int msg, Object[] args) throws TransformerException {
        String fmsg = XSLMessages.createXPATHWarning(msg, args);
        if (this.m_errorHandler != null) {
            this.m_errorHandler.warning(new TransformerException(fmsg, this.m_locator));
        } else {
            System.out.println(String.valueOf(fmsg) + "; file " + this.m_locator.getSystemId() + "; line " + this.m_locator.getLineNumber() + "; column " + this.m_locator.getColumnNumber());
        }
    }
}

