/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceWalker
extends AxesWalker {
    transient Stack m_namespaces;

    public NamespaceWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceWalker clone = (NamespaceWalker)super.clone();
        if (this.m_namespaces != null) {
            clone.m_namespaces = (Stack)this.m_namespaces.clone();
        }
        return clone;
    }

    public Node firstChild() {
        this.m_nextLevelAmount = 0;
        return this.nextSibling();
    }

    protected int getLevelMax() {
        return this.m_lpi.getDOMHelper().getLevel(this.m_root);
    }

    public Node nextSibling() {
        Node next = this.m_namespaces.isEmpty() ? null : (Node)this.m_namespaces.pop();
        return this.setCurrentIfNotNull(next);
    }

    public void setRoot(Node root) {
        this.m_nextLevelAmount = 1;
        this.m_namespaces = new Stack();
        Node nsContext = root;
        while (nsContext != null) {
            NamedNodeMap attributeList = nsContext.getAttributes();
            if (attributeList != null) {
                int nAttrs = attributeList.getLength();
                int i2 = nAttrs - 1;
                while (i2 >= 0) {
                    Node attr = attributeList.item(i2);
                    if (this.m_lpi.getDOMHelper().isNamespaceNode(attr)) {
                        this.m_namespaces.push(attr);
                    }
                    --i2;
                }
            }
            nsContext = nsContext.getParentNode();
        }
        super.setRoot(root);
    }
}

