/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.transformer;

import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.KeyDeclaration;
import org.apache.xalan.transformer.KeyIterator;
import org.apache.xml.utils.QName;
import org.apache.xpath.DOMHelper;
import org.apache.xpath.axes.DescendantOrSelfWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class KeyWalker
extends DescendantOrSelfWalker {
    transient NamedNodeMap m_attrs;
    transient boolean m_foundAttrs;
    transient int m_attrPos;
    String m_lookupKey;

    public KeyWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public short acceptNode(Node testNode) {
        boolean foundKey = false;
        KeyIterator ki = (KeyIterator)this.m_lpi;
        Vector keys = ki.getKeyDeclarations();
        QName name = ki.getName();
        try {
            String lookupKey = this.m_lookupKey;
            int nDeclarations = keys.size();
            int i2 = 0;
            while (i2 < nDeclarations) {
                KeyDeclaration kd = (KeyDeclaration)keys.elementAt(i2);
                if (kd.getName().equals(name)) {
                    foundKey = true;
                    ki.getXPathContext().setNamespaceContext(ki.getPrefixResolver());
                    double score = kd.getMatch().getMatchScore(ki.getXPathContext(), testNode);
                    kd.getMatch();
                    if (score != Double.NEGATIVE_INFINITY) {
                        XObject xuse = kd.getUse().execute(ki.getXPathContext(), testNode, ki.getPrefixResolver());
                        if (xuse.getType() != 4) {
                            String exprResult = xuse.str();
                            ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                            if (lookupKey.equals(exprResult)) {
                                return 1;
                            }
                        } else {
                            Node useNode;
                            NodeIterator nl = xuse.nodeset();
                            short result = -1;
                            while ((useNode = nl.nextNode()) != null) {
                                this.m_lpi.getDOMHelper();
                                String exprResult = DOMHelper.getNodeData(useNode);
                                ((KeyIterator)this.m_lpi).addRefNode(exprResult, testNode);
                                if (exprResult == null || !lookupKey.equals(exprResult)) continue;
                                result = 1;
                            }
                            if (result != -1) {
                                return result;
                            }
                        }
                    }
                }
                ++i2;
            }
        }
        catch (TransformerException transformerException) {}
        if (!foundKey) {
            throw new RuntimeException(XSLMessages.createMessage(58, new Object[]{name.getLocalName()}));
        }
        return 2;
    }

    protected Node getNextNode() {
        Node next;
        if (!this.m_foundAttrs) {
            this.m_attrs = this.getCurrentNode().getAttributes();
            this.m_foundAttrs = true;
        }
        if (this.m_attrs != null) {
            if (this.m_attrPos < this.m_attrs.getLength()) {
                return this.m_attrs.item(this.m_attrPos++);
            }
            this.m_attrs = null;
        }
        if ((next = super.getNextNode()) != null) {
            this.m_foundAttrs = false;
        }
        return next;
    }

    public Node nextNode() {
        Node node = super.nextNode();
        if (node == null) {
            ((KeyIterator)this.m_lpi).setLookForMoreNodes(false);
        }
        return node;
    }

    public void setRoot(Node root) {
        this.m_attrs = null;
        this.m_foundAttrs = false;
        this.m_attrPos = 0;
        super.setRoot(root);
    }
}

