/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.apache.xalan.stree.DocImpl;
import org.apache.xalan.stree.DocumentFragmentImpl;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.DocumentTypeImpl;
import org.apache.xalan.stree.EntityImpl;
import org.apache.xalan.stree.Parent;
import org.apache.xalan.stree.StreeDOMBuilder;
import org.apache.xalan.stree.StreeDOMHelper;
import org.apache.xalan.transformer.TransformerImpl;
import org.apache.xml.utils.BoolStack;
import org.apache.xml.utils.DOMBuilder;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xpath.SourceTreeManager;
import org.apache.xpath.XPathContext;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SourceTreeHandler
extends DefaultHandler
implements TransformerHandler,
DeclHandler,
DTDHandler {
    TransformerImpl m_transformer;
    private DOMBuilder m_sourceTreeHandler;
    private DocImpl m_root;
    private DocumentFragment m_docFrag;
    private boolean m_initedRoot;
    boolean m_shouldCheckWhitespace = false;
    boolean m_shouldTransformAtEnd = true;
    private Source m_inputSource;
    private boolean m_useMultiThreading = false;
    private static final boolean DEBUG = false;
    private boolean indexedLookup = false;
    private int m_eventsCount = 0;
    private int m_maxEventsToNotify = 18;
    private boolean m_isCData = false;
    private boolean m_inDTD = false;
    private boolean m_shouldStripWS = false;
    private BoolStack m_shouldStripWhitespaceStack = new BoolStack();

    public SourceTreeHandler() {
        this.m_root = new DocumentImpl(this);
        this.m_initedRoot = false;
    }

    public SourceTreeHandler(TransformerImpl transformer) {
        this(transformer, false);
    }

    public SourceTreeHandler(TransformerImpl transformer, boolean doFragment) {
        this.m_transformer = transformer;
        XPathContext xctxt = transformer.getXPathContext();
        xctxt.setDOMHelper(new StreeDOMHelper());
        if (doFragment) {
            this.m_root = new DocumentFragmentImpl(1024);
            this.m_docFrag = (DocumentFragmentImpl)this.m_root;
        } else {
            this.m_root = new DocumentImpl(this);
        }
        this.m_initedRoot = false;
        this.m_shouldCheckWhitespace = transformer.getStylesheet().shouldCheckWhitespace();
    }

    public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) throws SAXException {
    }

    public void characters(char[] ch2, int start, int length) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.characters(ch2, start, length);
        }
        this.notifyWaiters();
    }

    public void charactersRaw(char[] ch2, int start, int length) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.charactersRaw(ch2, start, length);
        }
        this.notifyWaiters();
    }

    public void comment(char[] ch2, int start, int length) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.comment(ch2, start, length);
        }
        this.notifyWaiters();
    }

    public void elementDecl(String name, String model) throws SAXException {
    }

    public void endCDATA() throws SAXException {
        this.m_isCData = false;
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void endDocument() throws SAXException {
        block8: {
            Thread transformThread;
            DocImpl synchObj;
            this.m_eventsCount = this.m_maxEventsToNotify;
            DocImpl docImpl = synchObj = this.m_root;
            synchronized (docImpl) {
                this.m_sourceTreeHandler.endDocument();
                this.m_root.setComplete(true);
                this.popShouldStripWhitespace();
                if (!this.m_useMultiThreading && this.m_transformer != null && this.m_shouldTransformAtEnd) {
                    try {
                        this.m_transformer.transformNode(this.m_root);
                    }
                    catch (TransformerException te) {
                        throw new SAXException(te);
                    }
                }
            }
            this.m_eventsCount = this.m_maxEventsToNotify;
            this.notifyWaiters();
            if (!this.m_useMultiThreading || this.m_transformer == null || (transformThread = this.m_transformer.getTransformThread()) == null) break block8;
            try {
                transformThread.join();
                this.m_transformer.setTransformThread(null);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void endElement(String ns, String localName, String name) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            Parent myElement = (Parent)this.m_sourceTreeHandler.getCurrentNode();
            this.m_sourceTreeHandler.endElement(ns, localName, name);
            myElement.setComplete(true);
            this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
        }
        this.notifyWaiters();
    }

    public void endEntity(String name) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.endEntity(name);
        }
        this.notifyWaiters();
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        this.m_sourceTreeHandler.endPrefixMapping(prefix);
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public Source getInputSource() {
        return this.m_inputSource;
    }

    public Node getRoot() {
        return this.m_root;
    }

    boolean getShouldStripWhitespace() {
        return this.m_shouldStripWS;
    }

    public String getSystemId() {
        return this.m_transformer.getBaseURLOfSource();
    }

    public Transformer getTransformer() {
        return this.m_transformer;
    }

    TransformerImpl getTransformerImpl() {
        return this.m_transformer;
    }

    public boolean getUseMultiThreading() {
        return this.m_useMultiThreading;
    }

    public void ignorableWhitespace(char[] ch2, int start, int length) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            if (this.m_shouldStripWS) {
                Object var5_5 = null;
                return;
            }
            this.m_sourceTreeHandler.characters(ch2, start, length);
        }
        this.notifyWaiters();
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    private void notifyWaiters() {
        if (this.m_useMultiThreading && this.m_eventsCount >= this.m_maxEventsToNotify) {
            DocImpl synchObj;
            DocImpl docImpl = synchObj = this.m_root;
            synchronized (docImpl) {
                synchObj.notify();
            }
            this.m_eventsCount = 0;
        } else {
            ++this.m_eventsCount;
        }
    }

    void popShouldStripWhitespace() {
        this.m_shouldStripWS = this.m_shouldStripWhitespaceStack.popAndTop();
    }

    private void printTree(Node n2) {
        System.out.println("node: " + n2.getNodeName());
        Node child = n2.getFirstChild();
        while (child != null) {
            this.printTree(child);
            child = child.getNextSibling();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.processingInstruction(target, data);
        }
        this.notifyWaiters();
    }

    void pushShouldStripWhitespace(boolean shouldStrip) {
        this.m_shouldStripWS = shouldStrip;
        this.m_shouldStripWhitespaceStack.push(shouldStrip);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void setExceptionThrown(Exception e10) {
        this.m_root.m_exceptionThrown = e10;
    }

    public void setInputSource(Source source) {
        this.m_inputSource = source;
    }

    public void setResult(Result result) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException("result should not be null");
        }
        try {
            ContentHandler handler = this.m_transformer.createResultContentHandler(result);
            this.m_transformer.setContentHandler(handler);
        }
        catch (TransformerException transformerException) {
            throw new IllegalArgumentException("result could not be set");
        }
    }

    public void setRoot(DocImpl root) {
        this.m_root = root;
    }

    void setShouldStripWhitespace(boolean shouldStrip) {
        this.m_shouldStripWS = shouldStrip;
        this.m_shouldStripWhitespaceStack.setTop(shouldStrip);
    }

    public void setShouldTransformAtEnd(boolean b10) {
        this.m_shouldTransformAtEnd = b10;
    }

    public void setSystemId(String baseID) {
        this.m_transformer.setBaseURLOfSource(baseID);
        XPathContext xctxt = this.m_transformer.getXPathContext();
        SourceTreeManager stm = xctxt.getSourceTreeManager();
        this.m_inputSource = new StreamSource(baseID);
        stm.putDocumentInCache(this.m_root, this.m_inputSource);
    }

    public void setUseMultiThreading(boolean b10) {
        this.m_useMultiThreading = b10;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        this.m_isCData = true;
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.m_inDTD = true;
        if (this.m_root instanceof DocumentImpl) {
            DocumentImpl doc = (DocumentImpl)this.m_root;
            DocumentTypeImpl dtd = new DocumentTypeImpl(doc, name, publicId, systemId);
            ((DocumentImpl)this.m_root).setDoctype(dtd);
        }
    }

    public void startDocument() throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_inDTD = false;
            this.m_root.setSourceTreeHandler(this);
            this.m_root.setUid(1);
            this.m_root.setLevel(new Integer(1).shortValue());
            this.m_root.setUseMultiThreading(this.getUseMultiThreading());
            this.m_sourceTreeHandler = this.m_docFrag != null ? new StreeDOMBuilder((Document)this.m_root, this.m_docFrag) : (this.m_root.getNodeType() == 11 ? new StreeDOMBuilder(this.m_root.getOwnerDocument(), (DocumentFragment)((Object)this.m_root)) : new StreeDOMBuilder(this.m_root));
            this.pushShouldStripWhitespace(false);
            this.m_sourceTreeHandler.startDocument();
        }
        if (this.m_useMultiThreading && this.m_transformer != null && this.m_transformer.isParserEventsOnMain()) {
            ContentHandler resultContentHandler = this.m_transformer.getContentHandler();
            if (resultContentHandler != null && resultContentHandler instanceof SourceTreeHandler) {
                Properties myProps = this.m_transformer.getOutputProperties();
                SourceTreeHandler resultHandler = (SourceTreeHandler)resultContentHandler;
                Transformer resultTransformer = resultHandler.getTransformer();
                Properties resultProps = resultTransformer.getOutputProperties();
                Enumeration myKeys = ((Hashtable)myProps).keys();
                while (myKeys.hasMoreElements()) {
                    Object key = myKeys.nextElement();
                    if (((Hashtable)resultProps).get(key) != null) continue;
                    ((Hashtable)resultProps).put(key, ((Hashtable)myProps).get(key));
                }
                resultTransformer.setOutputProperties(resultProps);
            }
            if (this.m_docFrag != null) {
                this.m_transformer.setSourceTreeDocForThread(this.m_docFrag);
            } else {
                this.m_transformer.setSourceTreeDocForThread(this.m_root);
            }
            Thread t2 = this.m_transformer.createTransformThread();
            this.m_transformer.setTransformThread(t2);
            int cpriority = Thread.currentThread().getPriority();
            t2.setPriority(cpriority);
            t2.start();
        }
        this.notifyWaiters();
    }

    public void startElement(String ns, String localName, String name, Attributes atts) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_shouldStripWhitespaceStack.push(this.m_shouldStripWS);
            this.m_sourceTreeHandler.startElement(ns, localName, name, atts);
        }
        this.notifyWaiters();
    }

    public void startEntity(String name) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.startEntity(name);
        }
        this.notifyWaiters();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        DocImpl docImpl = this.m_root;
        synchronized (docImpl) {
            this.m_sourceTreeHandler.startPrefixMapping(prefix, uri);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        try {
            if (this.m_inputSource != null) {
                systemId = SystemIDResolver.getAbsoluteURI(systemId, this.m_inputSource.getSystemId());
            }
        }
        catch (Exception e10) {
            throw new SAXException(e10);
        }
        EntityImpl entity = new EntityImpl(name, notationName, publicId, systemId);
        this.m_root.getDoctype().getEntities().setNamedItem(entity);
    }
}

