/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.stree;

import org.apache.xalan.stree.AttrImpl;
import org.apache.xalan.stree.AttrImplNS;
import org.apache.xalan.stree.Child;
import org.apache.xalan.stree.DocumentImpl;
import org.apache.xalan.stree.NameSpaceDecl;
import org.apache.xalan.stree.Parent;
import org.apache.xml.utils.QName;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;

public class ElementImpl
extends Parent
implements Attributes,
NamedNodeMap {
    private String m_name;
    private short m_attrsEnd = 0;
    private AttrImpl m_firstAttr;
    private AttrImpl m_lastAttr;

    ElementImpl(DocumentImpl doc, String name) {
        super(doc);
        this.m_name = name;
    }

    ElementImpl(DocumentImpl doc, String name, Attributes atts) {
        super(doc);
        this.m_name = name;
        this.setAttributes(atts);
    }

    public Attr createAttribute(String name) throws DOMException {
        AttrImpl attrImpl = QName.isXMLNSDecl(name) ? new NameSpaceDecl(this.getDocumentImpl(), "http://www.w3.org/2000/xmlns/", name, "") : new AttrImpl(this.getDocumentImpl(), name, "");
        boolean found = false;
        AttrImpl attr = this.m_firstAttr;
        while (attr != null) {
            if (attr.getNodeName().equals(name)) {
                if (attr.m_prev != null) {
                    attr.m_prev.m_next = attr.m_next;
                }
                if (this.m_next != null) {
                    attr.m_next.m_prev = attr.m_prev;
                }
                attr.m_next = null;
                attr.m_prev = null;
                found = true;
                break;
            }
            attr = (AttrImpl)attr.m_next;
        }
        if (!found) {
            if (this.m_firstAttr == null) {
                this.m_firstAttr = attrImpl;
            } else {
                this.m_lastAttr.m_next = attrImpl;
                attrImpl.m_prev = this.m_lastAttr;
            }
            this.m_lastAttr = attrImpl;
            this.m_doc.incrementDocOrderCount();
            attrImpl.setUid(this.m_doc.getDocOrderCount());
            attrImpl.setParent(this);
            attrImpl.setLevel((short)(this.getLevel() + 1));
            this.m_attrsEnd = (short)(this.m_attrsEnd + 1);
        }
        return attrImpl;
    }

    public Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        AttrImplNS attrImpl = new AttrImplNS(this.getDocumentImpl(), namespaceURI, qualifiedName, "");
        boolean found = false;
        AttrImpl attr = this.m_firstAttr;
        while (attr != null) {
            String attrURI = attr.getNamespaceURI();
            if (attrURI == null) {
                attrURI = "";
            }
            if (attr.getLocalName().equals(attrImpl.getLocalName()) && attrURI.equals(attrImpl.getNamespaceURI())) {
                if (attr.m_prev != null) {
                    attr.m_prev.m_next = attr.m_next;
                }
                if (this.m_next != null) {
                    attr.m_next.m_prev = attr.m_prev;
                }
                attr.m_next = null;
                attr.m_prev = null;
                found = true;
                break;
            }
            attr = (AttrImpl)attr.m_next;
        }
        if (!found) {
            if (this.m_firstAttr == null) {
                this.m_firstAttr = attrImpl;
            } else {
                this.m_lastAttr.m_next = attrImpl;
                attrImpl.m_prev = this.m_lastAttr;
            }
            this.m_lastAttr = attrImpl;
            this.m_doc.incrementDocOrderCount();
            attrImpl.setUid(this.m_doc.getDocOrderCount());
            attrImpl.setParent(this);
            attrImpl.setLevel((short)(this.getLevel() + 1));
            this.m_attrsEnd = (short)(this.m_attrsEnd + 1);
        }
        return attrImpl;
    }

    public int getAttrCount() {
        DocumentImpl documentImpl = this.m_doc;
        synchronized (documentImpl) {
            short s2 = this.m_attrsEnd;
            Object var3_3 = null;
            return s2;
        }
    }

    public String getAttribute(String name) {
        return this.getValue(name);
    }

    public NamedNodeMap getAttributes() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AttrImpl getChildAttribute(int i2) throws ArrayIndexOutOfBoundsException, NullPointerException {
        if (i2 < 0) {
            return null;
        }
        DocumentImpl documentImpl = this.m_doc;
        synchronized (documentImpl) {
            if (this.m_firstAttr == null) return null;
            Child next = this.m_firstAttr;
            int k2 = 0;
            while (k2 < i2) {
                if (next == null) {
                    return null;
                }
                next = next.m_next;
                ++k2;
            }
            return next;
        }
    }

    public int getChildCount() {
        if (!this.isComplete()) {
            DocumentImpl documentImpl = this.m_doc;
            synchronized (documentImpl) {
                try {
                    while (!this.isComplete()) {
                        this.m_doc.wait(100L);
                        this.throwIfParseError();
                    }
                }
                catch (InterruptedException interruptedException) {
                    this.throwIfParseError();
                }
            }
        }
        return this.m_childCount;
    }

    public int getIndex(String rawName) {
        int i2 = 0;
        while (i2 < this.getAttrCount()) {
            AttrImpl attr = this.getChildAttribute(i2);
            if (attr.getNodeName().equals(rawName)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int getIndex(String uri, String localPart) {
        int i2 = 0;
        while (i2 < this.getAttrCount()) {
            AttrImpl attr = this.getChildAttribute(i2);
            if (attr.getLocalName().equals(localPart) && attr.getNamespaceURI().equals(uri)) {
                return i2;
            }
            ++i2;
        }
        return -1;
    }

    public int getLength() {
        return this.getAttrCount();
    }

    public String getLocalName() {
        return this.m_name;
    }

    public String getLocalName(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (attr != null) {
            return attr.getLocalName();
        }
        return null;
    }

    public Node getNamedItem(String name) {
        return this.getChildAttribute(this.getIndex(name));
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        return this.getChildAttribute(this.getIndex(namespaceURI, localName));
    }

    public String getNodeName() {
        return this.m_name;
    }

    public short getNodeType() {
        return 1;
    }

    public String getQName(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (attr != null) {
            return attr.getNodeName();
        }
        return null;
    }

    public String getTagName() {
        return this.m_name;
    }

    public String getType(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (attr != null) {
            return Integer.toString(attr.getNodeType());
        }
        return null;
    }

    public String getType(String rawName) {
        int i2 = 0;
        while (i2 < this.getAttrCount()) {
            AttrImpl attr = this.getChildAttribute(i2);
            if (attr.getNodeName().equals(rawName)) {
                return Integer.toString(attr.getNodeType());
            }
            ++i2;
        }
        return null;
    }

    public String getType(String uri, String localName) {
        int i2 = 0;
        while (i2 < this.getAttrCount()) {
            AttrImpl attr = this.getChildAttribute(i2);
            if (attr.getLocalName().equals(localName) && attr.getNamespaceURI().equals(uri)) {
                return Integer.toString(attr.getNodeType());
            }
            ++i2;
        }
        return null;
    }

    public String getURI(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (attr != null) {
            return attr.getNamespaceURI();
        }
        return null;
    }

    public String getValue(int index) {
        AttrImpl attr = this.getChildAttribute(index);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    public String getValue(String rawName) {
        int i2 = 0;
        while (i2 < this.getAttrCount()) {
            AttrImpl attr = this.getChildAttribute(i2);
            if (attr.getNodeName().equals(rawName)) {
                return attr.getValue();
            }
            ++i2;
        }
        return null;
    }

    public String getValue(String uri, String localName) {
        int i2 = 0;
        while (i2 < this.getAttrCount()) {
            AttrImpl attr = this.getChildAttribute(i2);
            if (attr.getLocalName().equals(localName) && attr.getNamespaceURI().equals(uri)) {
                return attr.getValue();
            }
            ++i2;
        }
        return null;
    }

    public Node item(int index) {
        return this.getChildAttribute(index);
    }

    public Node removeItem(int index) throws DOMException {
        AttrImpl attr = this.m_firstAttr;
        int pos = 0;
        while (attr != null) {
            if (pos == index) {
                if (attr.m_prev != null) {
                    attr.m_prev.m_next = attr.m_next;
                }
                if (this.m_next != null) {
                    attr.m_next.m_prev = attr.m_prev;
                }
                attr.m_next = null;
                attr.m_prev = null;
                return attr;
            }
            attr = (AttrImpl)attr.m_next;
            ++pos;
        }
        return null;
    }

    public Node removeNamedItem(String name) throws DOMException {
        int index = this.getIndex(name);
        return this.removeItem(index);
    }

    public Node removeNamedItemNS(String namespaceURI, String localName) throws DOMException {
        int index = this.getIndex(namespaceURI, localName);
        return this.removeItem(index);
    }

    public void setAttribute(String name, String value) throws DOMException {
        AttrImpl attr = (AttrImpl)this.createAttribute(name);
        attr.setValue(value);
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        AttrImplNS attr = (AttrImplNS)this.createAttributeNS(namespaceURI, qualifiedName);
        attr.setValue(value);
    }

    public void setAttributes(Attributes atts) throws DOMException {
        int i2 = 0;
        while (i2 < atts.getLength()) {
            String uri = atts.getURI(i2);
            String name = atts.getQName(i2);
            AttrImpl attr = uri != null || name.indexOf(58) > 0 ? (AttrImplNS)this.createAttributeNS(uri, name) : (AttrImpl)this.createAttribute(name);
            attr.setValue(atts.getValue(i2));
            ++i2;
        }
    }

    public void setIDAttribute(String value) {
        this.getDocumentImpl().setIDAttribute(value, this);
    }

    public Node setNamedItem(Node arg) throws DOMException {
        this.setAttribute(((Attr)arg).getName(), ((Attr)arg).getValue());
        return this.getChildAttribute(this.getIndex(((Attr)arg).getName()));
    }

    public Node setNamedItemNS(Node arg) throws DOMException {
        this.setAttributeNS(((Attr)arg).getNamespaceURI(), ((Attr)arg).getName(), ((Attr)arg).getValue());
        return this.getChildAttribute(this.getIndex(((Attr)arg).getNamespaceURI(), ((Attr)arg).getName()));
    }
}

