/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.lib.sql;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Vector;
import org.apache.xalan.lib.sql.QueryParameter;
import org.apache.xalan.lib.sql.RowSet;
import org.apache.xalan.lib.sql.StreamableNode;
import org.apache.xalan.lib.sql.XConnection;
import org.apache.xpath.axes.ContextNodeList;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.NodeIterator;

public class XStatement
extends StreamableNode
implements NodeIterator,
ContextNodeList,
Cloneable {
    private static final boolean DEBUG = false;
    private Statement m_statement;
    private PreparedStatement m_pstatement;
    private int m_nodeCounter = 0;
    ResultSet m_resultSet;
    private XConnection m_xconnection;
    private String m_queryString;
    RowSet m_rowset;
    boolean m_nextHasBeenCalled = false;
    static final String S_DOCELEMENTNAME = "row-set";
    static final String S_COLUMNHEADERNAME = "column-header";
    static final String S_ROWNAME = "row";
    static final String S_COLUMNNAME = "col";
    private int m_last = 0;

    public XStatement(XConnection connection, String queryString) throws SQLException {
        super(null);
        this.m_xconnection = connection;
        this.m_statement = this.m_xconnection.m_connection.createStatement();
        this.m_queryString = queryString;
        this.m_resultSet = this.m_statement.executeQuery(this.m_queryString);
        this.m_rowset = new RowSet(this);
    }

    public XStatement(XConnection connection, String queryString, Vector pList) throws SQLException {
        super(null);
        this.m_xconnection = connection;
        this.m_queryString = queryString;
        this.m_pstatement = this.m_xconnection.m_connection.prepareStatement(this.m_queryString);
        Enumeration enumeration = pList.elements();
        int indx = 1;
        while (enumeration.hasMoreElements()) {
            QueryParameter param = (QueryParameter)enumeration.nextElement();
            this.setParameter(indx, this.m_pstatement, param);
            ++indx;
        }
        this.m_resultSet = this.m_pstatement.executeQuery();
        this.m_rowset = new RowSet(this);
        this.m_statement = this.m_pstatement;
    }

    public Object clone() throws CloneNotSupportedException {
        XStatement clone = (XStatement)super.clone();
        return clone;
    }

    public NodeIterator cloneWithReset() throws CloneNotSupportedException {
        XStatement clone = (XStatement)super.clone();
        clone.reset();
        return clone;
    }

    public void detach() {
        try {
            this.m_statement.close();
            this.m_statement = null;
            this.m_resultSet = null;
        }
        catch (SQLException sQLException) {}
    }

    int getAndIncrementNodeCounter() {
        int c10 = this.m_nodeCounter++;
        return c10;
    }

    public Node getCurrentNode() {
        return this.m_rowset;
    }

    public int getCurrentPos() {
        return 0;
    }

    public boolean getExpandEntityReferences() {
        return true;
    }

    public NodeFilter getFilter() {
        return null;
    }

    public Node getFirstChild() {
        try {
            if (this.getNodeTest().getNamespace() == null && this.getNodeTest().getLocalName().equals(S_DOCELEMENTNAME)) {
                return this.m_rowset;
            }
            return null;
        }
        catch (NullPointerException e10) {
            e10.printStackTrace();
            throw e10;
        }
    }

    public int getLast() {
        return this.m_last;
    }

    public Node getNextSibling() {
        return null;
    }

    public String getNodeName() {
        return "#Document";
    }

    public short getNodeType() {
        return 9;
    }

    public Document getOwnerDocument() {
        return null;
    }

    public Node getParentNode() {
        return null;
    }

    public ResultSet getResultSet() {
        return this.m_resultSet;
    }

    public Node getRoot() {
        return this;
    }

    public Statement getStatement() {
        return this.m_statement;
    }

    public int getWhatToShow() {
        return -17;
    }

    public XStatement getXStatement() {
        return this;
    }

    public boolean hasChildNodes() {
        return true;
    }

    public boolean isFresh() {
        return this.m_nextHasBeenCalled ^ true;
    }

    public Node nextNode() throws DOMException {
        if (!this.m_nextHasBeenCalled) {
            this.m_nextHasBeenCalled = true;
            return this;
        }
        return null;
    }

    public Node previousNode() throws DOMException {
        this.error(80);
        return null;
    }

    public void reset() {
        this.m_nextHasBeenCalled = false;
    }

    public void runTo(int index) {
    }

    public void setCurrentPos(int i2) {
    }

    public void setLast(int last) {
        this.m_last = last;
    }

    public void setParameter(int pos, PreparedStatement stmt, QueryParameter p2) throws SQLException {
        String type = p2.getType();
        if (type.equalsIgnoreCase("string")) {
            stmt.setString(pos, p2.getValue());
        }
        if (type.equalsIgnoreCase("bigdecimal")) {
            stmt.setBigDecimal(pos, new BigDecimal(p2.getValue()));
        }
        if (type.equalsIgnoreCase("boolean")) {
            Integer i2 = new Integer(p2.getValue());
            boolean b10 = i2 == 0;
            stmt.setBoolean(pos, b10);
        }
        if (type.equalsIgnoreCase("bytes")) {
            stmt.setBytes(pos, p2.getValue().getBytes());
        }
        if (type.equalsIgnoreCase("date")) {
            stmt.setDate(pos, Date.valueOf(p2.getValue()));
        }
        if (type.equalsIgnoreCase("double")) {
            Double d10 = new Double(p2.getValue());
            stmt.setDouble(pos, d10);
        }
        if (type.equalsIgnoreCase("float")) {
            Float f2 = new Float(p2.getValue());
            stmt.setFloat(pos, f2.floatValue());
        }
        if (type.equalsIgnoreCase("long")) {
            Long l2 = new Long(p2.getValue());
            stmt.setLong(pos, l2);
        }
        if (type.equalsIgnoreCase("short")) {
            Short s2 = new Short(p2.getValue());
            stmt.setShort(pos, s2);
        }
        if (type.equalsIgnoreCase("time")) {
            stmt.setTime(pos, Time.valueOf(p2.getValue()));
        }
        if (type.equalsIgnoreCase("timestamp")) {
            stmt.setTimestamp(pos, Timestamp.valueOf(p2.getValue()));
        }
    }

    public void setShouldCacheNodes(boolean b10) {
    }

    public int size() {
        return 1;
    }

    public String toString() {
        return "XStatement: " + this.m_queryString;
    }
}

