/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.resources;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.Hashtable;
import javax.naming.directory.DirContext;
import org.apache.naming.resources.DirContextURLConnection;

public class DirContextURLStreamHandler
extends URLStreamHandler {
    private static Hashtable clBindings = new Hashtable();
    protected DirContext context = null;

    public DirContextURLStreamHandler() {
    }

    public DirContextURLStreamHandler(DirContext context) {
        this.context = context;
    }

    public static void bind(ClassLoader cl2, DirContext dirContext) {
        clBindings.put(cl2, dirContext);
    }

    public static void bind(DirContext dirContext) {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        if (currentCL != null) {
            clBindings.put(currentCL, dirContext);
        }
    }

    public static DirContext get() {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        DirContext result = null;
        while (result == null && currentCL != null) {
            result = (DirContext)clBindings.get(currentCL);
            if (result != null) continue;
            currentCL = currentCL.getParent();
        }
        if (result == null) {
            throw new IllegalStateException("Illegal class loader binding");
        }
        return result;
    }

    public static DirContext get(ClassLoader cl2) {
        return (DirContext)clBindings.get(cl2);
    }

    protected URLConnection openConnection(URL u2) throws IOException {
        DirContext currentContext = this.context;
        if (currentContext == null) {
            currentContext = DirContextURLStreamHandler.get();
        }
        return new DirContextURLConnection(currentContext, u2);
    }

    public static void unbind() {
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        if (currentCL != null) {
            clBindings.remove(currentCL);
        }
    }

    public static void unbind(ClassLoader cl2) {
        clBindings.remove(cl2);
    }
}

