/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

public final class AccessLogValve
extends ValveBase
implements Lifecycle {
    private String dateStamp = "";
    private String directory = "logs";
    protected static final String info = "org.apache.catalina.valves.AccessLogValve/1.0";
    protected LifecycleSupport lifecycle = new LifecycleSupport(this);
    protected static final String[] months = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    private boolean common = false;
    private String pattern = null;
    private String prefix = "access_log.";
    private StringManager sm = StringManager.getManager("org.apache.catalina.valves");
    private boolean started = false;
    private String suffix = "";
    private PrintWriter writer = null;
    private SimpleDateFormat dateFormatter = null;
    private SimpleDateFormat dayFormatter = null;
    private SimpleDateFormat monthFormatter = null;
    private SimpleDateFormat yearFormatter = null;
    private SimpleDateFormat timeFormatter = null;
    private String timeZone = null;
    private Date currentDate = null;
    private String space = " ";
    private boolean resolveHosts = false;

    public AccessLogValve() {
        this.setPattern("common");
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    private synchronized void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.flush();
        this.writer.close();
        this.writer = null;
        this.dateStamp = "";
    }

    private Date getDate() {
        long systime = System.currentTimeMillis();
        if (systime - this.currentDate.getTime() > 1000L) {
            this.currentDate = new Date(systime);
        }
        return this.currentDate;
    }

    public String getDirectory() {
        return this.directory;
    }

    public String getInfo() {
        return info;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void invoke(Request request, Response response, ValveContext context) throws IOException, ServletException {
        context.invokeNext(request, response);
        Date date = this.getDate();
        StringBuffer result = new StringBuffer();
        if (this.common) {
            String value = null;
            ServletRequest req = request.getRequest();
            HttpServletRequest hreq = null;
            if (req instanceof HttpServletRequest) {
                hreq = (HttpServletRequest)req;
            }
            if (this.isResolveHosts()) {
                result.append(req.getRemoteHost());
            } else {
                result.append(req.getRemoteAddr());
            }
            result.append(" - ");
            if (hreq != null) {
                value = hreq.getRemoteUser();
            }
            if (value == null) {
                result.append("- ");
            } else {
                result.append(value);
                result.append(this.space);
            }
            result.append("[");
            result.append(this.dayFormatter.format(date));
            result.append('/');
            result.append(this.lookup(this.monthFormatter.format(date)));
            result.append('/');
            result.append(this.yearFormatter.format(date));
            result.append(':');
            result.append(this.timeFormatter.format(date));
            result.append(this.space);
            result.append(this.timeZone);
            result.append("] \"");
            result.append(hreq.getMethod());
            result.append(this.space);
            result.append(hreq.getRequestURI());
            result.append(this.space);
            result.append(hreq.getProtocol());
            result.append("\" ");
            result.append(((HttpResponse)response).getStatus());
            result.append(this.space);
            int length = response.getContentCount();
            value = length <= 0 ? "-" : String.valueOf(length);
            result.append(value);
        } else {
            boolean replace = false;
            int i2 = 0;
            while (i2 < this.pattern.length()) {
                char ch2 = this.pattern.charAt(i2);
                if (replace) {
                    result.append(this.replace(ch2, date, request, response));
                    replace = false;
                } else if (ch2 == '%') {
                    replace = true;
                } else {
                    result.append(ch2);
                }
                ++i2;
            }
        }
        this.log(result.toString(), date);
    }

    public boolean isResolveHosts() {
        return this.resolveHosts;
    }

    public void log(String message, Date date) {
        long systime = System.currentTimeMillis();
        if (systime - this.currentDate.getTime() > 1000L) {
            this.currentDate = new Date(systime);
            String tsDate = this.dateFormatter.format(this.currentDate);
            if (!this.dateStamp.equals(tsDate)) {
                AccessLogValve accessLogValve = this;
                synchronized (accessLogValve) {
                    this.close();
                    this.dateStamp = tsDate;
                    this.open();
                }
            }
        }
        if (this.writer != null) {
            this.writer.println(message);
        }
    }

    private String lookup(String month) {
        int index;
        try {
            index = Integer.parseInt(month) - 1;
        }
        catch (Throwable throwable) {
            index = 0;
        }
        return months[index];
    }

    private synchronized void open() {
        File dir = new File(this.directory);
        if (!dir.isAbsolute()) {
            dir = new File(String.valueOf(System.getProperty("catalina.home")) + File.separator + this.directory);
        }
        dir.mkdirs();
        try {
            String pathname = String.valueOf(dir.getAbsolutePath()) + File.separator + this.prefix + this.dateStamp + this.suffix;
            this.writer = new PrintWriter((Writer)new FileWriter(pathname, true), true);
        }
        catch (IOException iOException) {
            this.writer = null;
        }
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    private String replace(char pattern, Date date, Request request, Response response) {
        String value = null;
        ServletRequest req = request.getRequest();
        HttpServletRequest hreq = null;
        if (req instanceof HttpServletRequest) {
            hreq = (HttpServletRequest)req;
        }
        ServletResponse res = response.getResponse();
        HttpServletResponse hres = null;
        if (res instanceof HttpServletResponse) {
            hres = (HttpServletResponse)res;
        }
        if (pattern == 'a') {
            value = req.getRemoteAddr();
        } else if (pattern == 'A') {
            value = "127.0.0.1";
        } else if (pattern == 'b') {
            int length = response.getContentCount();
            value = length <= 0 ? "-" : String.valueOf(length);
        } else if (pattern == 'B') {
            value = String.valueOf(response.getContentLength());
        } else if (pattern == 'h') {
            value = req.getRemoteHost();
        } else if (pattern == 'H') {
            value = req.getProtocol();
        } else if (pattern == 'l') {
            value = "-";
        } else if (pattern == 'm') {
            value = hreq != null ? hreq.getMethod() : "";
        } else if (pattern == 'p') {
            value = String.valueOf(req.getServerPort());
        } else if (pattern == 'q') {
            String query = null;
            if (hreq != null) {
                query = hreq.getQueryString();
            }
            value = query != null ? "?" + query : "";
        } else if (pattern == 'r') {
            value = hreq != null ? String.valueOf(hreq.getMethod()) + this.space + hreq.getRequestURI() + this.space + hreq.getProtocol() : "- - " + req.getProtocol();
        } else if (pattern == 's') {
            value = hres != null ? String.valueOf(((HttpResponse)response).getStatus()) : "-";
        } else if (pattern == 't') {
            StringBuffer temp = new StringBuffer("[");
            temp.append(this.dayFormatter.format(date));
            temp.append('/');
            temp.append(this.lookup(this.monthFormatter.format(date)));
            temp.append('/');
            temp.append(this.yearFormatter.format(date));
            temp.append(':');
            temp.append(this.timeFormatter.format(date));
            temp.append(' ');
            temp.append(this.timeZone);
            temp.append(']');
            value = temp.toString();
        } else if (pattern == 'u') {
            if (hreq != null) {
                value = hreq.getRemoteUser();
            }
            if (value == null) {
                value = "-";
            }
        } else {
            value = pattern == 'U' ? (hreq != null ? hreq.getRequestURI() : "-") : (pattern == 'v' ? req.getServerName() : "???" + pattern + "???");
        }
        if (value == null) {
            return "";
        }
        return value;
    }

    public void setDirectory(String directory) {
        this.directory = directory;
    }

    public void setPattern(String pattern) {
        if (pattern == null) {
            pattern = "";
        }
        if (pattern.equals("common")) {
            pattern = "%h %l %u %t \"%r\" %s %b";
        }
        this.pattern = pattern;
        this.common = this.pattern.equals("%h %l %u %t \"%r\" %s %b");
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setResolveHosts(boolean resolveHosts) {
        this.resolveHosts = resolveHosts;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        TimeZone tz = TimeZone.getDefault();
        this.timeZone = String.valueOf(tz.getRawOffset() / 36000);
        if (this.timeZone.length() < 5) {
            this.timeZone = String.valueOf(this.timeZone.substring(0, 1)) + "0" + this.timeZone.substring(1, this.timeZone.length());
        }
        this.dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.dateFormatter.setTimeZone(tz);
        this.dayFormatter = new SimpleDateFormat("dd");
        this.dayFormatter.setTimeZone(tz);
        this.monthFormatter = new SimpleDateFormat("MM");
        this.monthFormatter.setTimeZone(tz);
        this.yearFormatter = new SimpleDateFormat("yyyy");
        this.yearFormatter.setTimeZone(tz);
        this.timeFormatter = new SimpleDateFormat("kk:mm:ss");
        this.timeFormatter.setTimeZone(tz);
        this.currentDate = new Date();
        this.dateStamp = this.dateFormatter.format(this.currentDate);
        this.open();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("accessLogValve.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.close();
    }
}

