/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.util;

public final class Base64 {
    private static final int BASELENGTH = 255;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int SIXBIT = 6;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final byte PAD = 61;
    private static final boolean fDebug = false;
    private static byte[] base64Alphabet = new byte[255];
    private static byte[] lookUpBase64Alphabet = new byte[64];

    static {
        int i2 = 0;
        while (i2 < 255) {
            Base64.base64Alphabet[i2] = -1;
            ++i2;
        }
        int i3 = 90;
        while (i3 >= 65) {
            Base64.base64Alphabet[i3] = (byte)(i3 - 65);
            --i3;
        }
        int i4 = 122;
        while (i4 >= 97) {
            Base64.base64Alphabet[i4] = (byte)(i4 - 97 + 26);
            --i4;
        }
        int i5 = 57;
        while (i5 >= 48) {
            Base64.base64Alphabet[i5] = (byte)(i5 - 48 + 52);
            --i5;
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        int i6 = 0;
        while (i6 <= 25) {
            Base64.lookUpBase64Alphabet[i6] = (byte)(65 + i6);
            ++i6;
        }
        int i7 = 26;
        int j2 = 0;
        while (i7 <= 51) {
            Base64.lookUpBase64Alphabet[i7] = (byte)(97 + j2);
            ++i7;
            ++j2;
        }
        int i8 = 52;
        int j3 = 0;
        while (i8 <= 61) {
            Base64.lookUpBase64Alphabet[i8] = (byte)(48 + j3);
            ++i8;
            ++j3;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }

    public static byte[] decode(byte[] base64Data) {
        int numberQuadruple = base64Data.length / 4;
        byte[] decodedData = null;
        byte b12 = 0;
        byte b22 = 0;
        byte b32 = 0;
        byte b42 = 0;
        byte marker0 = 0;
        byte marker1 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        decodedData = new byte[numberQuadruple * 3 + 1];
        int i2 = 0;
        while (i2 < numberQuadruple) {
            dataIndex = i2 * 4;
            marker0 = base64Data[dataIndex + 2];
            marker1 = base64Data[dataIndex + 3];
            b12 = base64Alphabet[base64Data[dataIndex]];
            b22 = base64Alphabet[base64Data[dataIndex + 1]];
            if (marker0 != 61 && marker1 != 61) {
                b32 = base64Alphabet[marker0];
                b42 = base64Alphabet[marker1];
                decodedData[encodedIndex] = (byte)(b12 << 2 | b22 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b22 & 0xF) << 4 | b32 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b32 << 6 | b42);
            } else if (marker0 == 61) {
                decodedData[encodedIndex] = (byte)(b12 << 2 | b22 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b22 & 0xF) << 4);
                decodedData[encodedIndex + 2] = 0;
            } else if (marker1 == 61) {
                b32 = base64Alphabet[marker0];
                decodedData[encodedIndex] = (byte)(b12 << 2 | b22 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b22 & 0xF) << 4 | b32 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b32 << 6);
            }
            encodedIndex += 3;
            ++i2;
        }
        return decodedData;
    }

    public static byte[] encode(byte[] binaryData) {
        byte val2;
        byte val1;
        int lengthDataBits = binaryData.length * 8;
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        byte[] encodedData = null;
        encodedData = fewerThan24bits != 0 ? new byte[(numberTriplets + 1) * 4] : new byte[numberTriplets * 4];
        byte k2 = 0;
        byte l2 = 0;
        byte b12 = 0;
        byte b22 = 0;
        byte b32 = 0;
        int encodedIndex = 0;
        int dataIndex = 0;
        int i2 = 0;
        i2 = 0;
        while (i2 < numberTriplets) {
            dataIndex = i2 * 3;
            b12 = binaryData[dataIndex];
            b22 = binaryData[dataIndex + 1];
            b32 = binaryData[dataIndex + 2];
            l2 = (byte)(b22 & 0xF);
            k2 = (byte)(b12 & 3);
            encodedIndex = i2 * 4;
            val1 = (b12 & 0xFFFFFF80) == 0 ? (byte)(b12 >> 2) : (byte)(b12 >> 2 ^ 0xC0);
            val2 = (b22 & 0xFFFFFF80) == 0 ? (byte)(b22 >> 4) : (byte)(b22 >> 4 ^ 0xF0);
            byte val3 = (b32 & 0xFFFFFF80) == 0 ? (byte)(b32 >> 6) : (byte)(b32 >> 6 ^ 0xFC);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k2 << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l2 << 2 | val3];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b32 & 0x3F];
            ++i2;
        }
        dataIndex = i2 * 3;
        encodedIndex = i2 * 4;
        if (fewerThan24bits == 8) {
            b12 = binaryData[dataIndex];
            k2 = (byte)(b12 & 3);
            val1 = (b12 & 0xFFFFFF80) == 0 ? (byte)(b12 >> 2) : (byte)(b12 >> 2 ^ 0xC0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k2 << 4];
            encodedData[encodedIndex + 2] = 61;
            encodedData[encodedIndex + 3] = 61;
        } else if (fewerThan24bits == 16) {
            b12 = binaryData[dataIndex];
            b22 = binaryData[dataIndex + 1];
            l2 = (byte)(b22 & 0xF);
            k2 = (byte)(b12 & 3);
            val1 = (b12 & 0xFFFFFF80) == 0 ? (byte)(b12 >> 2) : (byte)(b12 >> 2 ^ 0xC0);
            val2 = (b22 & 0xFFFFFF80) == 0 ? (byte)(b22 >> 4) : (byte)(b22 >> 4 ^ 0xF0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k2 << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l2 << 2];
            encodedData[encodedIndex + 3] = 61;
        }
        return encodedData;
    }

    public static boolean isArrayByteBase64(byte[] arrayOctect) {
        int length = arrayOctect.length;
        if (length == 0) {
            return false;
        }
        int i2 = 0;
        while (i2 < length) {
            if (!Base64.isBase64(arrayOctect[i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public static boolean isBase64(byte octect) {
        return octect == 61 || base64Alphabet[octect] != -1;
    }

    public static boolean isBase64(String isValidString) {
        return Base64.isArrayByteBase64(isValidString.getBytes());
    }
}

