/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.RequestDispatcher;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.UnavailableException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.Context;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Logger;
import org.apache.catalina.Request;
import org.apache.catalina.Response;
import org.apache.catalina.ValveContext;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.ApplicationFilterChain;
import org.apache.catalina.core.ApplicationFilterConfig;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.ErrorPage;
import org.apache.catalina.deploy.FilterDef;
import org.apache.catalina.deploy.FilterMap;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;
import org.apache.catalina.valves.ValveBase;

final class StandardWrapperValve
extends ValveBase {
    private int debug = 0;
    private FilterDef filterDef = null;
    private static final String info = "org.apache.catalina.core.StandardWrapperValve/1.0";
    private static final StringManager sm = StringManager.getManager("org.apache.catalina.core");

    StandardWrapperValve() {
    }

    private ApplicationFilterChain createFilterChain(Request request, Servlet servlet) {
        if (servlet == null) {
            return null;
        }
        ApplicationFilterChain filterChain = new ApplicationFilterChain();
        filterChain.setServlet(servlet);
        StandardWrapper wrapper = (StandardWrapper)this.getContainer();
        filterChain.setSupport(wrapper.getInstanceSupport());
        StandardContext context = (StandardContext)wrapper.getParent();
        FilterMap[] filterMaps = context.findFilterMaps();
        if (filterMaps == null || filterMaps.length == 0) {
            return filterChain;
        }
        String requestPath = null;
        if (request instanceof HttpRequest) {
            String requestURI;
            HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
            String contextPath = hreq.getContextPath();
            if (contextPath == null) {
                contextPath = "";
            }
            if ((requestURI = hreq.getRequestURI()).length() >= contextPath.length()) {
                requestPath = requestURI.substring(contextPath.length());
            }
        }
        String servletName = wrapper.getName();
        int n2 = 0;
        int i2 = 0;
        while (i2 < filterMaps.length) {
            ApplicationFilterConfig filterConfig;
            if (this.matchFiltersURL(filterMaps[i2], requestPath) && (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i2].getFilterName())) != null) {
                filterChain.addFilter(filterConfig);
                ++n2;
            }
            ++i2;
        }
        int i3 = 0;
        while (i3 < filterMaps.length) {
            ApplicationFilterConfig filterConfig;
            if (this.matchFiltersServlet(filterMaps[i3], servletName) && (filterConfig = (ApplicationFilterConfig)context.findFilterConfig(filterMaps[i3].getFilterName())) != null) {
                filterChain.addFilter(filterConfig);
                ++n2;
            }
            ++i3;
        }
        return filterChain;
    }

    private boolean custom(Request request, Response response, ErrorPage errorPage) {
        if (this.debug >= 1) {
            this.log("Processing " + errorPage);
        }
        if (!(request instanceof HttpRequest)) {
            if (this.debug >= 1) {
                this.log(" Not processing an HTTP request --> default handling");
            }
            return false;
        }
        HttpServletRequest hreq = (HttpServletRequest)request.getRequest();
        if (!(response instanceof HttpResponse)) {
            if (this.debug >= 1) {
                this.log("Not processing an HTTP response --> default handling");
            }
            return false;
        }
        HttpServletResponse hres = (HttpServletResponse)response.getResponse();
        try {
            hres.reset();
            ServletContext servletContext = ((Context)this.container.getParent()).getServletContext();
            RequestDispatcher rd = servletContext.getRequestDispatcher(errorPage.getLocation());
            rd.forward(hreq, hres);
            return true;
        }
        catch (Throwable t2) {
            this.log("Exception Processing " + errorPage, t2);
            return false;
        }
    }

    private void exception(Request request, Response response, Throwable exception) {
        Throwable realError;
        Context context;
        ErrorPage errorPage;
        if (this.debug >= 1) {
            this.log("Handling exception: " + exception);
        }
        if ((errorPage = this.findErrorPage(context = (Context)this.container.getParent(), realError = exception)) == null && realError instanceof ServletException) {
            realError = ((ServletException)exception).getRootCause();
            if (realError != null) {
                errorPage = this.findErrorPage(context, realError);
            } else {
                realError = exception;
            }
        }
        if (errorPage != null) {
            ServletRequest sreq = request.getRequest();
            sreq.setAttribute("javax.servlet.error.message", exception.getMessage());
            sreq.setAttribute("javax.servlet.error.exception", exception);
            Wrapper wrapper = (Wrapper)this.getContainer();
            sreq.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
            if (sreq instanceof HttpServletRequest) {
                sreq.setAttribute("javax.servlet.error.request_uri", ((HttpServletRequest)sreq).getRequestURI());
            }
            sreq.setAttribute("javax.servlet.error.exception_type", exception.getClass());
            if (this.custom(request, response, errorPage)) {
                return;
            }
        }
        response.setError();
        try {
            response.getResponse().reset();
        }
        catch (IllegalStateException illegalStateException) {}
        try {
            ServletResponse sresponse = response.getResponse();
            if (sresponse instanceof HttpServletResponse) {
                ((HttpServletResponse)sresponse).sendError(500);
            }
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IOException iOException) {}
        Throwable rootCause = null;
        if (exception instanceof ServletException) {
            rootCause = ((ServletException)exception).getRootCause();
        }
        try {
            try {
                response.getResponse().setContentType("text/html");
            }
            catch (Throwable throwable) {}
            PrintWriter writer = response.getReporter();
            writer.println("<html>");
            writer.println("<head>");
            writer.println("<title>" + sm.getString("standardWrapper.exception0") + "</title>");
            writer.println("</head>");
            writer.println("<body bgcolor=\"white\">");
            writer.println("<br><br>");
            writer.println("<h1>" + sm.getString("standardWrapper.exception1") + "</h1>");
            if (rootCause != null) {
                writer.println("<h3>" + sm.getString("standardWrapper.exception2") + "</h3>");
            }
            writer.println("<pre>");
            exception.printStackTrace(writer);
            writer.println("</pre>");
            if (rootCause != null) {
                writer.println("<h3>" + sm.getString("standardWrapper.exception3") + "</h3>");
                writer.println("<pre>");
                rootCause.printStackTrace(writer);
                writer.println("</pre>");
            }
            writer.println("</body>");
            writer.println("</html>");
            writer.flush();
        }
        catch (IllegalStateException illegalStateException) {}
    }

    private ErrorPage findErrorPage(Context context, Throwable exception) {
        if (exception == null) {
            return null;
        }
        Class<?> clazz = exception.getClass();
        String name = clazz.getName();
        while (!"java.lang.Object".equals(clazz)) {
            ErrorPage errorPage = context.findErrorPage(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    public String getInfo() {
        return info;
    }

    public void invoke(Request request, Response response, ValveContext valveContext) throws IOException, ServletException {
        boolean unavailable = false;
        Throwable throwable = null;
        StandardWrapper wrapper = (StandardWrapper)this.getContainer();
        ServletRequest sreq = request.getRequest();
        ServletResponse sres = response.getResponse();
        Servlet servlet = null;
        HttpServletRequest hreq = null;
        if (sreq instanceof HttpServletRequest) {
            hreq = (HttpServletRequest)sreq;
        }
        HttpServletResponse hres = null;
        if (sres instanceof HttpServletResponse) {
            hres = (HttpServletResponse)sres;
        }
        String jspFile = wrapper.getJspFile();
        if (hreq != null && hres != null && jspFile != null) {
            StringBuffer sb = new StringBuffer();
            String contextPath = hreq.getContextPath();
            if (contextPath != null) {
                sb.append(contextPath);
            }
            sb.append(jspFile);
            String pathInfo = hreq.getPathInfo();
            if (pathInfo != null) {
                sb.append(pathInfo);
            }
            ((HttpRequest)request).setRequestURI(sb.toString());
            ((HttpRequest)request).setServletPath(jspFile);
        }
        if (!((Context)wrapper.getParent()).getAvailable()) {
            hres.sendError(503, sm.getString("standardContext.isUnavailable"));
            unavailable = true;
        }
        if (!unavailable && wrapper.isUnavailable()) {
            this.log(sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
            if (hres != null) {
                long available = wrapper.getAvailable();
                if (available > 0L && available < Long.MAX_VALUE) {
                    hres.setDateHeader("Retry-After", available);
                }
                hres.sendError(503, sm.getString("standardWrapper.isUnavailable", wrapper.getName()));
            }
            unavailable = true;
        }
        try {
            if (!unavailable) {
                servlet = wrapper.allocate();
            }
        }
        catch (ServletException e10) {
            this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e10);
            throwable = e10;
            this.exception(request, response, e10);
            servlet = null;
        }
        catch (Throwable e11) {
            this.log(sm.getString("standardWrapper.allocateException", wrapper.getName()), e11);
            throwable = e11;
            this.exception(request, response, e11);
            servlet = null;
        }
        ApplicationFilterChain filterChain = this.createFilterChain(request, servlet);
        try {
            if (servlet != null && filterChain != null) {
                filterChain.doFilter(sreq, sres);
            }
        }
        catch (IOException e12) {
            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e12);
        }
        catch (UnavailableException e13) {
            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e13);
            throwable = e13;
            this.exception(request, response, e13);
            wrapper.unavailable(e13);
        }
        catch (ServletException e14) {
            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e14);
            throwable = e14;
            this.exception(request, response, e14);
        }
        catch (Throwable e15) {
            this.log(sm.getString("standardWrapper.serviceException", wrapper.getName()), e15);
            throwable = e15;
            this.exception(request, response, e15);
        }
        try {
            if (filterChain != null) {
                filterChain.release();
            }
        }
        catch (Throwable e16) {
            this.log(sm.getString("standardWrapper.releaseFilters", wrapper.getName()), e16);
            throwable = e16;
            this.exception(request, response, e16);
        }
        try {
            if (servlet != null) {
                wrapper.deallocate(servlet);
            }
        }
        catch (ServletException e17) {
            this.log(sm.getString("standardWrapper.deallocateException", wrapper.getName()), e17);
            throwable = e17;
            this.exception(request, response, e17);
        }
        catch (Throwable e18) {
            this.log(sm.getString("standardWrapper.deallocateException", wrapper.getName()), e18);
            throwable = e18;
            this.exception(request, response, e18);
        }
        if (throwable == null) {
            this.status(request, response);
        }
    }

    private void log(String message) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = null;
        if (this.container != null) {
            logger = this.container.getLogger();
        }
        if (logger != null) {
            logger.log("StandardWrapperValve[" + this.container.getName() + "]: " + message, throwable);
        } else {
            String containerName = null;
            if (this.container != null) {
                containerName = this.container.getName();
            }
            System.out.println("StandardWrapperValve[" + containerName + "]: " + message);
            System.out.println(String.valueOf(String.valueOf(throwable)));
            throwable.printStackTrace(System.out);
        }
    }

    private boolean matchFiltersServlet(FilterMap filterMap, String servletName) {
        if (servletName == null) {
            return false;
        }
        return servletName.equals(filterMap.getServletName());
    }

    private boolean matchFiltersURL(FilterMap filterMap, String requestPath) {
        if (requestPath == null) {
            return false;
        }
        String testPath = filterMap.getURLPattern();
        if (testPath == null) {
            return false;
        }
        if (testPath.equals(requestPath)) {
            return true;
        }
        if (testPath.equals("/*")) {
            return true;
        }
        if (testPath.endsWith("/*")) {
            String comparePath = requestPath;
            while (true) {
                if (testPath.equals(String.valueOf(comparePath) + "/*")) {
                    return true;
                }
                int slash = comparePath.lastIndexOf("/");
                if (slash < 0) break;
                comparePath = comparePath.substring(0, slash);
            }
            return false;
        }
        if (testPath.startsWith("*.")) {
            int slash = requestPath.lastIndexOf("/");
            int period = requestPath.lastIndexOf(".");
            if (slash >= 0 && period > slash) {
                return testPath.equals("*." + requestPath.substring(period + 1));
            }
        }
        return false;
    }

    private void status(Request request, Response response) {
        block23: {
            String report;
            String message;
            int statusCode;
            HttpServletResponse hres;
            block21: {
                if (!(response instanceof HttpResponse)) {
                    return;
                }
                HttpResponse hresponse = (HttpResponse)response;
                if (!(response.getResponse() instanceof HttpServletResponse)) {
                    return;
                }
                hres = (HttpServletResponse)response.getResponse();
                statusCode = hresponse.getStatus();
                message = RequestUtil.filter(hresponse.getMessage());
                if (message == null) {
                    message = "";
                }
                if (statusCode < 200) {
                    return;
                }
                if (statusCode == 200) {
                    return;
                }
                if (statusCode == 304) {
                    return;
                }
                if (statusCode == 204) {
                    return;
                }
                Context context = (Context)this.container.getParent();
                ErrorPage errorPage = context.findErrorPage(statusCode);
                if (errorPage != null) {
                    ServletRequest sreq = request.getRequest();
                    sreq.setAttribute("javax.servlet.error.status_code", new Integer(statusCode));
                    sreq.setAttribute("javax.servlet.error.message", message);
                    Wrapper wrapper = (Wrapper)this.getContainer();
                    sreq.setAttribute("javax.servlet.error.servlet_name", wrapper.getName());
                    if (sreq instanceof HttpServletRequest) {
                        sreq.setAttribute("javax.servlet.error.request_uri", ((HttpServletRequest)sreq).getRequestURI());
                    }
                    if (this.custom(request, response, errorPage)) {
                        return;
                    }
                }
                report = null;
                try {
                    report = sm.getString("http." + statusCode, message);
                }
                catch (Throwable throwable) {}
                if (report == null) {
                    return;
                }
                try {
                    if (hresponse.isError()) {
                        hresponse.reset(statusCode, message);
                    }
                }
                catch (Throwable e10) {
                    if (this.debug < 1) break block21;
                    this.log("status.reset", e10);
                }
            }
            try {
                block22: {
                    try {
                        hres.setContentType("text/html; charset=UTF-8");
                    }
                    catch (Throwable t2) {
                        if (this.debug < 1) break block22;
                        this.log("status.setContentType", t2);
                    }
                }
                PrintWriter writer = response.getReporter();
                if (writer != null) {
                    writer.println("<html>");
                    writer.println("<head>");
                    writer.println("<title>" + sm.getString("standardWrapper.statusTitle") + "</title>");
                    writer.println("</head>");
                    writer.println("<body bgcolor=\"white\">");
                    writer.println("<br><br>");
                    writer.println("<h1>" + sm.getString("standardWrapper.statusHeader", String.valueOf(statusCode), message) + "</h1>");
                    writer.println(report);
                    writer.println("</body>");
                    writer.println("</html>");
                    writer.flush();
                }
            }
            catch (IllegalStateException e11) {
                if (this.debug < 1) break block23;
                this.log("status.write", e11);
            }
        }
    }
}

