/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.connector.http10;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.HttpRequest;
import org.apache.catalina.HttpResponse;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Logger;
import org.apache.catalina.connector.http10.HttpConnector;
import org.apache.catalina.connector.http10.HttpRequestImpl;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

final class HttpProcessor
implements Lifecycle,
Runnable {
    private boolean available = false;
    private HttpConnector connector = null;
    private int debug = 0;
    private int id = 0;
    private LifecycleSupport lifecycle = new LifecycleSupport(this);
    private static final String match = ";jsessionid=";
    private String proxyName = null;
    private int proxyPort = 0;
    private HttpRequest request = null;
    private HttpResponse response = null;
    private int serverPort = 0;
    protected StringManager sm = StringManager.getManager("org.apache.catalina.connector.http10");
    private Socket socket = null;
    private boolean started = false;
    private boolean stopped = false;
    private Thread thread = null;
    private String threadName = null;
    private Object threadSync = new Object();

    public HttpProcessor(HttpConnector connector, int id) {
        this.connector = connector;
        this.debug = connector.getDebug();
        this.id = id;
        this.proxyName = connector.getProxyName();
        this.proxyPort = connector.getProxyPort();
        this.request = (HttpRequest)connector.createRequest();
        this.response = (HttpResponse)connector.createResponse();
        this.serverPort = connector.getPort();
        this.threadName = "HttpProcessor[" + connector.getPort() + "][" + id + "]";
    }

    public void addLifecycleListener(LifecycleListener listener) {
        this.lifecycle.addLifecycleListener(listener);
    }

    synchronized void assign(Socket socket) {
        while (this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.socket = socket;
        this.available = true;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log(" An incoming request is being assigned");
        }
    }

    private synchronized Socket await() {
        while (!this.available) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        Socket socket = this.socket;
        this.available = false;
        this.notifyAll();
        if (this.debug >= 1 && socket != null) {
            this.log("  The incoming request has been awaited");
        }
        return socket;
    }

    private void log(String message) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.threadName) + " " + message);
        }
    }

    private void log(String message, Throwable throwable) {
        Logger logger = this.connector.getContainer().getLogger();
        if (logger != null) {
            logger.log(String.valueOf(this.threadName) + " " + message, throwable);
        }
    }

    private void parseConnection(Socket socket) throws IOException, ServletException {
        if (this.debug >= 2) {
            this.log("  parseConnection: address=" + socket.getInetAddress() + ", port=" + this.connector.getPort());
        }
        ((HttpRequestImpl)this.request).setInet(socket.getInetAddress());
        if (this.proxyPort != 0) {
            this.request.setServerPort(this.proxyPort);
        } else {
            this.request.setServerPort(this.serverPort);
        }
        this.request.setSocket(socket);
    }

    private void parseHeaders(InputStream input) throws IOException, ServletException {
        String line;
        while ((line = this.read(input)) != null && line.length() >= 1) {
            int colon = line.indexOf(":");
            if (colon < 0) {
                throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.colon"));
            }
            String name = line.substring(0, colon).trim();
            String match = name.toLowerCase();
            String value = line.substring(colon + 1).trim();
            if (this.debug >= 1) {
                this.log(" Header " + name + " = " + value);
            }
            if (match.equals("authorization")) {
                this.request.setAuthorization(value);
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("accept-language")) {
                this.request.addHeader(name, value);
                Hashtable<String, Vector<Object>> languages = new Hashtable<String, Vector<Object>>();
                StringTokenizer languageTokenizer = new StringTokenizer(value, ",");
                while (languageTokenizer.hasMoreTokens()) {
                    String language = languageTokenizer.nextToken().trim();
                    int qValueIndex = language.indexOf(59);
                    int qIndex = language.indexOf(113);
                    int equalIndex = language.indexOf(61);
                    Double qValue = new Double(1.0);
                    if (qValueIndex > -1 && qValueIndex < qIndex && qIndex < equalIndex) {
                        String qValueStr = language.substring(qValueIndex + 1);
                        language = language.substring(0, qValueIndex);
                        qValueStr = qValueStr.trim().toLowerCase();
                        qValueIndex = qValueStr.indexOf(61);
                        qValue = new Double(0.0);
                        if (qValueStr.startsWith("q") && qValueIndex > -1) {
                            qValueStr = qValueStr.substring(qValueIndex + 1);
                            try {
                                qValue = new Double(qValueStr.trim());
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    }
                    if (language.equals("*")) continue;
                    String key = qValue.toString();
                    Vector<Object> v2 = languages.containsKey(key) ? languages.get(key) : new Vector();
                    v2.addElement(language);
                    languages.put(key, v2);
                }
                Vector l2 = new Vector();
                Enumeration e10 = languages.keys();
                while (e10.hasMoreElements()) {
                    String key = (String)e10.nextElement();
                    Vector v3 = (Vector)languages.get(key);
                    Enumeration le = v3.elements();
                    while (le.hasMoreElements()) {
                        String language = (String)le.nextElement();
                        String country = "";
                        int countryIndex = language.indexOf("-");
                        if (countryIndex > -1) {
                            country = language.substring(countryIndex + 1).trim();
                            language = language.substring(0, countryIndex).trim();
                        }
                        this.request.addLocale(new Locale(language, country));
                    }
                }
                continue;
            }
            if (match.equals("cookie")) {
                Cookie[] cookies = RequestUtil.parseCookieHeader(value);
                int i2 = 0;
                while (i2 < cookies.length) {
                    if (cookies[i2].getName().equals("JSESSIONID")) {
                        this.request.setRequestedSessionId(cookies[i2].getValue());
                        this.request.setRequestedSessionCookie(true);
                        this.request.setRequestedSessionURL(false);
                        if (this.debug < 1) break;
                        this.log(" Requested cookie session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
                        break;
                    }
                    this.request.addCookie(cookies[i2]);
                    ++i2;
                }
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("content-length")) {
                int n2 = -1;
                try {
                    n2 = Integer.parseInt(value);
                }
                catch (Exception exception) {
                    throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.contentLength"));
                }
                this.request.setContentLength(n2);
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("content-type")) {
                this.request.setContentType(value);
                this.request.addHeader(name, value);
                continue;
            }
            if (match.equals("host")) {
                int n3 = value.indexOf(":");
                if (n3 < 0) {
                    this.request.setServerName(value);
                } else {
                    this.request.setServerName(value.substring(0, n3).trim());
                    int port = 80;
                    try {
                        port = Integer.parseInt(value.substring(n3 + 1).trim());
                    }
                    catch (Exception exception) {
                        throw new ServletException(this.sm.getString("httpProcessor.parseHeaders.portNumber"));
                    }
                    this.request.setServerPort(port);
                }
                this.request.addHeader(name, value);
                continue;
            }
            this.request.addHeader(name, value);
        }
    }

    private void parseRequest(InputStream input) throws IOException, ServletException {
        String line = this.read(input);
        if (line == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.read"));
        }
        StringTokenizer st = new StringTokenizer(line);
        String method = null;
        try {
            method = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            method = null;
        }
        String uri = null;
        try {
            uri = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            uri = null;
        }
        String protocol = null;
        try {
            protocol = st.nextToken();
        }
        catch (NoSuchElementException noSuchElementException) {
            protocol = "HTTP/0.9";
        }
        if (method == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.method"));
        }
        if (uri == null) {
            throw new ServletException(this.sm.getString("httpProcessor.parseRequest.uri"));
        }
        int question = uri.indexOf("?");
        if (question >= 0) {
            this.request.setQueryString(uri.substring(question + 1));
            if (this.debug >= 1) {
                this.log(" Query string is " + ((HttpServletRequest)this.request.getRequest()).getQueryString());
            }
            uri = uri.substring(0, question);
        } else {
            this.request.setQueryString(null);
        }
        int semicolon = uri.indexOf(match);
        if (semicolon >= 0) {
            String rest = uri.substring(semicolon + match.length());
            int semicolon2 = rest.indexOf(";");
            if (semicolon2 >= 0) {
                this.request.setRequestedSessionId(rest.substring(0, semicolon2));
                rest = rest.substring(semicolon2);
            } else {
                this.request.setRequestedSessionId(rest);
                rest = "";
            }
            this.request.setRequestedSessionURL(true);
            uri = String.valueOf(uri.substring(0, semicolon)) + rest;
            if (this.debug >= 1) {
                this.log(" Requested URL session id is " + ((HttpServletRequest)this.request.getRequest()).getRequestedSessionId());
            }
        } else {
            this.request.setRequestedSessionId(null);
            this.request.setRequestedSessionURL(false);
        }
        this.request.setMethod(method);
        this.request.setProtocol(protocol);
        this.request.setRequestURI(uri);
        this.request.setSecure(false);
        this.request.setScheme("http");
        if (this.debug >= 1) {
            this.log(" Request is " + method + " for " + uri);
        }
    }

    private void process(Socket socket) {
        boolean ok = true;
        BufferedInputStream input = null;
        OutputStream output = null;
        try {
            input = new BufferedInputStream(socket.getInputStream(), this.connector.getBufferSize());
            this.request.setStream(input);
            this.request.setResponse(this.response);
            output = socket.getOutputStream();
            this.response.setStream(output);
            this.response.setRequest(this.request);
            ((HttpServletResponse)this.response.getResponse()).setHeader("Server", "Apache Tomcat/4.0-b4-dev (HTTP/1.0 Connector)");
        }
        catch (Exception e10) {
            this.log("process.create", e10);
            ok = false;
        }
        try {
            if (ok) {
                this.parseConnection(socket);
                this.parseRequest(input);
                if (!this.request.getRequest().getProtocol().startsWith("HTTP/0")) {
                    this.parseHeaders(input);
                }
            }
        }
        catch (Exception e11) {
            try {
                this.log("process.parse", e11);
                ((HttpServletResponse)this.response.getResponse()).sendError(400);
            }
            catch (Exception exception) {}
        }
        try {
            if (ok) {
                this.connector.getContainer().invoke(this.request, this.response);
            }
        }
        catch (ServletException e12) {
            this.log("process.invoke", e12);
            try {
                ((HttpServletResponse)this.response.getResponse()).sendError(500);
            }
            catch (Exception exception) {}
            ok = false;
        }
        catch (Throwable e13) {
            this.log("process.invoke", e13);
            try {
                ((HttpServletResponse)this.response.getResponse()).sendError(500);
            }
            catch (Exception exception) {}
            ok = false;
        }
        try {
            if (ok) {
                this.response.finishResponse();
            }
        }
        catch (IOException e14) {
            this.log("FIXME-Exception from finishResponse", e14);
        }
        try {
            if (output != null) {
                output.flush();
            }
        }
        catch (IOException e15) {
            this.log("FIXME-Exception flushing output", e15);
        }
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException e16) {
            this.log("FIXME-Exception closing output", e16);
        }
        try {
            if (ok) {
                this.request.finishRequest();
            }
        }
        catch (IOException e17) {
            this.log("FIXME-Exception from finishRequest", e17);
        }
        try {
            if (input != null) {
                ((InputStream)input).close();
            }
        }
        catch (IOException e18) {
            this.log("FIXME-Exception closing input", e18);
        }
        try {
            socket.close();
        }
        catch (IOException e19) {
            this.log("FIXME-Exception closing socket", e19);
        }
        socket = null;
    }

    private String read(InputStream input) throws IOException {
        StringBuffer sb = new StringBuffer();
        while (true) {
            int ch2;
            if ((ch2 = input.read()) < 0) {
                if (sb.length() != 0) break;
                return null;
            }
            if (ch2 == 13) continue;
            if (ch2 == 10) break;
            sb.append((char)ch2);
        }
        if (this.debug >= 2) {
            this.log("  Read: " + sb.toString());
        }
        return sb.toString();
    }

    public void removeLifecycleListener(LifecycleListener listener) {
        this.lifecycle.removeLifecycleListener(listener);
    }

    public void run() {
        while (!this.stopped) {
            Socket socket = this.await();
            if (socket == null) continue;
            this.process(socket);
            this.request.recycle();
            this.response.recycle();
            this.connector.recycle(this);
        }
        Object object = this.threadSync;
        synchronized (object) {
            this.threadSync.notifyAll();
        }
    }

    public void start() throws LifecycleException {
        if (this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.alreadyStarted"));
        }
        this.lifecycle.fireLifecycleEvent("start", null);
        this.started = true;
        this.threadStart();
    }

    public void stop() throws LifecycleException {
        if (!this.started) {
            throw new LifecycleException(this.sm.getString("httpProcessor.notStarted"));
        }
        this.lifecycle.fireLifecycleEvent("stop", null);
        this.started = false;
        this.threadStop();
    }

    private void threadStart() {
        this.log(this.sm.getString("httpProcessor.starting"));
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
        if (this.debug >= 1) {
            this.log(" Background thread has been started");
        }
    }

    private void threadStop() {
        this.log(this.sm.getString("httpProcessor.stopping"));
        this.stopped = true;
        this.assign(null);
        Object object = this.threadSync;
        synchronized (object) {
            try {
                this.threadSync.wait(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.thread = null;
    }
}

