/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jts.CosTransactions;

import com.sun.jts.CosTransactions.Configuration;
import com.sun.jts.CosTransactions.ErrorLog;
import com.sun.jts.CosTransactions.LogControl;
import com.sun.jts.CosTransactions.LogException;
import com.sun.jts.CosTransactions.LogFile;
import com.sun.jts.CosTransactions.LogHandle;
import com.sun.jts.CosTransactions.LogUpcallTarget;

class Log {
    private LogControl logControl = null;
    private static String logPath = null;

    Log() {
        if (logPath == null) {
            int[] result = new int[1];
            logPath = Configuration.getDirectory("com.sun.jts.logDirectory", "jts", result);
            if (result[0] == 1 || result[0] == 2) {
                if (logPath.length() > 0) {
                    ErrorLog.error(18, new Object[]{logPath}, false);
                }
                if (result[0] == 2) {
                    ErrorLog.error(19, null, false);
                    logPath = ".";
                }
            }
        }
    }

    public void finalize() {
        this.logControl = null;
        logPath = null;
    }

    boolean initialise() {
        boolean result = true;
        this.logControl = new LogControl();
        this.logControl.initLog(false, false, logPath);
        return result;
    }

    LogFile open(String serverName, LogUpcallTarget upcall) {
        LogFile logFile = null;
        boolean[] newLog = new boolean[]{true};
        try {
            LogHandle handle = this.logControl.openFile(serverName, upcall, null, newLog);
            logFile = new LogFile(handle);
        }
        catch (LogException le) {
            ErrorLog.error(23, new Object[]{le.toString()}, true);
        }
        return logFile;
    }

    boolean terminate() {
        boolean result = true;
        return result;
    }

    static boolean checkFileExists(String serverName) {
        boolean exists = false;
        if (serverName != null) {
            exists = LogControl.checkFileExists(serverName, logPath);
        }
        return exists;
    }

    void dump() {
        this.logControl.dump();
    }
}

