/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionConsumerDurableSubscription;
import com.sun.jms.service.ConnectionConsumerImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DurableSubscription;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.service.TopicSubscription;
import com.sun.jms.util.JmsResourceBundle;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class TopicConnectionConsumerImpl
extends ConnectionConsumerImpl {
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.service.LocalStrings");
    private TopicSubscription tSubscription = new TopicSubscription(this);
    private ConnectionConsumerDurableSubscription ccDurableSubscription = null;
    boolean noLocal = false;
    String clientID = null;

    TopicConnectionConsumerImpl(int id, Destination dest, String messageSelector, int maxMessages, String subscriptionName, ConnectionImpl conn) throws JMSException, InvalidSelectorException {
        super(id, dest, messageSelector, maxMessages, subscriptionName, conn);
        this.tSubscription.setSubscriptionName(subscriptionName);
        this.ccDurableSubscription = new ConnectionConsumerDurableSubscription(this, this.tSubscription, this.parentConnection);
        this.parentConnection.addConnectionConsumer(this);
    }

    public void deliveredMessage(MessageImpl msg) {
        boolean durable = this.isDurableSubscriber();
        if (durable) {
            try {
                if (SessionImpl.service.isPersistentMessage(msg)) {
                    this.tSubscription.updateUnackedMessageDeliveryCount(msg);
                }
            }
            catch (JMSException je) {
                ConsumerImpl.logger.warning(je);
            }
        }
    }

    public void acknowledgeMessage(MessageImpl msg) throws SQLException, JMSException {
        boolean durable = this.isDurableSubscriber();
        if (durable && SessionImpl.service.isPersistentMessage(msg)) {
            SessionImpl session = this.parentConnection.getSession(msg.getSessionID());
            if (session != null) {
                this.tSubscription.deleteUnackedMessage(session.dbConnection, msg.getJMSMessageID());
            } else if (ConsumerImpl.logger.isLogging(6)) {
                ConsumerImpl.logger.finer("session reference is null in  TopicConnectionConsumer.acknowledgeMessage for msg: " + msg);
            }
        }
    }

    protected void performClose() throws JMSException {
        super.performClose();
        this.setClientID(this.getClientID());
        this.ccDurableSubscription.deactivate();
    }

    public boolean isDurableSubscriber() {
        boolean isDurable = false;
        if (this.tSubscription.getSubscriptionName() != null) {
            isDurable = true;
        }
        return isDurable;
    }

    public void initializeDurableSubscription() throws JMSException {
        this.ccDurableSubscription.initialize();
    }

    public boolean isActive() {
        boolean active = true;
        if (this.isDurableSubscriber()) {
            active = this.ccDurableSubscription.isActive();
        }
        return active;
    }

    public String getClientID() {
        String clientID = this.clientID;
        if (clientID == null) {
            clientID = super.getClientID();
        }
        return clientID;
    }

    private void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public boolean matches(String clientID, String subscriptionName) {
        boolean match = false;
        if (subscriptionName.equals(this.tSubscription.getSubscriptionName()) && clientID.equals(this.getClientID())) {
            match = true;
        }
        return match;
    }

    public void deleteDurableSubscription() throws JMSException {
        this.ccDurableSubscription.deleteDurableSubscription(this.getClientID(), this.getDestination());
    }

    public void preSendProcessing(MessageImpl msg, Connection con) throws JMSException {
        if (SessionImpl.service.isPersistentMessage(msg) && this.isDurableSubscriber() && !msg.getJMSRedelivered()) {
            boolean storeSucceeded = false;
            try {
                int i2 = 1;
                while (!storeSucceeded && i2 < 11) {
                    block10: {
                        try {
                            this.tSubscription.storeUnackedMessage(con, msg);
                            storeSucceeded = true;
                        }
                        catch (SQLException se) {
                            if (i2 == 10) {
                                throw se;
                            }
                            try {
                                Thread.sleep(1000 * i2);
                            }
                            catch (Throwable t2) {
                                // empty catch block
                            }
                            if (!ConsumerImpl.logger.isLogging(5)) break block10;
                            ConsumerImpl.logger.fine("retry storing unacked entry for msg " + msg);
                        }
                    }
                    ++i2;
                }
            }
            catch (SQLException e10) {
                JMSException jmse = new JMSException(MessageFormat.format(resource.getString("topicconnectionconsumer.exception_in_tcc"), e10.getMessage()));
                jmse.setLinkedException(e10);
                if (ConsumerImpl.logger.isLogging(2)) {
                    ConsumerImpl.logger.warning(MessageFormat.format(resource.getString("topicconnectionconsumer.dropped_message"), msg.toString(), DurableSubscription.getGlobalSubscriptionName(this.getClientID(), this.tSubscription.getSubscriptionName())));
                }
                throw jmse;
            }
        }
    }

    public void sendMessageInternal(MessageImpl msg) throws JMSException {
        this.initResources();
        if (this.isActive()) {
            this.addIncomingMessage(msg);
        }
    }

    public synchronized void sendLoggedMessages() {
        block2: {
            try {
                this.ccDurableSubscription.sendLoggedMessages();
            }
            catch (JMSException e10) {
                if (!ConsumerImpl.logger.isLogging(2)) break block2;
                ConsumerImpl.logger.warning(MessageFormat.format(resource.getString("topicconnectionconsumer.could_not_recover_unacked_messages"), e10.getMessage()));
                ConsumerImpl.logger.warning(e10);
            }
        }
    }

    public void sendLoggedMessage(MessageImpl msg) throws JMSException, IllegalStateException {
        super.sendMessageInternal(msg);
    }

    public boolean getNoLocal() throws IllegalStateException {
        return this.noLocal;
    }
}

