/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.MessageConsumerImpl;
import com.sun.jms.service.QueueSubscription;
import com.sun.jms.service.SessionImpl;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class QueueReceiverImpl
extends MessageConsumerImpl {
    private QueueSubscription qSubscription = null;
    private Object synchronousReceive = new Object();
    private boolean waitingForSynchronousReceive = false;
    private MessageImpl synchronousReceiveMsg = null;

    QueueReceiverImpl(DestinationImpl dest, SessionImpl parent, int id, String selectPattern) throws InvalidSelectorException, JMSException {
        super(dest, parent, id, selectPattern);
        this.qSubscription = new QueueSubscription(this);
    }

    protected void performCloseActions() throws JMSException {
        super.performCloseActions();
        ArrayList messagesToRedeliver = new ArrayList();
        this.getUnAckedMessages(messagesToRedeliver, true);
        if (messagesToRedeliver.size() != 0) {
            this.getDestination().redeliverMessages(messagesToRedeliver);
        }
    }

    public void deliveredMessage(MessageImpl msg) {
        super.deliveredMessage(msg);
        try {
            if (SessionImpl.service.isPersistentMessage(msg)) {
                this.qSubscription.updateUnackedMessageDeliveryCount(msg);
            }
        }
        catch (JMSException je) {
            ConsumerImpl.logger.warning(je);
        }
    }

    public void acknowledgeMessage(MessageImpl msg) throws JMSException, SQLException {
        if (ConsumerImpl.logger.isLogging(7)) {
            ConsumerImpl.logger.finest("Global Txn=" + this.parent.isGlobalTxn());
        }
        if (SessionImpl.service.isPersistentMessage(msg)) {
            this.qSubscription.deleteUnackedMessage(this.parent.getDBConnection(), msg.getJMSMessageID());
        }
    }

    public boolean hasMessageListener() {
        return this.hasMessageListener;
    }

    public boolean setHasMessageListener(boolean hasMsgListener) throws JMSException {
        boolean hadMsgListener = this.hasMessageListener;
        this.hasMessageListener = hasMsgListener;
        if (!hadMsgListener && hasMsgListener) {
            this.getDestination().wakeup();
        }
        return hadMsgListener;
    }

    protected void sendMessageInternal(MessageImpl msg) throws JMSException {
        if (this.hasMessageListener) {
            super.sendMessageInternal(msg);
        }
    }

    MessageImpl receive(long timeout) throws JMSException {
        MessageImpl msg = null;
        MessageImpl sendMsg = null;
        if (!this.isStopped() && this.parent.parentConnection.okToSendMessagesToClient()) {
            msg = this.parent.synchronousReceiveFromOutgoingMessages(this);
            if (msg == null) {
                msg = this.getDestination().receiveNoWait(this);
            }
            if (msg != null) {
                sendMsg = this.cloneForDeliveryToClient(msg);
                return sendMsg;
            }
        }
        if (timeout < 0L) {
            return null;
        }
        Object object = this.synchronousReceive;
        synchronized (object) {
            try {
                this.waitingForSynchronousReceive = true;
                this.synchronousReceiveMsg = null;
                this.getDestination().registerWaitForSynchronousReceive(this);
                try {
                    this.synchronousReceive.wait(timeout);
                }
                catch (InterruptedException ie) {
                }
                Object var8_6 = null;
                this.waitingForSynchronousReceive = false;
                sendMsg = this.synchronousReceiveMsg;
                this.synchronousReceiveMsg = null;
                if (sendMsg == null) {
                    this.getDestination().deregisterWaitForSynchronousReceive(this);
                }
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                this.waitingForSynchronousReceive = false;
                sendMsg = this.synchronousReceiveMsg;
                this.synchronousReceiveMsg = null;
                if (sendMsg == null) {
                    this.getDestination().deregisterWaitForSynchronousReceive(this);
                }
                throw throwable;
            }
        }
        if (sendMsg != null) {
            sendMsg = this.cloneForDeliveryToClient(sendMsg);
            return sendMsg;
        }
        return null;
    }

    public void deliverSynchronousMessage(MessageImpl msg) {
        Object object = this.synchronousReceive;
        synchronized (object) {
            this.synchronousReceiveMsg = msg;
            this.waitingForSynchronousReceive = false;
            this.synchronousReceive.notify();
        }
    }

    public synchronized void close(boolean removeFromParent) throws JMSException {
        Object object = this.synchronousReceive;
        synchronized (object) {
            if (this.waitingForSynchronousReceive) {
                this.deliverSynchronousMessage(null);
            }
        }
        super.close(removeFromParent);
    }

    public boolean awaitingSynchronousReceive() {
        Object object = this.synchronousReceive;
        synchronized (object) {
            boolean bl2 = this.waitingForSynchronousReceive;
            return bl2;
        }
    }

    public String toString() {
        return "QueueReceiver [synchWait=" + this.waitingForSynchronousReceive + "]";
    }

    public boolean presendToClient() {
        return this.hasMessageListener() && !this.isStopped();
    }

    void start() {
        this.dest.wakeup();
    }
}

