/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionConsumerImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.QueueSubscription;
import com.sun.jms.service.SessionImpl;
import java.sql.SQLException;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class QueueConnectionConsumerImpl
extends ConnectionConsumerImpl {
    private QueueSubscription qSubscription = new QueueSubscription(this);

    QueueConnectionConsumerImpl(int id, Destination dest, String messageSelector, int maxMessages, ConnectionImpl conn) throws JMSException, InvalidSelectorException {
        super(id, dest, messageSelector, maxMessages, null, conn);
        conn.addConnectionConsumer(this);
    }

    public void deliveredMessage(MessageImpl msg) {
        try {
            if (SessionImpl.service.isPersistentMessage(msg)) {
                this.qSubscription.updateUnackedMessageDeliveryCount(msg);
            }
        }
        catch (JMSException je) {
            ConsumerImpl.logger.warning(je);
        }
    }

    public void acknowledgeMessage(MessageImpl msg) throws SQLException, JMSException {
        ConsumerImpl.logger.finest("Entering....");
        if (SessionImpl.service.isPersistentMessage(msg)) {
            SessionImpl session = this.parentConnection.getSession(msg.getSessionID());
            if (session != null) {
                this.qSubscription.deleteUnackedMessage(session.dbConnection, msg.getJMSMessageID());
            } else if (ConsumerImpl.logger.isLogging(6)) {
                ConsumerImpl.logger.finer("session reference is null in  QueueConnectionConsumer.acknowledgeMessage for msg: " + msg);
            }
        }
    }
}

