/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.service;

import com.sun.jms.JMSClient;
import com.sun.jms.MessageImpl;
import com.sun.jms.service.ConnectionImpl;
import com.sun.jms.service.ConsumerImpl;
import com.sun.jms.service.DestinationImpl;
import com.sun.jms.service.JMSServiceImpl;
import com.sun.jms.service.SessionImpl;
import com.sun.jms.util.JMSProperties;
import com.sun.jms.util.Waiter;
import com.sun.jms.util.WaiterManager;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import javax.jms.Destination;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;

public class ConnectionConsumerImpl
extends ConsumerImpl {
    private int maxMessages;
    private String subscriptionName;
    ConnectionImpl parentConnection = null;
    private ArrayList incomingMessages = null;
    private ArrayList outgoingMessages = null;
    private Waiter outgoingMessageWaiter;
    private volatile boolean processingOutgoingMessages = false;

    ConnectionConsumerImpl(int id, Destination dest, String messageSelector, int maxMessages, String subscriptionName, ConnectionImpl conn) throws JMSException, InvalidSelectorException {
        super((DestinationImpl)dest, id, messageSelector);
        this.maxMessages = maxMessages;
        this.subscriptionName = subscriptionName;
        this.parentConnection = conn;
    }

    public void close(boolean removeFromParent) throws JMSException {
        if (!this.isDurableSubscriber()) {
            this.getDestination().deregister(this);
        }
        if (removeFromParent && this.parentConnection != null) {
            this.parentConnection.removeConnectionConsumer(this.getId());
        }
        this.performClose();
        if (this.parentConnection != null) {
            this.parentConnection = null;
        }
        if (this.outgoingMessageWaiter != null) {
            this.outgoingMessageWaiter.stopRunning();
        }
    }

    protected void performClose() throws JMSException {
    }

    public void sendMessage(MessageImpl message) throws JMSException {
        if (ConsumerImpl.logger.isLogging(6)) {
            ConsumerImpl.logger.finer("ConnectionConsumer got the Message: " + message.toString());
        }
        this.sendMessageInternal(message);
    }

    public void sendMessageInternal(MessageImpl msg) throws JMSException {
        this.initResources();
        this.addIncomingMessage(msg);
    }

    boolean firstMessage() {
        return this.outgoingMessageWaiter == null;
    }

    void initResources() {
        if (this.firstMessage()) {
            if (ConsumerImpl.logger.isLogging(6)) {
                ConsumerImpl.logger.finer("Intializing outgoing waiter in ConnectionConsumer( " + this.getId() + " )");
            }
            this.incomingMessages = new ArrayList();
            this.outgoingMessages = new ArrayList();
            this.outgoingMessageWaiter = new Waiter(JMSServiceImpl.serviceThreadGroup, new WaiterManager(){

                public void activityDetected() {
                    ConnectionConsumerImpl.this.processOutgoingMessages();
                }
            }, "jms.service ConnectionConsumer.outgoingWaiter.", JMSProperties.getInstance().getWaiterTimeoutInterval());
        }
    }

    void addIncomingMessage(MessageImpl msg) {
        ArrayList arrayList = this.incomingMessages;
        synchronized (arrayList) {
            this.incomingMessages.add(msg);
        }
        if (!this.isStopped() && !this.processingOutgoingMessages) {
            this.outgoingMessageWaiter.wakeup();
        }
    }

    private void processOutgoingMessages() {
        this.processingOutgoingMessages = true;
        try {
            block7: while (true) {
                ArrayList arrayList = this.incomingMessages;
                synchronized (arrayList) {
                    if (this.incomingMessages.isEmpty()) {
                        break;
                    }
                    this.outgoingMessages.addAll(this.incomingMessages);
                    this.incomingMessages.clear();
                }
                int i2 = 0;
                while (i2 < this.outgoingMessages.size()) {
                    MessageImpl m2 = (MessageImpl)this.outgoingMessages.get(i2);
                    m2.setCloseMessageForServerSession(0);
                    this.outgoingMessages.set(i2, m2);
                    ++i2;
                }
                int i3 = this.maxMessages - 1;
                while (i3 < this.outgoingMessages.size()) {
                    MessageImpl msg1 = (MessageImpl)this.outgoingMessages.get(i3);
                    if (ConsumerImpl.logger.isLogging(7)) {
                        ConsumerImpl.logger.finest("Tagging msg " + i3 + ":" + msg1 + " for ServerSession close....");
                    }
                    msg1.setCloseMessageForServerSession(1);
                    this.outgoingMessages.set(i3, msg1);
                    i3 += this.maxMessages;
                }
                MessageImpl msg2 = (MessageImpl)this.outgoingMessages.get(this.outgoingMessages.size() - 1);
                if (ConsumerImpl.logger.isLogging(7)) {
                    ConsumerImpl.logger.finest("Tagging msg " + (this.outgoingMessages.size() - 1) + ":" + msg2 + " for ServerSession close....");
                }
                msg2.setCloseMessageForServerSession(1);
                this.outgoingMessages.set(this.outgoingMessages.size() - 1, msg2);
                Iterator msgIter = ((AbstractList)this.outgoingMessages).iterator();
                block10: while (true) {
                    if (!msgIter.hasNext()) continue block7;
                    try {
                        SessionImpl session = this.getSession();
                        int i4 = 0;
                        while (true) {
                            if (i4 >= this.maxMessages) continue block10;
                            if (!msgIter.hasNext()) continue block10;
                            MessageImpl msg = (MessageImpl)msgIter.next();
                            msg.setSessionID(session.getId());
                            MessageImpl newMsg = this.cloneForDeliveryToClient(session, msg);
                            session.sendMessage(newMsg);
                            msgIter.remove();
                            ++i4;
                        }
                    }
                    catch (Exception e10) {
                        ConsumerImpl.logger.warning(e10);
                    }
                }
                break;
            }
            Object var11_13 = null;
            this.processingOutgoingMessages = false;
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.processingOutgoingMessages = false;
            throw throwable;
        }
    }

    public boolean isConnectionConsumer() {
        return true;
    }

    public boolean presendToClient() {
        return true;
    }

    public boolean awaitingSynchronousReceive() {
        return false;
    }

    public void deliverSynchronousMessage(MessageImpl msg) {
    }

    public SessionImpl getSession() {
        SessionImpl session = null;
        try {
            JMSClient client = this.parentConnection.getJMSClient();
            int sessionID = client.getSessionForConnectionConsumer(this.parentConnection.getId(), this.getId());
            session = this.parentConnection.getSession(sessionID);
            session.prepareForConnectionConsumerUse();
        }
        catch (Exception e10) {
            ConsumerImpl.logger.warning(e10);
        }
        return session;
    }

    public String getClientID() {
        return this.parentConnection == null ? "" : this.parentConnection.getClientID();
    }

    public MessageImpl cloneForDeliveryToClient(MessageImpl msg) throws JMSException {
        throw new JMSException("this method is only used by MessageConsumers - use cloneForDeliveryToClient( SessionImpl, MessageImpl )");
    }

    public ConnectionImpl getConnection() {
        return this.parentConnection;
    }

    public boolean isStopped() {
        return this.parentConnection == null || this.parentConnection.isStopped();
    }

    public void start() {
        if (!this.processingOutgoingMessages && this.incomingMessages != null) {
            this.outgoingMessageWaiter.wakeup();
        }
    }
}

