/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jms.client;

import com.sun.jms.JMSService;
import com.sun.jms.client.QueueSessionImpl;
import com.sun.jms.util.JmsResourceBundle;
import com.sun.jms.util.Log;
import com.sun.jms.util.Logger;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.InvalidDestinationException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;

public class QueueBrowserImpl
implements QueueBrowser,
Enumeration {
    Queue queue;
    String queueName = null;
    String selector;
    String[] id = null;
    int nextIndex = 0;
    Message currentMessage = null;
    JMSService service = null;
    QueueSessionImpl queueSession;
    static Logger logger = Log.getLogger(2);
    static JmsResourceBundle resource = JmsResourceBundle.getBundle("com.sun.jms.client.LocalStrings");

    QueueBrowserImpl(Queue queue, String selector, QueueSessionImpl queueSession) throws InvalidDestinationException, InvalidSelectorException, JMSException {
        if (queue == null) {
            throw new InvalidDestinationException(resource.getString("queuebrowserimpl.queue_is_null"));
        }
        this.queue = queue;
        this.selector = selector == null ? "" : selector;
        this.queueSession = queueSession;
        this.service = queueSession.getJMSService();
        this.queueName = queue.getQueueName();
        QueueReceiver receiver = this.queueSession.createReceiver(this.queue, this.selector);
        receiver.close();
    }

    public Enumeration getEnumeration() throws JMSException {
        this.currentMessage = null;
        this.nextIndex = 0;
        try {
            this.id = this.service.getMessageIds(this.queueName, this.selector);
        }
        catch (Exception re) {
            if (re instanceof JMSException) {
                throw (JMSException)re;
            }
            if (logger.isLogging(2)) {
                logger.warning(MessageFormat.format(resource.getString("queuebrowserimpl.getenumeration_failed"), re.getMessage()));
                logger.warning(re);
            }
            this.id = null;
        }
        return this;
    }

    public String getMessageSelector() throws JMSException {
        return this.selector;
    }

    public Queue getQueue() throws JMSException {
        return this.queue;
    }

    /*
     * Unable to fully structure code
     */
    public boolean hasMoreElements() {
        if (this.id == null) {
            return false;
        }
        if (this.currentMessage == null) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            try {
                this.currentMessage = this.service.getMessage(this.id[this.nextIndex]);
                return true;
            }
            catch (Exception e) {
                this.currentMessage = null;
                ++this.nextIndex;
            }
lbl11:
            // 2 sources

            ** while (this.nextIndex < this.id.length)
        }
lbl12:
        // 1 sources

        this.currentMessage = null;
        return false;
    }

    public Object nextElement() throws NoSuchElementException {
        if (this.currentMessage == null) {
            this.hasMoreElements();
        }
        if (this.currentMessage == null) {
            throw new NoSuchElementException(this.id == null || this.id.length == 0 ? resource.getString("queuebrowserimpl.queue_was_empty") : resource.getString("queuebrowserimpl.enumeration_complete"));
        }
        Message returnMsg = this.currentMessage;
        this.currentMessage = null;
        ++this.nextIndex;
        return returnMsg;
    }

    public void close() throws JMSException {
        this.service = null;
        this.currentMessage = null;
        this.id = null;
        this.queue = null;
        this.selector = null;
        this.nextIndex = 0;
    }

    public String toString() {
        String name;
        try {
            name = this.queue.getQueueName();
        }
        catch (JMSException e10) {
            name = "UNKNOWN";
        }
        return "com.sun.jms.QueueBrowser: queue name=" + name + ", messages remaining in enumeration=" + (this.id.length - this.nextIndex);
    }
}

