/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.tools.verifier.CheckMgr;
import com.sun.enterprise.tools.verifier.VerifierEventsListener;
import java.io.File;
import java.io.IOException;
import java.util.EventObject;
import java.util.Vector;
import org.apache.catalina.loader.StandardClassLoader;

public class WebTestsUtil
implements VerifierEventsListener {
    protected final String listenerClassPath = "WEB-INF/classes";
    protected final String libraryClassPath = "WEB-INF/lib";
    private final String separator = System.getProperty("file.separator");
    private static File warFile = new File(System.getProperty("java.io.tmpdir"), "listenertmp");
    private static WebTestsUtil util = null;
    private static ClassLoader cl = null;

    public static WebTestsUtil getUtil() {
        if (util == null) {
            util = new WebTestsUtil();
            CheckMgr.addVerifierEventsListener(util);
        }
        return util;
    }

    public File extractJarFile(File warFilePath) throws IOException {
        if (!warFile.exists()) {
            Archivist.extractJarFile(warFilePath, warFile);
        }
        return warFile;
    }

    private void deleteDirectory(String oneDir) {
        File cleanDir = new File(oneDir);
        if (!cleanDir.exists()) {
            return;
        }
        File[] listOfFiles = cleanDir.listFiles();
        if (listOfFiles != null) {
            int countFiles = 0;
            while (countFiles < listOfFiles.length) {
                if (listOfFiles[countFiles].isFile()) {
                    listOfFiles[countFiles].delete();
                } else {
                    String nextCleanDir = cleanDir + this.separator + listOfFiles[countFiles].getName();
                    File newCleanDir = new File(nextCleanDir);
                    this.deleteDirectory(newCleanDir.getAbsolutePath());
                }
                ++countFiles;
            }
        }
        cleanDir.delete();
    }

    public void testFinished(EventObject e10) {
    }

    public void allTestsFinished(EventObject e10) {
        if (warFile.exists()) {
            this.deleteDirectory(warFile.getAbsolutePath());
        }
        warFile = null;
        util = null;
        cl = null;
        CheckMgr.removeVerifierEventsListener(this);
    }

    private ClassLoader getClassLoader() {
        int i2;
        if (cl != null) {
            return cl;
        }
        File warclasses = new File(warFile, "WEB-INF/classes");
        File libraries = new File(warFile, "WEB-INF/lib");
        Vector<File> v2 = new Vector<File>();
        if (libraries.exists()) {
            File[] libs = libraries.listFiles();
            i2 = 0;
            while (i2 < libs.length) {
                if (libs[i2].getName().endsWith(".jar")) {
                    v2.add(libs[i2]);
                }
                ++i2;
            }
        }
        String[] repositories = new String[v2.size() + 1];
        repositories[v2.size()] = warclasses.getAbsolutePath();
        i2 = 0;
        while (i2 < v2.size()) {
            repositories[i2] = ((File)v2.elementAt(i2)).getAbsolutePath();
            ++i2;
        }
        return new StandardClassLoader(repositories);
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        if (warFile == null || !warFile.exists()) {
            throw new ClassNotFoundException();
        }
        return this.getClassLoader().loadClass(className);
    }
}

