/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.session.createmethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;

public class HomeInterfaceCreateMethodExceptionMatch
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbSessionDescriptor) {
            boolean oneFailed = false;
            if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), (EjbSessionDescriptor)descriptor);
            }
            if (oneFailed) {
                this.result.setStatus(1);
            } else {
                this.result.setStatus(0);
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Session", "Entity"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbSessionDescriptor descriptor) {
        boolean oneFailed = false;
        int ejbCreateMethodLoopCounter = 0;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] methods = c10.getDeclaredMethods();
            boolean ejbCreateFound = false;
            boolean exceptionsMatch = false;
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2].getName().equals("create")) {
                    ejbCreateFound = false;
                    exceptionsMatch = false;
                    Class<?> EJBClass = jcl.loadClass(descriptor.getEjbClassName());
                    do {
                        Method[] ejbCreateMethods = EJBClass.getDeclaredMethods();
                        int z2 = 0;
                        while (z2 < ejbCreateMethods.length) {
                            Object[] ejbCreateMethodParameterTypes;
                            Object[] methodParameterTypes;
                            if (ejbCreateMethods[z2].getName().equals("ejbCreate") && Arrays.equals(methodParameterTypes = methods[i2].getParameterTypes(), ejbCreateMethodParameterTypes = ejbCreateMethods[z2].getParameterTypes())) {
                                ejbCreateFound = true;
                                Class[] methodExceptionTypes = methods[i2].getExceptionTypes();
                                Class[] ejbCreateMethodExceptionTypes = ejbCreateMethods[z2].getExceptionTypes();
                                if (RmiIIOPUtils.isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(ejbCreateMethodExceptionTypes, methodExceptionTypes)) {
                                    exceptionsMatch = true;
                                    ejbCreateMethodLoopCounter = z2;
                                    break;
                                }
                            }
                            ++z2;
                        }
                        if (!ejbCreateFound || !exceptionsMatch) continue;
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The corresponding [ {0} ] method with matching exceptions was found.", new Object[]{ejbCreateMethods[ejbCreateMethodLoopCounter].getName()}));
                        this.result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    } while ((EJBClass = EJBClass.getSuperclass()) != null && (!ejbCreateFound || !exceptionsMatch));
                    if (ejbCreateFound && !exceptionsMatch) {
                        oneFailed = true;
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A corresponding [ {0} ] method was found, but the exceptions defined by method [ {1} ] are not defined within matching create() method.", new Object[]{"ejb" + methods[i2].getName().toUpperCase().substring(0, 1) + methods[i2].getName().substring(1), "ejb" + methods[i2].getName().toUpperCase().substring(0, 1) + methods[i2].getName().substring(1)}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    } else if (!ejbCreateFound) {
                        oneFailed = true;
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed1", "Error: No corresponding ejbCreate method was found."));
                        this.result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                    }
                }
                ++i2;
            }
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{home, descriptor.getEjbClassName(), descriptor.getName()}));
            return oneFailed;
        }
    }
}

