/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.intf;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;
import java.util.Arrays;

public abstract class InterfaceMethodTest
extends EjbTest {
    static String[] EJBObjectMethods = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical", "remove"};

    protected abstract String getInterfaceName(EjbDescriptor var1);

    protected abstract String getInterfaceType();

    protected abstract boolean runIndividualMethodTest(EjbDescriptor var1, Method var2, Result var3);

    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (!(descriptor instanceof EjbSessionDescriptor) && !(descriptor instanceof EjbEntityDescriptor)) {
            result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.homeintf.HomeMethodTest.notApplicable1", "Test apply only to session or entity beans."));
            return result;
        }
        if (this.getInterfaceName(descriptor) == null || "".equals(this.getInterfaceName(descriptor))) {
            return result;
        }
        try {
            Arrays.sort(EJBObjectMethods);
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> interfaceClass = jcl.loadClass(this.getClassName(descriptor));
            if (this.studyInterface(descriptor, interfaceClass, result)) {
                result.setStatus(0);
            } else {
                result.setStatus(1);
            }
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: " + this.getInterfaceType() + "interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{this.getClassName(descriptor), descriptor.getName()}));
        }
        return result;
    }

    private boolean studyInterface(EjbDescriptor descriptor, Class clazz, Result result) {
        boolean allGood = true;
        Method[] interfaceMethods = clazz.getDeclaredMethods();
        int i2 = 0;
        while (i2 < interfaceMethods.length) {
            if (Arrays.binarySearch(EJBObjectMethods, interfaceMethods[i2].getName()) < 0 && !this.runIndividualMethodTest(descriptor, interfaceMethods[i2], result)) {
                allGood = false;
            }
            ++i2;
        }
        Class<?>[] interfaces = clazz.getInterfaces();
        int i3 = 0;
        while (i3 < interfaces.length) {
            if (!this.studyInterface(descriptor, interfaces[i3], result)) {
                allGood = false;
            }
            ++i3;
        }
        return allGood;
    }

    private String getClassName(EjbDescriptor descriptor) {
        return this.getInterfaceName(descriptor);
    }
}

