/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.primarykeyclass;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class PrimaryKeyClassOpt
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        boolean oneFailed = false;
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistence)) {
                String primkey = ((EjbEntityDescriptor)descriptor).getPrimaryKeyClassName();
                if (primkey.equals("java.lang.Object")) {
                    if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName())) {
                        oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor);
                    }
                    if (!oneFailed && descriptor.getLocalHomeClassName() != null && !"".equals(descriptor.getLocalHomeClassName())) {
                        oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor);
                    }
                } else {
                    this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Primary Key Class is [ {0} ]", new Object[]{primkey}));
                }
                return this.result;
            }
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Entity Bean with [ {0} ] managed persistence, primkey mandatory.", new Object[]{persistence}));
                return this.result;
            }
            this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable3", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistence}));
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, EjbDescriptor descriptor) {
        boolean oneFailed = false;
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(home);
            Method[] ejbFinderMethods = c10.getDeclaredMethods();
            boolean paramValid = false;
            int j2 = 0;
            while (j2 < ejbFinderMethods.length) {
                if (ejbFinderMethods[j2].getName().equals("findByPrimaryKey")) {
                    Class<?>[] ejbFinderMethodParameterTypes = ejbFinderMethods[j2].getParameterTypes();
                    int k2 = 0;
                    while (k2 < ejbFinderMethodParameterTypes.length) {
                        if (ejbFinderMethodParameterTypes[k2].getName().equals("java.lang.Object")) {
                            paramValid = true;
                            break;
                        }
                        ++k2;
                    }
                }
                ++j2;
            }
            if (paramValid) {
                this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "findByPrimaryKey method properly defines method parameter [ {0} ]", new Object[]{"java.lang.Object"}));
            } else {
                this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: findByPrimaryKey method does not properly define method parameter [ {0} ]", new Object[]{"java.lang.Object"}));
            }
            return oneFailed;
        }
        catch (Exception e10) {
            Verifier.debug(e10);
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Loading Home interface class [ {0} ]", new Object[]{home}));
            return oneFailed;
        }
    }
}

