/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.findermethod;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Method;

public class HomeInterfaceFindMethodExceptionRemote
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistence = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistence)) {
                boolean oneFailed = false;
                if (descriptor.getHomeClassName() == null || "".equals(descriptor.getHomeClassName())) {
                    result.addNaDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".NotApplicable", "No Remote Interface for this Ejb", new Object[0]));
                    return result;
                }
                try {
                    Context context = this.getVerifierContext();
                    JarClassLoader jcl = context.getClassLoader();
                    Class<?> c10 = jcl.loadClass(descriptor.getHomeClassName());
                    Method[] methods = c10.getDeclaredMethods();
                    boolean throwsRemoteException = false;
                    int i2 = 0;
                    while (i2 < methods.length) {
                        throwsRemoteException = false;
                        if (methods[i2].getName().startsWith("find")) {
                            Class[] methodExceptionTypes = methods[i2].getExceptionTypes();
                            if (EjbUtils.isValidRemoteException(methodExceptionTypes)) {
                                throwsRemoteException = true;
                                break;
                            }
                            if (throwsRemoteException) {
                                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "The find<METHOD> method which must throw java.rmi.RemoteException was found."));
                                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                            } else if (!throwsRemoteException) {
                                oneFailed = true;
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "For Home Interface [ {0} ] Method [ {1} ]", new Object[]{c10.getName(), methods[i2].getName()}));
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: A find<METHOD> method was found, but did not throw java.rmi.RemoteException."));
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug2", "=============================="));
                            }
                        }
                        ++i2;
                    }
                }
                catch (ClassNotFoundException e10) {
                    Verifier.debug(e10);
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: Home interface [ {0} ] does not exist or is not loadable within bean [ {1} ]", new Object[]{descriptor.getHomeClassName(), descriptor.getName()}));
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
                return result;
            }
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Expected [ {0} ] managed persistence, but [ {1} ] bean has [ {2} ] managed persistence.", new Object[]{EjbEntityDescriptor.BEAN_PERSISTENCE, descriptor.getName(), persistence}));
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

