/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class CmpFields
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
            if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                if ("2.0".compareTo(((EjbCMPEntityDescriptor)descriptor).getCMPVersion()) < 0) {
                    result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable3", "Test do not apply to this cmp-version of container managed persistence EJBs"));
                    return result;
                }
                Context context = this.getVerifierContext();
                JarClassLoader jcl = context.getClassLoader();
                Set persistentFields = ((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor().getCMPFields();
                Iterator iterator = persistentFields.iterator();
                boolean oneFailed = false;
                while (iterator.hasNext()) {
                    Descriptor persistentField = (Descriptor)iterator.next();
                    boolean foundField = false;
                    try {
                        Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                        do {
                            try {
                                Field f2 = c10.getDeclaredField(persistentField.getName());
                                foundField = true;
                                Class<?> persistentFieldClassType = f2.getType();
                                if (descriptor.getHomeClassName() != null && !"".equals(descriptor.getHomeClassName()) && descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) {
                                    if (RmiIIOPUtils.isPersistentFieldTypeValid(persistentFieldClassType, descriptor.getHomeClassName(), descriptor.getRemoteClassName())) {
                                        result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid type assigned to container managed field [ {0} ] found in bean [ {1} ]", new Object[]{persistentField.getName(), c10.getName()}));
                                    } else {
                                        oneFailed = true;
                                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Invalid type assigned to container managed field [ {0} ] found in bean [ {1} ]", new Object[]{persistentField.getName(), c10.getName()}));
                                    }
                                }
                                if (descriptor.getLocalHomeClassName() == null || "".equals(descriptor.getLocalHomeClassName()) || descriptor.getLocalClassName() == null || "".equals(descriptor.getLocalClassName())) continue;
                                if (RmiIIOPUtils.isPersistentFieldTypeValid(persistentFieldClassType, descriptor.getLocalHomeClassName(), descriptor.getLocalClassName())) {
                                    result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid type assigned to container managed field [ {0} ] found in bean [ {1} ]", new Object[]{persistentField.getName(), c10.getName()}));
                                    continue;
                                }
                                oneFailed = true;
                                result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Invalid type assigned to container managed field [ {0} ] found in bean [ {1} ]", new Object[]{persistentField.getName(), c10.getName()}));
                            }
                            catch (NoSuchFieldException e10) {
                                foundField = false;
                            }
                        } while ((c10 = c10.getSuperclass()) != null && !foundField);
                        if (foundField) continue;
                        if (!oneFailed) {
                            oneFailed = true;
                        }
                        result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: field [ {0} ] not found in class [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                    }
                    catch (ClassNotFoundException e11) {
                        Verifier.debug(e11);
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException", "Error: [ {0} ] class not found.", new Object[]{descriptor.getEjbClassName()}));
                    }
                }
                if (oneFailed) {
                    result.setStatus(1);
                } else {
                    result.setStatus(0);
                }
            } else {
                result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Expected persistence type [ {0} ], but [ {1} ] bean has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistentType}));
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

