/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Set;

public class PersistenceFieldsElement
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
            block14: {
                String persistentType = ((EjbEntityDescriptor)descriptor).getPersistenceType();
                if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                    if ("2.0".compareTo(((EjbCMPEntityDescriptor)descriptor).getCMPVersion()) < 0) {
                        result.notApplicable(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable3", "Test do not apply to this cmp-version of container managed persistence EJBs"));
                        return result;
                    }
                    if (this.debug) {
                        System.out.println(VerifierTest.smh.getLocalString(this.getClass().getName() + ".debug1", "[ {0} ] is valid persistentType.", new Object[]{persistentType}));
                    }
                    Set persistentFields = ((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor().getCMPFields();
                    Iterator iterator = persistentFields.iterator();
                    try {
                        Context context = this.getVerifierContext();
                        JarClassLoader jcl = context.getClassLoader();
                        Class<?> c10 = jcl.loadClass(descriptor.getEjbClassName());
                        boolean oneFailed = false;
                        while (iterator.hasNext()) {
                            Descriptor persistentField = (Descriptor)iterator.next();
                            try {
                                Field field = c10.getField(persistentField.getName());
                                result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "[ {0} ] field found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                            }
                            catch (NoSuchFieldException e10) {
                                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException1", "Error: NoSuchFieldException: [ {0} ] not found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                if (oneFailed) continue;
                                oneFailed = true;
                            }
                            catch (SecurityException e11) {
                                result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException2", "Error: SecurityException: [ {0} ] not found in [ {1} ]", new Object[]{persistentField.getName(), descriptor.getEjbClassName()}));
                                if (oneFailed) continue;
                                oneFailed = true;
                            }
                        }
                        if (oneFailed) {
                            result.setStatus(1);
                            break block14;
                        }
                        result.setStatus(0);
                    }
                    catch (ClassNotFoundException e12) {
                        Verifier.debug(e12);
                        result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failedException3", "Error: Fields don't exist or are not loadable within bean [ {0} ]", new Object[]{descriptor.getName()}));
                    }
                } else if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType)) {
                    result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "Expected persistence type [ {0} ], but [ {1} ] bean has persistence type [ {2} ]", new Object[]{EjbEntityDescriptor.CONTAINER_PERSISTENCE, descriptor.getName(), persistentType}));
                } else {
                    result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] is not valid persistentType within bean [ {1} ]", new Object[]{persistentType, descriptor.getName()}));
                }
            }
            return result;
        }
        result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] expected {1} bean, but called with {2} bean.", new Object[]{this.getClass(), "Entity", "Session"}));
        return result;
    }
}

