/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.Iterator;
import java.util.Map;

public class MethodPermissionSecurityRoleExists
extends EjbTest
implements EjbCheck {
    public Result check(EjbDescriptor descriptor) {
        Result result = this.getInitializedResult();
        Map permissionedMethods = descriptor.getPermissionedMethodsByPermission();
        boolean oneFailed = false;
        if (permissionedMethods.size() > 0) {
            Iterator e10 = permissionedMethods.keySet().iterator();
            while (e10.hasNext()) {
                MethodPermission nextPermission = (MethodPermission)e10.next();
                if (!nextPermission.isRoleBased()) continue;
                if (!descriptor.getEjbBundleDescriptor().getRoles().contains(nextPermission.getRole())) {
                    oneFailed = true;
                    result.addErrorDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: Method permissions role [ {0} ] must be one of the roles defined in bean [ {1} ]", new Object[]{nextPermission.getRole().getName(), descriptor.getName()}));
                    continue;
                }
                result.addGoodDetails(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed", "Valid: Method permissions role [ {0} ] is defined as one of the roles defined in bean [ {1} ]", new Object[]{nextPermission.getRole().getName(), descriptor.getName()}));
            }
            if (oneFailed) {
                result.setStatus(1);
            } else {
                result.setStatus(0);
            }
        } else {
            result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "There are no <method-permission> elements within this bean [ {0} ]", new Object[]{descriptor.getName()}));
        }
        return result;
    }
}

