/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.elements;

import com.sun.enterprise.deployment.EjbAbstractDescriptor;
import com.sun.enterprise.deployment.EjbBundleArchivist;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import com.sun.enterprise.util.JarClassLoader;
import java.util.Iterator;
import java.util.Set;

public class EjbReferencesElement
extends EjbTest
implements EjbCheck {
    Result result = null;

    public Result check(EjbDescriptor descriptor) {
        this.result = this.getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor || descriptor instanceof EjbSessionDescriptor) {
            Set references = descriptor.getEjbReferenceDescriptors();
            if (references == null) {
                System.out.println("references is null");
                return this.result;
            }
            Iterator iterator = references.iterator();
            if (iterator.hasNext()) {
                boolean oneFailed = false;
                boolean foundBeanClassName = false;
                boolean foundHomeClassName = false;
                boolean foundRemoteClassName = false;
                while (iterator.hasNext()) {
                    EjbReferenceDescriptor ejbReference = (EjbReferenceDescriptor)iterator.next();
                    EjbAbstractDescriptor ejbDescriptor = ejbReference.getEjbDescriptor();
                    if (ejbDescriptor instanceof EjbDescriptor) {
                        if (descriptor.getHomeClassName() != null && descriptor.getRemoteClassName() != null) {
                            oneFailed = this.commonToBothInterfaces(descriptor.getHomeClassName(), descriptor.getRemoteClassName(), ejbReference, descriptor);
                        }
                        if (oneFailed || descriptor.getLocalHomeClassName() == null || descriptor.getLocalClassName() == null) continue;
                        oneFailed = this.commonToBothInterfaces(descriptor.getLocalHomeClassName(), descriptor.getLocalClassName(), ejbReference, descriptor);
                        continue;
                    }
                    this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable2", "Not Applicable: [ {0} ] must be external reference to bean outside of [ {1} ].", new Object[]{ejbReference.getName(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
                }
                if (oneFailed) {
                    this.result.setStatus(1);
                } else {
                    this.result.setStatus(0);
                }
            } else {
                this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable1", "There are no ejb references to other beans within this bean [ {0} ]", new Object[]{descriptor.getName()}));
            }
            return this.result;
        }
        this.result.notApplicable(VerifierTest.smh.getLocalString(this.getClass().getName() + ".notApplicable", "[ {0} ] not called \n with a Session or Entity bean.", new Object[]{this.getClass()}));
        return this.result;
    }

    private boolean commonToBothInterfaces(String home, String remote, EjbReferenceDescriptor ejbReference, EjbDescriptor descriptor) {
        boolean foundBeanClassName = false;
        boolean foundHomeClassName = false;
        boolean foundRemoteClassName = false;
        boolean oneFailed = false;
        EjbAbstractDescriptor ejbDescriptor = ejbReference.getEjbDescriptor();
        try {
            Context context = this.getVerifierContext();
            JarClassLoader jcl = context.getClassLoader();
            Class<?> c10 = jcl.loadClass(((EjbDescriptor)ejbDescriptor).getEjbClassName());
            foundBeanClassName = true;
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed1", "The referenced bean [ {0} ] exists and is loadable within [ {1} ].", new Object[]{((EjbDescriptor)ejbDescriptor).getEjbClassName(), Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            c10 = jcl.loadClass(home);
            foundHomeClassName = true;
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed2", "The referenced bean's home interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{home, Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            c10 = jcl.loadClass(remote);
            foundRemoteClassName = true;
            this.result.passed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".passed3", "The referenced bean's remote interface [ {0} ] exists and is loadable within [ {1} ].", new Object[]{remote, Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            return oneFailed;
        }
        catch (ClassNotFoundException e10) {
            Verifier.debug(e10);
            if (!oneFailed) {
                oneFailed = true;
            }
            String classStr = "";
            if (!foundBeanClassName) {
                classStr = ((EjbDescriptor)ejbDescriptor).getEjbClassName();
            } else if (!foundHomeClassName) {
                classStr = home;
            } else if (!foundRemoteClassName) {
                classStr = remote;
            }
            this.result.failed(VerifierTest.smh.getLocalString(this.getClass().getName() + ".failed", "Error: [ {0} ] class [ {1} ] cannot be found within this jar [ {2} ].", new Object[]{ejbReference.getName(), classStr, Verifier.getJarFile(((EjbBundleArchivist)descriptor.getEjbBundleDescriptor().getArchivist()).getEjbJarFile().getName()).getName()}));
            return oneFailed;
        }
    }
}

