/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class RmiIIOPUtils {
    public static boolean isValidRmiIIOPInterface(Class RMIIIOPinterface) {
        boolean validInterface = false;
        Class c10 = RMIIIOPinterface;
        block2: do {
            if (RMIIIOPinterface.getName().equals("java.rmi.Remote")) {
                validInterface = true;
                break;
            }
            Class<?>[] interfaces = RMIIIOPinterface.getInterfaces();
            int i2 = 0;
            while (i2 < interfaces.length) {
                if (interfaces[i2].getName().equals("java.rmi.Remote") || interfaces[i2].getName().equals("javax.ejb.EJBObject") || interfaces[i2].getName().equals("javax.ejb.EJBHome")) {
                    validInterface = true;
                    continue block2;
                }
                ++i2;
            }
        } while ((RMIIIOPinterface = RMIIIOPinterface.getSuperclass()) != null && !validInterface);
        if (!validInterface) {
            return false;
        }
        try {
            Method[] methods = c10.getDeclaredMethods();
            int i3 = 0;
            while (i3 < methods.length) {
                Class[] methodExceptionTypes = methods[i3].getExceptionTypes();
                if (!EjbUtils.isValidRemoteException(methodExceptionTypes)) {
                    return false;
                }
                ++i3;
            }
            int i4 = 0;
            while (i4 < methods.length) {
                Class[] methodExceptionTypes = methods[i4].getExceptionTypes();
                if (!RmiIIOPUtils.isValidRmiIIOPException(methodExceptionTypes)) {
                    return false;
                }
                ++i4;
            }
            Field[] fields = c10.getFields();
            int i5 = 0;
            while (i5 < fields.length) {
                if (!RmiIIOPUtils.isValidRmiIIOPField(fields[i5])) {
                    return false;
                }
                ++i5;
            }
        }
        catch (Throwable t2) {
            Verifier.debug(t2);
            return false;
        }
        return validInterface;
    }

    public static boolean isValidRmiIIOPParameters(Class[] RMIIIOPparams) {
        if (RMIIIOPparams.length > 0) {
            int ii = 0;
            while (ii < RMIIIOPparams.length) {
                Class c10 = RMIIIOPparams[ii];
                if (!(RmiIIOPUtils.isValidRmiIDLPrimitiveType(c10) || RmiIIOPUtils.isValidRmiIIOPValueType(c10) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(c10) || RmiIIOPUtils.isJavaLangStringType(c10))) {
                    return false;
                }
                ++ii;
            }
            return true;
        }
        return true;
    }

    public static boolean isValidRmiIIOPValueType(Class RMIIIOPvaluetype) {
        int i2;
        Class<?>[] interfaces;
        Class c10 = RMIIIOPvaluetype;
        boolean validInterface = false;
        boolean badOne = false;
        block0: do {
            interfaces = c10.getInterfaces();
            i2 = 0;
            while (i2 < interfaces.length) {
                if (interfaces[i2].getName().equals("java.io.Serializable")) {
                    validInterface = true;
                    continue block0;
                }
                Class<?> superClass = interfaces[i2];
                do {
                    if (!superClass.getName().equals("java.io.Serializable")) continue;
                    validInterface = true;
                    break;
                } while ((superClass = superClass.getSuperclass()) != null && !validInterface);
                ++i2;
            }
        } while ((c10 = c10.getSuperclass()) != null && !validInterface);
        if (!validInterface) {
            return false;
        }
        c10 = RMIIIOPvaluetype;
        block3: do {
            interfaces = c10.getInterfaces();
            i2 = 0;
            while (i2 < interfaces.length) {
                if (interfaces[i2].getName().equals("java.rmi.Remote")) {
                    badOne = true;
                    continue block3;
                }
                ++i2;
            }
        } while ((c10 = c10.getSuperclass()) != null && !badOne);
        if (badOne) {
            return false;
        }
        return validInterface;
    }

    public static boolean isValidRmiIIOPField(Field RMIIIOPField) {
        boolean validPrimitiveType = false;
        if (RmiIIOPUtils.isValidRmiIDLPrimitiveType(RMIIIOPField) || RMIIIOPField.getType().equals("java.lang.String")) {
            validPrimitiveType = true;
        }
        return validPrimitiveType;
    }

    public static boolean isValidRmiIDLPrimitiveType(Field RMIIIOPField) {
        boolean validPrimitiveType = false;
        if (RMIIIOPField.getType().getName().equals("void") || RMIIIOPField.getType().getName().equals("boolean") || RMIIIOPField.getType().getName().equals("byte") || RMIIIOPField.getType().getName().equals("char") || RMIIIOPField.getType().getName().equals("short") || RMIIIOPField.getType().getName().equals("int") || RMIIIOPField.getType().getName().equals("long") || RMIIIOPField.getType().getName().equals("float") || RMIIIOPField.getType().getName().equals("double")) {
            validPrimitiveType = true;
        }
        return validPrimitiveType;
    }

    private static boolean isValidRmiIIOPInterfaceType(Class interfaceClass) {
        return interfaceClass.isInterface();
    }

    public static boolean isValidRmiIDLPrimitiveType(Class primitiveClass) {
        boolean validPrimitiveType = false;
        if (primitiveClass.getName().equals("void") || primitiveClass.getName().equals("boolean") || primitiveClass.getName().equals("byte") || primitiveClass.getName().equals("char") || primitiveClass.getName().equals("short") || primitiveClass.getName().equals("int") || primitiveClass.getName().equals("long") || primitiveClass.getName().equals("float") || primitiveClass.getName().equals("double")) {
            validPrimitiveType = true;
        }
        return validPrimitiveType;
    }

    public static boolean isJavaLangStringType(Class jlsClass) {
        boolean validJlsType = false;
        if (jlsClass.getName().equals("java.lang.String")) {
            validJlsType = true;
        }
        return validJlsType;
    }

    public static boolean isValidRmiIIOPException(Class[] RMIIIOPexceptions) {
        boolean throwsRemoteException = false;
        int kk = 0;
        while (kk < RMIIIOPexceptions.length) {
            if (RMIIIOPexceptions[kk].getName().equals("java.rmi.RemoteException") || RMIIIOPexceptions[kk].getName().equals("RemoteException")) {
                throwsRemoteException = true;
                break;
            }
            ++kk;
        }
        return throwsRemoteException;
    }

    public static boolean isValidRmiIIOPReturnType(Class RMIIIOPReturnType) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(RMIIIOPReturnType) || RmiIIOPUtils.isValidRmiIIOPValueType(RMIIIOPReturnType) || RmiIIOPUtils.isValidRmiIIOPInterfaceType(RMIIIOPReturnType) || RmiIIOPUtils.isJavaLangStringType(RMIIIOPReturnType);
    }

    public static boolean isValidSerializableType(Class c10) {
        boolean validInterface = false;
        block0: do {
            Class<?>[] interfaces = c10.getInterfaces();
            int i2 = 0;
            while (i2 < interfaces.length) {
                if (interfaces[i2].getName().equals("java.io.Serializable")) {
                    validInterface = true;
                    continue block0;
                }
                ++i2;
            }
        } while ((c10 = c10.getSuperclass()) != null && !validInterface);
        return validInterface;
    }

    public static boolean isPersistentFieldTypeValid(Class CmpField2, String HomeClass, String RemoteClass2) {
        return RmiIIOPUtils.isValidRmiIDLPrimitiveType(CmpField2) || RmiIIOPUtils.isValidSerializableType(CmpField2) || CmpField2.getName().equals(HomeClass) || CmpField2.getName().equals(RemoteClass2);
    }

    public static boolean isEjbFindMethodExceptionsSubsetOfFindMethodExceptions(Class[] ejbFindExceptions, Class[] findExceptions) {
        boolean oneFailed = false;
        if (Arrays.equals(ejbFindExceptions, findExceptions)) {
            return true;
        }
        List<Class> ejbFindList = Arrays.asList(ejbFindExceptions);
        List<Class> findList = Arrays.asList(findExceptions);
        if (!ejbFindList.isEmpty()) {
            Iterator<Class> itr = ejbFindList.iterator();
            while (itr.hasNext()) {
                Class nextEjbFindMethodException = itr.next();
                if (findList.contains(nextEjbFindMethodException) || RmiIIOPUtils.isSuperClassofClass("java.lang.RuntimeException", nextEjbFindMethodException)) continue;
                oneFailed = true;
                break;
            }
            return !oneFailed;
        }
        return true;
    }

    private static boolean isSuperClassofClass(String superClass, Class fromClass) {
        boolean validSuperClass = false;
        Class c10 = fromClass;
        do {
            if (!c10.getName().equals(superClass)) continue;
            validSuperClass = true;
            break;
        } while ((c10 = c10.getSuperclass()) != null && !validSuperClass);
        return validSuperClass;
    }
}

