/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests.connector;

import com.sun.enterprise.deployment.AuthMechanism;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import java.util.Iterator;
import java.util.Set;

public class CredentialInterface
extends ConnectorTest
implements ConnectorCheck {
    private static String[] allowedInterfaces = new String[]{"javax.resource.security.PasswordCredential", "javax.resource.security.GenericCredential"};

    public Result check(ConnectorDescriptor descriptor) {
        boolean oneFailed = false;
        Result result = this.getInitializedResult();
        Set mechanisms = descriptor.getAuthMechanisms();
        if (mechanisms.isEmpty()) {
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.AuthMechType.nonexist", "No authentication mechanism defined for this resource adapater", new Object[]{descriptor.getConnectionFactoryImpl()}));
            return result;
        }
        Iterator mechIterator = mechanisms.iterator();
        while (mechIterator.hasNext()) {
            AuthMechanism am2 = (AuthMechanism)mechIterator.next();
            String credInterface = am2.getCredentialInterface();
            boolean allowedInterface = false;
            if (credInterface != null) {
                int i2 = 0;
                while (i2 < allowedInterfaces.length) {
                    if (credInterface.equals(allowedInterfaces[i2])) {
                        allowedInterface = true;
                        break;
                    }
                    ++i2;
                }
            }
            if (allowedInterface && credInterface != null) continue;
            oneFailed = true;
            result.failed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CredentialInterface.failed", "Authentication mechanism credential interface [ {0} ] defined in the credential-interface tag is not allowed", new Object[]{credInterface}));
        }
        if (!oneFailed) {
            result.passed(VerifierTest.smh.getLocalString("com.sun.enterprise.tools.verifier.tests.connector.CredentialInterface.passed", "All defined authorization mechanism credential interfaces are allowed", new Object[]{descriptor.getConnectionFactoryImpl()}));
        }
        return result;
    }
}

