/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.verifier.tests;

import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.StringManagerHelper;
import com.sun.enterprise.tools.verifier.Verifier;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public abstract class VerifierTest {
    protected final boolean debug = Verifier.getDebug();
    protected static final LocalStringManagerImpl smh = StringManagerHelper.getLocalStringsManager();
    private Context context = null;

    public void setVerifierContext(Context context) {
        this.context = context;
    }

    public Context getVerifierContext() {
        return this.context;
    }

    protected Result getInitializedResult() {
        if (this.debug) {
            System.out.println("\n********************************************************** \n " + smh.getLocalString("which.class.called.string", this.getClass() + " called \n", new Object[]{this.getClass()}) + "\n**********************************************************");
        }
        Result result = new Result();
        result.init(this.getClass());
        if (this.debug) {
            System.out.println(smh.getLocalString("test.string.assertion", "Assertion from resource file is: [ {0} ]", new Object[]{result.getAssertion()}));
        }
        return result;
    }

    public static boolean isSubclassOf(Class subClass, String superClassName) {
        if (subClass == null || superClassName == null) {
            return false;
        }
        Class c10 = subClass;
        do {
            if (!c10.getName().equals(superClassName)) continue;
            return true;
        } while ((c10 = c10.getSuperclass()) != null);
        return false;
    }

    public static boolean isImplementorOf(Class clazz, String interfaceName) {
        if (clazz == null || interfaceName == null) {
            return false;
        }
        Class c10 = clazz;
        do {
            Class<?>[] interfaces = c10.getInterfaces();
            int i2 = 0;
            while (i2 < interfaces.length) {
                if (VerifierTest.isSubclassOf(interfaces[i2], interfaceName)) {
                    return true;
                }
                ++i2;
            }
        } while ((c10 = c10.getSuperclass()) != null);
        return false;
    }

    public static Method getMethod(Class clazz, String methodName, Class[] parmTypes) {
        Method m2 = null;
        Class c10 = clazz;
        do {
            try {
                m2 = clazz.getMethod(methodName, parmTypes);
            }
            catch (NoSuchMethodException nsme) {
            }
            catch (SecurityException se) {
                // empty catch block
            }
            c10 = c10.getSuperclass();
        } while (m2 != null && c10 != null);
        return m2;
    }

    public static boolean testImplementationOf(Class clazz, String interfaceName, Result result) {
        if (VerifierTest.isImplementorOf(clazz, interfaceName)) {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.interfaceimplementation.passed", "The class [ {0} ] implements the [ {1} ] interface", new Object[]{clazz.getName(), interfaceName}));
            return true;
        }
        result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.interfaceimplementation.failed", "Error: The class [ {0} ] does not implement the [ {1} ] interface", new Object[]{clazz.getName(), interfaceName}));
        return false;
    }

    public static void testFileExistence(String fileName, File file, String fileID, Result result) {
        JarFile jarFile;
        if (fileName == null || fileName.length() == 0) {
            result.warning(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.warning", "Warning: No {0} defined in deployment descriptors", new Object[]{fileID}));
            return;
        }
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException ioe) {
            Verifier.debug(ioe);
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.failed", "Error:  {0} [ {1} ] not found in the archive", new Object[]{fileID, fileName}));
            return;
        }
        ZipEntry ze = jarFile.getEntry(fileName);
        if (ze == null) {
            result.failed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.failed", "Error: {0} [ {1} ] not found in the archive", new Object[]{fileID, fileName}));
        } else {
            result.passed(smh.getLocalString("com.sun.enterprise.tools.verifier.tests.VerifierTest.fileexistence.passed", "{0} [ {1} ] found in resource adapter archive", new Object[]{fileID, fileName}));
        }
    }

    public static boolean methodThrowException(Method method, String exception) {
        Class<?>[] exceptions = method.getExceptionTypes();
        int i2 = 0;
        while (i2 < exceptions.length) {
            if (VerifierTest.isSubclassOf(exceptions[i2], exception)) {
                return true;
            }
            ++i2;
        }
        return false;
    }
}

