/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.utils;

import com.sun.enterprise.tools.deployment.ui.UIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class UIConfigProperties {
    private File configFile = null;
    private Properties configProps = new Properties();

    public UIConfigProperties() {
    }

    public UIConfigProperties(File cfgFile) throws IOException {
        this.setConfigFile(cfgFile);
        this.loadFile();
    }

    public void setConfigFile(File cfgFile) {
        if (this.configFile != null) {
            UIUtils.printImplementationError("Configuration file has already been set");
        }
        this.configFile = cfgFile;
    }

    public void loadFile() throws IOException {
        if (this.configFile != null) {
            if (this.configFile.exists()) {
                this.configProps.load(new FileInputStream(this.configFile));
            }
        } else {
            UIUtils.printImplementationError("Configuration file has not been set");
        }
    }

    public void loadFile(File cfgFile) throws IOException {
        this.setConfigFile(cfgFile);
        this.loadFile();
    }

    public void save(String header) throws IOException {
        if (this.configFile != null) {
            FileOutputStream out = new FileOutputStream(this.configFile);
            this.configProps.store(out, header);
            out.close();
        }
    }

    public void removeKey(String key) {
        ((Hashtable)this.configProps).remove(key);
    }

    public void setProperty(String key, String value) {
        this.configProps.setProperty(key, value);
    }

    public String getProperty(String key) {
        return this.configProps.getProperty(key);
    }

    public String getProperty(String key, String dftVal) {
        return this.configProps.getProperty(key, dftVal);
    }

    public String toString() {
        return this.configFile != null ? this.configFile.toString() : "<UIConfigProperties>";
    }
}

