/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JdbcXAResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.repository.ResourceProperty;
import com.sun.enterprise.repository.ResourcePropertyImpl;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfigurationDialog;
import com.sun.enterprise.tools.deployment.ui.rescfg.XADataSrcDlg;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class ConfInstlDlgXAPnl
extends JPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgXAPnl == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgXAPnl = ConfInstlDlgXAPnl.class$("com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgXAPnl")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgXAPnl);
    private static String XA_DATASOURCE_BOX = localStrings.getLocalString("ui.confInstldlgxapnl.xadatasourcesbox", "XA Datasources");
    private static String JNDI_NAME = localStrings.getLocalString("ui.confInstldlgxapnl.jndiname", "JNDI Name");
    private static String DATA_OBJECT_CLASS = localStrings.getLocalString("ui.confInstldlgxapnl.dataobjectclass", "Data Object Class");
    private static String XA_ADD = localStrings.getLocalString("ui.configurationdialog.add", "Add...");
    private static String XA_REMOVE = localStrings.getLocalString("ui.configurationdialog.remove", "Remove...");
    private static String PROPERTIES_BOX = localStrings.getLocalString("ui.confInstldlgxapnl.propertiesbox", "Properties");
    private static String PROPERTIES_OF_BOX = localStrings.getLocalString("ui.confInstldlgxapnl.propertiesofbox", "Properties of ");
    private static String RECOVERY_BOX = localStrings.getLocalString("ui.confInstldlgxapnl.recoverysettings", "Recovery Settings");
    private static String USER_NAME = localStrings.getLocalString("ui.confInstldlgxapnl.username", "User Name:");
    private static String PASSWORD = localStrings.getLocalString("ui.confInstldlgxapnl.password", "Password:");
    private static String PROPERTY_NAME = localStrings.getLocalString("ui.confInstldlgxapnl.propertyname", "Property Name");
    private static String TYPE = localStrings.getLocalString("ui.confInstldlgxapnl.type", "Type");
    private static String VALUE = localStrings.getLocalString("ui.confInstldlgxapnl.value", "Value");
    private DatasourcesTable datasourcesTable;
    private DatasourcesTableModel datasourcesTableModel;
    private PropertiesTable propertiesTable;
    private PropertiesTableModel propertiesTableModel;
    private XADataSrcDlg xaDataSrcDlg;
    private UITitledTextField userName;
    private UITitledPasswordField password;
    private UITitledBox propertiesBox;
    private JButton propertiesAddBtn;
    private Vector resToBeDeleted = null;
    private Vector originalRes = null;
    private DatasourceObject currDSObj = null;
    private DatasourceObject lastDSObj = null;
    private boolean isChanged = false;
    private boolean isRestart = false;
    boolean inClassPath = false;
    private boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgXAPnl;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ConfInstlDlgXAPnl() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new BorderLayout());
        UITitledTable datasourcesBox = new UITitledTable(XA_DATASOURCE_BOX, true);
        this.add((Component)datasourcesBox, "Center");
        UITitledTable datasourcePanel = new UITitledTable(null, false);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        datasourcesBox.add((Component)datasourcePanel, gbc);
        this.datasourcesTable = new DatasourcesTable(new DatasourcesTableModel());
        this.datasourcesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (ConfInstlDlgXAPnl.this.checkForDuplicateProps()) {
                    return;
                }
                int rowIndex = ConfInstlDlgXAPnl.this.datasourcesTable.getSelectedRow();
                ConfInstlDlgXAPnl.this.currDSObj = ConfInstlDlgXAPnl.this.getDatasourceTableModel().getRow(rowIndex);
                ConfInstlDlgXAPnl.this.refreshPropertiesTable();
                ConfInstlDlgXAPnl.this.lastDSObj = ConfInstlDlgXAPnl.this.currDSObj;
                if (ConfInstlDlgXAPnl.this.currDSObj != null) {
                    ConfInstlDlgXAPnl.this.propertiesAddBtn.setEnabled(true);
                    ConfInstlDlgXAPnl.this.propertiesBox.setTitle(PROPERTIES_OF_BOX + ConfInstlDlgXAPnl.this.currDSObj.getName());
                } else {
                    ConfInstlDlgXAPnl.this.propertiesAddBtn.setEnabled(false);
                    ConfInstlDlgXAPnl.this.propertiesBox.setTitle(PROPERTIES_BOX);
                }
            }
        });
        datasourcePanel.setTableView(this.datasourcesTable);
        JButton datasourceAddBtn = new JButton(XA_ADD);
        datasourceAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgXAPnl.this.addDatasource(e10);
            }
        });
        datasourcePanel.addControlButton(datasourceAddBtn);
        JButton datasourceRemoveBtn = new JButton(XA_REMOVE);
        datasourceRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgXAPnl.this.removeDatasource(e10);
            }
        });
        datasourcePanel.addSelectionEnabledButton(datasourceRemoveBtn);
        this.propertiesBox = new UITitledBox(PROPERTIES_BOX, true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        datasourcesBox.add((Component)this.propertiesBox, gbc);
        UITitledTable propertiesTableBox = new UITitledTable(null, false);
        GridBagConstraints c10 = this.propertiesBox.getGBConstraints();
        c10.gridx = 0;
        c10.gridy = 0;
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.propertiesBox.add((Component)propertiesTableBox, c10);
        this.propertiesTable = new PropertiesTable(new PropertiesTableModel());
        propertiesTableBox.setTableView(this.propertiesTable);
        this.adjustPropertiesTableColumnSizes();
        this.propertiesAddBtn = new JButton(XA_ADD);
        this.propertiesAddBtn.setEnabled(false);
        this.propertiesAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgXAPnl.this.addProperty(e10);
            }
        });
        propertiesTableBox.addControlButton(this.propertiesAddBtn);
        JButton propertiesRemoveBtn = new JButton(XA_REMOVE);
        propertiesRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgXAPnl.this.removeProperties(e10);
            }
        });
        propertiesTableBox.addSelectionEnabledButton(propertiesRemoveBtn);
        UITitledBox recoveryBox = new UITitledBox(RECOVERY_BOX, true);
        c10.gridx = 0;
        c10.gridy = 1;
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        this.propertiesBox.add((Component)recoveryBox, c10);
        this.userName = new UITitledTextField(USER_NAME, false);
        GridBagConstraints rc = recoveryBox.getGBConstraints();
        rc.gridx = 0;
        rc.gridy = 0;
        rc.weightx = 0.5;
        rc.weighty = 0.5;
        rc.gridwidth = 1;
        rc.gridheight = 1;
        rc.insets = new Insets(5, 5, 5, 5);
        rc.fill = 1;
        recoveryBox.add((Component)this.userName, rc);
        this.userName.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                int rowIndex = ConfInstlDlgXAPnl.this.datasourcesTable.getSelectedRow();
                DatasourceObject obj = ConfInstlDlgXAPnl.this.getDatasourceTableModel().getRow(rowIndex);
                obj.setUserName(ConfInstlDlgXAPnl.this.userName.getText());
            }
        });
        this.password = new UITitledPasswordField(PASSWORD, false);
        rc.gridx = 0;
        rc.gridy = 1;
        rc.weightx = 0.5;
        rc.weighty = 0.5;
        rc.gridwidth = 1;
        rc.gridheight = 1;
        rc.fill = 1;
        rc.insets = new Insets(5, 5, 5, 5);
        recoveryBox.add((Component)this.password, rc);
        this.password.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                int rowIndex = ConfInstlDlgXAPnl.this.datasourcesTable.getSelectedRow();
                DatasourceObject obj = ConfInstlDlgXAPnl.this.getDatasourceTableModel().getRow(rowIndex);
                obj.setPassword(ConfInstlDlgXAPnl.this.password.getText());
            }
        });
        UITitledBox dummyBox = new UITitledBox("", false);
        rc.gridx = 1;
        rc.gridy = 0;
        rc.weightx = 0.5;
        rc.weighty = 0.5;
        rc.gridwidth = 1;
        rc.gridheight = 2;
        rc.insets = new Insets(5, 5, 5, 5);
        rc.fill = 1;
        recoveryBox.add((Component)dummyBox, rc);
        this.refresh();
    }

    public void refresh() {
        this.getPropertiesTableModel().removeAllRows();
        this.getDatasourceTableModel().removeAllRows();
        this.getPropertiesTableModel().fireTableDataChanged();
        this.getDatasourceTableModel().fireTableDataChanged();
        this.resToBeDeleted = new Vector();
        this.originalRes = new Vector();
        this.isRestart = false;
        ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
        try {
            Vector originals = new Vector(resAdmin.getResources(4));
            DatasourceObject obj = null;
            String resName = "";
            String objClass = "";
            Enumeration enumeration = originals.elements();
            while (enumeration.hasMoreElements()) {
                JdbcXAResource resource = (JdbcXAResource)enumeration.nextElement();
                if (resource == null) continue;
                resName = resource.getName();
                objClass = resource.getClassname();
                obj = new DatasourceObject(resName, objClass);
                Set props = resource.getProperties();
                Iterator pItr = props.iterator();
                while (pItr.hasNext()) {
                    ResourceProperty prop = (ResourceProperty)pItr.next();
                    PropertyObject propObj = new PropertyObject(prop.getName(), "", (String)prop.getValue());
                    obj.addDisplayProperty(propObj);
                }
                try {
                    Class<?> theClass = Class.forName(objClass);
                    Vector intrspectProps = this.getProperties(theClass);
                    if (intrspectProps.size() > 0) {
                        obj.setAllProperties(intrspectProps);
                    }
                }
                catch (ClassNotFoundException e10) {
                    // empty catch block
                }
                obj.setUserName(resource.getDbuser());
                obj.setPassword(resource.getDbpassword());
                obj.setInClassPath(true);
                this.getDatasourceTableModel().addRow(obj);
                this.originalRes.add(resName);
            }
            this.getDatasourceTableModel().fireTableDataChanged();
        }
        catch (J2EEResourceException e11) {
            System.out.println("J2EEResourceException: There was a problem while getting resources");
            e11.printStackTrace();
        }
    }

    public void removeProperties(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.propertiesTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgxapnl.removepropertiesconfirmation", "Are you sure you want to delete selected Property(s)?"), "Confirm Dialog", 0)) == 0) {
            Vector<PropertyObject> objs = new Vector<PropertyObject>();
            while (minIndex <= maxIndex) {
                PropertyObject obj = this.getPropertiesTableModel().getRow(minIndex);
                objs.add(obj);
                ++minIndex;
            }
            this.getPropertiesTableModel().removeRows(objs);
            this.getPropertiesTableModel().fireTableDataChanged();
            this.getCurrDSObj().removeDisplayProperties(objs);
            if (!this.resToBeDeleted.contains(this.getCurrDSObj().getName())) {
                this.resToBeDeleted.add(this.getCurrDSObj().getName());
            }
            this.setDirty(true);
        }
    }

    public void addProperty(ActionEvent evt) {
        int blankRow = this.getPropertiesTableModel().findRowWithValue(0, 0, "");
        if (blankRow >= 0) {
            return;
        }
        this.propertiesTable.refreshComboBox(this.currDSObj.getAllPropertyNames());
        PropertyObject obj = new PropertyObject("", "", "");
        this.getPropertiesTableModel().addRow(obj);
        this.getPropertiesTableModel().fireTableDataChanged();
        this.getCurrDSObj().addDisplayProperty(obj);
        this.propertiesTable.setSelectedIndex(-1);
        this.propertiesTable.setSelectedIndex(this.getPropertiesTableModel().findRowWithValue(0, 0, ""));
    }

    public void removeDatasource(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.datasourcesTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgxapnl.removedatasourcesconfirmation", "Are you sure you want to delete selected Datasopurce(s)?"), "Confirm Dialog", 0)) == 0) {
            Vector<DatasourceObject> objs = new Vector<DatasourceObject>();
            DatasourceObject obj = null;
            while (minIndex <= maxIndex) {
                obj = this.getDatasourceTableModel().getRow(minIndex);
                objs.add(obj);
                ++minIndex;
            }
            this.getDatasourceTableModel().removeRows(objs);
            this.getDatasourceTableModel().fireTableDataChanged();
            int i2 = 0;
            while (i2 < objs.size()) {
                obj = (DatasourceObject)objs.elementAt(i2);
                if (!this.resToBeDeleted.contains(obj.getName())) {
                    this.resToBeDeleted.add(obj.getName());
                }
                ++i2;
            }
            this.setDirty(true);
        }
    }

    public void addDatasource(ActionEvent evt) {
        if (this.checkForDuplicateProps()) {
            return;
        }
        if (this.xaDataSrcDlg == null) {
            this.xaDataSrcDlg = new XADataSrcDlg(this.getFrame());
        } else {
            this.xaDataSrcDlg.setVisible(true);
            this.xaDataSrcDlg.refresh();
        }
        if (this.xaDataSrcDlg.isOk()) {
            String objClass = this.xaDataSrcDlg.getDataSrsObjClass();
            String jndiName = this.xaDataSrcDlg.getJndiName();
            if (this.isJndiExists(jndiName)) {
                JOptionPane.showMessageDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgxapnl.jndinamealreadyexists", "Jndi name already exists."), "Message Dialog", 2);
                return;
            }
            if (this.isObjClassExists(objClass)) {
                JOptionPane.showMessageDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgxapnl.classnamealreadyexists", "Datasource Object Class name already exists"), "Message Dialog", 2);
                return;
            }
            this.currDSObj = new DatasourceObject(jndiName, objClass);
            this.currDSObj.setAllProperties(this.getPropertiesWithCheck(objClass));
            this.currDSObj.setUserName("");
            this.currDSObj.setPassword("");
            this.currDSObj.setInClassPath(this.inClassPath);
            this.getDatasourceTableModel().addRow(this.currDSObj);
            this.getDatasourceTableModel().fireTableDataChanged();
            this.lastDSObj = this.currDSObj;
            this.datasourcesTable.setSelectedIndex(-1);
            this.datasourcesTable.setSelectedIndex(this.getDatasourceTableModel().findRowWithValue(0, 0, jndiName));
            this.userName.setText("");
            this.password.setText("");
            this.setDirty(true);
        }
    }

    public void refreshPropertiesTable() {
        PropertiesTableModel ptm = this.getPropertiesTableModel();
        if (this.getCurrDSObj() != null) {
            ptm.removeAllRows();
            ptm.fireTableDataChanged();
            this.propertiesTable.refreshComboBox(this.getCurrDSObj().getAllPropertyNames());
            Vector props = this.currDSObj.getDisplayProperties();
            int i2 = 0;
            while (i2 < props.size()) {
                ptm.addRow(props.elementAt(i2));
                ++i2;
            }
            ptm.fireTableDataChanged();
            this.userName.setText(this.getCurrDSObj().getUserName());
            this.password.setText(this.getCurrDSObj().getPassword());
        } else {
            ptm.removeAllRows();
            ptm.fireTableDataChanged();
            this.userName.setText("");
            this.password.setText("");
        }
    }

    private Vector getPropertiesWithCheck(String objClass) {
        Class<?> dataSrcClass = null;
        try {
            dataSrcClass = Class.forName(objClass);
            this.inClassPath = true;
        }
        catch (ClassNotFoundException e10) {
            JOptionPane.showMessageDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgxapnl.mustchangeclasspath", "Please note that you must change the classpath to include the \nclass and restart the Server for Datasource to be available."), "Message Dialog", 2);
        }
        if (this.debug) {
            System.out.println("Could load the given Class? : " + (dataSrcClass != null));
        }
        return this.getProperties(dataSrcClass);
    }

    private Vector getProperties(Class dataSrcClass) {
        Vector<PropertyObject> properties = new Vector<PropertyObject>();
        if (dataSrcClass != null) {
            Method[] methods = dataSrcClass.getDeclaredMethods();
            Field[] fields = dataSrcClass.getDeclaredFields();
            Object instance = null;
            try {
                instance = dataSrcClass.newInstance();
            }
            catch (Exception e10) {
                // empty catch block
            }
            Method method = null;
            Field field = null;
            int i2 = 0;
            while (i2 < methods.length) {
                String methodName;
                method = methods[i2];
                if (method.getModifiers() == 1 && (methodName = method.getName()).startsWith("set")) {
                    methodName = methodName.substring(3, methodName.length());
                    methodName = methodName.toUpperCase();
                    int j2 = 0;
                    while (j2 < fields.length) {
                        String fieldName;
                        field = fields[j2];
                        if (field.getModifiers() == 1 && methodName.equals((fieldName = field.getName()).toUpperCase())) {
                            String propName = fieldName;
                            String propType = field.getType().getName();
                            String propValue = "";
                            try {
                                propValue = (String)field.get(instance);
                            }
                            catch (Exception e11) {
                                e11.printStackTrace();
                            }
                            properties.add(new PropertyObject(propName, propType, propValue));
                        }
                        ++j2;
                    }
                }
                ++i2;
            }
        }
        return properties;
    }

    public boolean checkForDuplicateProps() {
        if (this.lastDSObj == null) {
            return false;
        }
        if (this.hasDuplicateProps(this.lastDSObj)) {
            JOptionPane.showMessageDialog(this.getFrame(), localStrings.getLocalString("ui.confInstldlgxapnl.duplicatepropeties", "Datasource class  '{0}'\ncannot have duplicate properties.\nPlease enter unique properties.", new Object[]{this.lastDSObj.getObjClass()}), "Message Dialog", 2);
            return true;
        }
        return false;
    }

    private boolean hasDuplicateProps(DatasourceObject lastDSObj) {
        if (lastDSObj == null) {
            return false;
        }
        Vector props = lastDSObj.getDisplayProperties();
        if (props == null || props.size() < 1) {
            return false;
        }
        Vector<String> propNames = new Vector<String>();
        int i2 = 0;
        while (i2 < props.size()) {
            PropertyObject obj = (PropertyObject)props.elementAt(i2);
            propNames.add(obj.getName());
            ++i2;
        }
        do {
            String name = (String)propNames.elementAt(0);
            propNames.removeElementAt(0);
            if (!propNames.contains(name)) continue;
            return true;
        } while (propNames.size() > 1);
        return false;
    }

    private boolean isJndiExists(String jndiName) {
        int noOfRes = this.getDatasourceTableModel().getRowCount();
        String name = "";
        int i2 = 0;
        while (i2 < noOfRes) {
            DatasourceObject obj = this.getDatasourceTableModel().getRow(i2);
            name = obj.getName();
            if (name.equals(jndiName)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    private boolean isObjClassExists(String className) {
        int noOfRes = this.getDatasourceTableModel().getRowCount();
        String name = "";
        int i2 = 0;
        while (i2 < noOfRes) {
            DatasourceObject obj = this.getDatasourceTableModel().getRow(i2);
            name = obj.getObjClass();
            if (name.equals(className)) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    public void adjustPropertiesTableColumnSizes() {
        TableColumn column = null;
        int columnWidth = this.propertiesTable.getPreferredSize().width;
        int i2 = 0;
        while (i2 < this.propertiesTable.getModel().getColumnCount()) {
            column = this.propertiesTable.getColumnModel().getColumn(i2);
            columnWidth = i2 < 1 ? this.propertiesTable.getPreferredSize().width / 4 : this.propertiesTable.getPreferredSize().width;
            ++i2;
        }
    }

    public void propertiesChanged(String resName) {
        if (!this.resToBeDeleted.contains(resName)) {
            this.resToBeDeleted.add(resName);
            this.setDirty(true);
        }
    }

    public boolean isSrvrRestart() {
        return this.isRestart;
    }

    private PropertiesTableModel getPropertiesTableModel() {
        return (PropertiesTableModel)this.propertiesTable.getModel();
    }

    private DatasourcesTableModel getDatasourceTableModel() {
        return (DatasourcesTableModel)this.datasourcesTable.getModel();
    }

    private void setDirty(boolean value) {
        this.isChanged = value;
    }

    private boolean isDirty() {
        return this.isChanged;
    }

    private Frame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ConfInstlDlgXAPnl.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    private DatasourceObject getCurrDSObj() {
        return this.currDSObj;
    }

    public void saveData() {
        if (this.isDirty()) {
            ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
            try {
                Hashtable<String, DatasourceObject> resources = new Hashtable<String, DatasourceObject>();
                DatasourceObject obj = null;
                Enumeration keys = null;
                String resName = "";
                int noOfRes = this.getDatasourceTableModel().getRowCount();
                int i2 = 0;
                while (i2 < noOfRes) {
                    obj = this.getDatasourceTableModel().getRow(i2);
                    resName = obj.getName();
                    if (resources.containsKey(resName)) {
                        System.out.println("Found duplicate datasource: earlier one will be replaced by this");
                    }
                    resources.put(resName, obj);
                    ++i2;
                }
                if (this.debug) {
                    System.out.println("\n\n Removing del/modfied XA Datasources:");
                }
                int i3 = 0;
                while (i3 < this.resToBeDeleted.size()) {
                    resName = (String)this.resToBeDeleted.elementAt(i3);
                    if (!resName.equals("") && this.originalRes.contains(resName)) {
                        resAdmin.removeResource(resName, 4);
                        this.originalRes.remove(resName);
                        this.isRestart = true;
                        if (this.debug) {
                            System.out.println("     deleted Res :" + resName);
                        }
                    }
                    ++i3;
                }
                if (this.debug) {
                    System.out.println("\n\n Add New XA Datasource:");
                }
                JdbcXAResource resource = null;
                keys = resources.keys();
                String userName = "";
                String password = "";
                while (keys.hasMoreElements()) {
                    resName = (String)keys.nextElement();
                    if (resName.equals("") || this.originalRes.contains(resName)) continue;
                    obj = (DatasourceObject)resources.get(resName);
                    userName = obj.getUserName();
                    password = obj.getPassword();
                    Vector properties = obj.getDisplayProperties();
                    resource = new JdbcXAResource(resName);
                    if (this.debug) {
                        System.out.println("   Added Resource : ");
                        System.out.println("       name     : " + obj.getName());
                    }
                    resource.setClassname(obj.getObjClass());
                    if (this.debug) {
                        System.out.println("       class    : " + obj.getObjClass());
                    }
                    if (!userName.equals("") && !password.equals("")) {
                        resource.setDbuser(userName);
                        resource.setDbpassword(password);
                        if (this.debug) {
                            System.out.println("       UserName : " + userName);
                            System.out.println("       Password : " + password);
                        }
                    }
                    int j2 = 0;
                    while (j2 < properties.size()) {
                        PropertyObject prop = (PropertyObject)properties.elementAt(j2);
                        if (!prop.getValue().equals("") && !prop.getName().equals("")) {
                            ResourcePropertyImpl resProp = new ResourcePropertyImpl(prop.getName(), prop.getValue());
                            resource.addProperty(resProp);
                            if (this.debug) {
                                System.out.println("       Property : " + prop.getName() + " -> " + prop.getValue());
                            }
                        }
                        ++j2;
                    }
                    resAdmin.addResource(resource);
                    if (obj.isInClassPath()) continue;
                    this.isRestart = true;
                }
            }
            catch (J2EEResourceException e10) {
                System.out.println("J2EEResourceException: There was a problem while saving resources");
                e10.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        frm.getContentPane().add(new ConfInstlDlgXAPnl());
        ((Component)frm).setSize(450, 350);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class DatasourcesTableModel
    extends InspectorTableModel {
        public DatasourcesTableModel(String[] columnNames) {
            super(columnNames);
        }

        public DatasourcesTableModel() {
            this(new String[]{JNDI_NAME, DATA_OBJECT_CLASS});
        }

        public void addRow(Object datasource) {
            super.getData().add(datasource);
        }

        public void removeRow(int index) {
            super.getData().remove(index);
        }

        public void removeRows(Collection rows) {
            super.getData().removeAll(rows);
        }

        public void removeAllRows() {
            super.getData().clear();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public DatasourceObject getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (DatasourceObject)super.getData().get(index);
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Object getValueAt(int row, int col) {
            String value = "";
            DatasourceObject obj = (DatasourceObject)super.getData().get(row);
            switch (col) {
                case 0: {
                    value = obj.getName();
                    break;
                }
                case 1: {
                    value = obj.getObjClass();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            DatasourceObject obj = (DatasourceObject)super.getData().get(row);
            switch (col) {
                case 0: {
                    obj.setName((String)value);
                    break;
                }
                case 1: {
                    obj.setObjClass((String)value);
                    break;
                }
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    class DatasourcesTable
    extends InspectorTable {
        public DatasourcesTable(DatasourcesTableModel model) {
            super(model);
            this.setSelectionMode(1);
            this.setColumnSelectionAllowed(false);
            this.setDatasourcesColumnSizes();
        }

        public void setDatasourcesColumnSizes() {
            this.getColumnModel().getColumn(0).setPreferredWidth(this.getWidth() / 3);
        }
    }

    class PropertiesTableModel
    extends InspectorTableModel {
        public PropertiesTableModel(String[] columnNames) {
            super(columnNames);
        }

        public PropertiesTableModel() {
            this(new String[]{PROPERTY_NAME, VALUE});
        }

        public void addRow(Object property) {
            super.getData().add(property);
        }

        public void addRows(Collection rows) {
            super.getData().addAll(rows);
        }

        public void removeRow(int index) {
            super.getData().remove(index);
        }

        public void removeRows(Collection rows) {
            super.getData().removeAll(rows);
        }

        public void removeAllRows() {
            super.getData().clear();
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public PropertyObject getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (PropertyObject)super.getData().get(index);
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            String value = "";
            PropertyObject propObj = (PropertyObject)super.getData().get(row);
            switch (col) {
                case 0: {
                    value = propObj.getName();
                    break;
                }
                case 1: {
                    value = propObj.getValue();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            PropertyObject propObj = (PropertyObject)super.getData().get(row);
            String name = propObj.getName();
            String val = propObj.getValue();
            if (col == 0 && value.equals(name)) {
                return;
            }
            if (col == 1 && value.equals(val)) {
                return;
            }
            switch (col) {
                case 0: {
                    propObj.setName((String)value);
                    ConfInstlDlgXAPnl.this.propertiesChanged(ConfInstlDlgXAPnl.this.getCurrDSObj().getName());
                    break;
                }
                case 1: {
                    propObj.setValue((String)value);
                    ConfInstlDlgXAPnl.this.propertiesChanged(ConfInstlDlgXAPnl.this.getCurrDSObj().getName());
                    break;
                }
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    private class ColumnHeaderRenderer
    extends DefaultTableCellRenderer {
        public ColumnHeaderRenderer(String label) {
            this.setOpaque(true);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            this.setHorizontalAlignment(0);
            this.setText(label);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return this;
        }
    }

    class PropertiesTable
    extends InspectorTable {
        private Vector allProps;

        public PropertiesTable(PropertiesTableModel model) {
            super(model);
            this.setSelectionMode(1);
            this.setColumnSelectionAllowed(false);
            this.allProps = new Vector();
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor editor = super.getCellEditor(row, col);
            switch (col) {
                case 0: {
                    JComboBox combo = new JComboBox(this.allProps);
                    combo.setEditable(true);
                    editor = new DefaultCellEditor(combo);
                    break;
                }
            }
            return editor;
        }

        public void refreshComboBox(Vector proeprties) {
            this.allProps = proeprties;
        }
    }

    class PropertyObject {
        private String name;
        private String type;
        private String value;

        public PropertyObject(String name, String type, String value) {
            this.name = name;
            this.type = type;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    class DatasourceObject {
        private String name;
        private String objClass;
        private String userName;
        private String password;
        private Vector allProperties;
        private Vector displayProperties;
        private boolean inClassPath = true;

        public DatasourceObject(String name, String objClass) {
            this.name = name;
            this.objClass = objClass;
            this.allProperties = new Vector();
            this.displayProperties = new Vector();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getObjClass() {
            return this.objClass;
        }

        public void setObjClass(String obj) {
            this.objClass = obj;
        }

        public Vector getAllPropertyNames() {
            Vector<String> names = new Vector<String>();
            int i2 = 0;
            while (i2 < this.allProperties.size()) {
                PropertyObject obj = (PropertyObject)this.allProperties.elementAt(i2);
                names.add(obj.getName());
                ++i2;
            }
            return names;
        }

        public void setAllProperties(Vector v2) {
            this.allProperties = v2;
        }

        public void addAllProperty(PropertyObject o2) {
            this.allProperties.add(o2);
        }

        public boolean isInAllProperties(String name) {
            Vector props = this.getAllPropertyNames();
            return props.contains(name);
        }

        public Vector getDisplayProperties() {
            return this.displayProperties;
        }

        public void addDisplayProperty(PropertyObject o2) {
            this.displayProperties.add(o2);
        }

        public void addDisplayProperties(Vector v2) {
            this.displayProperties.addAll(v2);
        }

        public void removeDisplayProperty(PropertyObject o2) {
            this.displayProperties.remove(o2);
        }

        public void removeDisplayProperties(Vector v2) {
            this.displayProperties.removeAll(v2);
        }

        public String getUserName() {
            return this.userName;
        }

        public void setUserName(String userName) {
            this.userName = userName;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public boolean isInClassPath() {
            return this.inClassPath;
        }

        public void setInClassPath(boolean value) {
            this.inClassPath = value;
        }
    }
}

