/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.rescfg;

import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceAdmin;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.rescfg.ConfigurationDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;

public class ConfInstlDlgDestinationsPnl
extends JPanel {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgDestinationsPnl == null ? (class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgDestinationsPnl = ConfInstlDlgDestinationsPnl.class$("com.sun.enterprise.tools.deployment.ui.rescfg.ConfInstlDlgDestinationsPnl")) : class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgDestinationsPnl);
    private static String TOPIC_DEST_BOX = localStrings.getLocalString("ui.confinstldlgdestinationspnl.topicdestinationsbox", "JMS Topic Destinations");
    private static String QUEUE_DEST_BOX = localStrings.getLocalString("ui.confinstldlgdestinationspnl.queuedestinationsbox", "JMS Queue Destinations");
    private static String JNDI_NAME = localStrings.getLocalString("ui.confinstldlgdestinationspnl.jndiname", "JNDI Name");
    private static String ADD_BTN = localStrings.getLocalString("ui.configurationdialog.add", "Add");
    private static String REMOVE_BTN = localStrings.getLocalString("ui.configurationdialog.remove", "Remove...");
    public static final String TOPIC = "topic";
    public static final String QUEUE = "queue";
    private JndiTable topicTable;
    private JndiTableModel topicTableModel;
    private JndiTable queueTable;
    private JndiTableModel queueTableModel;
    private JButton topicRemoveBtn;
    private JButton queueRemoveBtn;
    private Vector jmsResToBeDeleted = null;
    private Vector originalJmsResNames = null;
    private boolean isChanged = false;
    private boolean debug = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$rescfg$ConfInstlDlgDestinationsPnl;
    static /* synthetic */ Class class$javax$swing$JFrame;

    public ConfInstlDlgDestinationsPnl() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints gbc = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledTable topicPanel = null;
        topicPanel = new UITitledTable(TOPIC_DEST_BOX, true);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        this.add((Component)topicPanel, gbc);
        this.topicTable = new JndiTable(new JndiTableModel());
        topicPanel.setTableView(this.topicTable);
        JButton topicAddBtn = new JButton(ADD_BTN);
        topicAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgDestinationsPnl.this.addTopic(e10);
            }
        });
        topicPanel.addControlButton(topicAddBtn);
        this.topicRemoveBtn = new JButton(REMOVE_BTN);
        this.topicRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgDestinationsPnl.this.removeTopic(e10);
            }
        });
        topicPanel.addSelectionEnabledButton(this.topicRemoveBtn);
        UITitledTable queuePanel = null;
        queuePanel = new UITitledTable(QUEUE_DEST_BOX, true);
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(5, 5, 5, 5);
        gbc.fill = 1;
        this.add((Component)queuePanel, gbc);
        this.queueTable = new JndiTable(new JndiTableModel());
        queuePanel.setTableView(this.queueTable);
        JButton queueAddBtn = new JButton(ADD_BTN);
        queueAddBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgDestinationsPnl.this.addQueue(e10);
            }
        });
        queuePanel.addControlButton(queueAddBtn);
        this.queueRemoveBtn = new JButton(REMOVE_BTN);
        this.queueRemoveBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ConfInstlDlgDestinationsPnl.this.removeQueue(e10);
            }
        });
        queuePanel.addSelectionEnabledButton(this.queueRemoveBtn);
        this.refresh();
    }

    public void refresh() {
        this.getTopicTableModel().removeAllRows();
        this.getQueueTableModel().removeAllRows();
        this.getTopicTableModel().fireTableDataChanged();
        this.getQueueTableModel().fireTableDataChanged();
        this.jmsResToBeDeleted = new Vector();
        this.originalJmsResNames = new Vector();
        ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
        try {
            Set jmsRes = resAdmin.getResources(1);
            Iterator itr = jmsRes.iterator();
            while (itr.hasNext()) {
                String resourceName;
                JmsDestinationResource resource = (JmsDestinationResource)itr.next();
                if (resource == null || (resourceName = resource.getName()) == null || resourceName.equals("")) continue;
                DestinationObject obj = null;
                if (!resource.getIsQueue()) {
                    obj = new DestinationObject(resourceName, TOPIC);
                    this.getTopicTableModel().addRow(obj);
                    this.originalJmsResNames.add(resourceName);
                    continue;
                }
                obj = new DestinationObject(resourceName, QUEUE);
                this.getQueueTableModel().addRow(obj);
                this.originalJmsResNames.add(resourceName);
            }
            this.getTopicTableModel().fireTableDataChanged();
            this.getQueueTableModel().fireTableDataChanged();
        }
        catch (J2EEResourceException e10) {
            System.out.println("J2EEResourceException: There was a problem while getting resources");
            e10.printStackTrace();
        }
    }

    public void addTopic(ActionEvent evt) {
        int index = this.getTopicTableModel().findRowWithValue(0, 0, "");
        if (index > 0) {
            return;
        }
        this.getTopicTableModel().addRow(new DestinationObject("", TOPIC));
        this.getTopicTableModel().fireTableDataChanged();
    }

    public void removeTopic(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.topicTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        DestinationObject obj = null;
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confinstldlgdestinationspnl.removejndinamesconfirmation", "Are you sure you want to delete selected JNDI Name(s)?"), "Delete JNDI Names", 0)) == 0) {
            Vector<DestinationObject> objs = new Vector<DestinationObject>();
            while (minIndex <= maxIndex) {
                obj = this.getTopicTableModel().getRow(minIndex);
                objs.add(obj);
                ++minIndex;
            }
            this.getTopicTableModel().removeRows(objs);
            this.jmsResToBeDeleted.addAll(objs);
            this.getTopicTableModel().fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void addQueue(ActionEvent evt) {
        int index = this.getQueueTableModel().findRowWithValue(0, 0, "");
        if (index > 0) {
            return;
        }
        this.getQueueTableModel().addRow(new DestinationObject("", QUEUE));
        this.getQueueTableModel().fireTableDataChanged();
    }

    public void removeQueue(ActionEvent evt) {
        int n2;
        ListSelectionModel sm = this.queueTable.getSelectionModel();
        int minIndex = sm.getMinSelectionIndex();
        int maxIndex = sm.getMaxSelectionIndex();
        DestinationObject obj = null;
        if (minIndex >= 0 && (n2 = JOptionPane.showConfirmDialog(this.getFrame(), localStrings.getLocalString("ui.confinstldlgdestinationspnl.removejndinamesconfirmation", "Are you sure you want to delete selected JNDI Name(s)?"), "Confirmation Dialog", 0)) == 0) {
            Vector<DestinationObject> objs = new Vector<DestinationObject>();
            while (minIndex <= maxIndex) {
                obj = this.getQueueTableModel().getRow(minIndex);
                objs.add(obj);
                ++minIndex;
            }
            this.getQueueTableModel().removeRows(objs);
            this.jmsResToBeDeleted.addAll(objs);
            this.getQueueTableModel().fireTableDataChanged();
            this.setDirty(true);
        }
    }

    public void addToDelResource(DestinationObject obj) {
        this.jmsResToBeDeleted.add(obj);
        this.setDirty(true);
    }

    private JndiTableModel getTopicTableModel() {
        return (JndiTableModel)this.topicTable.getModel();
    }

    private JndiTableModel getQueueTableModel() {
        return (JndiTableModel)this.queueTable.getModel();
    }

    private JFrame getFrame() {
        return (JFrame)SwingUtilities.getAncestorOfClass(class$javax$swing$JFrame == null ? (class$javax$swing$JFrame = ConfInstlDlgDestinationsPnl.class$("javax.swing.JFrame")) : class$javax$swing$JFrame, this);
    }

    private void setDirty(boolean value) {
        this.isChanged = value;
    }

    private boolean isDirty() {
        return this.isChanged;
    }

    private boolean isValueExists(String name) {
        if (name.equals("")) {
            return false;
        }
        int noOfTopics = this.getTopicTableModel().getRowCount();
        int i2 = 0;
        while (i2 < noOfTopics) {
            String resName = (String)this.getTopicTableModel().getValueAt(i2, 0);
            if (resName.equalsIgnoreCase(name)) {
                return true;
            }
            ++i2;
        }
        int noOfQueues = this.getQueueTableModel().getRowCount();
        int i3 = 0;
        while (i3 < noOfTopics) {
            String resName = (String)this.getQueueTableModel().getValueAt(i3, 0);
            if (resName.equalsIgnoreCase(name)) {
                return true;
            }
            ++i3;
        }
        return false;
    }

    public void saveData() {
        if (this.isDirty()) {
            ResourceAdmin resAdmin = ConfigurationDialog.getResourceAdmin();
            try {
                Hashtable<String, String> allRes = new Hashtable<String, String>();
                DestinationObject obj = null;
                String resName = "";
                if (this.debug) {
                    System.out.println("\n\n Merging two view's data:");
                }
                int noOfTopics = this.getTopicTableModel().getRowCount();
                int i2 = 0;
                while (i2 < noOfTopics) {
                    obj = this.getTopicTableModel().getRow(i2);
                    resName = "t_" + obj.getName();
                    allRes.put(resName, obj.getType());
                    if (this.debug) {
                        System.out.println("     Topic Res :" + obj.getName());
                    }
                    ++i2;
                }
                int noOfQueues = this.getQueueTableModel().getRowCount();
                int i3 = 0;
                while (i3 < noOfQueues) {
                    obj = this.getQueueTableModel().getRow(i3);
                    resName = "q_" + obj.getName();
                    allRes.put(resName, obj.getType());
                    if (this.debug) {
                        System.out.println("     Queue Res :" + obj.getName());
                    }
                    ++i3;
                }
                if (this.debug) {
                    System.out.println("\n\n Removing del/modfied res from Property File:");
                }
                int i4 = 0;
                while (i4 < this.jmsResToBeDeleted.size()) {
                    obj = (DestinationObject)this.jmsResToBeDeleted.elementAt(i4);
                    resName = obj.getName();
                    if (!resName.equals("") && this.originalJmsResNames.contains(resName)) {
                        resAdmin.removeResource(resName, 1);
                        this.originalJmsResNames.remove(resName);
                        if (this.debug) {
                            System.out.println("     del/modfied Res :" + resName + "  Type: " + "");
                        }
                    }
                    ++i4;
                }
                if (this.debug) {
                    System.out.println("\n\n Add New Resources to Property File:");
                }
                Enumeration keys = allRes.keys();
                String type = "";
                while (keys.hasMoreElements()) {
                    resName = (String)keys.nextElement();
                    type = (String)allRes.get(resName);
                    if ((resName = resName.substring(2, resName.length())).equals("") || this.originalJmsResNames.contains(resName)) continue;
                    JmsDestinationResource resource = new JmsDestinationResource(resName);
                    if (type.equals(QUEUE)) {
                        resource.setIsQueue(true);
                    } else {
                        if (!type.equals(TOPIC)) continue;
                        resource.setIsQueue(false);
                    }
                    resAdmin.addResource(resource);
                    if (!this.debug) continue;
                    System.out.println("     Added Res :" + resName + "  Type: " + type);
                }
            }
            catch (J2EEResourceException e10) {
                System.out.println("J2EEResourceException: There was a problem while saving resources");
                e10.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        JFrame frm = new JFrame();
        frm.getContentPane().setLayout(new BorderLayout());
        frm.getContentPane().add(new ConfInstlDlgDestinationsPnl());
        ((Component)frm).setSize(450, 350);
        frm.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e10) {
                System.exit(0);
            }
        });
        ((Component)frm).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JndiTableModel
    extends InspectorTableModel {
        public JndiTableModel(String[] columnNames) {
            super(columnNames);
        }

        public JndiTableModel() {
            this(new String[]{JNDI_NAME});
        }

        public void addRow(Object row) {
            super.getData().add(row);
        }

        public void removeRow(int index) {
            super.getData().remove(index);
        }

        public void removeRows(Collection rows) {
            super.getData().removeAll(rows);
        }

        public void removeAllRows() {
            super.getData().clear();
        }

        public DestinationObject getRow(int index) {
            if (index < 0 || index >= this.getRowCount()) {
                return null;
            }
            return (DestinationObject)super.getRowObject(index);
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return super.getData().size();
        }

        public String getColumnName(int col) {
            return this.columnNames[col].toString();
        }

        public boolean isCellEditable(int row, int col) {
            return true;
        }

        public Object getValueAt(int row, int col) {
            String value = "";
            Object obj = super.getRowObject(row);
            switch (col) {
                case 0: {
                    value = ((DestinationObject)obj).getName();
                    break;
                }
            }
            return value;
        }

        public void setValueAt(Object value, int row, int col) {
            DestinationObject obj = (DestinationObject)super.getRowObject(row);
            String originalName = obj.getName();
            if (!originalName.equals(value)) {
                switch (col) {
                    case 0: {
                        obj.setName((String)value);
                        break;
                    }
                }
                ConfInstlDlgDestinationsPnl.this.addToDelResource(new DestinationObject(originalName, obj.getType()));
            }
        }

        public Object getObjectValue(Object obj, int col) {
            return null;
        }

        public void setObjectValue(Object obj, int col, Object value) {
        }
    }

    class JndiTable
    extends InspectorTable {
        public JndiTable(JndiTableModel model) {
            super(model);
            this.setSelectionMode(1);
        }
    }

    class DestinationObject {
        private String name;
        private String type;

        public DestinationObject(String name, String type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String toString() {
            this.name = this.name;
            return this.name;
        }
    }
}

