/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.ServletFilterDescriptor;
import com.sun.enterprise.deployment.ServletFilterMappingDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.WebServletFiltersInspector;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class WebServletFilterMapInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFilterMapInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFilterMapInspector = WebServletFilterMapInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebServletFilterMapInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFilterMapInspector);
    private static final String MAP_TABLE_TITLE = localStrings.getLocalString("ui.webservletfiltermapinspector.map_table_title", "Servlet Filter Mapping");
    private static final String MOVE_UP = localStrings.getLocalString("ui.webservletfiltermapinspector.move_up", "Move Up");
    private static final String MOVE_DOWN = localStrings.getLocalString("ui.webservletfiltermapinspector.move_down", "Move Down");
    private static final String EDIT_FILTER = localStrings.getLocalString("ui.webservletfiltermapinspector.edit_filter", "Edit Filter List...");
    private static final String URL_PATTERN = localStrings.getLocalString("ui.webservletfiltermapinspector.type_url_pattern", "URL Pattern");
    private static final String SERVLET = localStrings.getLocalString("ui.webservletfiltermapinspector.type_servlet", "Servlet");
    private static final String TABLE_DISPLAY_NAME = localStrings.getLocalString("ui.webservletfiltermapinspector.column_display_name", "Filter Display Name");
    private static final String TABLE_TARGET_TYPE = localStrings.getLocalString("ui.webservletfiltermapinspector.column_target_type", "Target Type");
    private static final String TABLE_TARGETS = localStrings.getLocalString("ui.webservletfiltermapinspector.column_target", "Targets");
    private static final String TABNAME = localStrings.getLocalString("ui.webservletfiltermapinspector.tabname", "Filter Mapping");
    private static String wizardHelpID = "ServletFilterMaps";
    private static String deployHelpID = "ServletFilterMaps";
    private WebBundleDescriptor descriptor = null;
    private UITitledTable mapPanel = null;
    private ServletFilterMapTable mapTable = null;
    private ServletFilterMapTableModel mapTableModel = null;
    private InspectorPane.InspectorPaneDialog servletFilterDialog = null;
    private String[] targetTypeTitles = new String[]{SERVLET, URL_PATTERN};
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebServletFilterMapInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebBundleDescriptor;

    private static final String SERVLET_FILTERS_FOR(String v0) {
        return localStrings.getLocalString("ui.webservletfiltermapinspector.servlet_filters_for", "Servlet Filters for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebServletFilterMapInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebBundleDescriptor == null ? (class$com$sun$enterprise$deployment$WebBundleDescriptor = WebServletFilterMapInspector.class$("com.sun.enterprise.deployment.WebBundleDescriptor")) : class$com$sun$enterprise$deployment$WebBundleDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebBundleDescriptor ? (WebBundleDescriptor)desc : (desc instanceof WebComponentDescriptorImpl ? ((WebComponentDescriptorImpl)desc).getWebBundleDescriptor() : null);
            this.mapTable.clearTableData();
            if (this.descriptor != null && this.servletFilterDialog != null) {
                this.servletFilterDialog.setDescriptor(this.descriptor);
            }
        }
    }

    private WebServletFilterMapInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        this.mapPanel = new UITitledTable(MAP_TABLE_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.mapPanel, c10);
        this.mapTableModel = new ServletFilterMapTableModel();
        this.mapTable = new ServletFilterMapTable(this.mapTableModel);
        this.mapPanel.setTableView(this.mapTable);
        UIButton addButton = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFilterMapInspector.this.addAction();
            }
        });
        this.mapPanel.addControlButton(addButton);
        UIButton delButton = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFilterMapInspector.this.deleteAction();
            }
        });
        this.mapPanel.addSelectionEnabledButton(delButton);
        this.mapPanel.addControlSpacer();
        UIButton mvUpBtn = new UIButton(MOVE_UP, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFilterMapInspector.this.moveUpAction();
            }
        });
        this.mapPanel.addSelectionEnabledButton(mvUpBtn);
        UIButton mvDnBtn = new UIButton(MOVE_DOWN, null, new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebServletFilterMapInspector.this.moveDownAction();
            }
        });
        this.mapPanel.addSelectionEnabledButton(mvDnBtn);
        if (this.isDeploymentMode()) {
            this.mapPanel.addControlSpacer();
            UIButton edPB = new UIButton(EDIT_FILTER, null, new ActionListener(){

                public void actionPerformed(ActionEvent ae2) {
                    WebServletFilterMapInspector.this.editFilterAction();
                }
            });
            this.mapPanel.addControlButton(edPB);
        }
    }

    private WebBundleDescriptor getWebBundleDescriptor() {
        Descriptor d10 = this.getBundleDescriptor();
        if (d10 == null) {
            return null;
        }
        if (d10 instanceof WebBundleDescriptor) {
            return (WebBundleDescriptor)d10;
        }
        UIUtils.printImplementationError("WebServletFilterMapInspector.getWebBundleDescriptor", "Unrecognized bundle descriptor - " + d10.getClass().getName());
        return null;
    }

    public void refresh() {
        this.mapTable.updateTableData(this.descriptor.getServletFilterMappingDescriptors());
        Vector filterNameList = this.getFilterNames();
        Vector servletNameList = this.getServletNames();
        this.mapTable.resetEditors(filterNameList, servletNameList);
    }

    private ServletFilterMappingDescriptor getSelectedServletFilterMap() {
        return (ServletFilterMappingDescriptor)this.mapTable.getSelectedRowObject();
    }

    private Vector getFilterNames() {
        Vector<String> v2 = new Vector<String>();
        Vector sf = this.descriptor.getServletFilterDescriptors();
        Enumeration e10 = sf.elements();
        while (e10.hasMoreElements()) {
            Descriptor d10 = (Descriptor)e10.nextElement();
            v2.add(((ServletFilterDescriptor)d10).getDisplayName());
        }
        return v2;
    }

    private ServletFilterDescriptor getFilterByName(String name) {
        Vector sf = this.descriptor.getServletFilterDescriptors();
        Enumeration e10 = sf.elements();
        while (e10.hasMoreElements()) {
            ServletFilterDescriptor sfd = (ServletFilterDescriptor)e10.nextElement();
            if (!sfd.getName().equals(name)) continue;
            return sfd;
        }
        return null;
    }

    private Vector getServletNames() {
        WebBundleDescriptor wbd = this.getWebBundleDescriptor();
        Set webSet = wbd != null ? wbd.getWebComponentDescriptorsSet() : new HashSet();
        Vector<String> v2 = new Vector<String>();
        Iterator i2 = webSet.iterator();
        while (i2.hasNext()) {
            Descriptor d10 = (Descriptor)i2.next();
            if (!(d10 instanceof ServletDescriptorImpl)) continue;
            v2.add(d10.getName());
        }
        return v2;
    }

    private void addAction() {
        if (this.mapTable.getRowWithValue(0, "") == null) {
            ServletFilterMappingDescriptor ref = new ServletFilterMappingDescriptor("", "Servlet", "");
            this.descriptor.addServletFilterMapping(ref);
        }
        this.mapTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteAction() {
        Object[] list = this.mapTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                ServletFilterMappingDescriptor ref = (ServletFilterMappingDescriptor)list[i2];
                this.descriptor.removeServletFilterMapping(ref);
                ++i2;
            }
        }
        this.invokeRefresh();
    }

    private void moveUpAction() {
        ServletFilterMappingDescriptor ref = this.getSelectedServletFilterMap();
        if (ref != null) {
            this.descriptor.moveServletFilterMapping(ref, -1);
        }
        this.invokeRefresh();
    }

    private void moveDownAction() {
        ServletFilterMappingDescriptor ref = this.getSelectedServletFilterMap();
        if (ref != null) {
            this.descriptor.moveServletFilterMapping(ref, 1);
        }
        this.invokeRefresh();
    }

    private void editFilterAction() {
        if (this.servletFilterDialog == null) {
            InspectorPane ip = WebServletFiltersInspector.newInspectorPane(this.getInspectorMode(), null);
            this.servletFilterDialog = ip.createInspectorPaneDialog(this.getOwner(), this, true);
        }
        this.servletFilterDialog.setDescriptor(this.descriptor);
        this.servletFilterDialog.setLocationRelativeTo(this);
        this.servletFilterDialog.setTitle(WebServletFilterMapInspector.SERVLET_FILTERS_FOR(this.descriptor.getName()));
        this.servletFilterDialog.show();
        this.invokeRefresh();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class ServletFilterMapTableModel
    extends InspectorTableModel {
        public ServletFilterMapTableModel() {
            super(new String[]{TABLE_DISPLAY_NAME, TABLE_TARGET_TYPE, TABLE_TARGETS});
            this.setDataOrdering(2);
        }

        public ServletFilterMappingDescriptor getRow(int index) {
            return (ServletFilterMappingDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            ServletFilterMappingDescriptor ref = (ServletFilterMappingDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.isURLPatternTarget() ? URL_PATTERN : SERVLET;
                    break;
                }
                case 2: {
                    value = ref.getTarget();
                    if (value != null) break;
                    value = "";
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ServletFilterMappingDescriptor ref = (ServletFilterMappingDescriptor)obj;
            if (ref == null) {
                return;
            }
            switch (col) {
                case 0: {
                    ref.setName(value.toString());
                    break;
                }
                case 1: {
                    ref.setTargetType(value.equals(URL_PATTERN) ? "URLPattern" : "Servlet");
                    break;
                }
                case 2: {
                    ref.setTarget(value.toString());
                }
            }
        }
    }

    private class ServletFilterMapTable
    extends InspectorTable {
        DefaultCellEditor filterNames = null;
        DefaultCellEditor targetTypes = null;
        DefaultCellEditor URLPatterns = null;
        DefaultCellEditor servletNames = null;

        public ServletFilterMapTable(ServletFilterMapTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
        }

        public void resetEditors(Vector filters, Vector servlets) {
            this.filterNames = new DefaultCellEditor(new JComboBox(filters));
            if (this.targetTypes == null) {
                this.targetTypes = new DefaultCellEditor(new JComboBox<String>(WebServletFilterMapInspector.this.targetTypeTitles));
            }
            if (this.URLPatterns == null) {
                this.URLPatterns = new DefaultCellEditor(new JTextField());
            }
            this.servletNames = new DefaultCellEditor(new JComboBox(servlets));
        }

        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor rtn = null;
            switch (col) {
                case 0: {
                    rtn = this.filterNames;
                    break;
                }
                case 1: {
                    rtn = this.targetTypes;
                    break;
                }
                case 2: {
                    rtn = this.getModel().getValueAt(row, 1).equals(URL_PATTERN) ? this.URLPatterns : this.servletNames;
                    break;
                }
                default: {
                    rtn = super.getCellEditor(row, col);
                }
            }
            return rtn;
        }
    }
}

