/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.JspDescriptorImpl;
import com.sun.enterprise.deployment.ServletDescriptorImpl;
import com.sun.enterprise.deployment.WebBundleArchivist;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptorImpl;
import com.sun.enterprise.tools.deployment.main.ApplicationManager;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JPanel;

public class WebComponentGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentGeneralInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentGeneralInspector = WebComponentGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.WebComponentGeneralInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentGeneralInspector);
    private static final String SERVLET_CLASSFILE_LABEL = localStrings.getLocalString("ui.webcomponentgeneralinspector.servlet_class", "Servlet Class:");
    private static final String JSP_CLASSFILE_LABEL = localStrings.getLocalString("ui.webcomponentgeneralinspector.jsp_filename", "JSP Filename:");
    private static final String WEB_COMP_NAME = localStrings.getLocalString("ui.webcomponentgeneralinspector.name", "Web Component Name:");
    private static final String WEB_COMP_DISPLAY_NAME = localStrings.getLocalString("ui.webcomponentgeneralinspector.display_name", "Web Component Display Name:");
    private static final String STARTUP_LOAD_SEQ = localStrings.getLocalString("ui.webcomponentgeneralinspector.startup_seq_pos", "Startup load sequence position:");
    private static final String DEFAULT_STARTUP_SEQ = localStrings.getLocalString("ui.webcomponentgeneralinspector.default_startup_seq_pos", "Load at any time");
    private static final String TABNAME = localStrings.getLocalString("ui.webcomponentgeneralinspector.tabname", "General");
    private static String wizardHelpID = "Prop";
    private static String deployHelpID = "General";
    private WebComponentDescriptorImpl descriptor;
    private UITitledComboBox jspServletCombo = null;
    private UITitledTextField webCompName = null;
    private UITitledTextField webCompDisplayName = null;
    private UITitledComboBox startupLoadSeqPos = null;
    IconInspector.DialogDisplayButton iconInspector = null;
    DescriptionInspector.DialogDisplayButton descInspector = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$WebComponentGeneralInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WebComponentDescriptorImpl;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new WebComponentGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WebComponentDescriptorImpl == null ? (class$com$sun$enterprise$deployment$WebComponentDescriptorImpl = WebComponentGeneralInspector.class$("com.sun.enterprise.deployment.WebComponentDescriptorImpl")) : class$com$sun$enterprise$deployment$WebComponentDescriptorImpl;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WebComponentDescriptorImpl ? (WebComponentDescriptorImpl)desc : null;
        }
    }

    private WebComponentGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        this.setLayout(new GridBagLayout());
        UITitledBox box = new UITitledBox(null, false);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 0.7;
        gbc.weighty = 0.5;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = new Insets(5, 5, 0, 0);
        gbc.fill = 2;
        gbc.anchor = 18;
        this.add((Component)box, gbc);
        gbc.weightx = 0.3;
        gbc.gridx = 1;
        this.add((Component)new JPanel(), gbc);
        GridBagConstraints c10 = box.getGBConstraints();
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = -1;
        c10.insets = new Insets(7, 0, 0, 0);
        c10.fill = 2;
        c10.anchor = 18;
        this.jspServletCombo = new UITitledComboBox("", false);
        box.add((Component)this.jspServletCombo, c10);
        this.jspServletCombo.setShowSelectionAsToolTip(true);
        this.jspServletCombo.setShowWidePopups(true);
        this.jspServletCombo.setMaximumPreferredSize(new Dimension(100, -1));
        this.jspServletCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                if (WebComponentGeneralInspector.this.descriptor == null) {
                    return;
                }
                String item = (String)WebComponentGeneralInspector.this.jspServletCombo.getSelectedItem();
                if (WebComponentGeneralInspector.this.descriptor instanceof ServletDescriptorImpl) {
                    if (!((ServletDescriptorImpl)WebComponentGeneralInspector.this.descriptor).getClassName().equals(item)) {
                        ((ServletDescriptorImpl)WebComponentGeneralInspector.this.descriptor).setClassName(item);
                    }
                } else if (WebComponentGeneralInspector.this.descriptor instanceof JspDescriptorImpl && !((JspDescriptorImpl)WebComponentGeneralInspector.this.descriptor).getJspFileName().equals(item)) {
                    ((JspDescriptorImpl)WebComponentGeneralInspector.this.descriptor).setJspFileName(item);
                }
            }
        });
        this.jspServletCombo.setReadOnly(this.isDeploymentMode());
        this.webCompName = new UITitledTextField(WEB_COMP_NAME, false);
        box.add((Component)this.webCompName, c10);
        this.webCompName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                WebComponentGeneralInspector.this.webCompDisplayName.setText(WebComponentGeneralInspector.this.webCompName.getText());
                WebComponentGeneralInspector.this.descriptor.setName(WebComponentGeneralInspector.this.webCompName.getText());
            }
        });
        this.webCompDisplayName = new UITitledTextField(WEB_COMP_DISPLAY_NAME, false);
        this.webCompDisplayName.setReadOnly(true);
        box.add((Component)this.webCompDisplayName, c10);
        this.webCompDisplayName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
            }
        });
        this.startupLoadSeqPos = new UITitledComboBox(STARTUP_LOAD_SEQ, false);
        this.startupLoadSeqPos.addItem(DEFAULT_STARTUP_SEQ);
        this.startupLoadSeqPos.setEditable(true);
        box.add((Component)this.startupLoadSeqPos, c10);
        this.startupLoadSeqPos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                int val = WebComponentGeneralInspector.this.startupLoadSeqPos.getIntValue(-1);
                WebComponentGeneralInspector.this.descriptor.setLoadOnStartUp(val);
            }
        });
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        box.add((Component)this.descInspector, c10);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        box.add((Component)this.iconInspector, c10);
        this.iconInspector.setEnabled(this.isDeploymentMode());
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridwidth = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        c10.fill = 1;
        box.add((Component)new JPanel(), c10);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("large", iconFile, this.descriptor.getWebBundleDescriptor().getApplication().getApplicationArchivist(), this.descriptor.getWebBundleDescriptor(), this.descriptor);
        }
    }

    public void addSmallIcon(File iconFile) {
        if (this.isDeploymentMode()) {
            this._addDeploymentIcon("small", iconFile, this.descriptor.getWebBundleDescriptor().getApplication().getApplicationArchivist(), this.descriptor.getWebBundleDescriptor(), this.descriptor);
        }
    }

    public void setComponentClassModel(Collection classFiles) {
        if (classFiles == null) {
            this.jspServletCombo.clearModel();
        } else {
            Object componentName = this.jspServletCombo.getSelectedItem();
            this.jspServletCombo.setModel(classFiles);
            if (componentName != null) {
                this.jspServletCombo.setSelectedItem(componentName);
            } else {
                this.jspServletCombo.setSelectedIndex(-1);
            }
        }
    }

    private void setComponentClassModel(DefaultComboBoxModel model, Object sel) {
        if (model == null) {
            this.jspServletCombo.clearModel();
        } else {
            this.jspServletCombo.setModel(model);
            if (sel != null) {
                if (!this.jspServletCombo.containsItem(sel)) {
                    this.jspServletCombo.addItem(sel);
                }
                this.jspServletCombo.setSelectedItem(sel);
            } else {
                this.jspServletCombo.setSelectedIndex(-1);
            }
        }
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        boolean isServlet = this.descriptor instanceof ServletDescriptorImpl;
        boolean isJsp = this.descriptor instanceof JspDescriptorImpl;
        boolean isHelper = this.descriptor != null && !isServlet && !isJsp;
        String currentSel = null;
        if (isServlet) {
            this.jspServletCombo.setVisible(true);
            this.jspServletCombo.setTitle(SERVLET_CLASSFILE_LABEL);
            currentSel = ((ServletDescriptorImpl)this.descriptor).getClassName();
        } else if (isJsp) {
            this.jspServletCombo.setVisible(true);
            this.jspServletCombo.setTitle(JSP_CLASSFILE_LABEL);
            currentSel = ((JspDescriptorImpl)this.descriptor).getJspFileName();
        } else if (isHelper) {
            this.jspServletCombo.setVisible(false);
            this.jspServletCombo.setTitle("");
            currentSel = "";
        }
        if (this.isDeploymentMode()) {
            WebBundleDescriptor wbd = this.descriptor.getWebBundleDescriptor();
            if (wbd == null) {
                return;
            }
            ApplicationManager am2 = InspectorPane.getApplicationManager();
            Application app = am2.getActiveApplication();
            if (wbd.getApplication() == null) {
                wbd.setApplication(app);
            }
            if (isServlet) {
                DefaultComboBoxModel<String> classModel = new DefaultComboBoxModel<String>();
                String item = "?";
                try {
                    Vector v2 = wbd.getArchivist().getClassNames();
                    int n2 = 0;
                    while (n2 < v2.size()) {
                        item = (String)v2.elementAt(n2);
                        classModel.addElement(item);
                        ++n2;
                    }
                }
                catch (Throwable t2) {
                    UIUtils.debugPrintln("Servlet ComboBox update exeption: (" + item + ") " + t2.toString());
                }
                this.setComponentClassModel(classModel, currentSel);
            } else if (isJsp) {
                DefaultComboBoxModel<String> classModel = new DefaultComboBoxModel<String>();
                String item = "?";
                try {
                    Vector v3 = ((WebBundleArchivist)wbd.getArchivist()).getJspFileNames();
                    int n3 = 0;
                    while (n3 < v3.size()) {
                        item = (String)v3.elementAt(n3);
                        classModel.addElement(item);
                        ++n3;
                    }
                }
                catch (Throwable t3) {
                    UIUtils.debugPrintln("JSP ComboBox update exeption: (" + item + ") " + t3.toString());
                }
                this.setComponentClassModel(classModel, currentSel);
            } else if (isHelper) {
                this.setComponentClassModel(null, null);
            } else {
                UIUtils.printImplementationError("Unknown descriptor class - " + this.descriptor.getClass().getName());
            }
        } else if (this.jspServletCombo.isVisible()) {
            if (this.jspServletCombo.containsItem(currentSel)) {
                this.jspServletCombo.setSelectedItem(currentSel);
            } else {
                this.jspServletCombo.setSelectedIndex(-1);
            }
        }
        this.webCompName.setText(this.descriptor.getName());
        this.webCompDisplayName.setText(this.descriptor.getName());
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getName(), this, this.descriptor);
        int seq = this.descriptor.getLoadOnStartUp();
        if (seq < 0) {
            this.startupLoadSeqPos.setText(DEFAULT_STARTUP_SEQ);
        } else {
            this.startupLoadSeqPos.setIntValue(seq);
        }
    }

    public String getJspFileOrServerClassname() {
        return (String)this.jspServletCombo.getSelectedItem();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

