/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MailConfiguration;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.WritableJndiNameEnvironment;
import com.sun.enterprise.resource.ResourcePrincipal;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UICardPanel;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIJndiName;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledPasswordField;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import com.sun.enterprise.util.NotificationListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class ResourceRefsInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector = ResourceRefsInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.ResourceRefsInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector);
    private static String RESFACT_REF = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.resourcefactoriesrefrencedincode", "Resource factories referenced in code");
    private static String DEPLOYMENT_SETTINGS = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettings", "Deployment Settings");
    private static String JNDI_NAME = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.linkvalue", "JNDI Name:");
    private static String URL_TITLE = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.url", "URL");
    private static String USER_NAME = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.username", "User name:");
    private static String USER_PASS = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.password", "Password:");
    private static String MAIL_FROM = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.from", "From:");
    private static String MAIL_HOST = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.host", "Host:");
    private static String USER_PASSWD_PANEL = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.userpasswdpanel", "Password");
    private static String JAVA_MAIL = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.javamail", "Java Mail");
    private static String URL = "URL";
    private static final String RESREF_TABLE_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.tooltip", "Table of resource references");
    private static final String RESREF_TYPE_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.type.tooltip", "Click to Edit Resource Type");
    private static final String RESREF_AUTH_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.auth.tooltip", "Click to Edit Resource Authentication");
    private static final String RESREF_SHARE_TOOLTIP = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.sharable.tooltip", "Click to Toggle Sharable Scope");
    private static final String REFREF_COL_CODEDNAME = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.coded_name", "Coded Name");
    private static final String RESREF_COL_TYPE = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.type", "Type");
    private static final String RESREF_COL_AUTH = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.auth", "Authentication");
    private static final String RESREF_COL_SHARABLE = localStrings.getLocalString("ui.resourcerefsinspector.resfact_table.sharable", "Sharable");
    private static String TABNAME = localStrings.getLocalString("ui.resourcerefsinspector.tabname", "Resource Ref's");
    private static String wizardHelpID = "ResourceRef";
    private static String deployHelpID = "ResourceRef";
    private WritableJndiNameEnvironment descriptor;
    ResourceRefsTableModel resourceRefsTableModel;
    ResourceRefsTable resourceRefsTable;
    JButton addPB;
    JButton delPB;
    UITitledBox deploymentSettingsPanel;
    UITitledTextField urlValueText = null;
    UIJndiName linkValueText = null;
    UIJndiName jndiNameText = null;
    UITitledTextField userNameText;
    UITitledPasswordField passwdText;
    UITitledTextField mailFromText;
    UITitledTextField mailHostText;
    UITitledTextField mailUserNameText;
    UICardPanel lowerCardPanel;
    UICardPanel upperCardPanel;
    String[] resourceTypes = new String[]{"javax.sql.DataSource", "javax.mail.Session", "java.net.URL", "javax.jms.QueueConnectionFactory", "javax.jms.TopicConnectionFactory", "javax.resource.cci.ConnectionFactory"};
    String[] authTypes = new String[]{ResourceReferenceDescriptor.CONTAINER_AUTHORIZATION, ResourceReferenceDescriptor.APPLICATION_AUTHORIZATION};
    public final String JNDI_COMBO_PANEL = "jndiCombo";
    public final String JNDI_TEXT_PANEL = "jndiText";
    public final String URL_TEXT_PANEL = "urlText";
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$ResourceRefsInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$WritableJndiNameEnvironment;

    private static String DEPLOYMENT_SETTINGS_FOR(String v0) {
        return localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.deploymentsettingsfor", "Deployment Settings for {0}", new Object[]{v0});
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ResourceRefsInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$WritableJndiNameEnvironment == null ? (class$com$sun$enterprise$deployment$WritableJndiNameEnvironment = ResourceRefsInspector.class$("com.sun.enterprise.deployment.WritableJndiNameEnvironment")) : class$com$sun$enterprise$deployment$WritableJndiNameEnvironment;
    }

    public Descriptor getDescriptor() {
        return (Descriptor)((Object)this.descriptor);
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof WritableJndiNameEnvironment ? (WritableJndiNameEnvironment)((Object)desc) : null;
            this.resourceRefsTable.clearTableData();
        }
    }

    private ResourceRefsInspector(String mode) {
        this.initializeLayout();
        this.setInspectorMode(mode);
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        UITitledBox titledBox = new UITitledBox(RESFACT_REF, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)titledBox, c10);
        UITitledTable resourceRefsPanel = new UITitledTable(null, false);
        titledBox.addWithGBConstraints(resourceRefsPanel);
        this.resourceRefsTable = new ResourceRefsTable(new ResourceRefsTableModel());
        this.resourceRefsTable.getSelectionModel().addListSelectionListener(new ResourceRefsSelectionListener());
        this.resourceRefsTable.setAutoResizeMode(4);
        resourceRefsPanel.getGBConstraints().weighty = 0.85;
        resourceRefsPanel.setTableView(this.resourceRefsTable);
        this.addPB = UIButton.createAddButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResourceRefsInspector.this.addResourceRefAction();
            }
        });
        resourceRefsPanel.addControlButton(this.addPB);
        this.delPB = UIButton.createDeleteButton(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ResourceRefsInspector.this.deleteResourceRefAction();
            }
        }, true);
        resourceRefsPanel.addSelectionEnabledButton(this.delPB);
        this.deploymentSettingsPanel = new UITitledBox(DEPLOYMENT_SETTINGS, true);
        GridBagConstraints gbc = titledBox.getGBConstraints();
        gbc.weighty = 0.0;
        gbc.insets.top = 5;
        gbc.insets.right = 85;
        titledBox.addWithGBConstraints(this.deploymentSettingsPanel);
        this.upperCardPanel = new UICardPanel();
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        this.deploymentSettingsPanel.add((Component)this.upperCardPanel, c10);
        JPanel jndiTextPanel = new JPanel(new BorderLayout());
        this.linkValueText = new UIJndiName(false);
        this.linkValueText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeLinkValue(ResourceRefsInspector.this.linkValueText.getJndiName());
            }
        });
        jndiTextPanel.add(this.linkValueText);
        this.upperCardPanel.addCard(jndiTextPanel, "jndiText");
        JPanel urlTextPanel = new JPanel(new BorderLayout());
        this.urlValueText = new UITitledTextField(URL_TITLE + ":", false);
        this.urlValueText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeLinkValue(ResourceRefsInspector.this.urlValueText.getText());
            }
        });
        urlTextPanel.add(this.urlValueText);
        this.upperCardPanel.addCard(urlTextPanel, "urlText");
        JPanel jndiComboPanel = new JPanel(new BorderLayout());
        this.jndiNameText = new UIJndiName(false);
        this.jndiNameText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeJndiComboValue();
            }
        });
        jndiComboPanel.add(this.jndiNameText);
        this.upperCardPanel.addCard(jndiComboPanel, "jndiCombo");
        this.lowerCardPanel = new UICardPanel();
        c10 = this.deploymentSettingsPanel.getGBConstraintsCopy();
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        this.deploymentSettingsPanel.add((Component)this.lowerCardPanel, c10);
        JPanel userPasswdPanel = new JPanel(new GridBagLayout());
        this.lowerCardPanel.addCard(userPasswdPanel, USER_PASSWD_PANEL);
        this.userNameText = new UITitledTextField(USER_NAME, false);
        this.userNameText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeUserName();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 7);
        userPasswdPanel.add((Component)this.userNameText, c10);
        this.passwdText = new UITitledPasswordField(USER_PASS, false);
        this.passwdText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storePassword();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        userPasswdPanel.add((Component)this.passwdText, c10);
        JPanel urlPanel = new JPanel();
        this.lowerCardPanel.addCard(urlPanel, URL);
        JPanel mailPanel = new JPanel(new GridBagLayout());
        this.lowerCardPanel.addCard(mailPanel, JAVA_MAIL);
        this.mailFromText = new UITitledTextField(MAIL_FROM, false);
        this.mailFromText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeMailConfig();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 7);
        mailPanel.add((Component)this.mailFromText, c10);
        this.mailHostText = new UITitledTextField(MAIL_HOST, false);
        this.mailHostText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeMailConfig();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 1;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 7);
        mailPanel.add((Component)this.mailHostText, c10);
        this.mailUserNameText = new UITitledTextField(USER_NAME, false);
        this.mailUserNameText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ResourceRefsInspector.this.storeMailConfig();
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 2;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 0, 0, 0);
        mailPanel.add((Component)this.mailUserNameText, c10);
        this.deSelectAction();
    }

    ResourceReferenceDescriptor getSelectedResourceReference() {
        int minIndex;
        ResourceReferenceDescriptor resourceRef = null;
        ListSelectionModel lsm = this.resourceRefsTable.getSelectionModel();
        if (lsm.isSelectedIndex(minIndex = lsm.getMinSelectionIndex())) {
            resourceRef = this.getTableModel().getRow(minIndex);
        }
        return resourceRef;
    }

    ResourceRefsTableModel getTableModel() {
        return (ResourceRefsTableModel)this.resourceRefsTable.getModel();
    }

    private void deSelectAction() {
        this.jndiNameText.setEnabled(false);
        this.linkValueText.setEnabled(false);
        this.userNameText.setText("");
        this.userNameText.setEnabled(false);
        this.passwdText.setText("");
        this.passwdText.setEnabled(false);
        this.mailFromText.setText("");
        this.mailFromText.setEnabled(false);
        this.mailHostText.setEnabled(false);
        this.mailUserNameText.setText("");
        this.mailUserNameText.setEnabled(false);
        this.deploymentSettingsPanel.setTitle(DEPLOYMENT_SETTINGS);
    }

    private void selectAction() {
        this.showResourceRef(this.getSelectedResourceReference());
        this.jndiNameText.setEnabled(true);
        this.linkValueText.setEnabled(true);
        this.userNameText.setEnabled(true);
        this.passwdText.setEnabled(true);
        this.mailFromText.setEnabled(true);
        this.mailHostText.setEnabled(true);
        this.mailUserNameText.setEnabled(true);
    }

    private void storeLinkValue(String value) {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            resourceRef.setJndiName(value);
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void storeJndiComboValue() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            resourceRef.setJndiName(this.jndiNameText.getJndiName());
            if (this.descriptor != null) {
                ((Descriptor)((Object)this.descriptor)).changed();
            }
        }
    }

    private void storeUserName() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            String rawPassword = new String(this.passwdText.getPassword());
            resourceRef.setResourcePrincipal(new ResourcePrincipal(this.userNameText.getText(), rawPassword.trim()));
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void storePassword() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            String passwd = new String(this.passwdText.getPassword());
            resourceRef.setResourcePrincipal(new ResourcePrincipal(this.userNameText.getText(), passwd));
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void storeMailConfig() {
        ResourceReferenceDescriptor resourceRef = this.getSelectedResourceReference();
        if (resourceRef != null) {
            String userName = this.mailUserNameText.getText();
            String host = this.mailHostText.getText();
            String mailFrom = this.mailFromText.getText();
            MailConfiguration mailConfig = new MailConfiguration(userName, mailFrom, host);
            resourceRef.setMailConfiguration(mailConfig);
            ((Descriptor)((Object)this.descriptor)).changed();
        }
    }

    private void showResourceRef(ResourceReferenceDescriptor resourceRef) {
        MailConfiguration mailConfig;
        if (resourceRef == null) {
            return;
        }
        String resType = resourceRef.getType();
        if (resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.resource.cci.ConnectionFactory")) {
            String jndiName = resourceRef.getJndiName();
            if (UIUtils.debugMode()) {
                this.jndiNameText.setJndiNames(new Object[]{"ConnFactory", "QueConnFactory", "TopicConnFactory"});
            }
            this.jndiNameText.setJndiName(jndiName);
        } else if (resType.equals("java.net.URL")) {
            this.urlValueText.setText(resourceRef.getJndiName());
        } else {
            this.linkValueText.setJndiName(resourceRef.getJndiName());
        }
        this.deploymentSettingsPanel.setTitle(ResourceRefsInspector.DEPLOYMENT_SETTINGS_FOR(resourceRef.getName()));
        this.showResourceType(resType);
        ResourcePrincipal principal = resourceRef.getResourcePrincipal();
        if (principal != null) {
            this.userNameText.setText(principal.getName());
            this.passwdText.setText(principal.getPassword());
        }
        if ((mailConfig = resourceRef.getMailConfiguration()) != null) {
            this.mailUserNameText.setText(mailConfig.getUsername());
            this.mailFromText.setText(mailConfig.getMailFrom());
            this.mailHostText.setText(mailConfig.getMailHost());
        }
    }

    private void addResourceRefAction() {
        if (this.resourceRefsTable.getRowWithValue(0, "") == null) {
            ResourceReferenceDescriptor ref = new ResourceReferenceDescriptor();
            ref.setName("");
            ref.setType(this.resourceTypes[0]);
            ref.setAuthorization(this.authTypes[0]);
            ref.setDescription("");
            this.descriptor.addResourceReferenceDescriptor(ref);
        }
        this.resourceRefsTable.selectRowWithValueOnUpdate(0, "");
        this.invokeRefresh();
    }

    private void deleteResourceRefAction() {
        Object[] list = this.resourceRefsTable.confirmDeleteSelection(null, null);
        if (list != null) {
            int i2 = 0;
            while (i2 < list.length) {
                this.descriptor.removeResourceReferenceDescriptor((ResourceReferenceDescriptor)list[i2]);
                ++i2;
            }
            this.invokeRefresh();
        }
    }

    public void refresh() {
        this.resourceRefsTable.updateTableData(this.descriptor.getResourceReferenceDescriptors());
        this.resourceRefsTable.sizeColumnsToFit(0);
        this.showResourceRef(this.getSelectedResourceReference());
    }

    private void showResourceType(String resType) {
        if (resType.equals("javax.mail.Session")) {
            this.upperCardPanel.showCard("jndiText");
            this.lowerCardPanel.showCard(JAVA_MAIL);
        } else if (resType.equals("java.net.URL")) {
            this.upperCardPanel.showCard("urlText");
            this.lowerCardPanel.showCard(null);
        } else if (resType.equals("javax.jms.QueueConnectionFactory") || resType.equals("javax.jms.TopicConnectionFactory") || resType.equals("javax.resource.cci.ConnectionFactory")) {
            this.upperCardPanel.showCard("jndiCombo");
            this.lowerCardPanel.showCard(USER_PASSWD_PANEL);
        } else {
            this.upperCardPanel.showCard("jndiText");
            this.lowerCardPanel.showCard(USER_PASSWD_PANEL);
        }
    }

    public static void main(String[] args) {
        final ResourceRefsInspector ei2 = new ResourceRefsInspector("WizardMode");
        JFrame f2 = new JFrame();
        ((Component)f2).setBounds(10, 10, 300, 300);
        f2.getContentPane().add(ei2);
        f2.show();
        final EjbSessionDescriptor descriptor = new EjbSessionDescriptor();
        descriptor.addNotificationListener(new NotificationListener(){

            public void notification(NotificationEvent ne) {
                ei2.setDescriptor(descriptor);
            }
        });
        ei2.setDescriptor(descriptor);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class ResourceRefsTableModel
    extends InspectorTableModel {
        ResourceRefsInspector inspector;

        public ResourceRefsTableModel() {
            super(new String[]{REFREF_COL_CODEDNAME, RESREF_COL_TYPE, RESREF_COL_AUTH, RESREF_COL_SHARABLE, DescriptionInspector.DESCRIPTION_COLUMN_INIT});
        }

        public ResourceReferenceDescriptor getRow(int index) {
            return (ResourceReferenceDescriptor)this.getRowObject(index);
        }

        public Object getObjectValue(Object obj, int col) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)obj;
            Object value = null;
            switch (col) {
                case 0: {
                    value = ref.getName();
                    break;
                }
                case 1: {
                    value = ref.getType();
                    break;
                }
                case 2: {
                    value = ref.getAuthorization();
                    break;
                }
                case 3: {
                    value = ref.getSharingScope().equals(ResourceReferenceDescriptor.RESOURCE_SHAREABLE) ? Boolean.TRUE : Boolean.FALSE;
                    break;
                }
                case 4: {
                    value = ref.getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            ResourceReferenceDescriptor ref = (ResourceReferenceDescriptor)obj;
            if (ref == null) {
                return;
            }
            String vs = value.toString();
            switch (col) {
                case 0: {
                    ref.setName(vs);
                    break;
                }
                case 1: {
                    ref.setType(vs);
                    break;
                }
                case 2: {
                    ref.setAuthorization(vs);
                    break;
                }
                case 3: {
                    ref.setSharingScope(vs.equals("true") ? ResourceReferenceDescriptor.RESOURCE_SHAREABLE : ResourceReferenceDescriptor.RESOURCE_UNSHAREABLE);
                    break;
                }
                case 4: {
                    ref.setDescription(vs);
                }
            }
            ((Descriptor)((Object)ResourceRefsInspector.this.descriptor)).changed();
        }
    }

    private class ResourceRefsTable
    extends InspectorTable {
        public ResourceRefsTable(ResourceRefsTableModel model) {
            super(model);
            this.setToolTipText(RESREF_TABLE_TOOLTIP);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
            TableColumn typeColumn = this.getColumnModel().getColumn(1);
            JComboBox<String> typeComboBox = new JComboBox<String>(ResourceRefsInspector.this.resourceTypes);
            typeComboBox.addItemListener(new ResourceTypeItemListener());
            typeComboBox.setEditable(true);
            typeColumn.setCellEditor(new DefaultCellEditor(typeComboBox));
            DefaultTableCellRenderer typeRenderer = new DefaultTableCellRenderer();
            typeRenderer.setToolTipText(RESREF_TYPE_TOOLTIP);
            typeColumn.setCellRenderer(typeRenderer);
            TableColumn authColumn = this.getColumnModel().getColumn(2);
            JComboBox<String> authComboBox = new JComboBox<String>(ResourceRefsInspector.this.authTypes);
            authColumn.setCellEditor(new DefaultCellEditor(authComboBox));
            DefaultTableCellRenderer authRenderer = new DefaultTableCellRenderer();
            authRenderer.setToolTipText(RESREF_AUTH_TOOLTIP);
            authColumn.setCellRenderer(authRenderer);
        }
    }

    private class ResourceTypeItemListener
    implements ItemListener {
        private ResourceTypeItemListener() {
        }

        public void itemStateChanged(ItemEvent evt) {
            String item = (String)evt.getItem();
            ResourceRefsInspector.this.showResourceType(item);
        }
    }

    class ResourceRefsSelectionListener
    implements ListSelectionListener {
        ResourceRefsSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e10) {
            ListSelectionModel sm = (ListSelectionModel)e10.getSource();
            if (sm.isSelectionEmpty()) {
                ResourceRefsInspector.this.deSelectAction();
            } else {
                ResourceRefsInspector.this.selectAction();
            }
        }
    }
}

