/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.ContainerTransaction;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;

public class EjbTransactionInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector = EjbTransactionInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbTransactionInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector);
    private static final String HELP_TAB = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.ejbtxinspectortab", "EJB_Transactions_Inspector_Tab");
    private static final String XACTION_MGMT = localStrings.getLocalString("ui.ejbtransactioninspector.box_title", "Transaction Management");
    private static final String BEAN_MGT_XACTIONS = localStrings.getLocalString("ui.ejbtransactioninspector.bean_managed", "Bean-Managed");
    private static final String CONT_MGT_XACTIONS = localStrings.getLocalString("ui.ejbtransactioninspector.container_managed", "Container-Managed");
    private static final String SHOW_INTERFACES = localStrings.getLocalString("ui.ejbtransactioninspector.show_interface", "Show:");
    private static final String SHOW_LOCAL = localStrings.getLocalString("ui.ejbtransactioninspector.local", "Local");
    private static final String SHOW_LOCAL_HOME = localStrings.getLocalString("ui.ejbtransactioninspector.local_home", "Local Home");
    private static final String SHOW_REMOTE = localStrings.getLocalString("ui.ejbtransactioninspector.remote", "Remote");
    private static final String SHOW_REMOTE_HOME = localStrings.getLocalString("ui.ejbtransactioninspector.remote_home", "Remote Home");
    private static final String TRANS_NOT_SUPPORTED = localStrings.getLocalString("ui.ejbtransactioninspector.trans.not_supported", "Not Supported");
    private static final String TRANS_SUPPORTS = localStrings.getLocalString("ui.ejbtransactioninspector.trans.supports", "Supports");
    private static final String TRANS_REQUIRED = localStrings.getLocalString("ui.ejbtransactioninspector.trans.required", "Required");
    private static final String TRANS_REQUIRES_NEW = localStrings.getLocalString("ui.ejbtransactioninspector.trans.requires_new", "Requires New");
    private static final String TRANS_MANDATORY = localStrings.getLocalString("ui.ejbtransactioninspector.trans.mandatory", "Mandatory");
    private static final String TRANS_NEVER = localStrings.getLocalString("ui.ejbtransactioninspector.trans.never", "Never");
    private static String[] COLUMN_LABELS = new String[]{localStrings.getLocalString("ui.ejbtransactioninspector.cmt_table.method", "Method"), localStrings.getLocalString("ui.ejbtransactioninspector.cmt_table.attribute", "Transaction Attribute"), DescriptionInspector.DESCRIPTION_COLUMN_INIT};
    private static String TABNAME = localStrings.getLocalString("ui.ejbtransactioninspector.tabname", "Transactions");
    private static String wizardHelpID = "Transaction";
    private static String deployHelpID = "Transaction";
    EjbDescriptor descriptor;
    private static String[] EJB_METH_TYPE = new String[]{MethodDescriptor.EJB_LOCAL, MethodDescriptor.EJB_LOCALHOME, MethodDescriptor.EJB_REMOTE, MethodDescriptor.EJB_HOME};
    private static Object[] INTERFACE_OPTIONS = new Object[]{SHOW_LOCAL, SHOW_LOCAL_HOME, SHOW_REMOTE, SHOW_REMOTE_HOME};
    private UIRadioButtonBox showInterfaces = null;
    private static String[] ContainerTransaction_TYPES = new String[]{ContainerTransaction.NOT_SUPPORTED, ContainerTransaction.SUPPORTS, ContainerTransaction.REQUIRED, ContainerTransaction.REQUIRES_NEW, ContainerTransaction.MANDATORY, ContainerTransaction.NEVER};
    private static String[] TRANS_ATTR_OPTIONS = new String[]{TRANS_NOT_SUPPORTED, TRANS_SUPPORTS, TRANS_REQUIRED, TRANS_REQUIRES_NEW, TRANS_MANDATORY, TRANS_NEVER};
    private Vector transAttrs = null;
    private UIRadioButtonBox xactionMgmtBox = null;
    private TransactionTable transactionTable = null;
    private boolean refresh_disable = false;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbTransactionInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EjbTransactionInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$EjbDescriptor == null ? (class$com$sun$enterprise$deployment$EjbDescriptor = EjbTransactionInspector.class$("com.sun.enterprise.deployment.EjbDescriptor")) : class$com$sun$enterprise$deployment$EjbDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof EjbDescriptor ? (EjbDescriptor)desc : null;
            this.transactionTable.clearTableData();
        }
    }

    private EjbTransactionInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeWidgets();
    }

    private void initializeWidgets() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gb1 = new GridBagLayout();
        this.setLayout(gb1);
        CSH.setHelpIDString((Component)this, (String)HELP_TAB);
        this.xactionMgmtBox = new UIRadioButtonBox(XACTION_MGMT, true);
        this.xactionMgmtBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbTransactionInspector.this._xactionMgmtChangedAction();
            }
        });
        this.xactionMgmtBox.addItem(BEAN_MGT_XACTIONS);
        this.xactionMgmtBox.addItem(CONT_MGT_XACTIONS);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)this.xactionMgmtBox, c10);
        UITitledBox CMTBox = new UITitledBox(null, true);
        GridBagConstraints gbc = this.xactionMgmtBox.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.insets = new Insets(0, 20, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        this.xactionMgmtBox.add((Component)CMTBox, gbc);
        this.xactionMgmtBox.addSelectionEnabledComponent(CMTBox, CONT_MGT_XACTIONS);
        this.showInterfaces = new UIRadioButtonBox(SHOW_INTERFACES, false);
        this.showInterfaces.setModel(INTERFACE_OPTIONS);
        this.showInterfaces.setClearWhenDisabled(true);
        this.showInterfaces.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbTransactionInspector.this.invokeRefresh();
            }
        });
        gbc = CMTBox.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbc.fill = 0;
        gbc.anchor = 11;
        CMTBox.add((Component)this.showInterfaces, gbc);
        UITitledTable transTable = new UITitledTable(null, false);
        this.transactionTable = new TransactionTable(new TransactionTableModel());
        this.transactionTable.setContainTransactionsEditable(true);
        transTable.setTableView(this.transactionTable);
        gbc = CMTBox.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        CMTBox.add((Component)transTable, gbc);
    }

    public void refresh() {
        if (this.refresh_disable) {
            return;
        }
        if (this.descriptor == null) {
            return;
        }
        if (this.descriptor.getTransactionType().equals(EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {
            this.xactionMgmtBox.setSelectedItem(CONT_MGT_XACTIONS);
        } else {
            this.xactionMgmtBox.setSelectedItem(BEAN_MGT_XACTIONS);
        }
        boolean isMDB = this.descriptor instanceof EjbMessageBeanDescriptor;
        this.xactionMgmtBox.setReadOnly(!isMDB && !(this.descriptor instanceof EjbSessionDescriptor));
        this.showInterfaces.setVisible(!isMDB);
        if (this.descriptor.getTransactionType().equals(EjbDescriptor.BEAN_TRANSACTION_TYPE)) {
            this.transactionTable.clearTableData();
        } else {
            String methType = null;
            if (isMDB) {
                this.showInterfaces.setItemEnabled(SHOW_LOCAL, false);
                this.showInterfaces.setItemEnabled(SHOW_LOCAL_HOME, false);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE, false);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE_HOME, false);
                methType = MethodDescriptor.EJB_BEAN;
            } else {
                this.showInterfaces.setItemEnabled(SHOW_LOCAL, this.descriptor.getLocalClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_LOCAL_HOME, this.descriptor.getLocalHomeClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE, this.descriptor.getRemoteClassName() != null);
                this.showInterfaces.setItemEnabled(SHOW_REMOTE_HOME, this.descriptor.getHomeClassName() != null);
                int mtNdx = this.showInterfaces.getSelectedIndex();
                String string = methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : null;
                if (methType == null) {
                    if (this.descriptor.getLocalClassName() != null) {
                        this.showInterfaces.setSelectedItem(SHOW_LOCAL);
                    } else if (this.descriptor.getRemoteClassName() != null) {
                        this.showInterfaces.setSelectedItem(SHOW_REMOTE);
                    }
                    mtNdx = this.showInterfaces.getSelectedIndex();
                    methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : "";
                }
            }
            Vector methods = new Vector();
            try {
                methods.addAll(this.descriptor.getTransactionMethodDescriptors());
            }
            catch (Throwable e10) {
                this.refresh_disable = true;
                UIUtils.debugImplementationError("==> getTransactionMethodDescriptors()", e10);
                UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.ejbtransactioninspector.problemgettingmethods", "Error obtaining the list of methods on {0}\n{1}\n", new Object[]{this.descriptor.getName(), e10.getMessage()}));
                this.refresh_disable = false;
                return;
            }
            this.transAttrs = this.descriptor.getPossibleTransactionAttributes();
            Vector<MethodDescriptor> vdata = new Vector<MethodDescriptor>();
            Enumeration e11 = methods.elements();
            while (e11.hasMoreElements()) {
                MethodDescriptor md = (MethodDescriptor)e11.nextElement();
                if (!md.getEjbClassSymbol().equals(methType)) continue;
                vdata.add(md);
            }
            this.transactionTable.clearTableData();
            this.transactionTable.updateTableData(vdata);
            this.transactionTable.refreshEditors();
        }
    }

    public void _xactionMgmtChangedAction() {
        String item = (String)this.xactionMgmtBox.getSelectedItem();
        if (item.equals(BEAN_MGT_XACTIONS)) {
            this.descriptor.setTransactionType(EjbDescriptor.BEAN_TRANSACTION_TYPE);
        } else {
            this.descriptor.setTransactionType(EjbDescriptor.CONTAINER_TRANSACTION_TYPE);
        }
        this.invokeRefresh();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class TransactionTableModel
    extends InspectorTableModel {
        private boolean editable = true;

        public TransactionTableModel() {
            super(COLUMN_LABELS);
            this.setDataOrdering(1);
        }

        public void setContainTransactionsEditable(boolean state) {
            this.editable = state;
        }

        public boolean isCellEditable(int row, int col) {
            return col <= 0 ? false : this.editable;
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            String value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    value = this._Type2Display(this._getCTFor(md).getTransactionAttribute());
                    break;
                }
                case 2: {
                    value = this._getCTFor(md).getDescription();
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    EjbTransactionInspector.this.descriptor.setContainerTransactionFor(md, new ContainerTransaction(this._Display2Type((String)value), this._getCTFor(md).getDescription()));
                    break;
                }
                case 2: {
                    this._getCTFor(md).setDescription((String)value);
                }
            }
        }

        private ContainerTransaction _getCTFor(MethodDescriptor md) {
            ContainerTransaction ct2 = EjbTransactionInspector.this.descriptor.getContainerTransactionFor(md);
            if (ct2 == null || !EjbTransactionInspector.this.transAttrs.contains(ct2)) {
                ct2 = new ContainerTransaction(ContainerTransaction.REQUIRED, "");
                EjbTransactionInspector.this.descriptor.setContainerTransactionFor(md, ct2);
            }
            return ct2;
        }

        public String _Display2Type(String s2) {
            int i2 = 0;
            while (i2 < TRANS_ATTR_OPTIONS.length) {
                if (TRANS_ATTR_OPTIONS[i2].equals(s2)) {
                    return ContainerTransaction_TYPES[i2];
                }
                ++i2;
            }
            UIUtils.debugImplementationError("Display type not found: " + s2);
            return s2;
        }

        public String _Type2Display(String s2) {
            int i2 = 0;
            while (i2 < ContainerTransaction_TYPES.length) {
                if (ContainerTransaction_TYPES[i2].equals(s2)) {
                    return TRANS_ATTR_OPTIONS[i2];
                }
                ++i2;
            }
            UIUtils.debugImplementationError("Trans type not found: " + s2);
            return s2;
        }
    }

    private class TransactionTable
    extends InspectorTable {
        private Vector lastTransAttr = null;
        private JComboBox transAttrCB = null;

        public TransactionTable(TransactionTableModel model) {
            super(model);
            this.setAutoResizeMode(4);
            this.setSelectionMode(0);
            this.setHandleDescriptionUpdates(true);
        }

        public void setContainTransactionsEditable(boolean state) {
            ((TransactionTableModel)this.getModel()).setContainTransactionsEditable(state);
        }

        public void refreshEditors() {
            this.getColumn(COLUMN_LABELS[1]).setCellEditor(new DefaultCellEditor(this.getTransactionTypeCombo()));
        }

        private JComboBox getTransactionTypeCombo() {
            if (this.transAttrCB == null || this.lastTransAttr != EjbTransactionInspector.this.transAttrs) {
                this.lastTransAttr = EjbTransactionInspector.this.transAttrs;
                TransactionTableModel m2 = (TransactionTableModel)this.getModel();
                this.transAttrCB = new JComboBox();
                Enumeration e10 = this.lastTransAttr.elements();
                while (e10.hasMoreElements()) {
                    this.transAttrCB.addItem(m2._Type2Display(((ContainerTransaction)e10.nextElement()).getTransactionAttribute()));
                }
            }
            return this.transAttrCB;
        }
    }
}

