/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.repository.J2EEResourceException;
import com.sun.enterprise.repository.JmsCnxFactoryResource;
import com.sun.enterprise.repository.JmsDestinationResource;
import com.sun.enterprise.repository.ResourceAdminImpl;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextArea;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class EjbMessageInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbMessageInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbMessageInspector = EjbMessageInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbMessageInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbMessageInspector);
    private static final String DESTINATION_TYPE = localStrings.getLocalString("ui.ejbmessageinspector.destinationtype", "Destination Type");
    private static final String QUEUE = localStrings.getLocalString("ui.ejbmessageinspector.queue", "Queue");
    private static final String TOPIC = localStrings.getLocalString("ui.ejbmessageinspector.topic", "Topic");
    private static final String DURABLE_SUBSCR = localStrings.getLocalString("ui.ejbmessageinspector.durablesubscriber", "Durable Subscriber");
    private static final String CLIENT_ID = localStrings.getLocalString("ui.ejbmessageinspector.clientid", "Client Id:");
    private static final String SUBSCRIPTION_NAME = localStrings.getLocalString("ui.ejbmessageinspector.subscriptionname", "Subscription Name:");
    private static final String DESTINATION = localStrings.getLocalString("ui.ejbmessageinspector.destination", "Destination:");
    private static final String CONNECTION_FACTORY = localStrings.getLocalString("ui.ejbmessageinspector.connection_factory", "Connection Factory:");
    private static final String ACKNOWLEDGEMENT = localStrings.getLocalString("ui.ejbmessageinspector.acknowledgement", "Acknowledgement:");
    private static final String AUTO_ACK = localStrings.getLocalString("ui.ejbmessageinspector.autoack", "Auto-Acknowledge");
    private static final String DUPS_OK = localStrings.getLocalString("ui.ejbmessageinspector.dupsok", "Duplicates-OK");
    private static final String JMS_MSG_SELECTOR = localStrings.getLocalString("ui.ejbmessageinspector.jmsmessageselector", "JMS Message Selector:");
    private static String TABNAME = localStrings.getLocalString("ui.ejbmessageinspector.tabname", "Message");
    private static String wizardHelpID = "Message";
    private static String deployHelpID = "Message";
    private EjbMessageBeanDescriptor descriptor;
    ResourceAdminImpl resAdmin = null;
    public static final boolean prefersRadioButtons = UIRadioButtonBox.getPrefersRadioButtons();
    private UITitledComboBox destTypeCombo = null;
    private boolean destTypeCombo_isRadio = true;
    private JCheckBox destTypeDurableCB = null;
    private UITitledTextField destTypeClientID = null;
    private UITitledTextField destTypeSubName = null;
    private UITitledComboBox cbDestination = null;
    private UITitledComboBox cbConnFact = null;
    private UITitledComboBox bmtAckCombo = null;
    private UITitledTextArea jmsMsgSelector = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbMessageInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EjbMessageInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor == null ? (class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor = EjbMessageInspector.class$("com.sun.enterprise.deployment.EjbMessageBeanDescriptor")) : class$com$sun$enterprise$deployment$EjbMessageBeanDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof EjbMessageBeanDescriptor) {
            this.descriptor = (EjbMessageBeanDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private EjbMessageInspector(String mode) {
        this.setInspectorMode(mode);
        this.resAdmin = new ResourceAdminImpl();
        this.initUI();
    }

    private void initUI() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setToolTipText(localStrings.getLocalString("ui.ejbmessageinspector.messagebeaninfo", "MessageBean information"));
        UITitledBox destTypeBox = new UITitledBox(DESTINATION_TYPE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 0, 0);
        c10.fill = 2;
        c10.anchor = 17;
        this.add((Component)destTypeBox, c10);
        this.destTypeCombo = new UIRadioButtonBox(null, false);
        this.destTypeCombo.setModel(new String[]{QUEUE, TOPIC});
        this.destTypeCombo.setSelectedItem(QUEUE);
        this.destTypeCombo.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent comp) {
                String item = (String)EjbMessageInspector.this.destTypeCombo.getSelectedItem();
                if (item.equals(QUEUE)) {
                    EjbMessageInspector.this.descriptor.setHasQueueDest();
                    EjbMessageInspector.this.destTypeDurableCB.setEnabled(false);
                    EjbMessageInspector.this.destTypeClientID.setEnabled(false);
                    EjbMessageInspector.this.destTypeSubName.setEnabled(false);
                } else if (item.equals(TOPIC)) {
                    EjbMessageInspector.this.descriptor.setHasTopicDest();
                    EjbMessageInspector.this.destTypeDurableCB.setEnabled(true);
                    boolean hasDurable = EjbMessageInspector.this.destTypeDurableCB.isSelected();
                    EjbMessageInspector.this.destTypeClientID.setEnabled(hasDurable);
                    EjbMessageInspector.this.destTypeSubName.setEnabled(hasDurable);
                }
                EjbMessageInspector.this.populateDestComboBox();
                EjbMessageInspector.this.populateCnxFactComboBox();
            }
        });
        destTypeBox.addWithGBConstraints(this.destTypeCombo);
        this.destTypeDurableCB = new JCheckBox(DURABLE_SUBSCR);
        this.destTypeDurableCB.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                boolean hasDurable = EjbMessageInspector.this.destTypeDurableCB.isSelected();
                EjbMessageInspector.this.descriptor.setHasDurableSubscription(hasDurable);
                EjbMessageInspector.this.destTypeClientID.setEnabled(hasDurable);
                EjbMessageInspector.this.destTypeSubName.setEnabled(hasDurable);
            }
        });
        if (this.destTypeCombo_isRadio) {
            destTypeBox.getGBConstraints().insets.left += 25;
            destTypeBox.addWithGBConstraints(this.destTypeDurableCB);
        } else {
            destTypeBox.addWithGBConstraints(this.destTypeDurableCB);
            destTypeBox.getGBConstraints().insets.left += 25;
        }
        this.destTypeClientID = new UITitledTextField(CLIENT_ID);
        this.destTypeClientID.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent comp) {
                String text = EjbMessageInspector.this.destTypeClientID.getText();
                EjbMessageInspector.this.descriptor.setJmsClientID(text);
            }
        });
        this.destTypeSubName = new UITitledTextField(SUBSCRIPTION_NAME);
        this.destTypeSubName.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent comp) {
                String text = EjbMessageInspector.this.destTypeSubName.getText();
                EjbMessageInspector.this.descriptor.setDurableSubscriptionName(text);
            }
        });
        destTypeBox.addWithGBConstraints(this.destTypeSubName);
        this.cbDestination = new UITitledComboBox(DESTINATION, false);
        this.cbDestination.setEditable(true);
        this.cbDestination.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String item = EjbMessageInspector.this.cbDestination.getText();
                EjbMessageInspector.this.descriptor.setJndiName(item);
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)this.cbDestination, c10);
        this.cbConnFact = new UITitledComboBox(CONNECTION_FACTORY, false);
        this.cbConnFact.setEditable(true);
        this.cbConnFact.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String item = EjbMessageInspector.this.cbConnFact.getText().trim();
                if (item.equals("")) {
                    EjbMessageInspector.this.descriptor.setConnectionFactoryName(null);
                } else {
                    EjbMessageInspector.this.descriptor.setConnectionFactoryName(item);
                }
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)this.cbConnFact, c10);
        this.bmtAckCombo = new UITitledComboBox(ACKNOWLEDGEMENT, false);
        this.bmtAckCombo.setModel(new String[]{AUTO_ACK, DUPS_OK});
        this.bmtAckCombo.setSelectedItem(AUTO_ACK);
        this.bmtAckCombo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                String item = (String)EjbMessageInspector.this.bmtAckCombo.getSelectedItem();
                if (item.equals(AUTO_ACK)) {
                    EjbMessageInspector.this.descriptor.setJmsAcknowledgeMode(1);
                } else if (item.equals(DUPS_OK)) {
                    EjbMessageInspector.this.descriptor.setJmsAcknowledgeMode(3);
                }
            }
        });
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 3;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)this.bmtAckCombo, c10);
        this.jmsMsgSelector = new UITitledTextArea(JMS_MSG_SELECTOR, false);
        this.jmsMsgSelector.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent comp) {
                EjbMessageInspector.this.descriptor.setJmsMessageSelector(EjbMessageInspector.this.jmsMsgSelector.getText());
            }
        });
        this.jmsMsgSelector.setPreferredSize(new Dimension(300, 100));
        this.jmsMsgSelector.setMinimumSize(new Dimension(300, 100));
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 4;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)this.jmsMsgSelector, c10);
    }

    public boolean hasDestination() {
        String item = this.cbDestination.getText();
        return !item.equals("");
    }

    private void populateDestComboBox() {
        if (this.resAdmin == null) {
            return;
        }
        try {
            Set jmsRes = this.resAdmin.getResources(1);
            Vector<String> resNames = new Vector<String>();
            Iterator itr = jmsRes.iterator();
            while (itr.hasNext()) {
                JmsDestinationResource resource = (JmsDestinationResource)itr.next();
                if (resource == null) continue;
                if (this.destTypeCombo.getSelectedItem().equals(QUEUE)) {
                    if (!resource.getIsQueue()) continue;
                    resNames.add(resource.getName());
                    continue;
                }
                if (resource.getIsQueue()) continue;
                resNames.add(resource.getName());
            }
            this.cbDestination.clearModel();
            if (resNames.size() > 0) {
                this.cbDestination.setModel(resNames);
            }
        }
        catch (J2EEResourceException e10) {
            UIUtils.println("J2EEResourceException: There was a problem while getting resources");
            e10.printStackTrace();
        }
    }

    private void populateCnxFactComboBox() {
        if (this.resAdmin == null) {
            return;
        }
        try {
            Set cnxFactRes = this.resAdmin.getResources(2);
            Vector<String> resNames = new Vector<String>();
            Iterator itr = cnxFactRes.iterator();
            while (itr.hasNext()) {
                JmsCnxFactoryResource resource = (JmsCnxFactoryResource)itr.next();
                if (resource == null) continue;
                if (this.destTypeCombo.getSelectedItem().equals(QUEUE)) {
                    if (!resource.getIsQueue()) continue;
                    resNames.add(resource.getName());
                    continue;
                }
                if (resource.getIsQueue()) continue;
                resNames.add(resource.getName());
            }
            this.cbConnFact.clearModel();
            if (resNames.size() > 0) {
                this.cbConnFact.setModel(resNames);
            }
        }
        catch (J2EEResourceException e10) {
            UIUtils.println("J2EEResourceException: There was a problem while getting resources");
            e10.printStackTrace();
        }
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (!this.descriptor.getTransactionType().equals(EjbDescriptor.CONTAINER_TRANSACTION_TYPE)) {
            this.bmtAckCombo.setEnabled(true);
            boolean isAuto = this.descriptor.getJmsAcknowledgeMode() == 1;
            this.bmtAckCombo.setSelectedItem(isAuto ? AUTO_ACK : DUPS_OK);
        } else {
            this.bmtAckCombo.setSelectedItem(null);
            this.bmtAckCombo.setEnabled(false);
        }
        if (this.descriptor.hasQueueDest()) {
            this.destTypeCombo.setSelectedItem(QUEUE);
            this.destTypeDurableCB.setSelected(false);
            this.destTypeDurableCB.setEnabled(false);
            this.destTypeClientID.setText("");
            this.destTypeClientID.setEnabled(false);
            this.destTypeSubName.setText("");
            this.destTypeSubName.setEnabled(false);
        } else {
            this.destTypeCombo.setSelectedItem(TOPIC);
            this.destTypeDurableCB.setEnabled(true);
            if (this.descriptor.hasDurableSubscription()) {
                this.destTypeDurableCB.setSelected(true);
                this.destTypeClientID.setEnabled(true);
                this.destTypeClientID.setText(this.descriptor.getJmsClientID());
                this.destTypeSubName.setEnabled(true);
                this.destTypeSubName.setText(this.descriptor.getDurableSubscriptionName());
            } else {
                this.destTypeDurableCB.setSelected(false);
                this.destTypeClientID.setText("");
                this.destTypeClientID.setEnabled(false);
                this.destTypeSubName.setText("");
                this.destTypeSubName.setEnabled(false);
            }
        }
        this.populateDestComboBox();
        this.cbDestination.setText(this.descriptor.getJndiName());
        this.populateCnxFactComboBox();
        if (this.descriptor.hasConnectionFactory()) {
            this.cbConnFact.setText(this.descriptor.getConnectionFactoryName());
        } else {
            this.cbConnFact.setText("");
        }
        if (this.descriptor.hasJmsMessageSelector()) {
            this.jmsMsgSelector.setText(this.descriptor.getJmsMessageSelector());
        } else {
            this.jmsMsgSelector.setText("");
        }
    }

    public static void main(String[] args) {
        String mode = "DeploymentMode";
        JFrame frame = new JFrame();
        EjbMessageInspector myPanel = (EjbMessageInspector)EjbMessageInspector.newInspectorPane(mode, null);
        EjbMessageBeanDescriptor d10 = new EjbMessageBeanDescriptor();
        myPanel.setDescriptor(d10);
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

