/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbIORConfigurationDescriptor;
import com.sun.enterprise.deployment.EjbMessageBeanDescriptor;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.MethodPermission;
import com.sun.enterprise.deployment.RoleReference;
import com.sun.enterprise.deployment.Roles;
import com.sun.enterprise.deployment.RunAsIdentityDescriptor;
import com.sun.enterprise.security.PrincipalImpl;
import com.sun.enterprise.security.acl.Role;
import com.sun.enterprise.security.acl.RoleMapper;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.descriptor.RolesInspector;
import com.sun.enterprise.tools.deployment.ui.utils.UIButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIDialog;
import com.sun.enterprise.tools.deployment.ui.utils.UIHelpButton;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIRoleRefsTable;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.table.TableModel;

public class EjbComponentSecurityInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector = EjbComponentSecurityInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.EjbComponentSecurityInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector);
    private static final String SECURITY_IDENTITY = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.security_identity", "Security Identity");
    private static final String USE_CALLER_ID = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.use_caller_id", "Use Caller ID");
    private static final String RUN_AS_ROLE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.run_as_role", "Run As Specified Role:");
    private static final String EDIT_ROLES = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.edit_roles", "Edit Roles...");
    private static final String DEPLOYMENT_SETTINGS = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.deployment_settings", "Deployment Settings...");
    private static final String METHOD_COLUMN = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.method_column", "Method");
    private static final String AVAILABILITY_COLUMN = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability_column", "Availability");
    private static final String AVAIL_ALL_USERS = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability.all_users", "All Users");
    private static final String AVAIL_NO_USERS = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability.no_users", "No Users");
    private static final String AVAIL_SELECTED_ROLES = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.availability.selected_roles", "Sel Roles");
    private static final String METH_PERM = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.method_permissions", "Method permissions");
    private static final String SHOW_INTERFACES = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.show_interface", "Show:");
    private static final String SHOW_LOCAL = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.local", "Local");
    private static final String SHOW_LOCAL_HOME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.local_home", "Local Home");
    private static final String SHOW_REMOTE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.remote", "Remote");
    private static final String SHOW_REMOTE_HOME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.remote_home", "Remote Home");
    private static final String SSL_REQUIRED = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.ssl_required", "SSL Required");
    private static final String CLIENT_AUTH = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.client_auth", "Client Authentication");
    private static final String CERTIFICATE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.certificate", "Certificate");
    private static final String PASSWORD = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.password", "Password");
    private static final String CLIENT_CHOICE = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.client_choice", "Support Client Choice");
    private static final String RUN_AS_USER = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.depsettings.run_as_user", "Run as Specified User:");
    private static final String TABNAME = localStrings.getLocalString("ui.ejbcomponentsecurityinspector.tabname", "Security");
    private static String wizardHelpID = "Security";
    private static String deployHelpID = "Security";
    private EjbDescriptor descriptor = null;
    private static String[] EJB_METH_TYPE = new String[]{MethodDescriptor.EJB_LOCAL, MethodDescriptor.EJB_LOCALHOME, MethodDescriptor.EJB_REMOTE, MethodDescriptor.EJB_HOME};
    private static Object[] INTERFACE_OPTIONS = new Object[]{SHOW_LOCAL, SHOW_LOCAL_HOME, SHOW_REMOTE, SHOW_REMOTE_HOME};
    private UIRadioButtonBox showInterfaces = null;
    private JRadioButton rbUseCallerId = null;
    private JRadioButton rbRunAsRole = null;
    private UITitledComboBox cbRoleName = null;
    private UIRoleRefsTable roleNamesPanel = null;
    private MethodPermissionsTable methodPermissionsTable = null;
    private SecDeploymentSettingsDialog secDSDialog = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$EjbComponentSecurityInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$EjbDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new EjbComponentSecurityInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$EjbDescriptor == null ? (class$com$sun$enterprise$deployment$EjbDescriptor = EjbComponentSecurityInspector.class$("com.sun.enterprise.deployment.EjbDescriptor")) : class$com$sun$enterprise$deployment$EjbDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor desc) {
        if (this.descriptor != desc) {
            this.descriptor = desc instanceof EjbDescriptor ? (EjbDescriptor)desc : null;
            this.methodPermissionsTable.clearTableData();
            this.roleNamesPanel.clearTableData();
        }
    }

    private EjbComponentSecurityInspector(String mode) {
        this.setInspectorMode(mode);
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledControlButtonBox secDepBox = new UITitledControlButtonBox(null, false);
        secDepBox.setControlButtonLocation(13);
        UIRadioButtonBox secIdBox = new UIRadioButtonBox(SECURITY_IDENTITY, true);
        secDepBox.setView(secIdBox);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        this.add((Component)secDepBox, c10);
        this.rbUseCallerId = new JRadioButton(USE_CALLER_ID);
        secIdBox.addItem(this.rbUseCallerId);
        this.rbRunAsRole = new JRadioButton(RUN_AS_ROLE);
        secIdBox.addItem(this.rbRunAsRole);
        secIdBox.getGBConstraints().insets.left += 25;
        this.cbRoleName = new UITitledComboBox(null, false);
        this.cbRoleName.setClearWhenDisabled(true);
        this.cbRoleName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbComponentSecurityInspector.this.updateRunAsRole();
            }
        });
        secIdBox.addWithGBConstraints(this.cbRoleName);
        secIdBox.addSelectionEnabledComponent(this.cbRoleName, null);
        this.rbUseCallerId.setSelected(true);
        secIdBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                boolean useCID = EjbComponentSecurityInspector.this.descriptor.getUsesCallerIdentity();
                if (useCID && !EjbComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    EjbComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(false);
                } else if (!useCID && EjbComponentSecurityInspector.this.rbUseCallerId.isSelected()) {
                    EjbComponentSecurityInspector.this.descriptor.setUsesCallerIdentity(true);
                }
                EjbComponentSecurityInspector.this.invokeRefresh();
            }
        });
        JButton editRoles = new JButton(EDIT_ROLES);
        editRoles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbComponentSecurityInspector.this.editRolesAction();
            }
        });
        secDepBox.addControlButton(editRoles);
        JButton deploySettings = new JButton(DEPLOYMENT_SETTINGS);
        deploySettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbComponentSecurityInspector.this.deploymentSettingsAction();
            }
        });
        secDepBox.addControlButton(deploySettings);
        UITitledTable methPermBox = new UITitledTable(METH_PERM, true);
        c10.weightx = 0.5;
        c10.weighty = 0.4;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)methPermBox, c10);
        this.showInterfaces = new UIRadioButtonBox(SHOW_INTERFACES, false);
        this.showInterfaces.setModel(INTERFACE_OPTIONS);
        this.showInterfaces.setClearWhenDisabled(true);
        this.showInterfaces.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                EjbComponentSecurityInspector.this.invokeRefresh();
            }
        });
        GridBagConstraints gbc = methPermBox.getGBConstraintsCopy();
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(5, 0, 0, 5);
        gbc.fill = 0;
        gbc.anchor = 11;
        methPermBox.add((Component)this.showInterfaces, gbc);
        UITitledTable methodPermissionsPanel = new UITitledTable(null, false);
        gbc = methPermBox.getGBConstraintsCopy();
        gbc.weightx = 0.5;
        gbc.weighty = 0.5;
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.insets = new Insets(0, 0, 0, 0);
        gbc.fill = 1;
        gbc.anchor = 10;
        methPermBox.add((Component)methodPermissionsPanel, gbc);
        this.methodPermissionsTable = new MethodPermissionsTable(new MethodPermissionsTableModel());
        methodPermissionsPanel.setTableView(this.methodPermissionsTable);
        this.roleNamesPanel = new UIRoleRefsTable(){

            public Collection getRoleReferences() {
                ArrayList list = new ArrayList();
                Iterator i2 = EjbComponentSecurityInspector.this.descriptor.getRoleReferences().iterator();
                while (i2.hasNext()) {
                    list.add(i2.next());
                }
                return list;
            }

            public void addRoleReference(RoleReference roleRef) {
                EjbComponentSecurityInspector.this.descriptor.addRoleReference(roleRef);
                EjbComponentSecurityInspector.this.invokeRefresh();
            }

            public void removeRoleReference(RoleReference roleRef) {
                EjbComponentSecurityInspector.this.descriptor.removeRoleReference(roleRef);
                EjbComponentSecurityInspector.this.invokeRefresh();
            }

            public Roles getRolesDescriptor() {
                return EjbComponentSecurityInspector.this.descriptor.getEjbBundleDescriptor();
            }

            public void roleReferenceChanged(RoleReference roleRef) {
                EjbComponentSecurityInspector.this.descriptor.changed();
                EjbComponentSecurityInspector.this.invokeRefresh();
            }
        };
        c10.weightx = 0.5;
        c10.weighty = 0.6;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)this.roleNamesPanel, c10);
    }

    public void refresh() {
        String methType;
        if (this.descriptor == null) {
            return;
        }
        if (this.descriptor instanceof EjbMessageBeanDescriptor) {
            this.rbRunAsRole.setSelected(true);
            this.rbUseCallerId.setEnabled(false);
        } else {
            this.rbUseCallerId.setEnabled(true);
        }
        if (this.descriptor.getUsesCallerIdentity()) {
            this.rbUseCallerId.setSelected(true);
        } else {
            Set rolesSet;
            EjbBundleDescriptor ebd = this.descriptor.getEjbBundleDescriptor();
            Vector<String> roleList = new Vector<String>();
            Set set = rolesSet = ebd != null ? ebd.getRoles() : null;
            if (rolesSet != null) {
                Iterator i2 = rolesSet.iterator();
                while (i2.hasNext()) {
                    String rn = i2.next().toString();
                    roleList.add(rn);
                }
            }
            this.cbRoleName.setModel(roleList);
            this.rbRunAsRole.setSelected(true);
            RunAsIdentityDescriptor rad = this.getEjbRunAsIdentity();
            if (rad == null) {
                rad = new RunAsIdentityDescriptor("");
                this.descriptor.setRunAsIdentity(rad);
            }
            if (rad.getRoleName().equals("") && this.cbRoleName.getItemCount() > 0) {
                rad.setRoleName(this.cbRoleName.getItemAt(0).toString());
            }
            this.cbRoleName.setText(rad.getRoleName());
        }
        this.showInterfaces.setItemEnabled(SHOW_LOCAL, this.descriptor.getLocalClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_LOCAL_HOME, this.descriptor.getLocalHomeClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_REMOTE, this.descriptor.getRemoteClassName() != null);
        this.showInterfaces.setItemEnabled(SHOW_REMOTE_HOME, this.descriptor.getHomeClassName() != null);
        int mtNdx = this.showInterfaces.getSelectedIndex();
        String string = methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : null;
        if (methType == null) {
            if (this.descriptor.getLocalClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_LOCAL);
            } else if (this.descriptor.getRemoteClassName() != null) {
                this.showInterfaces.setSelectedItem(SHOW_REMOTE);
            }
            mtNdx = this.showInterfaces.getSelectedIndex();
            methType = mtNdx >= 0 ? EJB_METH_TYPE[mtNdx] : "";
        }
        Vector methods = new Vector();
        try {
            methods.addAll(this.descriptor.getMethodDescriptors());
        }
        catch (Throwable e10) {
            UIUtils.printException("Getting method descriptors", e10);
            UIOptionPane.showErrorDialog(this, localStrings.getLocalString("ui.ejbcomponentsecurityinspector.error_getting_methods", "Error obtaining the list of methods on {0}\n{1}\n", new Object[]{this.descriptor.getName(), e10.toString()}));
        }
        this.methodPermissionsTable.setModel(new MethodPermissionsTableModel());
        Vector<MethodDescriptor> vdata = new Vector<MethodDescriptor>();
        Enumeration e11 = methods.elements();
        while (e11.hasMoreElements()) {
            MethodDescriptor md = (MethodDescriptor)e11.nextElement();
            if (!md.getEjbClassSymbol().equals(methType)) continue;
            vdata.add(md);
        }
        this.methodPermissionsTable.updateTableData(vdata);
        this.roleNamesPanel.refresh();
    }

    JComponent getComponent() {
        return this;
    }

    private RunAsIdentityDescriptor getEjbRunAsIdentity() {
        return !this.descriptor.getUsesCallerIdentity() ? this.descriptor.getRunAsIdentity() : null;
    }

    private void updateRunAsRole() {
        RunAsIdentityDescriptor rad;
        if (!this.rbRunAsRole.isSelected()) {
            UIUtils.debugPrintln("Run-As-Role not selected!");
            return;
        }
        if (this.descriptor.getUsesCallerIdentity()) {
            this.descriptor.setUsesCallerIdentity(false);
        }
        if ((rad = this.getEjbRunAsIdentity()) == null) {
            rad = new RunAsIdentityDescriptor("");
            this.descriptor.setRunAsIdentity(rad);
        }
        String roleName = this.cbRoleName.getText();
        rad.setRoleName(roleName);
        this.invokeRefresh();
    }

    private void editRolesAction() {
        InspectorPane.InspectorPaneDialog rd = RolesInspector.createRolesInspectorDialog(this.getOwner(), this, true);
        rd.setDescriptor(this.descriptor.getEjbBundleDescriptor());
        rd.show();
        this.invokeRefresh();
    }

    private void deploymentSettingsAction() {
        if (this.secDSDialog == null) {
            Window win = this.getMyParentWindow();
            this.secDSDialog = win instanceof Frame ? new SecDeploymentSettingsDialog((Frame)win) : new SecDeploymentSettingsDialog((Dialog)win);
            this.secDSDialog.setLocationRelativeTo(this);
        }
        this.secDSDialog.showDialog(this.descriptor);
    }

    public String[] getColumnNames() {
        EjbBundleDescriptor ebd;
        Vector<String> cn2 = new Vector<String>();
        cn2.add(METHOD_COLUMN);
        cn2.add(AVAILABILITY_COLUMN);
        EjbBundleDescriptor ejbBundleDescriptor = ebd = this.descriptor != null ? this.descriptor.getEjbBundleDescriptor() : null;
        if (ebd != null) {
            Iterator ri = ebd.getRoles().iterator();
            while (ri.hasNext()) {
                cn2.add(((Role)ri.next()).getName());
            }
        }
        return cn2.toArray(new String[0]);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SecDeploymentSettingsDialog
    extends UIDialog
    implements ActionListener {
        private String helpId = "EjbSecurityDeploymentSettings";
        private EjbDescriptor descriptor = null;
        private JCheckBox cbSSLRequired = null;
        private UIRadioButtonBox clientAuth = null;
        private UITitledComboBox cbUserNames = null;
        private boolean isOk = false;

        public SecDeploymentSettingsDialog(Frame frame) {
            super(frame, true);
            this._init();
        }

        public SecDeploymentSettingsDialog(Dialog dialog) {
            super(dialog, true);
            this._init();
        }

        private void _init() {
            Object gbc = null;
            this.setTitle(DEPLOYMENT_SETTINGS);
            this.doNothingOnClose();
            UITitledBox content = new UITitledBox(null, false);
            this.setContentPane(content);
            content.getGBConstraints().insets.left += 10;
            content.getGBConstraints().insets.right += 10;
            UITitledControlButtonBox buttonBox = new UITitledControlButtonBox(null, false);
            buttonBox.setControlButtonLocation(13);
            this.cbSSLRequired = new JCheckBox(SSL_REQUIRED);
            content.addWithGBConstraints(this.cbSSLRequired);
            this.clientAuth = new UIRadioButtonBox(CLIENT_AUTH, true);
            buttonBox.setView(this.clientAuth);
            content.addWithGBConstraints(buttonBox);
            this.clientAuth.addItem(CERTIFICATE);
            this.clientAuth.addItem(PASSWORD);
            this.clientAuth.addItem(CLIENT_CHOICE);
            UITitledBox secIdBox = new UITitledBox(SECURITY_IDENTITY, true);
            this.cbUserNames = new UITitledComboBox(RUN_AS_USER, false);
            secIdBox.addWithGBConstraints(this.cbUserNames);
            content.addWithGBConstraints(secIdBox);
            buttonBox.addControlButton(UIButton.createOkButton(this));
            buttonBox.addControlButton(UIButton.createCancelButton(this));
            buttonBox.addControlButton(new UIHelpButton(this.helpId));
            Rectangle b10 = this.getOwner().getBounds();
            ((Component)this).setBounds(b10.x + 20, b10.y + 20, 375, 240);
        }

        public void actionPerformed(ActionEvent ae2) {
            String cmd = ae2.getActionCommand();
            if (cmd.equals("ok")) {
                this.isOk = true;
                this.updateDescriptor();
                this.setVisible(false);
            } else if (cmd.equals("cancel")) {
                this.isOk = false;
                this.setVisible(false);
            } else {
                UIUtils.printImplementationError("Unsupported ActionCommand: '" + cmd + "'");
            }
        }

        public boolean showDialog(EjbDescriptor ejb) {
            this.descriptor = ejb;
            this.isOk = false;
            this.refreshDialog();
            this.show();
            return this.isOk;
        }

        private RunAsIdentityDescriptor getEjbRunAsIdentity() {
            return !this.descriptor.getUsesCallerIdentity() ? this.descriptor.getRunAsIdentity() : null;
        }

        private void updateDescriptor() {
            Set s2 = this.descriptor.getIORConfigurationDescriptors();
            Iterator itr = s2.iterator();
            int size = s2.size();
            boolean addDescriptor = false;
            EjbIORConfigurationDescriptor iorDesc = null;
            if (size == 0) {
                iorDesc = new EjbIORConfigurationDescriptor();
                addDescriptor = true;
            } else {
                iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            }
            boolean sslRequired = this.cbSSLRequired.isSelected();
            if (sslRequired) {
                iorDesc.setIntegrity("required");
                iorDesc.setConfidentiality("required");
                iorDesc.setEstablishTrustInTarget("required");
            } else {
                iorDesc.setIntegrity("supported");
                iorDesc.setConfidentiality("supported");
                iorDesc.setEstablishTrustInTarget("supported");
            }
            String authType = (String)this.clientAuth.getSelectedItem();
            if (authType != null) {
                if (CERTIFICATE.equals(authType)) {
                    iorDesc.setEstablishTrustInClient("required");
                } else if (PASSWORD.equals(authType)) {
                    iorDesc.setEstablishTrustInClient("supported");
                    iorDesc.setAuthMethodRequired(true);
                } else if (CLIENT_CHOICE.equals(authType)) {
                    iorDesc.setEstablishTrustInClient("supported");
                    iorDesc.setAuthMethodRequired(false);
                }
            }
            if (addDescriptor) {
                this.descriptor.addIORConfigurationDescriptor(iorDesc);
            }
            if (!this.descriptor.getUsesCallerIdentity()) {
                String userName = (String)this.cbUserNames.getSelectedItem();
                RunAsIdentityDescriptor rad = this.getEjbRunAsIdentity();
                if (rad != null) {
                    rad.setPrincipal(userName);
                }
            }
        }

        private void refreshDialog() {
            RunAsIdentityDescriptor rad;
            Set s2 = this.descriptor.getIORConfigurationDescriptors();
            Iterator itr = s2.iterator();
            int size = s2.size();
            EjbIORConfigurationDescriptor iorDesc = null;
            if (size != 0) {
                iorDesc = (EjbIORConfigurationDescriptor)itr.next();
            }
            if (iorDesc != null) {
                if (iorDesc.getIntegrity().equals("required") || iorDesc.getConfidentiality().equals("required") || iorDesc.getEstablishTrustInTarget().equals("required")) {
                    this.cbSSLRequired.setSelected(true);
                }
                String authType = iorDesc.getEstablishTrustInClient().equals("required") ? CERTIFICATE : (iorDesc.isAuthMethodRequired() ? PASSWORD : CLIENT_CHOICE);
                this.clientAuth.setSelectedItem(authType);
            } else {
                this.clientAuth.setSelectedItem(CERTIFICATE);
            }
            Application app = this.descriptor.getApplication();
            if (app == null) {
                UIUtils.debugPrintln("Descriptor app is 'null'");
            }
            this.cbUserNames.setEnabled((rad = this.getEjbRunAsIdentity()) != null);
            if (app != null && rad != null) {
                this.cbUserNames.setEnabled(true);
                RoleMapper rm = app.getRoleMapper();
                Role r2 = new Role(rad.getRoleName());
                Enumeration e10 = rm.getUsersAssignedTo(r2);
                Vector<String> v2 = new Vector<String>();
                while (e10.hasMoreElements()) {
                    PrincipalImpl p2 = (PrincipalImpl)e10.nextElement();
                    v2.addElement(p2.getName());
                }
                this.cbUserNames.setModel(v2);
                String currentUser = rad.getPrincipal();
                if (currentUser != null && !currentUser.equals("")) {
                    this.cbUserNames.setSelectedItem(currentUser);
                }
            } else {
                this.cbUserNames.setEnabled(false);
            }
        }
    }

    public class MethodPermissionsTableModel
    extends InspectorTableModel {
        private MethodPermission unchMP = MethodPermission.getUncheckedMethodPermission();
        private MethodPermission exclMP = MethodPermission.getExcludedMethodPermission();
        static /* synthetic */ Class class$java$lang$String;
        static /* synthetic */ Class class$java$lang$Boolean;

        public MethodPermissionsTableModel() {
            super(EjbComponentSecurityInspector.this.getColumnNames());
        }

        public Object getObjectValue(Object obj, int col) {
            MethodDescriptor md = (MethodDescriptor)obj;
            Set mpSet = null;
            Role role = null;
            MethodPermission mp = null;
            Object value = null;
            switch (col) {
                case 0: {
                    value = md.getFormattedString();
                    break;
                }
                case 1: {
                    mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
                    if (mpSet.contains(this.exclMP)) {
                        value = AVAIL_NO_USERS;
                        break;
                    }
                    if (mpSet.contains(this.unchMP)) {
                        value = AVAIL_ALL_USERS;
                        break;
                    }
                    value = AVAIL_SELECTED_ROLES;
                    break;
                }
                default: {
                    mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
                    role = new Role(this.getColumnName(col));
                    mp = new MethodPermission(role);
                    value = mpSet.contains(mp) ? Boolean.TRUE : Boolean.FALSE;
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            MethodDescriptor md = (MethodDescriptor)obj;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    if (value.equals(AVAIL_NO_USERS)) {
                        EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.unchMP, md);
                        EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod(this.exclMP, md);
                        break;
                    }
                    if (value.equals(AVAIL_ALL_USERS)) {
                        EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.exclMP, md);
                        EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod(this.unchMP, md);
                        break;
                    }
                    EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.exclMP, md);
                    Set mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
                    HashSet<MethodPermission> newSet = new HashSet<MethodPermission>();
                    int c10 = 2;
                    while (c10 < this.getColumnCount()) {
                        MethodPermission mp = new MethodPermission(new Role(this.getColumnName(c10)));
                        if (mpSet.contains(mp)) {
                            newSet = null;
                            break;
                        }
                        newSet.add(mp);
                        ++c10;
                    }
                    if (newSet != null) {
                        Iterator i2 = newSet.iterator();
                        while (i2.hasNext()) {
                            EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod((MethodPermission)i2.next(), md);
                        }
                    }
                    EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(this.unchMP, md);
                    break;
                }
                default: {
                    MethodPermission mp = new MethodPermission(new Role(this.getColumnName(col)));
                    if (((Boolean)value).booleanValue()) {
                        EjbComponentSecurityInspector.this.descriptor.addPermissionedMethod(mp, md);
                        break;
                    }
                    EjbComponentSecurityInspector.this.descriptor.removePermissionedMethod(mp, md);
                }
            }
        }

        public Class getColumnClass(int col) {
            Class clazz = col <= 1 ? (class$java$lang$String == null ? (class$java$lang$String = MethodPermissionsTableModel.class$("java.lang.String")) : class$java$lang$String) : (class$java$lang$Boolean == null ? (class$java$lang$Boolean = MethodPermissionsTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean);
            return clazz;
        }

        public boolean isCellEditable(int row, int col) {
            if (col == 0) {
                return false;
            }
            if (col == 1) {
                return true;
            }
            MethodDescriptor md = (MethodDescriptor)this.getRowObject(row);
            Set mpSet = EjbComponentSecurityInspector.this.descriptor.getMethodPermissionsFor(md);
            return !mpSet.contains(this.unchMP) && !mpSet.contains(this.exclMP);
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }

    private class MethodPermissionsTable
    extends InspectorTable {
        private DefaultCellEditor availEditor = null;

        public MethodPermissionsTable(MethodPermissionsTableModel model) {
            super((TableModel)model, true);
            this.setSelectionMode(0);
            this.availEditor = new DefaultCellEditor(new JComboBox<Object>(new Object[]{AVAIL_ALL_USERS, AVAIL_NO_USERS, AVAIL_SELECTED_ROLES}));
        }

        public void setModel(MethodPermissionsTableModel model) {
            super.setModel(model);
            this.getColumnModel().getColumn(1).setCellEditor(this.availEditor);
        }

        public void updateColumnNames() {
            this.getInspectorTableModel().setColumnNames(EjbComponentSecurityInspector.this.getColumnNames());
        }
    }
}

