/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.ui.DeployToolWindow;
import com.sun.enterprise.tools.deployment.ui.DescriptorTreeView;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIRadioButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledComboBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;

public class ConnectorRARGeneralInspector
extends InspectorPane
implements UIJarPackagerBox.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectorRARGeneralInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectorRARGeneralInspector = ConnectorRARGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.ConnectorRARGeneralInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectorRARGeneralInspector);
    private static final String TOOLTIP = localStrings.getLocalString("ui.connectorrargeneralinspector.tooltip", "Resource Adapter Archive information");
    private static final String ARCHIVE_LOCATION = localStrings.getLocalString("ui.connectorrargeneralinspector.archivelocation", "Archive Location");
    private static final String STANDALONE_ARCH = localStrings.getLocalString("ui.connectorrargeneralinspector.standalone", "Create Stand-alone Archive");
    private static final String APP_ARCH = localStrings.getLocalString("ui.connectorrargeneralinspector.applicationarchive", "Create Archive Within Application");
    private static final String ARCHIVE_FILENAME = localStrings.getLocalString("ui.connectorrargeneralinspector.archfilename", "Archive File Name:");
    private static String DISPLAYNAME = localStrings.getLocalString("ui.connectorrargeneralinspector.displayname", "RAR Display Name:");
    private static String TABNAME = localStrings.getLocalString("ui.connectorrargeneralinspector.tabname", "RAR File");
    private static String wizardHelpID = "RAR";
    private static String deployHelpID = "RAR";
    private ConnectorDescriptor descriptor;
    private JComponent targetChooser = null;
    private UIRadioButtonBox archiveLocBox = null;
    private UITitledTextField archFileName = null;
    private UITitledTextField displayNameField = null;
    private UITitledComboBox appSelectCombo = null;
    private UIJarPackagerBox contentsListBox = null;
    private FileContentsDescriptor wizardContentsMap = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$ConnectorRARGeneralInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ConnectorRARGeneralInspector(mode, (JComponent)obj);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? (class$com$sun$enterprise$deployment$ConnectorDescriptor = ConnectorRARGeneralInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor")) : class$com$sun$enterprise$deployment$ConnectorDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ConnectorDescriptor) {
            this.descriptor = (ConnectorDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ConnectorRARGeneralInspector(String mode, JComponent targetChooser) {
        this.setInspectorMode(mode);
        this.targetChooser = targetChooser;
        this.initLayout();
    }

    private void initLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        this.setToolTipText(TOOLTIP);
        if (this.isWizardMode()) {
            this.archiveLocBox = new UIRadioButtonBox(ARCHIVE_LOCATION, true);
            this.archiveLocBox.addItem(STANDALONE_ARCH);
            GridBagConstraints gbc = this.archiveLocBox.getGBConstraintsCopy();
            gbc.insets.left += 25;
            this.archFileName = new UITitledTextField(ARCHIVE_FILENAME, false);
            this.archFileName.setBrowserActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e10) {
                    ConnectorRARGeneralInspector.this.browseArchiveFileName();
                }
            });
            this.archiveLocBox.add((Component)this.archFileName, gbc);
            this.archiveLocBox.addSelectionEnabledComponent(this.archFileName, null);
            this.archiveLocBox.addItem(APP_ARCH);
            gbc = this.archiveLocBox.getGBConstraintsCopy();
            gbc.insets.left += 25;
            if (this.targetChooser != null) {
                this.archiveLocBox.add((Component)this.targetChooser, gbc);
                this.archiveLocBox.addSelectionEnabledComponent(this.targetChooser, null);
            } else {
                this.appSelectCombo = DeployToolWindow.getDeployToolWindow().getDescriptorTreeView().getApplicationsCombo(DescriptorTreeView.AppType_AppsOnly);
                this.archiveLocBox.add((Component)this.appSelectCombo, gbc);
                this.archiveLocBox.addSelectionEnabledComponent(this.appSelectCombo, null);
            }
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.gridx = 0;
            c10.gridy = 0;
            c10.gridwidth = 1;
            c10.gridheight = 1;
            c10.insets = new Insets(0, 5, 0, 5);
            c10.fill = 2;
            c10.anchor = 10;
            this.add((Component)this.archiveLocBox, c10);
            this.archiveLocBox.setSelectedItem(APP_ARCH);
        } else {
            UIDisplayNameBox fileDisplayBox = new UIDisplayNameBox();
            c10.weightx = 0.5;
            c10.weighty = 0.0;
            c10.gridx = 0;
            c10.gridy = 0;
            c10.gridwidth = 1;
            c10.gridheight = 1;
            c10.insets = new Insets(0, 5, 5, 5);
            c10.fill = 2;
            c10.anchor = 10;
            this.add((Component)fileDisplayBox, c10);
            this.archFileName = new UITitledTextField(ARCHIVE_FILENAME, false);
            this.archFileName.setReadOnly(true);
            fileDisplayBox.setFileNameField(this.archFileName);
            this.displayNameField = new UITitledTextField(DISPLAYNAME, false);
            this.displayNameField.addUpdateHandler(new UIComponentUpdateHandler(){

                public void updateComponent(JComponent c10) {
                    ConnectorRARGeneralInspector.this.descriptor.setName(ConnectorRARGeneralInspector.this.displayNameField.getText());
                }
            });
            fileDisplayBox.setDisplayNameField(this.displayNameField);
        }
        this.contentsListBox = new UIJarPackagerBox(this, "conrar", true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)this.contentsListBox, c10);
        if (this.isWizardMode()) {
            this.wizardContentsMap = new FileContentsDescriptor();
        }
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.isDeploymentMode()) {
            this.archFileName.setText(this.descriptor.getArchivist().getArchiveUri());
            this.displayNameField.setText(this.descriptor.getName());
        }
        if (this.isDeploymentMode()) {
            this.contentsListBox.setContents(this.descriptor);
        } else {
            this.contentsListBox.setContents(this.wizardContentsMap);
        }
    }

    private void browseArchiveFileName() {
        JFileChooser jfc = UIFileChooser.getFileChooser();
        jfc.setFileSelectionMode(0);
        int rtn = jfc.showDialog(this, localStrings.getLocalString("ui.connectorrargeneralinspector.choosearchivefilename", "Choose Archive File"));
        if (rtn == 0) {
            File chosenFile = jfc.getSelectedFile();
            this.archFileName.setText(chosenFile.toString());
        }
    }

    public boolean isStandAlone() {
        return this.archiveLocBox.isSelectedItem(STANDALONE_ARCH);
    }

    public String getArchiveFileName() {
        return this.archFileName.getText();
    }

    public void addContentsAction(FileContentsDescriptor clsFcd, FileContentsDescriptor conFcd, Vector delCon) throws IOException {
        Enumeration e10 = delCon.elements();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            if (this.isWizardMode()) {
                this.wizardContentsMap.removeFile(f2);
                continue;
            }
            this.descriptor.getArchivist().removeEntry(f2.toString());
        }
        if (this.isWizardMode()) {
            Enumeration e11 = conFcd.getFiles();
            while (e11.hasMoreElements()) {
                File nextKey = (File)e11.nextElement();
                this.wizardContentsMap.add(nextKey, conFcd.getDirectoryFor(nextKey));
            }
        } else {
            Archivist arch = this.descriptor.getArchivist();
            arch.addFiles(arch.createEntryNameMap(conFcd));
        }
        this.invokeRefresh();
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.isWizardMode() ? this.wizardContentsMap : null;
    }

    public static void main(String[] args) {
        String mode = "DeploymentMode";
        if (args.length > 0 && args[0].equals("wizard")) {
            mode = "WizardMode";
        }
        JFrame frame = new JFrame();
        ConnectorRARGeneralInspector myPanel = (ConnectorRARGeneralInspector)ConnectorRARGeneralInspector.newInspectorPane(mode, null);
        ConnectorDescriptor d10 = new ConnectorDescriptor();
        myPanel.setDescriptor(d10);
        frame.getContentPane().add((Component)myPanel, "Center");
        ((Component)frame).setSize(myPanel.getPreferredSize());
        ((Component)frame).setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

