/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui.descriptor;

import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.Archivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.FileContentsDescriptor;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIJarPackagerBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.help.CSH;
import javax.swing.JComponent;

public class AppClientJarFileInspector
extends InspectorPane
implements UIJarPackagerBox.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientJarFileInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientJarFileInspector = AppClientJarFileInspector.class$("com.sun.enterprise.tools.deployment.ui.descriptor.AppClientJarFileInspector")) : class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientJarFileInspector);
    private static String HELP_ID = localStrings.getLocalString("ui.appclientgeneralinspector.help_id", "App-Client General Inspector Help");
    private static String TARGET_APP = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.targetappllication", "Create Archive Within Application:");
    private static String JAR_FILE = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.jarfile", "JAR File:");
    private static String CHOOSE_CONTENTS = localStrings.getLocalString("enterprise.tools.deployment.ui.descriptor.choosecontents", "Please click Browse and select the folder that represents the root directory of the files to be added.  Select a file or directory from the root directory and click Add.");
    private static String CHOOSER_FILES = localStrings.getLocalString("ui.appclientgeneralinspector.appclientjarcontents", "Files to be Added:");
    private static String CHOOSER_ROOT_DIR = localStrings.getLocalString("ui.appclientgeneralinspector.choosedirectory", "Root Directory");
    private static String CHOOSER_TITLE = localStrings.getLocalString("ui.appclientgeneralinspector.addfilestoappclient", "Add files to the Application Client");
    private static String TABNAME = localStrings.getLocalString("ui.appclientjarfileinspector.tabname", "JAR File");
    private static String wizardHelpID = "JAR";
    private static String deployHelpID = "JAR";
    ApplicationClientDescriptor descriptor = null;
    private UITitledTextField txtJarFile = null;
    private UITitledTextField txtClientDisplayName = null;
    private UIJarPackagerBox contentsPanel = null;
    private JComponent targetChooser;
    private FileContentsDescriptor contentsMap = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$descriptor$AppClientJarFileInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ApplicationClientDescriptor;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new AppClientJarFileInspector(mode, (JComponent)obj);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isWizardMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$ApplicationClientDescriptor == null ? (class$com$sun$enterprise$deployment$ApplicationClientDescriptor = AppClientJarFileInspector.class$("com.sun.enterprise.deployment.ApplicationClientDescriptor")) : class$com$sun$enterprise$deployment$ApplicationClientDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ApplicationClientDescriptor) {
            this.descriptor = (ApplicationClientDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private AppClientJarFileInspector(String mode, JComponent targetChooser) {
        this.setInspectorMode(mode);
        this.targetChooser = targetChooser;
        if (this.isWizardMode()) {
            this.contentsMap = new FileContentsDescriptor();
        }
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        CSH.setHelpIDString((Component)this, (String)HELP_ID);
        UIDisplayNameBox fileDisplayBox = new UIDisplayNameBox();
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 25);
        c10.fill = 2;
        c10.anchor = 10;
        gridbag.setConstraints(fileDisplayBox, c10);
        this.add((Component)fileDisplayBox, c10);
        this.txtJarFile = new UITitledTextField(JAR_FILE, false);
        this.txtJarFile.setReadOnly(true);
        this.txtJarFile.setText(new File("client.jar").getAbsolutePath());
        UITitledBox locationComponent = this.txtJarFile;
        if (this.targetChooser != null) {
            UITitledBox targetBox = new UITitledBox(TARGET_APP, false);
            targetBox.addWithGBConstraints(this.targetChooser);
            locationComponent = targetBox;
        }
        fileDisplayBox.setFileNameField(locationComponent);
        this.contentsPanel = new UIJarPackagerBox(this, "appcli", true);
        c10.weightx = 1.0;
        c10.weighty = 0.7;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)this.contentsPanel, c10);
    }

    public void addContentsAction(FileContentsDescriptor clsFcd, FileContentsDescriptor conFcd, Vector delCon) throws IOException {
        Enumeration e10 = delCon.elements();
        while (e10.hasMoreElements()) {
            File f2 = (File)e10.nextElement();
            if (this.isWizardMode()) {
                this.contentsMap.removeFile(f2);
                continue;
            }
            this.descriptor.getArchivist().removeEntry(f2.toString());
        }
        if (this.isWizardMode()) {
            Enumeration e11 = conFcd.getFiles();
            while (e11.hasMoreElements()) {
                File nextKey = (File)e11.nextElement();
                this.contentsMap.add(nextKey, conFcd.getDirectoryFor(nextKey));
            }
        } else {
            Archivist archivist = this.descriptor.getArchivist();
            archivist.addFiles(archivist.createEntryNameMap(conFcd));
        }
        this.invokeRefresh();
    }

    public FileContentsDescriptor getFileContentsDescriptor() {
        return this.isWizardMode() ? this.contentsMap : null;
    }

    public String getJarFile() {
        return this.txtJarFile.getText();
    }

    public void setJarFile(String jarFilename) {
        this.txtJarFile.setText(jarFilename);
    }

    public void refresh() {
        if (this.descriptor == null) {
            return;
        }
        if (this.isDeploymentMode()) {
            this.txtJarFile.setText(this.descriptor.getArchivist().getArchiveUri());
            this.contentsPanel.setContents(this.descriptor);
        } else {
            this.contentsPanel.setContents(this.contentsMap);
        }
        this.invalidate();
        this.validate();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

