/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.main.ServerException;
import com.sun.enterprise.tools.deployment.ui.DT;
import com.sun.enterprise.tools.deployment.ui.DeployedObjectDescriptor;
import com.sun.enterprise.tools.deployment.ui.DeploymentManager;
import com.sun.enterprise.tools.deployment.ui.DescriptorTreeView;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.InspectorTable;
import com.sun.enterprise.tools.deployment.ui.InspectorTableModel;
import com.sun.enterprise.tools.deployment.ui.ServerDescriptor;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIConfig;
import com.sun.enterprise.tools.deployment.ui.utils.UIOptionPane;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTable;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.NotificationEvent;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServerGeneralInspector
extends InspectorPane {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ServerGeneralInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$ServerGeneralInspector = ServerGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.ServerGeneralInspector")) : class$com$sun$enterprise$tools$deployment$ui$ServerGeneralInspector);
    private static String TABNAME = localStrings.getLocalString("ui.servergeneralinspector.tabname", "General");
    private static String DEPLOYED_OBJECT_TITLE = localStrings.getLocalString("ui.servergeneralinspector.deployedobject", "Deployed Objects");
    private static String UNDEPLOY = localStrings.getLocalString("ui.servergeneralinspector.uninstall", "Undeploy");
    private static String SERVER_TITLE = localStrings.getLocalString("ui.servergeneralinspector.j2eeservers", "J2EE Servers");
    private static String RESTART_SERVER = localStrings.getLocalString("ui.servergeneralinspector.server_restart", "Restart");
    private static String STOP_SERVER = localStrings.getLocalString("ui.servergeneralinspector.server_stop", "Stop...");
    private static String CONFIRM_UNDEPLOY = localStrings.getLocalString("ui.servergeneralinspector.confirm_uninstall", "Confirm Undeploy");
    private static String SELECT_APP = null;
    private static String TABLE_SERVER = localStrings.getLocalString("ui.servergeneralinspector.column_server", "Server");
    private static String TABLE_STATUS = localStrings.getLocalString("ui.servergeneralinspector.column_status", "Status");
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    ServerDescriptor descriptor = null;
    private JList appList = null;
    private DefaultListModel appListModel = null;
    private ServerTable serverTable;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ServerGeneralInspector;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;

    private static String OKTOUNDEPLOY_APP(String v0, String v1) {
        return localStrings.getLocalString("ui.servergeneralinspector.chosen_uninstall", "You have chosen to undeploy the application(s)\n {0} from {1}\nContinue?", new Object[]{v0, v1});
    }

    private static String COMMUNICATION_ERROR(String v0) {
        return localStrings.getLocalString("ui.servergeneralinspector.communication_error", "There was a communication error with the server:\n {0}", new Object[]{v0});
    }

    private static String SELECT_APP() {
        return SELECT_APP != null ? SELECT_APP : (SELECT_APP = localStrings.getLocalString("ui.servergeneralinspector.select_app_first", "Select the Application first."));
    }

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ServerGeneralInspector(mode);
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor == null ? (class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor = ServerGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.ServerDescriptor")) : class$com$sun$enterprise$tools$deployment$ui$ServerDescriptor;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof ServerDescriptor) {
            this.descriptor = (ServerDescriptor)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ServerGeneralInspector(String mode) {
        this.setInspectorMode(mode);
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagConstraints c10 = new GridBagConstraints();
        this.setLayout(new GridBagLayout());
        UITitledList appListPanel = new UITitledList(DEPLOYED_OBJECT_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.add((Component)appListPanel, c10);
        this.appListModel = new DefaultListModel();
        this.appList = new JList(this.appListModel);
        this.appList.getSelectionModel().setSelectionMode(0);
        this.appList.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                DeployedObject dep = (DeployedObject)value;
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                label.setIcon(DescriptorTreeView.getIconForDescriptor(dep.getType()));
                return label;
            }
        });
        this.appList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e10) {
                if (e10.getValueIsAdjusting()) {
                    return;
                }
                boolean connectorFound = false;
                Object[] sel = ServerGeneralInspector.this.appList.getSelectedValues();
                if (sel.length > 0) {
                    int i2 = 0;
                    while (i2 < sel.length) {
                        DeployedObject dep = (DeployedObject)sel[i2];
                        if (dep.isConnector()) {
                            connectorFound = true;
                            break;
                        }
                        ++i2;
                    }
                }
            }
        });
        appListPanel.setListView(this.appList);
        JButton btnUndeploy = new JButton(UNDEPLOY);
        btnUndeploy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ServerGeneralInspector.this.undeployAction();
            }
        });
        appListPanel.addSelectionEnabledButton(btnUndeploy);
        UITitledTable serverTablePanel = new UITitledTable(SERVER_TITLE, true);
        c10.weightx = 0.5;
        c10.weighty = 0.5;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 1;
        this.serverTable = new ServerTable(new ServerTableModel(this));
        serverTablePanel.setTableView(this.serverTable);
        JButton btnRestartServer = new JButton(RESTART_SERVER);
        btnRestartServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ServerGeneralInspector.this.restartAction();
            }
        });
        serverTablePanel.addSelectionEnabledButton(btnRestartServer);
        JButton btnStopServer = new JButton(STOP_SERVER);
        btnStopServer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e10) {
                ServerGeneralInspector.this.stopAction();
            }
        });
        serverTablePanel.addSelectionEnabledButton(btnStopServer);
        this.invokeRefresh();
    }

    public void refresh() {
        this.appListModel = new DefaultListModel();
        try {
            Vector rarNames;
            Vector appNames = DT.getServerManager().getApplicationNames();
            if (appNames != null) {
                int i2 = 0;
                while (i2 < appNames.size()) {
                    DeployedObject dep = new DeployedObject((String)appNames.elementAt(i2), class$com$sun$enterprise$deployment$Application == null ? ServerGeneralInspector.class$("com.sun.enterprise.deployment.Application") : class$com$sun$enterprise$deployment$Application);
                    this.appListModel.addElement(dep);
                    ++i2;
                }
            }
            if ((rarNames = DT.getServerManager().getConnectorNames()) != null) {
                int i3 = 0;
                while (i3 < rarNames.size()) {
                    String conName = (String)rarNames.elementAt(i3);
                    if (conName.indexOf(":") < 0) {
                        DeployedObject dep = new DeployedObject(conName, class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? ServerGeneralInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor);
                        this.appListModel.addElement(dep);
                    }
                    ++i3;
                }
            }
        }
        catch (Exception e10) {
            UIUtils.debugPrintln("ServerGeneralInspector.refresh: Exception - " + e10);
        }
        this.appList.setModel(this.appListModel);
    }

    public void notification(NotificationEvent ne) {
        this.invokeRefresh();
    }

    public void restartAction() {
        UIOptionPane.showNotImplemented(this);
    }

    public void stopAction() {
        UIOptionPane.showNotImplemented(this);
    }

    public void undeployAction() {
        ServerGeneralInspector.undeployObject(this, this.appList.getSelectedValues());
        this.invokeRefresh();
    }

    public static void undeployObject(Component frameOwner, Object[] s2) {
        String currentServer = DT.getServerManager().getCurrentServer();
        if (currentServer == null) {
            return;
        }
        if (s2 == null || s2.length == 0) {
            return;
        }
        String appsString = "";
        int i2 = 0;
        while (i2 < s2.length) {
            appsString = appsString + s2[i2].toString() + "\n";
            ++i2;
        }
        boolean userChoice = UIOptionPane.showConfirmDialog(frameOwner, ServerGeneralInspector.OKTOUNDEPLOY_APP(appsString, currentServer));
        if (!userChoice) {
            return;
        }
        DeploymentManager dm2 = DT.getDeploymentManager();
        try {
            int i3 = 0;
            while (i3 < s2.length) {
                Object d10;
                if (s2[i3] instanceof DeployedObject) {
                    d10 = (DeployedObject)s2[i3];
                    String deployName = ((DeployedObject)d10).getDeployName();
                    if (((DeployedObject)d10).isApplication()) {
                        dm2.undeployApplication(deployName, currentServer);
                    } else if (((DeployedObject)d10).isConnector()) {
                        dm2.undeployStandAlone(deployName, currentServer);
                    } else {
                        UIUtils.printImplementationError("Unsupported Class: " + ((DeployedObject)d10).getType().getName());
                    }
                } else if (s2[i3] instanceof DeployedObjectDescriptor) {
                    d10 = (DeployedObjectDescriptor)s2[i3];
                    if (((DeployedObjectDescriptor)d10).getType() == (class$com$sun$enterprise$deployment$Application == null ? ServerGeneralInspector.class$("com.sun.enterprise.deployment.Application") : class$com$sun$enterprise$deployment$Application)) {
                        dm2.undeployApplication(((Descriptor)d10).getName(), currentServer);
                    } else if (((DeployedObjectDescriptor)d10).getType() == (class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? ServerGeneralInspector.class$("com.sun.enterprise.deployment.ConnectorDescriptor") : class$com$sun$enterprise$deployment$ConnectorDescriptor)) {
                        dm2.undeployStandAlone(((Descriptor)d10).getName(), currentServer);
                    } else {
                        UIUtils.printImplementationError("Unsupported Class: " + ((DeployedObjectDescriptor)d10).getType().getName());
                    }
                } else {
                    UIUtils.printImplementationError("Unsupported Class: " + s2[i3].getClass().getName());
                }
                ++i3;
            }
        }
        catch (ServerException se) {
            UIOptionPane.showErrorDialog(frameOwner, ServerGeneralInspector.COMMUNICATION_ERROR(se.getMessage()));
            DT.getServerManager().removeServer(currentServer);
        }
        catch (Throwable t2) {
            UIOptionPane.showErrorDialog(frameOwner, ServerGeneralInspector.COMMUNICATION_ERROR(t2.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ServerTableModel
    extends InspectorTableModel {
        ServerGeneralInspector inspector;

        public ServerTableModel(ServerGeneralInspector inspector) {
            super(new String[]{TABLE_SERVER, TABLE_STATUS});
            this.inspector = inspector;
        }

        public Object getObjectValue(Object obj, int col) {
            Object value = null;
            switch (col) {
                case 0: {
                    break;
                }
                case 1: {
                    break;
                }
            }
            return value;
        }

        public void setObjectValue(Object obj, int col, Object value) {
            switch (col) {
                case 0: {
                    return;
                }
                case 1: {
                    break;
                }
            }
        }
    }

    private class ServerTable
    extends InspectorTable {
        public ServerTable(ServerTableModel model) {
            super(model);
            this.setSelectionMode(0);
            this.setAutoResizeMode(4);
        }
    }

    private class DeployedObject {
        private Descriptor descriptor = null;
        private String displayName = null;
        private String deployName = null;
        private Class type = null;
        static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;
        static /* synthetic */ Class class$com$sun$enterprise$deployment$ConnectorDescriptor;

        public DeployedObject(String name, Class type) {
            this.displayName = name;
            this.deployName = name;
            this.type = type;
            if (!this.isConnector() || this.displayName.endsWith(".rar")) {
                // empty if block
            }
        }

        public DeployedObject(Descriptor desc) {
            this.descriptor = desc;
            this.displayName = desc.getName();
            this.type = desc.getClass();
            if (desc instanceof Application) {
                this.deployName = desc.getName();
            } else if (desc instanceof ConnectorDescriptor) {
                ConnectorDescriptor cd2 = (ConnectorDescriptor)desc;
                if (UIConfig.getConfigBoolean("ui.deploy.connectors.useDisplayName")) {
                    this.deployName = cd2.getName();
                } else {
                    File rarfile = new File(cd2.getArchivist().getArchiveUri());
                    this.deployName = rarfile.getName();
                }
            } else {
                UIUtils.printImplementationError("Invalid DeployedObject type: " + desc.getClass().getName());
                this.deployName = desc.getName();
                this.type = null;
            }
        }

        public Descriptor getDescriptor() {
            return this.descriptor;
        }

        public Class getType() {
            return this.type;
        }

        public boolean isApplication() {
            return this.type == (class$com$sun$enterprise$deployment$Application == null ? (class$com$sun$enterprise$deployment$Application = DeployedObject.class$("com.sun.enterprise.deployment.Application")) : class$com$sun$enterprise$deployment$Application);
        }

        public boolean isConnector() {
            return this.type == (class$com$sun$enterprise$deployment$ConnectorDescriptor == null ? (class$com$sun$enterprise$deployment$ConnectorDescriptor = DeployedObject.class$("com.sun.enterprise.deployment.ConnectorDescriptor")) : class$com$sun$enterprise$deployment$ConnectorDescriptor);
        }

        public String getDeployName() {
            return this.deployName;
        }

        public String toString() {
            return this.displayName;
        }

        static /* synthetic */ Class class$(String x0) {
            try {
                return Class.forName(x0);
            }
            catch (ClassNotFoundException x1) {
                throw new NoClassDefFoundError(x1.getMessage());
            }
        }
    }
}

