/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.deployment.ui;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationArchivist;
import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.tools.deployment.ui.DescriptionInspector;
import com.sun.enterprise.tools.deployment.ui.IconInspector;
import com.sun.enterprise.tools.deployment.ui.InspectorPane;
import com.sun.enterprise.tools.deployment.ui.UIUtils;
import com.sun.enterprise.tools.deployment.ui.utils.UIComponentUpdateHandler;
import com.sun.enterprise.tools.deployment.ui.utils.UIDisplayNameBox;
import com.sun.enterprise.tools.deployment.ui.utils.UIFileChooser;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledControlButtonBox;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledList;
import com.sun.enterprise.tools.deployment.ui.utils.UITitledTextField;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JOptionPane;

public class ApplicationGeneralInspector
extends InspectorPane
implements IconInspector.UpdateListener,
DescriptionInspector.UpdateListener {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector == null ? (class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector = ApplicationGeneralInspector.class$("com.sun.enterprise.tools.deployment.ui.ApplicationGeneralInspector")) : class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector);
    private static String LOCATION = localStrings.getLocalString("applicationgeneralinspector.location_label", "Location:");
    private static String DISPLAY_NAME = localStrings.getLocalString("applicationgeneralinspector.display_name_label", "Display name:");
    private static String ADD_LIB_JAR = localStrings.getLocalString("applicationgeneralinspector.add_library_jar_button", "Add Library JAR...");
    private static String REMOVE_LIB_JAR = localStrings.getLocalString("applicationgeneralinspector.remove_library_jar_button", "Remove Library JAR...");
    private static String TABNAME = localStrings.getLocalString("applicationgeneralinspector.tabname", "General");
    private static String wizardHelpID = "General";
    private static String deployHelpID = "General";
    Application descriptor = null;
    UITitledTextField displayNameText;
    UITitledTextField locationText;
    JList contentsList;
    IconInspector.DialogDisplayButton iconInspector = null;
    DescriptionInspector.DialogDisplayButton descInspector = null;
    static /* synthetic */ Class class$com$sun$enterprise$tools$deployment$ui$ApplicationGeneralInspector;
    static /* synthetic */ Class class$com$sun$enterprise$deployment$Application;

    public static InspectorPane newInspectorPane(String mode, Object obj) {
        return new ApplicationGeneralInspector();
    }

    public String getTabName() {
        return TABNAME;
    }

    public String getHelpID() {
        return this.isDevelopmentMode() ? wizardHelpID : deployHelpID;
    }

    public Class getDescriptorClass() {
        return class$com$sun$enterprise$deployment$Application == null ? (class$com$sun$enterprise$deployment$Application = ApplicationGeneralInspector.class$("com.sun.enterprise.deployment.Application")) : class$com$sun$enterprise$deployment$Application;
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(Descriptor obj) {
        if (obj instanceof Application) {
            this.descriptor = (Application)obj;
            this.invokeRefresh();
        } else {
            this.descriptor = null;
        }
    }

    private ApplicationGeneralInspector() {
        this.initializeLayout();
    }

    private void initializeLayout() {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        GridBagConstraints c10 = new GridBagConstraints();
        UIDisplayNameBox fileDisplayBox = new UIDisplayNameBox();
        c10.weightx = 1.0;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 0;
        c10.gridwidth = 1;
        c10.gridheight = 1;
        c10.insets = new Insets(5, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)fileDisplayBox, c10);
        this.locationText = new UITitledTextField(LOCATION, false);
        this.locationText.setReadOnly(true);
        fileDisplayBox.setFileNameField(this.locationText);
        this.displayNameText = new UITitledTextField(DISPLAY_NAME, false);
        this.displayNameText.addUpdateHandler(new UIComponentUpdateHandler(){

            public void updateComponent(JComponent c10) {
                ApplicationGeneralInspector.this.descriptor.setName(ApplicationGeneralInspector.this.displayNameText.getText());
            }
        });
        fileDisplayBox.setDisplayNameField(this.displayNameText);
        UITitledList contentsListPanel = new UITitledList(localStrings.getLocalString("applicationgeneralinspector.contents_label", "Contents:"), true);
        this.contentsList = new JList();
        contentsListPanel.setListView(this.contentsList);
        c10.weightx = 1.0;
        c10.weighty = 0.7;
        c10.gridx = 0;
        c10.gridy = 1;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 1;
        c10.anchor = 10;
        this.add((Component)contentsListPanel, c10);
        JButton addLibJarButton = new JButton(ADD_LIB_JAR);
        addLibJarButton.setMinimumSize(new Dimension(100, 25));
        addLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ApplicationGeneralInspector.this.addLibJarAction();
            }
        });
        contentsListPanel.addControlButton(addLibJarButton);
        JButton removeLibJarButton = new JButton(REMOVE_LIB_JAR);
        removeLibJarButton.setMinimumSize(new Dimension(100, 25));
        removeLibJarButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae2) {
                ApplicationGeneralInspector.this.removeLibJarAction();
            }
        });
        contentsListPanel.addSelectionEnabledButton(removeLibJarButton);
        UITitledControlButtonBox buttonBox = new UITitledControlButtonBox(null, false);
        buttonBox.setControlButtonLocation(15, true);
        this.descInspector = new DescriptionInspector.DialogDisplayButton(this);
        buttonBox.addControlButton(this.descInspector);
        this.iconInspector = new IconInspector.DialogDisplayButton(this);
        buttonBox.addControlButton(this.iconInspector);
        c10.weightx = 0.5;
        c10.weighty = 0.0;
        c10.gridx = 0;
        c10.gridy = 2;
        c10.gridwidth = 2;
        c10.gridheight = 1;
        c10.insets = new Insets(0, 5, 5, 5);
        c10.fill = 2;
        c10.anchor = 10;
        this.add((Component)buttonBox, c10);
    }

    public void descriptionUpdated(String description, Object ref) {
        this.descriptor.setDescription(description);
    }

    public void addLargeIcon(File iconFile) {
        if (iconFile != null) {
            this._addDeploymentIcon("large", iconFile, this.descriptor.getApplicationArchivist(), null, null);
        } else {
            UIUtils.debugPrintln("'null' file specified");
        }
    }

    public void addSmallIcon(File iconFile) {
        if (iconFile != null) {
            this._addDeploymentIcon("small", iconFile, this.descriptor.getApplicationArchivist(), null, null);
        } else {
            UIUtils.debugPrintln("'null' file specified");
        }
    }

    private void addLibJarAction() {
        JFileChooser jfc = UIFileChooser.getFileChooser();
        jfc.setFileSelectionMode(0);
        int returnValue = jfc.showDialog(this, localStrings.getLocalString("applicationgeneralinspector.add_library_jar", "Add Library JAR"));
        if (returnValue == 0) {
            File libJarFile = jfc.getSelectedFile();
            try {
                this.descriptor.getApplicationArchivist().addLibraryJar(libJarFile);
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                JOptionPane.showMessageDialog(this, "Error adding library JAR.");
            }
        }
        this.invokeRefresh();
    }

    private void removeLibJarAction() {
        Object[] libraryJars = null;
        try {
            libraryJars = this.descriptor.getApplicationArchivist().getLibraryJarUris().toArray();
        }
        catch (Throwable ioException) {
            ioException.printStackTrace();
        }
        if (Array.getLength(libraryJars) > 0) {
            Object selectedValue = JOptionPane.showInputDialog(null, localStrings.getLocalString("applicationgeneralinspector.select_library_jar", "Select the library .jar to be removed:"), localStrings.getLocalString("applicationgeneralinspector.remove_library_jar_title", "Remove Library Jar"), 1, null, libraryJars, libraryJars[0]);
            if (selectedValue != null) {
                try {
                    this.descriptor.getApplicationArchivist().removeLibraryJar((String)selectedValue);
                }
                catch (Throwable ioException) {
                    ioException.printStackTrace();
                }
                this.invokeRefresh();
            }
        } else {
            JOptionPane.showMessageDialog(this, localStrings.getLocalString("applicationgeneralinspector.no_library_jars", "There are no library .jar files in this application"));
        }
    }

    public void refresh() {
        ApplicationArchivist archivist = this.descriptor.getApplicationArchivist();
        if (archivist != null) {
            this.locationText.setText(archivist.getApplicationFile().toString());
        }
        this.displayNameText.setText(this.descriptor.getName());
        this.descInspector.setDescriptionInspector(this.descriptor.getDescription(), this.descriptor.getName(), this, this.descriptor);
        if (archivist != null) {
            try {
                Vector entryNames = archivist.getEntryNames();
                DefaultListModel<String> contentsListModel = new DefaultListModel<String>();
                int entryIndex = 0;
                while (entryIndex < entryNames.size()) {
                    contentsListModel.addElement((String)entryNames.elementAt(entryIndex));
                    ++entryIndex;
                }
                this.contentsList.setModel(contentsListModel);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

